/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.DirtyableHorizontalPane;
import org.drools.guvnor.client.common.DirtyableVerticalPane;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.ui.ActionRetractFactWidget;
import org.drools.guvnor.client.modeldriven.ui.AttributeSelectorPopup;
import org.drools.guvnor.client.modeldriven.ui.ModellerWidgetFactory;
import org.drools.guvnor.client.modeldriven.ui.RuleAttributeWidget;
import org.drools.guvnor.client.modeldriven.ui.RuleModelEditor;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerConfiguration;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.packages.WorkingSetManager;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.AnalysisReportLine;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.VerificationService;
import org.drools.guvnor.client.rpc.VerificationServiceAsync;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.security.Capabilities;
import org.drools.guvnor.client.security.CapabilitiesManager;
import org.drools.guvnor.client.util.Format;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionCallMethod;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromAccumulateCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCollectCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleMetadata;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleModeller
extends DirtyableComposite
implements RuleModelEditor {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private DirtyableFlexTable layout;
    private RuleModel model;
    private RuleModellerConfiguration configuration = RuleModellerConfiguration.getInstance();
    private boolean showingOptions = false;
    private int currentLayoutRow = 0;
    private String packageName;
    private RuleAsset asset;
    private ModellerWidgetFactory widgetFactory;
    private List<RuleModellerWidget> lhsWidgets = new ArrayList();
    private List<RuleModellerWidget> rhsWidgets = new ArrayList();
    private boolean hasModifiedWidgets;
    private final Command onWidgetModifiedCommand = new /* Unavailable Anonymous Inner Class!! */;
    private List<AnalysisReportLine> errors;
    private List<AnalysisReportLine> warnings;

    public RuleModeller(RuleAsset asset, RuleViewer viewer, ModellerWidgetFactory widgetFactory) {
        this(asset, widgetFactory);
    }

    public RuleModeller(RuleAsset asset, ModellerWidgetFactory widgetFactory) {
        this.asset = asset;
        this.model = (RuleModel)asset.content;
        this.packageName = asset.metaData.packageName;
        this.widgetFactory = widgetFactory;
        this.layout = new DirtyableFlexTable();
        this.initWidget();
        this.layout.setStyleName("model-builder-Background");
        this.initWidget((Widget)this.layout);
        this.setWidth("100%");
        this.setHeight("100%");
    }

    public void initWidget() {
        this.layout.clear();
        this.currentLayoutRow = 0;
        ImageButton addPattern = new ImageButton(images.newItem());
        addPattern.setTitle(this.constants.AddAConditionToThisRule());
        addPattern.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.layout.getColumnFormatter().setWidth(0, "8%");
        this.layout.getColumnFormatter().setWidth(1, "87%");
        this.layout.getColumnFormatter().setWidth(2, "5%");
        if (this.showLHS()) {
            this.layout.setWidget(this.currentLayoutRow, 0, (Widget)new SmallLabel("<b>" + this.constants.WHEN() + "</b>"));
            if (!this.lockLHS()) {
                this.layout.setWidget(this.currentLayoutRow, 2, (Widget)addPattern);
            }
            ++this.currentLayoutRow;
            this.renderLhs(this.model);
        }
        if (this.showRHS()) {
            this.layout.setWidget(this.currentLayoutRow, 0, (Widget)new SmallLabel("<b>" + this.constants.THEN() + "</b>"));
            ImageButton addAction = new ImageButton(images.newItem());
            addAction.setTitle(this.constants.AddAnActionToThisRule());
            addAction.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            if (!this.lockRHS()) {
                this.layout.setWidget(this.currentLayoutRow, 2, (Widget)addAction);
            }
            ++this.currentLayoutRow;
            this.renderRhs(this.model);
        }
        if (this.showAttributes()) {
            int tmp1 = this.currentLayoutRow;
            int tmp2 = this.currentLayoutRow + 1;
            RuleModeller self = this;
            if (!this.showingOptions) {
                ClickableLabel showMoreOptions = new ClickableLabel("(show options...)", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                this.layout.setWidget(tmp1, 0, (Widget)showMoreOptions);
            } else {
                this.layout.setWidget(tmp1, 0, (Widget)new SmallLabel(this.constants.optionsRuleModeller()));
                this.layout.setWidget(tmp1, 2, this.getAddAttribute());
                this.layout.setWidget(tmp2, 1, (Widget)new RuleAttributeWidget(self, self.model));
            }
        }
        ++this.currentLayoutRow;
        this.layout.setWidget(this.currentLayoutRow + 1, 1, (Widget)this.spacerWidget());
        this.layout.getCellFormatter().setHeight(this.currentLayoutRow + 1, 1, "100%");
        this.verifyRule(null);
    }

    private boolean isLock(String attr) {
        if (this.asset.isreadonly) {
            return true;
        }
        if (this.model.metadataList.length == 0) {
            return false;
        }
        for (RuleMetadata at : this.model.metadataList) {
            if (!at.attributeName.equals(attr)) continue;
            return true;
        }
        return false;
    }

    public boolean showRHS() {
        return !this.configuration.isHideRHS();
    }

    public boolean lockRHS() {
        return this.isLock("freeze_actions");
    }

    public boolean showLHS() {
        return !this.configuration.isHideLHS();
    }

    public boolean lockLHS() {
        return this.isLock("freeze_conditions");
    }

    private boolean showAttributes() {
        if (!CapabilitiesManager.getInstance().shouldShow(new Integer[]{Capabilities.SHOW_PACKAGE_VIEW})) {
            return false;
        }
        return !this.configuration.isHideAttributes();
    }

    public void refreshWidget() {
        this.initWidget();
        this.showWarningsAndErrors();
        this.makeDirty();
    }

    private Widget getAddAttribute() {
        ImageButton add = new ImageButton(images.newItem());
        add.setTitle(this.constants.AddAnOptionToTheRuleToModifyItsBehaviorWhenEvaluatedOrExecuted());
        add.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return add;
    }

    protected void showAttributeSelector() {
        AttributeSelectorPopup pop = new AttributeSelectorPopup(this.model, this.lockLHS(), this.lockRHS(), (Command)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void renderRhs(RuleModel model) {
        for (int i = 0; i < model.rhs.length; ++i) {
            DirtyableVerticalPane widget = new DirtyableVerticalPane();
            widget.setWidth("100%");
            IAction action = model.rhs[i];
            Boolean readOnly = this.lockRHS() ? Boolean.valueOf(true) : null;
            RuleModellerWidget w = this.getWidgetFactory().getWidget(this, action, readOnly);
            w.addOnModifiedCommand(this.onWidgetModifiedCommand);
            w.setWidth("100%");
            widget.add((Widget)this.spacerWidget());
            DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
            horiz.setWidth("100%");
            ImageButton remove = new ImageButton(images.deleteItemSmall());
            remove.setTitle(this.constants.RemoveThisAction());
            int idx = i;
            remove.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            horiz.add((Widget)w);
            if (!(w instanceof ActionRetractFactWidget)) {
                w.setWidth("100%");
                horiz.setWidth("100%");
            }
            if (!this.lockRHS() && !w.isReadOnly()) {
                horiz.add((Widget)remove);
            }
            widget.add((Widget)horiz);
            this.layout.setHTML(this.currentLayoutRow, 0, "<div class='x-form-field'>" + (i + 1) + ".</div>");
            this.layout.getFlexCellFormatter().setHorizontalAlignment(this.currentLayoutRow, 0, HasHorizontalAlignment.ALIGN_CENTER);
            this.layout.getFlexCellFormatter().setVerticalAlignment(this.currentLayoutRow, 0, HasVerticalAlignment.ALIGN_MIDDLE);
            this.layout.setWidget(this.currentLayoutRow, 1, (Widget)widget);
            this.layout.getFlexCellFormatter().setHorizontalAlignment(this.currentLayoutRow, 1, HasHorizontalAlignment.ALIGN_LEFT);
            this.layout.getFlexCellFormatter().setVerticalAlignment(this.currentLayoutRow, 1, HasVerticalAlignment.ALIGN_TOP);
            this.layout.getFlexCellFormatter().setWidth(this.currentLayoutRow, 1, "100%");
            int index = i;
            if (!this.lockRHS() && !w.isReadOnly()) {
                this.addActionsButtonsToLayout(this.constants.AddAnActionBelow(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */, (ClickHandler)new /* Unavailable Anonymous Inner Class!! */, (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            }
            this.rhsWidgets.add(w);
            ++this.currentLayoutRow;
        }
    }

    protected void showConditionSelector(Widget w, Integer position) {
        String[] facts;
        FormStylePopup popup = new FormStylePopup();
        popup.setTitle(this.constants.AddAConditionToTheRule());
        HashMap<String, Object> cmds = new HashMap<String, Object>();
        ListBox positionCbo = new ListBox();
        if (position == null) {
            positionCbo.addItem(this.constants.Bottom(), String.valueOf(this.model.lhs.length));
            positionCbo.addItem(this.constants.Top(), "0");
            for (int i = 1; i < this.model.lhs.length; ++i) {
                positionCbo.addItem(Format.format((String)this.constants.Line0(), (int[])new int[]{i}), String.valueOf(i));
            }
        } else {
            positionCbo.addItem(String.valueOf(position));
            positionCbo.setSelectedIndex(0);
        }
        ListBox choices = new ListBox(true);
        SuggestionCompletionEngine completions = SuggestionCompletionCache.getInstance().getEngineFromCache(this.packageName);
        if (completions.getDSLConditions().length > 0) {
            for (int i = 0; i < completions.getDSLConditions().length; ++i) {
                DSLSentence sen = completions.getDSLConditions()[i];
                String key = "DSL" + i;
                choices.addItem(sen.toString(), key);
                cmds.put(key, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        if ((facts = completions.getFactTypes()).length > 0) {
            choices.addItem("..................");
            for (int i = 0; i < facts.length; ++i) {
                String f = facts[i];
                String key = "NF" + f;
                choices.addItem(f + " ...", key);
                cmds.put(key, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        String[] ces = HumanReadable.CONDITIONAL_ELEMENTS;
        choices.addItem("..................");
        for (int i = 0; i < ces.length; ++i) {
            String ce = ces[i];
            String key = "CE" + ce;
            choices.addItem(HumanReadable.getCEDisplayName((String)ce) + " ...", key);
            cmds.put(key, new /* Unavailable Anonymous Inner Class!! */);
        }
        String[] fces = HumanReadable.FROM_CONDITIONAL_ELEMENTS;
        choices.addItem("..................");
        for (int i = 0; i < fces.length; ++i) {
            String ce = fces[i];
            String key = "FCE" + ce;
            choices.addItem(HumanReadable.getCEDisplayName((String)ce) + " ...", key);
            cmds.put(key, new /* Unavailable Anonymous Inner Class!! */);
        }
        if (CapabilitiesManager.getInstance().shouldShow(new Integer[]{Capabilities.SHOW_PACKAGE_VIEW})) {
            choices.addItem("..................");
            choices.addItem(this.constants.FreeFormDrl(), "FF");
            cmds.put("FF", new /* Unavailable Anonymous Inner Class!! */);
        }
        if (completions.getDSLConditions().length == 0 && facts.length == 0) {
            popup.addRow((Widget)new HTML("<div class='highlight'>" + this.constants.NoModelTip() + "</div>"));
        }
        choices.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (position == null) {
            HorizontalPanel hp0 = new HorizontalPanel();
            hp0.add((Widget)new HTML(this.constants.PositionColon()));
            hp0.add((Widget)positionCbo);
            hp0.add((Widget)new InfoPopup(this.constants.PositionColon(), this.constants.ConditionPositionExplanation()));
            popup.addRow((Widget)hp0);
        }
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)choices);
        Button ok = new Button(this.constants.OK());
        hp.add((Widget)ok);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button cancel = new Button(this.constants.Cancel());
        hp.add((Widget)cancel);
        cancel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.addRow((Widget)hp);
        popup.show();
        choices.setFocus(true);
        popup.setAfterShow((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void selectSomething(ListBox choices, Map<String, Command> cmds) {
        int sel = choices.getSelectedIndex();
        if (sel != -1) {
            Command cmd = cmds.get(choices.getValue(choices.getSelectedIndex()));
            if (cmd != null) {
                cmd.execute();
            }
            this.verifyRule(null);
        }
    }

    protected void addNewDSLLhs(DSLSentence sentence, int position) {
        this.model.addLhsItem((IPattern)sentence.copy(), position);
        this.refreshWidget();
    }

    protected void showActionSelector(Widget w, Integer position) {
        String item;
        int i;
        String v2;
        FormStylePopup popup = new FormStylePopup();
        popup.setTitle(this.constants.AddANewAction());
        ListBox positionCbo = new ListBox();
        if (position == null) {
            positionCbo.addItem(this.constants.Bottom(), String.valueOf(this.model.rhs.length));
            positionCbo.addItem(this.constants.Top(), "0");
            for (int i2 = 1; i2 < this.model.rhs.length; ++i2) {
                positionCbo.addItem(Format.format((String)this.constants.Line0(), (int[])new int[]{i2}), String.valueOf(i2));
            }
        } else {
            positionCbo.addItem(String.valueOf(position));
            positionCbo.setSelectedIndex(0);
        }
        ListBox choices = new ListBox(true);
        HashMap<String, Object> cmds = new HashMap<String, Object>();
        SuggestionCompletionEngine completions = SuggestionCompletionCache.getInstance().getEngineFromCache(this.packageName);
        List vars = this.model.getBoundFacts();
        List vars2 = this.model.getRhsBoundFacts();
        String[] globals = completions.getGlobalVariables();
        if (completions.getDSLActions().length > 0) {
            for (int i3 = 0; i3 < completions.getDSLActions().length; ++i3) {
                DSLSentence sen = completions.getDSLActions()[i3];
                if (sen == null) continue;
                String sentence = sen.toString();
                choices.addItem(sentence, "DSL" + sentence);
                cmds.put("DSL" + sentence, new /* Unavailable Anonymous Inner Class!! */);
            }
            choices.addItem("................");
        }
        for (String v2 : vars) {
            choices.addItem(Format.format((String)this.constants.ChangeFieldValuesOf0(), (String[])new String[]{v2}), "VAR" + v2);
            cmds.put("VAR" + v2, new /* Unavailable Anonymous Inner Class!! */);
        }
        for (int i4 = 0; i4 < globals.length; ++i4) {
            v2 = globals[i4];
            choices.addItem(Format.format((String)this.constants.ChangeFieldValuesOf0(), (String[])new String[]{v2}), "GLOBVAR" + v2);
            cmds.put("GLOBVAR" + v2, new /* Unavailable Anonymous Inner Class!! */);
        }
        for (String v2 : vars) {
            choices.addItem(Format.format((String)this.constants.Retract0(), (String[])new String[]{v2}), "RET" + v2);
            cmds.put("RET" + v2, new /* Unavailable Anonymous Inner Class!! */);
        }
        for (String v2 : vars) {
            choices.addItem(Format.format((String)this.constants.Modify0(), (String[])new String[]{v2}), "MOD" + v2);
            cmds.put("MOD" + v2, new /* Unavailable Anonymous Inner Class!! */);
        }
        choices.addItem("................");
        for (i = 0; i < completions.getFactTypes().length; ++i) {
            item = completions.getFactTypes()[i];
            choices.addItem(Format.format((String)this.constants.InsertFact0(), (String[])new String[]{item}), "INS" + item);
            cmds.put("INS" + item, new /* Unavailable Anonymous Inner Class!! */);
        }
        for (i = 0; i < completions.getFactTypes().length; ++i) {
            item = completions.getFactTypes()[i];
            choices.addItem(Format.format((String)this.constants.LogicallyInsertFact0(), (String[])new String[]{item}), "LINS" + item);
            cmds.put("LINS" + item, new /* Unavailable Anonymous Inner Class!! */);
        }
        choices.addItem("................");
        if (completions.getGlobalCollections().length > 0 && vars.size() > 0) {
            for (String bf : vars) {
                for (int i5 = 0; i5 < completions.getGlobalCollections().length; ++i5) {
                    String glob = completions.getGlobalCollections()[i5];
                    String var = bf;
                    choices.addItem(Format.format((String)this.constants.Append0ToList1(), (String[])new String[]{var, glob}), "GLOBCOL" + glob + var);
                    cmds.put("GLOBCOL" + glob + var, new /* Unavailable Anonymous Inner Class!! */);
                }
            }
        }
        if (CapabilitiesManager.getInstance().shouldShow(new Integer[]{Capabilities.SHOW_PACKAGE_VIEW})) {
            choices.addItem(this.constants.AddFreeFormDrl(), "FF");
            cmds.put("FF", new /* Unavailable Anonymous Inner Class!! */);
            for (int i6 = 0; i6 < globals.length; ++i6) {
                v2 = globals[i6];
                choices.addItem(Format.format((String)this.constants.CallMethodOn0(), (String[])new String[]{v2}), "GLOBCALL" + v2);
                cmds.put("GLOBCALL" + v2, new /* Unavailable Anonymous Inner Class!! */);
            }
            for (String v2 : vars) {
                choices.addItem(Format.format((String)this.constants.CallMethodOn0(), (String[])new String[]{v2}), "CALL" + v2);
                cmds.put("CALL" + v2, new /* Unavailable Anonymous Inner Class!! */);
            }
            for (String v2 : vars2) {
                choices.addItem(Format.format((String)this.constants.CallMethodOn0(), (String[])new String[]{v2}), "CALL" + v2);
                cmds.put("CALL" + v2, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        if (position == null) {
            HorizontalPanel hp0 = new HorizontalPanel();
            hp0.add((Widget)new HTML(this.constants.PositionColon()));
            hp0.add((Widget)positionCbo);
            hp0.add((Widget)new InfoPopup(this.constants.PositionColon(), this.constants.ActionPositionExplanation()));
            popup.addRow((Widget)hp0);
        }
        HorizontalPanel hp = new HorizontalPanel();
        choices.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button ok = new Button(this.constants.OK());
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        hp.add((Widget)choices);
        hp.add((Widget)ok);
        popup.addRow((Widget)hp);
        popup.show();
        choices.setFocus(true);
    }

    private void selectSomethingElse(ListBox choices, Map<String, Command> cmds) {
        int sel = choices.getSelectedIndex();
        if (sel != -1) {
            cmds.get(choices.getValue(sel)).execute();
        }
    }

    protected void addModify(String itemText, int position) {
        this.model.addRhsItem((IAction)new ActionUpdateField(itemText), position);
        this.refreshWidget();
    }

    protected void addNewDSLRhs(DSLSentence sentence, int position) {
        this.model.addRhsItem((IAction)sentence.copy(), position);
        this.refreshWidget();
    }

    protected void addRetract(String var, int position) {
        this.model.addRhsItem((IAction)new ActionRetractFact(var), position);
        this.refreshWidget();
    }

    protected void addActionSetField(String itemText, int position) {
        this.model.addRhsItem((IAction)new ActionSetField(itemText), position);
        this.refreshWidget();
    }

    protected void addCallMethod(String itemText, int position) {
        this.model.addRhsItem((IAction)new ActionCallMethod(itemText), position);
        this.refreshWidget();
    }

    protected void addNewCE(String s, int position) {
        this.model.addLhsItem((IPattern)new CompositeFactPattern(s), position);
        this.refreshWidget();
    }

    protected void addNewFCE(String type, int position) {
        FromCompositeFactPattern p = null;
        if (type.equals("from")) {
            p = new FromCompositeFactPattern();
        } else if (type.equals("from accumulate")) {
            p = new FromAccumulateCompositeFactPattern();
        } else if (type.equals("from collect")) {
            p = new FromCollectCompositeFactPattern();
        }
        this.model.addLhsItem((IPattern)p, position);
        this.refreshWidget();
    }

    protected void addNewFact(String itemText, int position) {
        this.model.addLhsItem((IPattern)new FactPattern(itemText), position);
        this.refreshWidget();
    }

    private void renderLhs(RuleModel model) {
        for (int i = 0; i < model.lhs.length; ++i) {
            DirtyableVerticalPane vert = new DirtyableVerticalPane();
            vert.setWidth("100%");
            Boolean readOnly = this.lockLHS() ? Boolean.valueOf(true) : null;
            IPattern pattern = model.lhs[i];
            RuleModellerWidget w = this.getWidgetFactory().getWidget(this, pattern, readOnly);
            w.addOnModifiedCommand(this.onWidgetModifiedCommand);
            vert.add(this.wrapLHSWidget(model, i, w));
            vert.add((Widget)this.spacerWidget());
            this.layout.setWidget(this.currentLayoutRow, 0, this.wrapLineNumber(i + 1, true));
            this.layout.getFlexCellFormatter().setHorizontalAlignment(this.currentLayoutRow, 0, HasHorizontalAlignment.ALIGN_CENTER);
            this.layout.getFlexCellFormatter().setVerticalAlignment(this.currentLayoutRow, 0, HasVerticalAlignment.ALIGN_MIDDLE);
            this.layout.setWidget(this.currentLayoutRow, 1, (Widget)vert);
            this.layout.getFlexCellFormatter().setHorizontalAlignment(this.currentLayoutRow, 1, HasHorizontalAlignment.ALIGN_LEFT);
            this.layout.getFlexCellFormatter().setVerticalAlignment(this.currentLayoutRow, 1, HasVerticalAlignment.ALIGN_TOP);
            this.layout.getFlexCellFormatter().setWidth(this.currentLayoutRow, 1, "100%");
            int index = i;
            if (!this.lockLHS() && !w.isReadOnly()) {
                this.addActionsButtonsToLayout(this.constants.AddAConditionBelow(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */, (ClickHandler)new /* Unavailable Anonymous Inner Class!! */, (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            }
            this.lhsWidgets.add(w);
            ++this.currentLayoutRow;
        }
    }

    private HTML spacerWidget() {
        HTML h = new HTML("&nbsp;");
        h.setHeight("2px");
        return h;
    }

    private Widget wrapLHSWidget(RuleModel model, int i, RuleModellerWidget w) {
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        ImageButton remove = new ImageButton(images.deleteItemSmall());
        remove.setTitle(this.constants.RemoveThisENTIREConditionAndAllTheFieldConstraintsThatBelongToIt());
        int idx = i;
        remove.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        horiz.setWidth("100%");
        w.setWidth("100%");
        horiz.add((Widget)w);
        if (!this.lockLHS() && !w.isReadOnly()) {
            horiz.add((Widget)remove);
        }
        return horiz;
    }

    private Widget wrapLineNumber(int number, boolean isLHSLine) {
        String id = "rhsLine";
        if (isLHSLine) {
            id = "lhsLine";
        }
        id = id + number;
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        horiz.add((Widget)new HTML("<div class='x-form-field' id='" + id + "'>" + number + ".</div>"));
        return horiz;
    }

    private void addLineIcon(int row, ImageResource img, String title) {
        Widget widget = this.layout.getWidget(row, 0);
        if (widget instanceof DirtyableHorizontalPane) {
            DirtyableHorizontalPane horiz = (DirtyableHorizontalPane)widget;
            ImageButton icon = new ImageButton(img);
            icon.setTitle(title);
            horiz.add((Widget)icon);
        }
    }

    private void clearLineIcons(int row) {
        if (this.layout.getCellCount(row) <= 0) {
            return;
        }
        Widget widget = this.layout.getWidget(row, 0);
        if (widget instanceof DirtyableHorizontalPane) {
            DirtyableHorizontalPane horiz = (DirtyableHorizontalPane)widget;
            while (horiz.getWidgetCount() > 1) {
                horiz.remove(horiz.getWidgetCount() - 1);
            }
        }
    }

    private void clearLinesIcons() {
        for (int i = 0; i < this.layout.getRowCount(); ++i) {
            this.clearLineIcons(i);
        }
    }

    private void addActionsButtonsToLayout(String title, ClickHandler addBelowListener, ClickHandler moveDownListener, ClickHandler moveUpListener) {
        DirtyableHorizontalPane hp = new DirtyableHorizontalPane();
        ImageButton addPattern = new ImageButton(images.newItemBelow());
        addPattern.setTitle(title);
        addPattern.addClickHandler(addBelowListener);
        ImageButton moveDown = new ImageButton(images.shuffleDown());
        moveDown.setTitle(this.constants.MoveDown());
        moveDown.addClickHandler(moveDownListener);
        ImageButton moveUp = new ImageButton(images.shuffleUp());
        moveUp.setTitle(this.constants.MoveUp());
        moveUp.addClickHandler(moveUpListener);
        hp.add((Widget)addPattern);
        hp.add((Widget)moveDown);
        hp.add((Widget)moveUp);
        this.layout.setWidget(this.currentLayoutRow, 2, (Widget)hp);
        this.layout.getFlexCellFormatter().setHorizontalAlignment(this.currentLayoutRow, 2, HasHorizontalAlignment.ALIGN_CENTER);
        this.layout.getFlexCellFormatter().setVerticalAlignment(this.currentLayoutRow, 2, HasVerticalAlignment.ALIGN_MIDDLE);
    }

    public RuleModel getModel() {
        return this.model;
    }

    public boolean isVariableNameUsed(String name) {
        SuggestionCompletionEngine completions = SuggestionCompletionCache.getInstance().getEngineFromCache(this.packageName);
        return this.model.isVariableNameUsed(name) || completions.isGlobalVariable(name);
    }

    public boolean isDirty() {
        return this.layout.hasDirty() || this.dirtyflag;
    }

    public SuggestionCompletionEngine getSuggestionCompletions() {
        return SuggestionCompletionCache.getInstance().getEngineFromCache(this.packageName);
    }

    public void verifyRule(Command cmd) {
        this.verifyRule(cmd, false);
    }

    public void verifyRule(Command cmd, boolean forceVerification) {
        this.errors = new ArrayList();
        this.warnings = new ArrayList();
        if (!(forceVerification || WorkingSetManager.getInstance().isAutoVerifierEnabled() && this.hasModifiedWidgets)) {
            if (cmd != null) {
                cmd.execute();
            }
            return;
        }
        LoadingPopup.showMessage((String)this.constants.VerifyingItemPleaseWait());
        Set activeWorkingSets = WorkingSetManager.getInstance().getActiveAssetUUIDs(this.asset.metaData.packageName);
        VerificationServiceAsync verificationService = (VerificationServiceAsync)GWT.create(VerificationService.class);
        verificationService.verifyAssetWithoutVerifiersRules(this.asset, activeWorkingSets, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void processWarningsAndErrors() {
        if (this.warnings.isEmpty() && this.errors.isEmpty()) {
            for (RuleModellerWidget ruleModellerWidget : this.lhsWidgets) {
                ruleModellerWidget.setModified(false);
            }
            for (RuleModellerWidget ruleModellerWidget : this.rhsWidgets) {
                ruleModellerWidget.setModified(false);
            }
        }
        this.showWarningsAndErrors();
    }

    private void showWarningsAndErrors() {
        this.clearLinesIcons();
        if (this.warnings != null) {
            for (AnalysisReportLine warning : this.warnings) {
                if (warning.patternOrderNumber == null) continue;
                this.addLineIcon(warning.patternOrderNumber + 1, images.warning(), warning.description);
            }
        }
        if (this.errors != null) {
            for (AnalysisReportLine error : this.errors) {
                if (error.patternOrderNumber == null) continue;
                this.addLineIcon(error.patternOrderNumber + 1, images.error(), error.description);
            }
        }
    }

    public boolean hasVerifierErrors() {
        return this.errors != null && this.errors.size() > 0;
    }

    public boolean hasVerifierWarnings() {
        return this.warnings != null && this.warnings.size() > 0;
    }

    public ModellerWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public void setWidgetFactory(ModellerWidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
    }

    public RuleModeller getRuleModeller() {
        return this;
    }

    public boolean isTemplate() {
        return this.widgetFactory.isTemplate();
    }

    public RuleAsset getAsset() {
        return this.asset;
    }

    static /* synthetic */ boolean access$002(RuleModeller x0, boolean x1) {
        x0.hasModifiedWidgets = x1;
        return x0.hasModifiedWidgets;
    }

    static /* synthetic */ boolean access$102(RuleModeller x0, boolean x1) {
        x0.showingOptions = x1;
        return x0.showingOptions;
    }

    static /* synthetic */ Constants access$200(RuleModeller x0) {
        return x0.constants;
    }

    static /* synthetic */ DirtyableFlexTable access$300(RuleModeller x0) {
        return x0.layout;
    }

    static /* synthetic */ Widget access$400(RuleModeller x0) {
        return x0.getAddAttribute();
    }

    static /* synthetic */ RuleModel access$500(RuleModeller x0) {
        return x0.model;
    }

    static /* synthetic */ void access$600(RuleModeller x0, ListBox x1, Map x2) {
        x0.selectSomething(x1, x2);
    }

    static /* synthetic */ void access$700(RuleModeller x0, ListBox x1, Map x2) {
        x0.selectSomethingElse(x1, x2);
    }

    static /* synthetic */ List access$802(RuleModeller x0, List x1) {
        x0.errors = x1;
        return x0.errors;
    }

    static /* synthetic */ List access$902(RuleModeller x0, List x1) {
        x0.warnings = x1;
        return x0.warnings;
    }

    static /* synthetic */ void access$1000(RuleModeller x0) {
        x0.processWarningsAndErrors();
    }
}

