/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.DataProxy;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.GroupingStore;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.Reader;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarMenuButton;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.EditorGridPanel;
import com.gwtext.client.widgets.grid.GridEditor;
import com.gwtext.client.widgets.grid.GridView;
import com.gwtext.client.widgets.grid.event.EditorGridListener;
import com.gwtext.client.widgets.grid.event.GridListener;
import com.gwtext.client.widgets.menu.BaseItem;
import com.gwtext.client.widgets.menu.Item;
import com.gwtext.client.widgets.menu.Menu;
import com.gwtext.client.widgets.menu.event.BaseItemListener;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.ModellerWidgetFactory;
import org.drools.guvnor.client.modeldriven.ui.RuleModelEditor;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.TemplateModellerWidgetFactory;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.ide.common.client.modeldriven.dt.TemplateModel;

public class RuleTemplateEditor
extends DirtyableComposite
implements RuleModelEditor {
    private TemplateModel model;
    private GroupingStore store = null;
    private EditorGridPanel grid = null;
    private RuleModeller ruleModeller;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public RuleTemplateEditor(RuleAsset asset) {
        this.model = (TemplateModel)asset.content;
        VerticalPanel tPanel = new VerticalPanel();
        tPanel.setWidth("100%");
        this.ruleModeller = new RuleModeller(asset, (ModellerWidgetFactory)new TemplateModellerWidgetFactory());
        tPanel.add((Widget)new Button(this.constants.LoadTemplateData(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
        tPanel.add((Widget)this.ruleModeller);
        this.initWidget((Widget)tPanel);
    }

    private Widget buildTemplateTable() {
        String[] vars = this.model.getInterpolationVariablesList();
        if (vars.length == 0) {
            return new Label("");
        }
        FieldDef[] fds = new FieldDef[vars.length];
        ColumnConfig[] cols = new ColumnConfig[fds.length];
        int idx = 0;
        for (String var : vars) {
            cols[idx] = new ColumnConfig();
            cols[idx].setHeader(var);
            cols[idx].setDataIndex(var);
            cols[idx].setSortable(false);
            cols[idx].setWidth(50);
            cols[idx].setResizable(true);
            cols[idx].setEditor(new GridEditor((Field)new TextField()));
            fds[idx] = new StringFieldDef(var);
            ++idx;
        }
        RecordDef recordDef = new RecordDef(fds);
        ArrayReader reader = new ArrayReader(recordDef);
        MemoryProxy proxy = new MemoryProxy((Object[][])this.model.getTableAsArray());
        ColumnModel cm = new ColumnModel((BaseColumnConfig[])cols);
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            cm.setEditable(i, true);
        }
        this.store = new GroupingStore((DataProxy)proxy, (Reader)reader);
        this.store.load();
        this.grid = new EditorGridPanel((Store)this.store, cm);
        this.grid.setStripeRows(true);
        GridView gv = new GridView();
        gv.setForceFit(true);
        this.grid.setView(gv);
        this.grid.setStore((Store)this.store);
        this.grid.setAutoWidth(true);
        this.grid.setAutoHeight(true);
        Toolbar tb = new Toolbar();
        Menu menu = new Menu();
        menu.addItem((BaseItem)new Item(this.constants.AddRow(), (BaseItemListener)new /* Unavailable Anonymous Inner Class!! */));
        menu.addItem((BaseItem)new Item(this.constants.RemoveSelectedRowS(), (BaseItemListener)new /* Unavailable Anonymous Inner Class!! */));
        this.grid.addGridListener((GridListener)new /* Unavailable Anonymous Inner Class!! */);
        ToolbarMenuButton tbb = new ToolbarMenuButton(this.constants.Modify(), menu);
        tb.addButton(tbb);
        this.grid.add((Component)tb);
        this.grid.addEditorGridListener((EditorGridListener)new /* Unavailable Anonymous Inner Class!! */);
        this.grid.setWidth((int)((double)Window.getClientWidth() * 0.75));
        return this.grid;
    }

    private void removeSelectedRows(EditorGridPanel grid) {
        if (Window.confirm((String)this.constants.AreYouSureYouWantToDeleteTheSelectedRowS())) {
            int row = grid.getCellSelectionModel().getSelectedCell()[0];
            Record rec = this.store.getAt(row);
            this.model.removeRowById(rec.getId());
            this.store.remove(rec);
        }
    }

    public void resetDirty() {
        super.resetDirty();
        if (this.store != null) {
            this.store.commitChanges();
        }
    }

    public RuleModeller getRuleModeller() {
        return this.ruleModeller;
    }

    static /* synthetic */ Constants access$000(RuleTemplateEditor x0) {
        return x0.constants;
    }

    static /* synthetic */ Widget access$100(RuleTemplateEditor x0) {
        return x0.buildTemplateTable();
    }

    static /* synthetic */ GroupingStore access$200(RuleTemplateEditor x0) {
        return x0.store;
    }

    static /* synthetic */ TemplateModel access$300(RuleTemplateEditor x0) {
        return x0.model;
    }

    static /* synthetic */ EditorGridPanel access$400(RuleTemplateEditor x0) {
        return x0.grid;
    }

    static /* synthetic */ void access$500(RuleTemplateEditor x0, EditorGridPanel x1) {
        x0.removeSelectedRows(x1);
    }
}

