/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa;

import com.google.gwt.user.client.Command;
import org.drools.guvnor.client.qa.BulkRunResultView;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.ScenarioResultSummary;

public class BulkRunResult
implements BulkRunResultView.Presenter {
    private BulkTestRunResult result;
    private Command closeCommand;
    private BulkRunResultView display;
    private int grandTotal = 0;
    private int totalFailures = 0;

    public BulkRunResult(BulkRunResultView display) {
        this.display = display;
        display.setPresenter((BulkRunResultView.Presenter)this);
    }

    private void bind() {
        if (this.resultHasErrors()) {
            this.showErrors();
        } else {
            this.showResult();
        }
    }

    private void showErrors() {
        this.display.showErrors(this.result.getResult());
    }

    private void showResult() {
        this.showSummaries();
        this.showFailuresOutOfExpetations();
        this.showResultPercent();
        this.showRulesCoveredPercent();
        this.showOverAllStatus();
        this.showUncoveredRules();
    }

    private void showRulesCoveredPercent() {
        this.display.setRulesCoveredPercent(this.result.getPercentCovered());
    }

    private void showResultPercent() {
        this.display.setResultsPercent(this.calculatePercentage());
    }

    private int calculatePercentage() {
        return (int)((float)(this.grandTotal - this.totalFailures) / (float)this.grandTotal * 100.0f);
    }

    private void showFailuresOutOfExpetations() {
        this.display.setFailuresOutOfExpectation(this.totalFailures, this.grandTotal);
    }

    private void countTestsAndFailures() {
        ScenarioResultSummary[] scenarioResultSummaries = this.result.getResults();
        if (scenarioResultSummaries != null) {
            for (ScenarioResultSummary scenarioResultSummary : scenarioResultSummaries) {
                this.grandTotal += scenarioResultSummary.getTotal();
                this.totalFailures += scenarioResultSummary.getFailures();
            }
        }
    }

    private void showSummaries() {
        ScenarioResultSummary[] scenarioResultSummaries = this.result.getResults();
        if (scenarioResultSummaries != null) {
            for (ScenarioResultSummary scenarioResultSummary : scenarioResultSummaries) {
                this.display.addSummary(scenarioResultSummary);
            }
        }
    }

    private void showOverAllStatus() {
        if (this.hasFailures()) {
            this.display.setFailed();
        } else {
            this.display.setSuccess();
        }
    }

    private boolean hasFailures() {
        return this.totalFailures > 0;
    }

    private void showUncoveredRules() {
        String[] rulesNotCovered = this.result.getRulesNotCovered();
        if (rulesNotCovered != null) {
            for (String ruleName : rulesNotCovered) {
                this.display.addUncoveredRules(ruleName);
            }
        }
    }

    private boolean resultHasErrors() {
        return this.result != null && this.result.getResult() != null && this.result.getResult().getLines() != null && this.result.getResult().getLines().length > 0;
    }

    public void onClose() {
        this.closeCommand.execute();
    }

    public void setCloseCommand(Command closeCommand) {
        this.closeCommand = closeCommand;
    }

    public void setBulkTestRunResult(BulkTestRunResult bulkTestRunResult) {
        this.result = bulkTestRunResult;
        this.countTestsAndFailures();
        this.bind();
    }
}

