/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.PackageBuilderWidget;
import org.drools.guvnor.client.qa.BulkRunResultView;
import org.drools.guvnor.client.qa.BulkRunResultViewImpl;
import org.drools.guvnor.client.qa.SummaryTable;
import org.drools.guvnor.client.qa.SummaryTableView;
import org.drools.guvnor.client.qa.SummaryTableViewImpl;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.ScenarioResultSummary;
import org.drools.guvnor.client.util.Format;
import org.drools.guvnor.client.util.PercentageBar;
import org.drools.guvnor.client.util.ToggleLabel;
import org.drools.guvnor.client.util.ValueList;

public class BulkRunResultViewImpl
extends Composite
implements BulkRunResultView {
    private static BulkRunResultViewImplBinder uiBinder = (BulkRunResultViewImplBinder)GWT.create(BulkRunResultViewImplBinder.class);
    private Constants constants = (Constants)GWT.create(Constants.class);
    private BulkRunResultView.Presenter presenter;
    @UiField
    ToggleLabel overAll;
    @UiField
    PercentageBar resultsBar;
    @UiField
    SmallLabel failuresOutOfExpectations;
    @UiField
    PercentageBar coveredPercentBar;
    @UiField
    SmallLabel ruleCoveragePercent;
    @UiField
    ValueList uncoveredRules;
    @UiField(provided=true)
    SummaryTableView summaryTableView = new SummaryTableViewImpl();
    private SummaryTable summaryTable = new SummaryTable(this.summaryTableView);

    public BulkRunResultViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    @UiHandler(value={"closeButton"})
    void close(ClickEvent clickEvent) {
        this.presenter.onClose();
    }

    public void addSummary(ScenarioResultSummary summary) {
        this.summaryTable.addRow(summary);
    }

    public void showErrors(BuilderResult errors) {
        SimplePanel err = new SimplePanel();
        PackageBuilderWidget.showBuilderErrors((BuilderResult)errors, (Panel)err);
    }

    public void setPresenter(BulkRunResultView.Presenter presenter) {
        this.presenter = presenter;
    }

    public void setFailed() {
        this.overAll.setValue(Boolean.valueOf(false));
    }

    public void setSuccess() {
        this.overAll.setValue(Boolean.valueOf(true));
    }

    public void setFailuresOutOfExpectation(int totalFailures, int grandTotal) {
        this.failuresOutOfExpectations.setText(Format.format((String)this.constants.failuresOutOFExpectations(), (int[])new int[]{totalFailures, grandTotal}));
    }

    public void setResultsPercent(int i) {
        this.resultsBar.setValue(Integer.valueOf(i));
    }

    public void setRulesCoveredPercent(int percentCovered) {
        this.coveredPercentBar.setValue(Integer.valueOf(percentCovered));
        this.ruleCoveragePercent.setText(Format.format((String)this.constants.RuleCoveragePercent(), (int[])new int[]{percentCovered}));
    }

    public void addUncoveredRules(String uncoveredRule) {
        this.uncoveredRules.addItem(uncoveredRule);
    }
}

