/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TreeItem;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.AnalysisFactUsage;
import org.drools.guvnor.client.rpc.AnalysisFieldUsage;
import org.drools.guvnor.client.util.Format;

class FactUsagesItem
extends TreeItem {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private Images images = (Images)GWT.create(Images.class);

    public FactUsagesItem(AnalysisFactUsage[] factUsages) {
        this.setStyleName("analysis-Report");
        this.setHTML(Format.format((String)"<img src='{0}'/><b>{1}</b>", (String[])new String[]{new Image(this.images.factTemplate()).getUrl(), this.constants.ShowFactUsages()}));
        this.setUserObject((Object)new HTML(Format.format((String)"<img src='{0}'/><b>{1}:</b>", (String[])new String[]{new Image(this.images.factTemplate()).getUrl(), this.constants.FactUsages()})));
        this.doFacts(factUsages);
    }

    private void doFacts(AnalysisFactUsage[] factUsages) {
        for (AnalysisFactUsage factUsage : factUsages) {
            TreeItem fact = new TreeItem(Format.format((String)"<img src='{0}'/>", (String[])new String[]{new Image(this.images.fact()).getUrl()}) + factUsage.name);
            TreeItem fieldList = this.doFields(factUsage.fields);
            fact.addItem(fieldList);
            fieldList.setState(true);
            this.addItem(fact);
            fact.setState(true);
        }
    }

    private TreeItem doFields(AnalysisFieldUsage[] fields) {
        TreeItem fieldList = new TreeItem(this.constants.FieldsUsed());
        for (AnalysisFieldUsage fieldUsage : fields) {
            TreeItem field = new TreeItem(Format.format((String)"<img src='{0}'/>", (String[])new String[]{new Image(this.images.field()).getUrl()}) + fieldUsage.name);
            fieldList.addItem(field);
            TreeItem ruleList = this.doAffectedRules(fieldUsage);
            field.addItem(ruleList);
            field.setState(true);
        }
        return fieldList;
    }

    private TreeItem doAffectedRules(AnalysisFieldUsage fieldUsage) {
        TreeItem ruleList = new TreeItem(this.constants.ShowRulesAffected());
        ruleList.setUserObject((Object)new HTML(this.constants.RulesAffected()));
        for (String ruleName : fieldUsage.rules) {
            ruleList.addItem(new TreeItem(Format.format((String)"<img src='{0}'/>", (String[])new String[]{new Image(this.images.ruleAsset()).getUrl()}) + ruleName));
        }
        return ruleList;
    }
}

