/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.common.DefaultContentUploadEditor;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.decisiontable.DecisionTableXLSWidget;
import org.drools.guvnor.client.decisiontable.GuidedDecisionTableWidget;
import org.drools.guvnor.client.explorer.Preferences;
import org.drools.guvnor.client.factmodel.FactModelsWidget;
import org.drools.guvnor.client.modeldriven.ui.ModellerWidgetFactory;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidgetFactory;
import org.drools.guvnor.client.modeldriven.ui.RuleTemplateEditor;
import org.drools.guvnor.client.packages.ModelAttachmentFileWidget;
import org.drools.guvnor.client.processeditor.BusinessProcessEditor;
import org.drools.guvnor.client.qa.testscenarios.ScenarioWidget;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.resources.RuleFormatImageResource;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.BPELWrapper;
import org.drools.guvnor.client.ruleeditor.DSLRuleEditor;
import org.drools.guvnor.client.ruleeditor.DefaultRuleContentWidget;
import org.drools.guvnor.client.ruleeditor.DrlEditor;
import org.drools.guvnor.client.ruleeditor.FunctionEditor;
import org.drools.guvnor.client.ruleeditor.PropertiesWidget;
import org.drools.guvnor.client.ruleeditor.RuleFlowWrapper;
import org.drools.guvnor.client.ruleeditor.RuleValidatorWrapper;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.ruleeditor.WorkingSetEditor;
import org.drools.guvnor.client.ruleeditor.XmlFileWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorLauncher {
    private static Images images = (Images)GWT.create(Images.class);
    public static final Map<String, RuleFormatImageResource> TYPE_IMAGES = EditorLauncher.getTypeImages();
    private static RepositoryServiceAsync SERVICE = RepositoryServiceFactory.getService();
    public static Boolean hostedMode = Boolean.FALSE;

    public static Widget getEditorViewer(RuleAsset asset, RuleViewer viewer) {
        RulePackageSelector.currentlySelectedPackage = asset.metaData.packageName;
        if (asset.metaData.format.equals("brl")) {
            return new RuleModeller(asset, (ModellerWidgetFactory)new RuleModellerWidgetFactory());
        }
        if (asset.metaData.format.equals("dslr")) {
            return new RuleValidatorWrapper((Widget)new DSLRuleEditor(asset));
        }
        if (asset.metaData.format.equals("bpel.jar") && Preferences.getBooleanPref((String)"flex-bpel-editor")) {
            return new BPELWrapper(asset, viewer);
        }
        if (asset.metaData.format.equals("jar")) {
            return new ModelAttachmentFileWidget(asset, viewer);
        }
        if (asset.metaData.format.equals("xls")) {
            return new DecisionTableXLSWidget(asset, viewer);
        }
        if (asset.metaData.format.equals("rf")) {
            return new RuleFlowWrapper(asset, viewer);
        }
        if ((asset.metaData.format.equals("bpmn2") || asset.metaData.format.equals("bpmn")) && Preferences.getBooleanPref((String)"oryx-bpmn-editor")) {
            return new BusinessProcessEditor(asset);
        }
        if (asset.metaData.format.equals("drl")) {
            return new DrlEditor(asset);
        }
        if (asset.metaData.format.equals("enumeration")) {
            return new DefaultRuleContentWidget(asset);
        }
        if (asset.metaData.format.equals("scenario")) {
            return new ScenarioWidget(asset);
        }
        if (asset.metaData.format.equals("gdst")) {
            return new GuidedDecisionTableWidget(asset);
        }
        if (asset.metaData.format.equals("model.drl")) {
            return new FactModelsWidget(asset);
        }
        if (asset.metaData.format.equals("dsl")) {
            return new DefaultRuleContentWidget(asset);
        }
        if (asset.metaData.format.equals("properties")) {
            return new PropertiesWidget(asset, viewer);
        }
        if (asset.metaData.format.equals("xml")) {
            return new XmlFileWidget(asset, viewer);
        }
        if (asset.metaData.format.equals("function")) {
            return new FunctionEditor(asset);
        }
        if (asset.metaData.format.equals("workingset")) {
            return new WorkingSetEditor(asset);
        }
        if (asset.metaData.format.equals("template")) {
            return new RuleTemplateEditor(asset);
        }
        return new DefaultContentUploadEditor(asset, viewer);
    }

    private static Map<String, RuleFormatImageResource> getTypeImages() {
        HashMap<String, RuleFormatImageResource> result = new HashMap<String, RuleFormatImageResource>();
        result.put("drl", new RuleFormatImageResource("drl", images.technicalRuleAssets()));
        result.put("dsl", new RuleFormatImageResource("dsl", images.dsl()));
        result.put("function", new RuleFormatImageResource("function", images.functionAssets()));
        result.put("jar", new RuleFormatImageResource("jar", images.modelAsset()));
        result.put("xls", new RuleFormatImageResource("xls", images.spreadsheetSmall()));
        result.put("brl", new RuleFormatImageResource("brl", images.businessRule()));
        result.put("dslr", new RuleFormatImageResource("dslr", images.businessRule()));
        result.put("rf", new RuleFormatImageResource("rf", images.ruleflowSmall()));
        result.put("bpmn", new RuleFormatImageResource("bpmn", images.ruleflowSmall()));
        result.put("bpmn2", new RuleFormatImageResource("bpmn2", images.ruleflowSmall()));
        result.put("scenario", new RuleFormatImageResource("scenario", images.testManager()));
        result.put("enumeration", new RuleFormatImageResource("enumeration", images.enumeration()));
        result.put("gdst", new RuleFormatImageResource("gdst", images.gdst()));
        return result;
    }

    public static RuleFormatImageResource getAssetFormatIcon(String format) {
        RuleFormatImageResource result = (RuleFormatImageResource)TYPE_IMAGES.get(format);
        if (result == null) {
            return new RuleFormatImageResource(format, images.ruleAsset());
        }
        return result;
    }

    static {
        SERVICE.isHostedMode((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

