/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.ruleeditor.AssetCategoryEditor;
import org.drools.guvnor.client.ruleeditor.MetaDataWidget;
import org.drools.guvnor.client.ruleeditor.VersionBrowser;
import org.drools.guvnor.client.security.Capabilities;
import org.drools.guvnor.client.security.CapabilitiesManager;
import org.drools.guvnor.client.util.DecoratedDisclosurePanel;
import org.drools.guvnor.client.util.Format;

public class MetaDataWidget
extends Composite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private MetaData data;
    private boolean readOnly;
    private String uuid;
    private Command metaDataRefreshView;
    private Command fullRefreshView;
    private VerticalPanel layout = new VerticalPanel();
    AssetCategoryEditor ed;
    private FormStyleLayout currentSection;
    private String currentSectionName;

    public MetaDataWidget(MetaData d, boolean readOnly, String uuid, Command metaDataRefreshView, Command fullRefreshView) {
        this.uuid = uuid;
        this.data = d;
        this.readOnly = readOnly;
        this.layout.setWidth("100%");
        this.metaDataRefreshView = metaDataRefreshView;
        this.fullRefreshView = fullRefreshView;
        this.initWidget((Widget)this.layout);
        this.render();
    }

    public void setMetaData(MetaData data) {
        this.data = data;
    }

    private void render() {
        this.layout.clear();
        this.layout.add((Widget)new SmallLabel(Format.format((String)"{0}: [<b>{1}</b>]", (String[])new String[]{this.constants.Title(), this.data.name})));
        if (!this.readOnly) {
            ImageButton edit = new ImageButton(images.edit(), this.constants.RenameThisAsset());
            edit.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.addHeader(images.metadata(), this.data.name, (Image)edit);
        } else {
            this.addHeader(images.assetVersion(), this.data.name, null);
        }
        this.loadData();
    }

    private void addHeader(ImageResource img, String name, Image edit) {
        this.startSection(name);
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new SmallLabel("<b>" + name + "</b>"));
        if (edit != null) {
            hp.add((Widget)edit);
        }
        this.currentSection.addAttribute(this.constants.Title(), (Widget)hp);
    }

    private void loadData() {
        this.addAttribute(this.constants.CategoriesMetaData(), this.categories());
        this.addAttribute(this.constants.ModifiedOnMetaData(), this.readOnlyDate(this.data.lastModifiedDate));
        this.addAttribute(this.constants.ModifiedByMetaData(), (Widget)this.readOnlyText(this.data.lastContributor));
        this.addAttribute(this.constants.NoteMetaData(), (Widget)this.readOnlyText(this.data.checkinComment));
        if (!this.readOnly) {
            this.addAttribute(this.constants.CreatedOnMetaData(), this.readOnlyDate(this.data.createdDate));
        }
        this.addAttribute(this.constants.CreatedByMetaData(), (Widget)this.readOnlyText(this.data.creator));
        this.addAttribute(this.constants.FormatMetaData(), (Widget)new SmallLabel("<b>" + this.data.format + "</b>"));
        this.addAttribute(this.constants.PackageMetaData(), this.packageEditor(this.data.packageName));
        this.addAttribute(this.constants.IsDisabledMetaData(), this.editableBoolean((FieldBooleanBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.DisableTip()));
        this.addAttribute("UUID:", (Widget)this.readOnlyText(this.uuid));
        this.endSection(false);
        this.startSection(this.constants.OtherMetaData());
        this.addAttribute(this.constants.SubjectMetaData(), this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.AShortDescriptionOfTheSubjectMatter()));
        this.addAttribute(this.constants.TypeMetaData(), this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.TypeTip()));
        this.addAttribute(this.constants.ExternalLinkMetaData(), this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.ExternalLinkTip()));
        this.addAttribute(this.constants.SourceMetaData(), this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.SourceMetaDataTip()));
        this.endSection(true);
        this.startSection(this.constants.VersionHistory());
        this.addAttribute(this.constants.CurrentVersionNumber(), this.getVersionNumberLabel());
        if (!this.readOnly) {
            this.addRow(new VersionBrowser(this.uuid, this.data, this.fullRefreshView));
        }
        this.endSection(false);
    }

    private void addRow(VersionBrowser versionBrowser) {
        this.currentSection.addRow((Widget)versionBrowser);
    }

    private void addAttribute(String string, Widget editable) {
        this.currentSection.addAttribute(string, editable);
    }

    private void endSection() {
        this.endSection(false);
    }

    private void endSection(boolean collapsed) {
        DecoratedDisclosurePanel advancedDisclosure = new DecoratedDisclosurePanel(this.currentSectionName);
        advancedDisclosure.setWidth("100%");
        advancedDisclosure.setOpen(collapsed);
        advancedDisclosure.setContent((Widget)this.currentSection);
        this.layout.add((Widget)advancedDisclosure);
    }

    private void startSection(String name) {
        this.currentSection = new FormStyleLayout();
        this.currentSectionName = name;
    }

    private Widget packageEditor(String packageName) {
        if (this.readOnly || !CapabilitiesManager.getInstance().shouldShow(new Integer[]{Capabilities.SHOW_PACKAGE_VIEW})) {
            return this.readOnlyText(packageName);
        }
        HorizontalPanel horiz = new HorizontalPanel();
        horiz.setStyleName("metadata-Widget");
        horiz.add((Widget)this.readOnlyText(packageName));
        ImageButton editPackage = new ImageButton(images.edit());
        editPackage.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        horiz.add((Widget)editPackage);
        return horiz;
    }

    private void showRenameAsset(ClickEvent source) {
        FormStylePopup pop = new FormStylePopup(images.packageLarge(), this.constants.RenameThisItem());
        TextBox box = new TextBox();
        box.setText(this.data.name);
        pop.addAttribute(this.constants.NewNameAsset(), (Widget)box);
        Button ok = new Button(this.constants.RenameItem());
        pop.addAttribute("", (Widget)ok);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void showEditPackage(String pkg, ClickEvent source) {
        FormStylePopup pop = new FormStylePopup(images.packageLarge(), this.constants.MoveThisItemToAnotherPackage());
        pop.addAttribute(this.constants.CurrentPackage(), (Widget)new Label(pkg));
        RulePackageSelector sel = new RulePackageSelector();
        pop.addAttribute(this.constants.NewPackage(), (Widget)sel);
        Button ok = new Button(this.constants.ChangePackage());
        pop.addAttribute("", (Widget)ok);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private Widget getVersionNumberLabel() {
        if (this.data.versionNumber == 0L) {
            return new SmallLabel(this.constants.NotCheckedInYet());
        }
        return this.readOnlyText(Long.toString(this.data.versionNumber));
    }

    private Widget readOnlyDate(Date lastModifiedDate) {
        if (lastModifiedDate == null) {
            return null;
        }
        return new SmallLabel(lastModifiedDate.toLocaleString());
    }

    private Label readOnlyText(String text) {
        SmallLabel lbl = new SmallLabel(text);
        lbl.setWidth("100%");
        return lbl;
    }

    private Widget categories() {
        this.ed = new AssetCategoryEditor(this.data, this.readOnly);
        return this.ed;
    }

    private Widget editableText(FieldBinding bind, String toolTip) {
        if (!this.readOnly) {
            TextBox box = new TextBox();
            box.setTitle(toolTip);
            box.setText(bind.getValue());
            box.setVisibleLength(10);
            10 listener = new /* Unavailable Anonymous Inner Class!! */;
            box.addChangeHandler((ChangeHandler)listener);
            return box;
        }
        return new Label(bind.getValue());
    }

    private Widget editableBoolean(FieldBooleanBinding bind, String toolTip) {
        if (!this.readOnly) {
            CheckBox box = new CheckBox();
            box.setTitle(toolTip);
            box.setEnabled(bind.getValue());
            11 listener = new /* Unavailable Anonymous Inner Class!! */;
            box.addClickHandler((ClickHandler)listener);
            return box;
        }
        CheckBox box = new CheckBox();
        box.setEnabled(bind.getValue());
        box.setEnabled(false);
        return box;
    }

    public MetaData getData() {
        return this.data;
    }

    public void refresh() {
        this.render();
    }

    static /* synthetic */ void access$000(MetaDataWidget x0, ClickEvent x1) {
        x0.showRenameAsset(x1);
    }

    static /* synthetic */ MetaData access$100(MetaDataWidget x0) {
        return x0.data;
    }

    static /* synthetic */ void access$200(MetaDataWidget x0, String x1, ClickEvent x2) {
        x0.showEditPackage(x1, x2);
    }

    static /* synthetic */ String access$300(MetaDataWidget x0) {
        return x0.uuid;
    }

    static /* synthetic */ Command access$400(MetaDataWidget x0) {
        return x0.metaDataRefreshView;
    }

    static /* synthetic */ Constants access$500(MetaDataWidget x0) {
        return x0.constants;
    }
}

