/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.drools.factconstraints.client.helper.ConstraintsContainer;
import org.drools.factconstraints.client.helper.CustomFormsContainer;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.WorkingSetConfigData;
import org.drools.guvnor.client.ruleeditor.CustomFormsEditorPanel;
import org.drools.guvnor.client.ruleeditor.EditorWidget;
import org.drools.guvnor.client.ruleeditor.FactsConstraintsEditorPanel;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;

public class WorkingSetEditor
extends Composite
implements EditorWidget {
    private RuleAsset workingSet;
    private ListBox availFacts = new ListBox(true);
    private ListBox validFacts = new ListBox(true);
    private ConstraintsContainer cc;
    private CustomFormsContainer cfc;
    private FactsConstraintsEditorPanel factsConstraintsgEditorPanel;
    private CustomFormsEditorPanel customFormsEditorPanel;

    public WorkingSetEditor(RuleAsset asset) {
        if (!"workingset".equals(asset.metaData.format)) {
            throw new IllegalArgumentException("asset must a be a workingset not a: " + asset.metaData.format);
        }
        this.workingSet = asset;
        WorkingSetConfigData wsData = (WorkingSetConfigData)this.workingSet.content;
        this.cc = new ConstraintsContainer((Collection)wsData.constraints);
        this.cfc = new CustomFormsContainer((Collection)wsData.customForms);
        this.refreshWidgets();
        this.setWidth("100%");
    }

    private void refreshWidgets() {
        WorkingSetConfigData wsData = (WorkingSetConfigData)this.workingSet.content;
        TabPanel tPanel = new TabPanel();
        ScrollPanel pnl = new ScrollPanel();
        pnl.setTitle("WS Definition");
        pnl.add((Widget)this.buildDoubleList(wsData));
        tPanel.add((Widget)pnl, "WS Definition");
        pnl = new ScrollPanel();
        this.factsConstraintsgEditorPanel = new FactsConstraintsEditorPanel(this);
        pnl.add((Widget)this.factsConstraintsgEditorPanel);
        tPanel.add((Widget)pnl, "WS Constraints");
        pnl = new ScrollPanel();
        pnl.setTitle("WS Custom Forms");
        this.customFormsEditorPanel = new CustomFormsEditorPanel(this);
        pnl.add((Widget)this.customFormsEditorPanel);
        tPanel.add((Widget)pnl, "WS Custom Forms");
        tPanel.addBeforeSelectionHandler((BeforeSelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        tPanel.selectTab(0);
        this.initWidget((Widget)tPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Grid buildDoubleList(WorkingSetConfigData wsData) {
        Grid grid = new Grid(2, 3);
        SuggestionCompletionEngine sce = SuggestionCompletionCache.getInstance().getEngineFromCache(this.workingSet.metaData.packageName);
        boolean filteringFact = sce.isFilteringFacts();
        sce.setFilteringFacts(false);
        try {
            HashSet<String> elem = new HashSet<String>();
            this.availFacts.setVisibleItemCount(10);
            this.validFacts.setVisibleItemCount(10);
            if (wsData.validFacts != null) {
                elem.addAll(Arrays.asList(wsData.validFacts));
                for (String factName : wsData.validFacts) {
                    this.validFacts.addItem(factName);
                }
            }
            for (String factName : sce.getFactTypes()) {
                if (elem.contains(factName)) continue;
                this.availFacts.addItem(factName);
            }
            Grid btnsPanel = new Grid(2, 1);
            btnsPanel.setWidget(0, 0, (Widget)new Button(">", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
            btnsPanel.setWidget(1, 0, (Widget)new Button("&lt;", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
            grid.setWidget(0, 0, (Widget)new SmallLabel("Available Facts"));
            grid.setWidget(0, 1, (Widget)new SmallLabel(""));
            grid.setWidget(0, 2, (Widget)new SmallLabel("WorkingSet Facts"));
            grid.setWidget(1, 0, (Widget)this.availFacts);
            grid.setWidget(1, 1, (Widget)btnsPanel);
            grid.setWidget(1, 2, (Widget)this.validFacts);
            grid.getColumnFormatter().setWidth(0, "45%");
            grid.getColumnFormatter().setWidth(0, "10%");
            grid.getColumnFormatter().setWidth(0, "45%");
            Grid grid2 = grid;
            return grid2;
        }
        finally {
            sce.setFilteringFacts(filteringFact);
        }
    }

    private void updateAsset(ListBox availFacts) {
        ArrayList<String> l = new ArrayList<String>(availFacts.getItemCount());
        for (int i = 0; i < availFacts.getItemCount(); ++i) {
            l.add(availFacts.getItemText(i));
        }
        ((WorkingSetConfigData)this.workingSet.content).validFacts = l.toArray(new String[l.size()]);
    }

    private void copySelected(ListBox from, ListBox to) {
        int selected;
        while ((selected = from.getSelectedIndex()) != -1) {
            to.addItem(from.getItemText(selected));
            from.removeItem(selected);
            this.factsConstraintsgEditorPanel.notifyValidFactsChanged();
            this.customFormsEditorPanel.notifyValidFactsChanged();
        }
    }

    public ConstraintsContainer getConstraintsConstrainer() {
        return this.cc;
    }

    public CustomFormsContainer getCustomFormsContainer() {
        return this.cfc;
    }

    protected RuleAsset getWorkingSet() {
        return this.workingSet;
    }

    protected ListBox getValidFactsListBox() {
        return this.validFacts;
    }

    static /* synthetic */ FactsConstraintsEditorPanel access$000(WorkingSetEditor x0) {
        return x0.factsConstraintsgEditorPanel;
    }

    static /* synthetic */ CustomFormsEditorPanel access$100(WorkingSetEditor x0) {
        return x0.customFormsEditorPanel;
    }

    static /* synthetic */ ListBox access$200(WorkingSetEditor x0) {
        return x0.availFacts;
    }

    static /* synthetic */ ListBox access$300(WorkingSetEditor x0) {
        return x0.validFacts;
    }

    static /* synthetic */ void access$400(WorkingSetEditor x0, ListBox x1, ListBox x2) {
        x0.copySelected(x1, x2);
    }

    static /* synthetic */ void access$500(WorkingSetEditor x0, ListBox x1) {
        x0.updateAsset(x1);
    }
}

