/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.table;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ClickableTextCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import org.drools.guvnor.client.table.SortDirection;
import org.drools.guvnor.client.table.SortableHeader;
import org.drools.guvnor.client.table.SortableHeaderGroup;
import org.drools.guvnor.client.table.TableImageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableHeader<T, C extends Comparable>
extends Header<String> {
    private static final TableImageResources TABLE_IMAGE_RESOURCES = (TableImageResources)GWT.create(TableImageResources.class);
    private static final String DOWN_ARROW = SortableHeader.makeImage((ImageResource)TABLE_IMAGE_RESOURCES.downArrow());
    private static final String SMALL_DOWN_ARROW = SortableHeader.makeImage((ImageResource)TABLE_IMAGE_RESOURCES.smallDownArrow());
    private static final String UP_ARROW = SortableHeader.makeImage((ImageResource)TABLE_IMAGE_RESOURCES.upArrow());
    private static final String SMALL_UP_ARROW = SortableHeader.makeImage((ImageResource)TABLE_IMAGE_RESOURCES.smallUpArrow());
    private final SortableHeaderGroup sortableHeaderGroup;
    private String text;
    private final Column<T, C> column;
    private SortDirection sortDirection = SortDirection.NONE;
    private int sortIndex = -1;

    private static String makeImage(ImageResource resource) {
        AbstractImagePrototype prototype = AbstractImagePrototype.create((ImageResource)resource);
        return prototype.getHTML();
    }

    public SortableHeader(SortableHeaderGroup sortableHeaderGroup, String text, Column<T, C> column) {
        super((Cell)new ClickableTextCell());
        this.sortableHeaderGroup = sortableHeaderGroup;
        this.text = text;
        this.column = column;
        this.setUpdater((ValueUpdater)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getValue() {
        return this.text;
    }

    public Column<T, C> getColumn() {
        return this.column;
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public void render(Cell.Context context, SafeHtmlBuilder sb) {
        sb.appendHtmlConstant("<div style='position: relative; cursor: pointer; padding: 0px;'>");
        sb.appendHtmlConstant("<span style='padding-right: 10px'>");
        sb.appendEscaped(this.text);
        sb.appendHtmlConstant("</span>");
        switch (2.$SwitchMap$org$drools$guvnor$client$table$SortDirection[this.sortDirection.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                sb.appendHtmlConstant(this.sortIndex == 0 ? UP_ARROW : SMALL_UP_ARROW);
                break;
            }
            case 3: {
                sb.appendHtmlConstant(this.sortIndex == 0 ? DOWN_ARROW : SMALL_DOWN_ARROW);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown sortDirection (" + this.sortDirection + ").");
            }
        }
        sb.appendHtmlConstant("</div>");
    }

    static /* synthetic */ SortableHeaderGroup access$000(SortableHeader x0) {
        return x0.sortableHeaderGroup;
    }
}

