/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.decoratedgrid;

import org.drools.guvnor.client.widgets.decoratedgrid.Coordinate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellValue<T extends Comparable<T>>
implements Comparable<CellValue<T>> {
    private T value;
    private int rowSpan = 1;
    private Coordinate coordinate;
    private Coordinate mapHtmlToData;
    private Coordinate mapDataToHtml;
    private boolean isSelected;

    public CellValue(T value, int row, int col) {
        this.value = value;
        this.coordinate = new Coordinate(row, col);
        this.mapHtmlToData = new Coordinate(row, col);
        this.mapDataToHtml = new Coordinate(row, col);
    }

    @Override
    public int compareTo(CellValue<T> cv) {
        if (this.value == null) {
            if (cv.value == null) {
                return 0;
            }
            return 1;
        }
        if (cv.value == null) {
            return -1;
        }
        return this.value.compareTo(cv.value);
    }

    public T getValue() {
        return (T)this.value;
    }

    public void setHtmlCoordinate(Coordinate c) {
        if (c == null) {
            throw new IllegalArgumentException("Coordinate cannot be null.");
        }
        this.mapDataToHtml = c;
    }

    public void setValue(Object value) {
        this.value = (Comparable)value;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public Coordinate getHtmlCoordinate() {
        return new Coordinate(this.mapDataToHtml);
    }

    public Coordinate getPhysicalCoordinate() {
        return new Coordinate(this.mapHtmlToData);
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void setCoordinate(Coordinate coordinate) {
        if (coordinate == null) {
            throw new IllegalArgumentException("Coordinate cannot be null.");
        }
        this.coordinate = coordinate;
    }

    public void setPhysicalCoordinate(Coordinate c) {
        if (c == null) {
            throw new IllegalArgumentException("Coordinate cannot be null.");
        }
        this.mapHtmlToData = c;
    }

    public void setRowSpan(int rowSpan) {
        if (rowSpan < 0) {
            throw new IllegalArgumentException("rowSpan cannot be less than zero.");
        }
        this.rowSpan = rowSpan;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CellValue)) {
            return false;
        }
        CellValue that = (CellValue)obj;
        return this.nullOrEqual((Object)this.value, (Object)that.value) && this.rowSpan == that.rowSpan && this.nullOrEqual((Object)this.coordinate, (Object)that.coordinate) && this.nullOrEqual((Object)this.mapHtmlToData, (Object)that.mapHtmlToData) && this.nullOrEqual((Object)this.mapDataToHtml, (Object)that.mapDataToHtml) && this.isSelected == that.isSelected;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + (this.value == null ? 0 : this.value.hashCode());
        hash = hash * 31 + this.rowSpan;
        hash = hash * 31 + (this.coordinate == null ? 0 : this.coordinate.hashCode());
        hash = hash * 31 + (this.mapHtmlToData == null ? 0 : this.mapHtmlToData.hashCode());
        hash = hash * 31 + (this.mapDataToHtml == null ? 0 : this.mapDataToHtml.hashCode());
        hash = hash * 31 + Boolean.valueOf(this.isSelected).hashCode();
        return hash;
    }

    private boolean nullOrEqual(Object thisAttr, Object thatAttr) {
        if (thisAttr == null && thatAttr == null) {
            return true;
        }
        if (thisAttr == null && thatAttr != null) {
            return false;
        }
        return thisAttr.equals(thatAttr);
    }
}

