/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.decoratedgrid;

import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.drools.guvnor.client.resources.DecisionTableResources;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.decoratedgrid.Coordinate;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridHeaderWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridSidebarWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicData;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicDataRow;
import org.drools.guvnor.client.widgets.decoratedgrid.HasSystemControlledColumns;
import org.drools.guvnor.client.widgets.decoratedgrid.MergableGridWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DecoratedGridWidget<T>
extends Composite
implements ValueUpdater<Object> {
    protected Panel mainPanel;
    protected Panel bodyPanel;
    protected FocusPanel mainFocusPanel;
    protected ScrollPanel scrollPanel;
    protected MergableGridWidget<T> gridWidget;
    protected DecoratedGridHeaderWidget<T> headerWidget;
    protected DecoratedGridSidebarWidget<T> sidebarWidget;
    protected HasSystemControlledColumns hasSystemControlledColumns;
    protected boolean isMerged = false;
    protected DynamicData data = new DynamicData();
    protected List<DynamicColumn<T>> columns = new ArrayList();
    protected int height;
    protected int width;
    protected static final DecisionTableResources resource = (DecisionTableResources)GWT.create(DecisionTableResources.class);
    protected static final DecisionTableResources.DecisionTableStyle style = resource.cellTableStyle();
    private TreeSet<CellValue<? extends Comparable<?>>> selections = new TreeSet(new /* Unavailable Anonymous Inner Class!! */);

    public DecoratedGridWidget() {
        this.mainPanel = this.getMainPanel();
        this.bodyPanel = this.getBodyPanel();
        this.gridWidget = this.getGridWidget();
        if (this.mainPanel == null) {
            throw new IllegalArgumentException("mainPanel cannot be null");
        }
        if (this.bodyPanel == null) {
            throw new IllegalArgumentException("bodyPanel cannot be null");
        }
        if (this.gridWidget == null) {
            throw new IllegalArgumentException("gridWidget cannot be null");
        }
        this.scrollPanel = new ScrollPanel();
        this.scrollPanel.add((Widget)this.gridWidget);
        this.scrollPanel.addScrollHandler(this.getScrollHandler());
        this.mainFocusPanel = new FocusPanel((Widget)this.mainPanel);
        this.initWidget((Widget)this.mainFocusPanel);
    }

    public void appendColumn(DynamicColumn<T> column, List<CellValue<?>> columnData, boolean bRedraw) {
        if (column == null) {
            throw new IllegalArgumentException("Column cannot be null.");
        }
        if (columnData == null) {
            throw new IllegalArgumentException("columnData cannot be null");
        }
        if (columnData.size() != this.data.size()) {
            throw new IllegalArgumentException("columnData contains a different number of rows to the grid");
        }
        this.insertColumnBefore(null, column, columnData, bRedraw);
    }

    public void appendRow(DynamicDataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row cannot be null");
        }
        this.clearSelection();
        this.insertRowBefore(null, row);
    }

    public void assertDimensions() {
        this.headerWidget.setWidth(this.scrollPanel.getElement().getClientWidth() + "px");
        this.sidebarWidget.setHeight(this.scrollPanel.getElement().getClientHeight() + "px");
    }

    public void assertModelIndexes() {
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            DynamicDataRow row = (DynamicDataRow)this.data.get(iRow);
            int colCount = 0;
            for (int iCol = 0; iCol < row.size(); ++iCol) {
                int newRow = iRow;
                int newCol = colCount;
                CellValue indexCell = (CellValue)row.get(iCol);
                DynamicColumn column = (DynamicColumn)this.columns.get(iCol);
                if (column.isVisible()) {
                    if (indexCell.getRowSpan() != 0) {
                        newRow = iRow;
                        newCol = colCount++;
                        CellValue cell = (CellValue)((DynamicDataRow)this.data.get(newRow)).get(newCol);
                        cell.setPhysicalCoordinate(new Coordinate(iRow, iCol));
                    } else {
                        DynamicDataRow priorRow = (DynamicDataRow)this.data.get(iRow - 1);
                        CellValue priorCell = (CellValue)priorRow.get(iCol);
                        Coordinate priorHtmlCoordinate = priorCell.getHtmlCoordinate();
                        newRow = priorHtmlCoordinate.getRow();
                        newCol = priorHtmlCoordinate.getCol();
                    }
                }
                indexCell.setCoordinate(new Coordinate(iRow, iCol));
                indexCell.setHtmlCoordinate(new Coordinate(newRow, newCol));
            }
        }
    }

    public void deleteColumn(DynamicColumn<T> column) {
        if (column == null) {
            throw new IllegalArgumentException("Column cannot be null.");
        }
        this.deleteColumn(column, true);
    }

    public void deleteRow(DynamicDataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row cannot be null");
        }
        int index = this.data.indexOf((Object)row);
        if (index == -1) {
            throw new IllegalArgumentException("DynamicDataRow does not exist in table data.");
        }
        this.clearSelection();
        this.data.remove(index);
        if (!this.isMerged) {
            this.gridWidget.deleteRow(index);
            this.assertModelIndexes();
        } else {
            this.gridWidget.deleteRow(index);
            if (this.data.size() > 0) {
                this.assertModelMerging();
                int minRedrawRow = this.findMinRedrawRow(index - 1);
                int maxRedrawRow = this.findMaxRedrawRow(index - 1) + 1;
                if (maxRedrawRow > this.data.size() - 1) {
                    maxRedrawRow = this.data.size() - 1;
                }
                this.gridWidget.redrawRows(minRedrawRow, maxRedrawRow);
            }
        }
        this.assertDimensions();
    }

    public abstract Panel getBodyPanel();

    public List<DynamicColumn<T>> getColumns() {
        return this.columns;
    }

    public DynamicData getData() {
        return this.data;
    }

    public abstract MergableGridWidget<T> getGridWidget();

    public DecoratedGridHeaderWidget<T> getHeaderWidget() {
        return this.headerWidget;
    }

    public abstract Panel getMainPanel();

    public abstract ScrollHandler getScrollHandler();

    public TreeSet<CellValue<? extends Comparable<?>>> getSelections() {
        return this.selections;
    }

    public DecoratedGridSidebarWidget<T> getSidebarWidget() {
        return this.sidebarWidget;
    }

    public void insertColumnBefore(DynamicColumn<T> columnBefore, DynamicColumn<T> newColumn, List<CellValue<?>> columnData, boolean bRedraw) {
        int index = this.columns.size();
        if (columnBefore != null) {
            index = this.columns.indexOf(columnBefore);
            if (index == -1) {
                throw new IllegalArgumentException("columnBefore does not exist in table data.");
            }
            ++index;
        }
        if (newColumn == null) {
            throw new IllegalArgumentException("newColumn cannot be null");
        }
        if (columnData == null) {
            throw new IllegalArgumentException("columnData cannot be null");
        }
        if (columnData.size() != this.data.size()) {
            throw new IllegalArgumentException("columnData contains a different number of rows to the grid");
        }
        this.columns.add(index, newColumn);
        this.reindexColumns();
        for (int iRow = 0; iRow < columnData.size(); ++iRow) {
            CellValue<?> cv = columnData.get(iRow);
            ((DynamicDataRow)this.data.get(iRow)).add(index, cv);
        }
        this.assertModelIndexes();
        if (bRedraw) {
            this.gridWidget.redrawColumns(index, this.columns.size() - 1);
            this.headerWidget.redraw();
            this.assertDimensions();
        }
    }

    public void insertRowBefore(DynamicDataRow rowBefore, DynamicDataRow newRow) {
        int index = this.data.size();
        if (rowBefore != null && (index = this.data.indexOf((Object)rowBefore)) == -1) {
            throw new IllegalArgumentException("rowBefore does not exist in table data.");
        }
        if (newRow == null) {
            throw new IllegalArgumentException("newRow cannot be null");
        }
        if (newRow.size() != this.columns.size()) {
            throw new IllegalArgumentException("newRow contains a different number of columns to the grid");
        }
        int minRedrawRow = index;
        int maxRedrawRow = index;
        if (this.isMerged) {
            if (index < this.data.size()) {
                minRedrawRow = this.findMinRedrawRow(index);
                maxRedrawRow = this.findMaxRedrawRow(index) + 1;
            } else {
                minRedrawRow = this.findMinRedrawRow(index > 0 ? index - 1 : index);
                maxRedrawRow = index;
            }
        }
        this.data.add(index, (Object)newRow);
        if (!this.isMerged) {
            this.assertModelIndexes();
            this.gridWidget.insertRowBefore(index, newRow);
        } else {
            this.assertModelMerging();
            this.gridWidget.insertRowBefore(index, newRow);
            this.gridWidget.redrawRows(minRedrawRow, maxRedrawRow);
        }
        this.assertDimensions();
    }

    public boolean isMerged() {
        return this.isMerged;
    }

    public void moveSelection(MOVE_DIRECTION dir) {
        if (this.selections.size() > 0) {
            int step = 0;
            Coordinate nc = null;
            MergableGridWidget.CellExtents ce = null;
            Coordinate c = ((CellValue)this.selections.first()).getCoordinate();
            switch (5.$SwitchMap$org$drools$guvnor$client$widgets$decoratedgrid$DecoratedGridWidget$MOVE_DIRECTION[dir.ordinal()]) {
                case 1: {
                    int n = step = c.getCol() > 0 ? 1 : 0;
                    if (step <= 0) break;
                    nc = new Coordinate(c.getRow(), c.getCol() - step);
                    while (nc.getCol() > 0 && !((DynamicColumn)this.columns.get(nc.getCol())).isVisible()) {
                        nc = new Coordinate(c.getRow(), nc.getCol() - step);
                    }
                    this.startSelecting(nc);
                    ce = this.gridWidget.getSelectedCellExtents((CellValue)this.selections.first());
                    if (ce.getOffsetX() >= this.scrollPanel.getHorizontalScrollPosition()) break;
                    this.scrollPanel.setHorizontalScrollPosition(ce.getOffsetX());
                    break;
                }
                case 2: {
                    int n = step = c.getCol() < this.columns.size() - 1 ? 1 : 0;
                    if (step <= 0) break;
                    nc = new Coordinate(c.getRow(), c.getCol() + step);
                    while (nc.getCol() < this.columns.size() - 2 && !((DynamicColumn)this.columns.get(nc.getCol())).isVisible()) {
                        nc = new Coordinate(c.getRow(), nc.getCol() + step);
                    }
                    this.startSelecting(nc);
                    ce = this.gridWidget.getSelectedCellExtents((CellValue)this.selections.first());
                    int scrollWidth = this.scrollPanel.getElement().getClientWidth();
                    if (ce.getOffsetX() + ce.getWidth() <= scrollWidth + this.scrollPanel.getHorizontalScrollPosition()) break;
                    int delta = ce.getOffsetX() + ce.getWidth() - this.scrollPanel.getHorizontalScrollPosition() - scrollWidth;
                    this.scrollPanel.setHorizontalScrollPosition(this.scrollPanel.getHorizontalScrollPosition() + delta);
                    break;
                }
                case 3: {
                    int n = step = c.getRow() > 0 ? 1 : 0;
                    if (step <= 0) break;
                    nc = new Coordinate(c.getRow() - step, c.getCol());
                    this.startSelecting(nc);
                    ce = this.gridWidget.getSelectedCellExtents((CellValue)this.selections.first());
                    if (ce.getOffsetY() >= this.scrollPanel.getScrollPosition()) break;
                    this.scrollPanel.setScrollPosition(ce.getOffsetY());
                    break;
                }
                case 4: {
                    int n = step = c.getRow() < this.data.size() - 1 ? 1 : 0;
                    if (step <= 0) break;
                    nc = new Coordinate(c.getRow() + step, c.getCol());
                    this.startSelecting(nc);
                    ce = this.gridWidget.getSelectedCellExtents((CellValue)this.selections.first());
                    int scrollHeight = this.scrollPanel.getElement().getClientHeight();
                    if (ce.getOffsetY() + ce.getHeight() <= scrollHeight + this.scrollPanel.getScrollPosition()) break;
                    int delta = ce.getOffsetY() + ce.getHeight() - this.scrollPanel.getScrollPosition() - scrollHeight;
                    this.scrollPanel.setScrollPosition(this.scrollPanel.getScrollPosition() + delta);
                }
            }
        }
    }

    public void redrawSystemControlledColumns() {
        for (DynamicColumn col : this.columns) {
            if (!col.isSystemControlled()) continue;
            this.gridWidget.redrawColumn(col.getColumnIndex());
        }
    }

    public void setColumnVisibility(int index, boolean isVisible) {
        if (index < 0 || index > this.columns.size()) {
            throw new IllegalArgumentException("Column index must be greater than zero and less than then number of declared columns.");
        }
        if (isVisible && !((DynamicColumn)this.columns.get(index)).isVisible()) {
            ((DynamicColumn)this.columns.get(index)).setVisible(isVisible);
            this.assertModelIndexes();
            this.gridWidget.showColumn(index);
            this.headerWidget.redraw();
        } else if (!isVisible && ((DynamicColumn)this.columns.get(index)).isVisible()) {
            ((DynamicColumn)this.columns.get(index)).setVisible(isVisible);
            this.assertModelIndexes();
            this.gridWidget.hideColumn(index);
            this.headerWidget.redraw();
        }
    }

    public void setHasSystemControlledColumns(HasSystemControlledColumns hasSystemControlledColumns) {
        this.hasSystemControlledColumns = hasSystemControlledColumns;
    }

    public abstract void setHeaderWidget(DecoratedGridHeaderWidget<T> var1);

    public void setPixelSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be less than zero");
        }
        super.setPixelSize(width, height);
        this.height = height;
        this.setHeight(height);
        this.setWidth(width);
    }

    public abstract void setSidebarWidget(DecoratedGridSidebarWidget<T> var1);

    public void sort() {
        DynamicColumn[] sortOrderList = new DynamicColumn[this.columns.size()];
        int index = 0;
        for (DynamicColumn column : this.columns) {
            int sortIndex = column.getSortIndex();
            if (sortIndex == -1) continue;
            sortOrderList[sortIndex] = column;
            ++index;
        }
        int sortedColumnCount = index;
        Collections.sort(this.data, new /* Unavailable Anonymous Inner Class!! */);
        this.removeModelMerging();
        this.assertModelMerging();
        if (this.hasSystemControlledColumns != null) {
            this.hasSystemControlledColumns.updateSystemControlledColumnValues();
        }
        this.gridWidget.redraw();
    }

    public void startSelecting(Coordinate start) {
        if (start == null) {
            throw new IllegalArgumentException("start cannot be null");
        }
        this.clearSelection();
        CellValue startCell = this.data.get(start);
        this.extendSelection(startCell.getCoordinate());
    }

    public boolean toggleMerging() {
        if (!this.isMerged) {
            this.isMerged = true;
            this.clearSelection();
            this.assertModelMerging();
            this.gridWidget.redraw();
        } else {
            this.isMerged = false;
            this.clearSelection();
            this.removeModelMerging();
            this.gridWidget.redraw();
        }
        return this.isMerged;
    }

    public void update(Object value) {
        for (CellValue cell : this.selections) {
            Coordinate c = cell.getCoordinate();
            if (((DynamicColumn)this.columns.get(c.getCol())).isSystemControlled()) continue;
            this.data.set(c, value);
        }
        this.assertModelMerging();
        int baseRowIndex = ((CellValue)this.selections.first()).getPhysicalCoordinate().getRow();
        int minRedrawRow = this.findMinRedrawRow(baseRowIndex);
        int maxRedrawRow = this.findMaxRedrawRow(baseRowIndex);
        if (maxRedrawRow < ((CellValue)this.selections.last()).getPhysicalCoordinate().getRow()) {
            maxRedrawRow = ((CellValue)this.selections.last()).getPhysicalCoordinate().getRow();
        }
        this.gridWidget.redrawRows(minRedrawRow, maxRedrawRow);
        this.gridWidget.selectCell((CellValue)this.selections.first());
    }

    private void assertModelMerging() {
        boolean minRowIndex = false;
        int maxRowIndex = this.data.size() - 1;
        for (int iCol = 0; iCol < this.columns.size(); ++iCol) {
            for (int iRow = 0; iRow <= maxRowIndex; ++iRow) {
                int rowSpan = 1;
                CellValue cell1 = (CellValue)((DynamicDataRow)this.data.get(iRow)).get(iCol);
                if (iRow + rowSpan < this.data.size()) {
                    CellValue cell2 = (CellValue)((DynamicDataRow)this.data.get(iRow + rowSpan)).get(iCol);
                    if (this.isMerged && !cell1.isEmpty() && !cell2.isEmpty()) {
                        while (cell1.getValue().equals(cell2.getValue()) && iRow + rowSpan < maxRowIndex) {
                            cell2.setRowSpan(0);
                            cell2 = (CellValue)((DynamicDataRow)this.data.get(iRow + ++rowSpan)).get(iCol);
                        }
                        if (cell1.getValue().equals(cell2.getValue())) {
                            cell2.setRowSpan(0);
                            ++rowSpan;
                        }
                    }
                    cell1.setRowSpan(rowSpan);
                    iRow = iRow + rowSpan - 1;
                    continue;
                }
                cell1.setRowSpan(rowSpan);
            }
        }
        this.assertModelIndexes();
    }

    private void clearSelection() {
        for (CellValue cell : this.selections) {
            cell.setSelected(false);
            this.gridWidget.deselectCell(cell);
        }
        this.selections.clear();
    }

    private void deleteColumn(DynamicColumn<T> column, boolean bRedraw) {
        int index = this.columns.indexOf(column);
        if (index == -1) {
            throw new IllegalArgumentException("Column not found in declared columns.");
        }
        this.clearSelection();
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            DynamicDataRow row = (DynamicDataRow)this.data.get(iRow);
            row.remove(index);
        }
        this.columns.remove(index);
        this.reindexColumns();
        if (bRedraw) {
            this.assertModelIndexes();
            this.gridWidget.redraw();
            this.headerWidget.redraw();
        }
    }

    private void extendSelection(Coordinate coordinate) {
        CellValue startCell;
        CellValue endCell = startCell = this.data.get(coordinate);
        while (startCell.getRowSpan() == 0) {
            startCell = (CellValue)((DynamicDataRow)this.data.get(startCell.getCoordinate().getRow() - 1)).get(startCell.getCoordinate().getCol());
        }
        if (startCell.getRowSpan() > 1) {
            endCell = (CellValue)((DynamicDataRow)this.data.get(startCell.getCoordinate().getRow() + startCell.getRowSpan() - 1)).get(startCell.getCoordinate().getCol());
        }
        this.selectRange(startCell, endCell);
    }

    private int findMaxRedrawRow(int baseRowIndex) {
        if (this.data.size() == 0) {
            return 0;
        }
        if (baseRowIndex < 0) {
            baseRowIndex = 0;
        }
        if (baseRowIndex > this.data.size() - 1) {
            baseRowIndex = this.data.size() - 1;
        }
        int maxRedrawRow = baseRowIndex;
        DynamicDataRow baseRow = (DynamicDataRow)this.data.get(baseRowIndex);
        for (int iCol = 0; iCol < baseRow.size(); ++iCol) {
            int iRow = baseRowIndex;
            CellValue cell = (CellValue)baseRow.get(iCol);
            while (cell.getRowSpan() != 1 && iRow < this.data.size() - 1) {
                DynamicDataRow row = (DynamicDataRow)this.data.get(++iRow);
                cell = (CellValue)row.get(iCol);
            }
            maxRedrawRow = iRow > maxRedrawRow ? iRow : maxRedrawRow;
        }
        return maxRedrawRow;
    }

    private int findMinRedrawRow(int baseRowIndex) {
        if (this.data.size() == 0) {
            return 0;
        }
        if (baseRowIndex < 0) {
            baseRowIndex = 0;
        }
        if (baseRowIndex > this.data.size() - 1) {
            baseRowIndex = this.data.size() - 1;
        }
        int minRedrawRow = baseRowIndex;
        DynamicDataRow baseRow = (DynamicDataRow)this.data.get(baseRowIndex);
        for (int iCol = 0; iCol < baseRow.size(); ++iCol) {
            int iRow = baseRowIndex;
            CellValue cell = (CellValue)baseRow.get(iCol);
            while (cell.getRowSpan() != 1 && iRow > 0) {
                DynamicDataRow row = (DynamicDataRow)this.data.get(--iRow);
                cell = (CellValue)row.get(iCol);
            }
            minRedrawRow = iRow < minRedrawRow ? iRow : minRedrawRow;
        }
        return minRedrawRow;
    }

    private void reindexColumns() {
        for (int iCol = 0; iCol < this.columns.size(); ++iCol) {
            DynamicColumn col = (DynamicColumn)this.columns.get(iCol);
            col.setColumnIndex(iCol);
        }
    }

    private void removeModelMerging() {
        for (int iCol = 0; iCol < this.columns.size(); ++iCol) {
            for (int iRow = 0; iRow < this.data.size(); ++iRow) {
                CellValue cell = (CellValue)((DynamicDataRow)this.data.get(iRow)).get(iCol);
                Coordinate c = new Coordinate(iRow, iCol);
                cell.setCoordinate(c);
                cell.setHtmlCoordinate(c);
                cell.setPhysicalCoordinate(c);
                cell.setRowSpan(1);
            }
        }
        this.assertModelIndexes();
    }

    private void selectRange(CellValue<?> startCell, CellValue<?> endCell) {
        int col = startCell.getCoordinate().getCol();
        for (int iRow = startCell.getCoordinate().getRow(); iRow <= endCell.getCoordinate().getRow(); ++iRow) {
            CellValue cell = (CellValue)((DynamicDataRow)this.data.get(iRow)).get(col);
            this.selections.add(cell);
            cell.setSelected(true);
            this.gridWidget.selectCell(cell);
        }
    }

    private void setHeight(int height) {
        this.mainPanel.setHeight(height + "px");
        this.mainFocusPanel.setHeight(height + "px");
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setWidth(int width) {
        this.mainPanel.setWidth(width + "px");
        this.scrollPanel.setWidth(width - style.sidebarWidth() + "px");
        this.mainFocusPanel.setWidth(width + "px");
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }
}

