/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.decoratedgrid;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.resources.DecisionTableResources;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.decoratedgrid.Coordinate;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicData;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicDataRow;
import org.drools.guvnor.client.widgets.decoratedgrid.MergableGridWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MergableGridWidget<T>
extends Widget {
    protected TableElement table;
    protected TableSectionElement tbody;
    protected static final DecisionTableResources resource = (DecisionTableResources)GWT.create(DecisionTableResources.class);
    protected static final DecisionTableResources.DecisionTableStyle style = resource.cellTableStyle();
    protected DynamicData data;
    protected List<DynamicColumn<T>> columns;

    public MergableGridWidget(DynamicData data, List<DynamicColumn<T>> columns) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        if (columns == null) {
            throw new IllegalArgumentException("columns cannot be null");
        }
        this.data = data;
        this.columns = columns;
        style.ensureInjected();
        this.table = Document.get().createTableElement();
        this.tbody = Document.get().createTBodyElement();
        this.table.setClassName(style.cellTable());
        this.table.setCellPadding(0);
        this.table.setCellSpacing(0);
        this.setElement((Element)this.table);
        this.table.appendChild((Node)this.tbody);
        this.sinkEvents(Event.getTypeInt((String)"click") | Event.getTypeInt((String)"dblclick") | Event.getTypeInt((String)"mouseover") | Event.getTypeInt((String)"mouseout") | Event.getTypeInt((String)"change") | Event.getTypeInt((String)"keypress") | Event.getTypeInt((String)"keydown"));
    }

    public abstract void deleteRow(int var1);

    public abstract void deselectCell(CellValue<? extends Comparable<?>> var1);

    public abstract void resizeColumn(DynamicColumn<?> var1, int var2);

    public CellExtents getSelectedCellExtents(CellValue<? extends Comparable<?>> cv) {
        if (cv == null) {
            throw new IllegalArgumentException("cv cannot be null");
        }
        if (!((DynamicColumn)this.columns.get(cv.getCoordinate().getCol())).isVisible()) {
            return null;
        }
        Coordinate hc = cv.getHtmlCoordinate();
        TableRowElement tre = (TableRowElement)((TableRowElement)this.tbody.getRows().getItem(hc.getRow())).cast();
        TableCellElement tce = (TableCellElement)((TableCellElement)tre.getCells().getItem(hc.getCol())).cast();
        int offsetX = tce.getOffsetLeft();
        int offsetY = tce.getOffsetTop();
        int w = tce.getOffsetWidth();
        int h = tce.getOffsetHeight();
        CellExtents e = new CellExtents(offsetX, offsetY, h, w);
        return e;
    }

    public abstract void hideColumn(int var1);

    public abstract void insertRowBefore(int var1, DynamicDataRow var2);

    public abstract void redraw();

    public abstract void redrawColumn(int var1);

    public abstract void redrawColumns(int var1, int var2);

    public abstract void redrawRows(int var1, int var2);

    public abstract void selectCell(CellValue<? extends Comparable<?>> var1);

    public abstract void showColumn(int var1);
}

