/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.drools.ClockType;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.WorkingMemory;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.common.AbstractRuleBase;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.event.AgendaEventListener;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.AssetPageResponse;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.DiscussionRecord;
import org.drools.guvnor.client.rpc.LogEntry;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.rpc.MetaDataQuery;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.ScenarioResultSummary;
import org.drools.guvnor.client.rpc.ScenarioRunResult;
import org.drools.guvnor.client.rpc.SingleScenarioResult;
import org.drools.guvnor.client.rpc.SnapshotDiff;
import org.drools.guvnor.client.rpc.SnapshotDiffs;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.rpc.TableConfig;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.guvnor.client.rpc.ValidatedResponse;
import org.drools.guvnor.server.AssetItemFilter;
import org.drools.guvnor.server.Backchannel;
import org.drools.guvnor.server.CategoryFilter;
import org.drools.guvnor.server.PackageFilter;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.builder.AuditLogReporter;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentAssemblyError;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.contenthandler.BPMN2ProcessHandler;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.ICanHasAttachment;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.contenthandler.IValidating;
import org.drools.guvnor.server.contenthandler.ModelContentHandler;
import org.drools.guvnor.server.repository.MailboxService;
import org.drools.guvnor.server.repository.UserInbox;
import org.drools.guvnor.server.security.AdminType;
import org.drools.guvnor.server.security.CategoryPathType;
import org.drools.guvnor.server.security.PackageNameType;
import org.drools.guvnor.server.security.PackageUUIDType;
import org.drools.guvnor.server.security.RoleTypes;
import org.drools.guvnor.server.selector.SelectorManager;
import org.drools.guvnor.server.util.AssetFormatHelper;
import org.drools.guvnor.server.util.AssetLockManager;
import org.drools.guvnor.server.util.BRMSSuggestionCompletionLoader;
import org.drools.guvnor.server.util.ClassicDRLImporter;
import org.drools.guvnor.server.util.Discussion;
import org.drools.guvnor.server.util.ISO8601;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.MetaDataMapper;
import org.drools.guvnor.server.util.TableDisplayHandler;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.AssetItemPageResult;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RepositoryFilter;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.VersionableItem;
import org.drools.repository.security.PermissionManager;
import org.drools.rule.MapBackedClassLoader;
import org.drools.rule.Package;
import org.drools.runtime.rule.ConsequenceException;
import org.drools.testframework.RuleCoverageListener;
import org.drools.testframework.ScenarioRunner;
import org.drools.util.CompositeClassLoader;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;
import org.jboss.seam.web.Session;
import org.mvel2.MVEL;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Name(value="org.drools.guvnor.client.rpc.RepositoryService")
@AutoCreate
public class ServiceImplementation
implements RepositoryService {
    private static final int MAX_RULES_TO_SHOW_IN_PACKAGE_LIST = 5000;
    @In
    public RulesRepository repository;
    private static final long serialVersionUID = 510L;
    private static final DateFormat dateFormatter = DateFormat.getInstance();
    private static final LoggingHelper log = LoggingHelper.getLogger(ServiceImplementation.class);
    private MetaDataMapper metaDataMapper = new MetaDataMapper();
    public static Map<String, RuleBase> ruleBaseCache = Collections.synchronizedMap(new HashMap());
    private static Backchannel backchannel = new Backchannel();

    public RulesRepository getRulesRepository() {
        return this.repository;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] loadChildCategories(String categoryPath) {
        ArrayList<String> resultList = new ArrayList<String>();
        CategoryFilter filter = new CategoryFilter();
        CategoryItem item = this.repository.loadCategory(categoryPath);
        List children = item.getChildTags();
        for (int i = 0; i < children.size(); ++i) {
            String childCategoryName = ((CategoryItem)children.get(i)).getName();
            if (!filter.acceptNavigate(categoryPath, childCategoryName)) continue;
            resultList.add(childCategoryName);
        }
        String[] resultArr = resultList.toArray(new String[resultList.size()]);
        return resultArr;
    }

    @WebRemote
    public Boolean createCategory(String path, String name, String description) {
        this.checkSecurityIsAdmin();
        log.info("USER:" + this.getCurrentUserName() + " CREATING cateogory: [" + name + "] in path [" + path + "]");
        if (path == null || "".equals(path)) {
            path = "/";
        }
        path = this.cleanHTML(path);
        this.repository.loadCategory(path).addCategory(name, description);
        this.repository.save();
        return Boolean.TRUE;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String createNewRule(String ruleName, String description, String initialCategory, String initialPackage, String format) throws SerializationException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(initialPackage), "package.developer");
        }
        log.info("USER:" + this.getCurrentUserName() + " CREATING new asset name [" + ruleName + "] in package [" + initialPackage + "]");
        try {
            PackageItem pkg = this.repository.loadPackage(initialPackage);
            AssetItem asset = pkg.addAsset(ruleName, description, initialCategory, format);
            this.applyPreBuiltTemplates(ruleName, format, asset);
            this.repository.save();
            this.push("categoryChange", initialCategory);
            this.push("packageChange", pkg.getName());
            return asset.getUUID();
        }
        catch (RulesRepositoryException e) {
            if (e.getCause() instanceof ItemExistsException) {
                return "DUPLICATE";
            }
            log.error("An error occurred creating new asset" + ruleName + "] in package [" + initialPackage + "]: ", (Throwable)e);
            throw new SerializationException(e.getMessage());
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String createNewImportedRule(String sharedAssetName, String initialPackage) throws SerializationException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(initialPackage), "package.developer");
        }
        log.info("USER:" + this.repository.getSession().getUserID() + " CREATING shared asset imported from global area named [" + sharedAssetName + "] in package [" + initialPackage + "]");
        try {
            PackageItem pkg = this.repository.loadPackage(initialPackage);
            AssetItem asset = pkg.addAssetImportedFromGlobalArea(sharedAssetName);
            this.repository.save();
            return asset.getUUID();
        }
        catch (RulesRepositoryException e) {
            if (e.getCause() instanceof ItemExistsException) {
                return "DUPLICATE";
            }
            log.error("An error occurred creating shared asset" + sharedAssetName + "] in package [" + initialPackage + "]: ", (Throwable)e);
            throw new SerializationException(e.getMessage());
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void deleteUncheckedRule(String uuid, String initialPackage) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "package.admin");
        }
        AssetItem asset = this.repository.loadAssetByUUID(uuid);
        String pkgName = asset.getPackageName();
        asset.remove();
        this.repository.save();
        this.push("packageChange", pkgName);
    }

    private void applyPreBuiltTemplates(String ruleName, String format, AssetItem asset) {
        if (format.equals("dslr")) {
            asset.updateContent("when\n\nthen\n");
        } else if (format.equals("function")) {
            asset.updateContent("function <returnType> " + ruleName + "(<args here>) {\n\n\n}");
        } else if (format.equals("dsl")) {
            asset.updateContent("[when]Condition sentence template {var}=rule language mapping {var}\n[then]Action sentence template=rule language mapping");
        } else if (format.equals("xls")) {
            asset.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/SampleDecisionTable.xls"));
            asset.updateBinaryContentAttachmentFileName("SampleDecisionTable.xls");
        } else if (format.equals("drl")) {
            asset.updateContent("when\n\t#conditions\nthen\n\t#actions");
        } else if (format.equals("enumeration")) {
            // empty if block
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listWorkspaces() {
        return this.repository.listWorkspaces();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void createWorkspace(String workspace) {
        this.repository.createWorkspace(workspace);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removeWorkspace(String workspace) {
        this.repository.removeWorkspace(workspace);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void updateWorkspace(String workspace, String[] selectedModules, String[] unselectedModules) {
        PackageItem module;
        for (String moduleName : selectedModules) {
            module = this.repository.loadPackage(moduleName);
            module.addWorkspace(workspace);
        }
        for (String moduleName : unselectedModules) {
            module = this.repository.loadPackage(moduleName);
            module.removeWorkspace(workspace);
        }
        this.repository.save();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listPackages() {
        return this.listPackages(null);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listPackages(String workspace) {
        PackageFilter pf = new PackageFilter();
        return this.listPackages(false, workspace, (RepositoryFilter)pf);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listArchivedPackages() {
        return this.listArchivedPackages(null);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listArchivedPackages(String workspace) {
        PackageFilter pf = new PackageFilter();
        return this.listPackages(true, workspace, (RepositoryFilter)pf);
    }

    public PackageConfigData loadGlobalPackage() {
        PackageConfigData data = new PackageConfigData();
        PackageItem item = this.repository.loadGlobalArea();
        data.uuid = item.getUUID();
        data.header = ServiceImplementation.getDroolsHeader((PackageItem)item);
        data.externalURI = item.getExternalURI();
        data.catRules = item.getCategoryRules();
        data.description = item.getDescription();
        data.archived = item.isArchived();
        data.name = item.getName();
        data.lastModified = item.getLastModified().getTime();
        data.dateCreated = item.getCreatedDate().getTime();
        data.checkinComment = item.getCheckinComment();
        data.lasContributor = item.getLastContributor();
        data.state = item.getStateDescription();
        data.isSnapshot = item.isSnapshot();
        if (data.isSnapshot) {
            data.snapshotName = item.getSnapshotName();
        }
        return data;
    }

    private PackageConfigData[] listPackages(boolean archive, String workspace, RepositoryFilter filter) {
        ArrayList result = new ArrayList();
        PackageIterator pkgs = this.repository.listPackages();
        this.handleIteratePackages(archive, workspace, filter, result, pkgs);
        this.sortPackages(result);
        return result.toArray(new PackageConfigData[result.size()]);
    }

    private PackageConfigData[] listSubPackages(PackageItem parentPkg, boolean archive, String workspace, RepositoryFilter filter) {
        LinkedList children = new LinkedList();
        PackageIterator pkgs = parentPkg.listSubPackages();
        this.handleIteratePackages(archive, workspace, filter, children, pkgs);
        this.sortPackages(children);
        return children.toArray(new PackageConfigData[children.size()]);
    }

    private void handleIteratePackages(boolean archive, String workspace, RepositoryFilter filter, List<PackageConfigData> result, PackageIterator pkgs) {
        pkgs.setArchivedIterator(archive);
        while (pkgs.hasNext()) {
            PackageItem pkg = pkgs.next();
            PackageConfigData data = new PackageConfigData();
            data.uuid = pkg.getUUID();
            data.name = pkg.getName();
            data.archived = pkg.isArchived();
            data.workspace = pkg.getWorkspaces();
            this.handleIsPackagesListed(archive, workspace, filter, result, data);
            data.subPackages = this.listSubPackages(pkg, archive, null, filter);
        }
    }

    private void handleIsPackagesListed(boolean archive, String workspace, RepositoryFilter filter, List<PackageConfigData> result, PackageConfigData data) {
        if (!(archive || filter != null && !filter.accept((Object)data, "package.readonly") || workspace != null && !this.isWorkspace(workspace, data.workspace))) {
            result.add(data);
        } else if (archive && data.archived && (filter == null || filter.accept((Object)data, "package.readonly")) && (workspace == null || this.isWorkspace(workspace, data.workspace))) {
            result.add(data);
        }
    }

    private boolean isWorkspace(String workspace, String[] workspaces) {
        for (String w : workspaces) {
            if (!w.equals(workspace)) continue;
            return true;
        }
        return false;
    }

    void sortPackages(List<PackageConfigData> result) {
        Collections.sort(result, new /* Unavailable Anonymous Inner Class!! */);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadRuleListForCategories(String categoryPath, int skip, int numRows, String tableConfig) throws SerializationException {
        if (Contexts.isSessionContextActive() && !Identity.instance().hasPermission((Object)new CategoryPathType(categoryPath), "analyst.readonly")) {
            TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
            return handler.loadRuleListTable(new AssetItemPageResult());
        }
        AssetItemPageResult result = this.repository.findAssetsByCategory(categoryPath, false, skip, numRows);
        TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
        return handler.loadRuleListTable(result);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadRuleListForState(String stateName, int skip, int numRows, String tableConfig) throws SerializationException {
        AssetItemFilter filter = new AssetItemFilter();
        AssetItemPageResult result = this.repository.findAssetsByState(stateName, false, skip, numRows, (RepositoryFilter)filter);
        TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
        return handler.loadRuleListTable(result);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableConfig loadTableConfig(String listName) {
        TableDisplayHandler handler = new TableDisplayHandler(listName);
        return handler.loadTableConfig();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public RuleAsset loadRuleAsset(String uuid) throws SerializationException {
        RuleAsset asset;
        AssetItem item;
        long time;
        block8: {
            time = System.currentTimeMillis();
            item = this.repository.loadAssetByUUID(uuid);
            asset = new RuleAsset();
            asset.uuid = uuid;
            asset.metaData = this.populateMetaData(item);
            if (Contexts.isSessionContextActive()) {
                boolean passed = false;
                try {
                    Identity.instance().checkPermission((Object)new PackageNameType(asset.metaData.packageName), "package.readonly");
                }
                catch (RuntimeException e) {
                    if (asset.metaData.categories.length == 0) {
                        Identity.instance().checkPermission((Object)new CategoryPathType(null), "analyst.readonly");
                    }
                    RuntimeException exception = null;
                    for (String cat : asset.metaData.categories) {
                        try {
                            Identity.instance().checkPermission((Object)new CategoryPathType(cat), "analyst.readonly");
                            passed = true;
                        }
                        catch (RuntimeException re) {
                            exception = re;
                        }
                    }
                    if (passed) break block8;
                    throw exception;
                }
            }
        }
        PackageItem pkgItem = item.getPackage();
        ContentHandler handler = ContentManager.getHandler((String)asset.metaData.format);
        handler.retrieveAssetContent(asset, pkgItem, item);
        asset.isreadonly = asset.metaData.hasSucceedingVersion;
        if (pkgItem.isSnapshot()) {
            asset.isreadonly = true;
        }
        log.debug("Package: " + pkgItem.getName() + ", asset: " + item.getName() + ". Load time taken for asset: " + (System.currentTimeMillis() - time));
        UserInbox.recordOpeningEvent((AssetItem)item);
        return asset;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public RuleAsset[] loadRuleAssets(String[] uuids) throws SerializationException {
        return this.loadRuleAssets(Arrays.asList(uuids));
    }

    RuleAsset[] loadRuleAssets(Collection<String> uuids) throws SerializationException {
        if (uuids == null) {
            return null;
        }
        HashSet<RuleAsset> assets = new HashSet<RuleAsset>();
        for (String uuid : uuids) {
            assets.add(this.loadRuleAsset(uuid));
        }
        return assets.toArray(new RuleAsset[assets.size()]);
    }

    private RuleAsset loadAsset(AssetItem item) throws SerializationException {
        RuleAsset asset = new RuleAsset();
        asset.uuid = item.getUUID();
        asset.metaData = this.populateMetaData(item);
        ContentHandler handler = ContentManager.getHandler((String)asset.metaData.format);
        handler.retrieveAssetContent(asset, item.getPackage(), item);
        return asset;
    }

    MetaData populateMetaData(VersionableItem item) {
        MetaData meta = new MetaData();
        meta.status = item.getState() != null ? item.getState().getName() : "";
        this.metaDataMapper.copyToMetaData(meta, (Object)item);
        meta.createdDate = this.calendarToDate(item.getCreatedDate());
        meta.lastModifiedDate = this.calendarToDate(item.getLastModified());
        meta.hasPreceedingVersion = item.getPrecedingVersion() != null;
        meta.hasSucceedingVersion = item.getSucceedingVersion() != null;
        return meta;
    }

    MetaData populateMetaData(AssetItem item) {
        MetaData meta = this.populateMetaData((VersionableItem)item);
        meta.packageName = item.getPackageName();
        meta.packageUUID = item.getPackage().getUUID();
        meta.setBinary(item.isBinary());
        List categories = item.getCategories();
        this.fillMetaCategories(meta, categories);
        meta.dateEffective = this.calendarToDate(item.getDateEffective());
        meta.dateExpired = this.calendarToDate(item.getDateExpired());
        return meta;
    }

    private void fillMetaCategories(MetaData meta, List categories) {
        meta.categories = new String[categories.size()];
        for (int i = 0; i < meta.categories.length; ++i) {
            CategoryItem cat = (CategoryItem)categories.get(i);
            meta.categories[i] = cat.getFullPath();
        }
    }

    private Date calendarToDate(Calendar createdDate) {
        if (createdDate == null) {
            return null;
        }
        return createdDate.getTime();
    }

    private Calendar dateToCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String checkinVersion(RuleAsset asset) throws SerializationException {
        block9: {
            if (Contexts.isSessionContextActive()) {
                boolean passed = false;
                try {
                    Identity.instance().checkPermission((Object)new PackageNameType(asset.metaData.packageName), "package.developer");
                }
                catch (RuntimeException e) {
                    if (asset.metaData.categories.length == 0) {
                        Identity.instance().checkPermission((Object)new CategoryPathType(null), "analyst");
                    }
                    RuntimeException exception = null;
                    for (String cat : asset.metaData.categories) {
                        try {
                            Identity.instance().checkPermission((Object)new CategoryPathType(cat), "analyst");
                            passed = true;
                        }
                        catch (RuntimeException re) {
                            exception = re;
                        }
                    }
                    if (passed) break block9;
                    throw exception;
                }
            }
        }
        log.info("USER:" + this.getCurrentUserName() + " CHECKING IN asset: [" + asset.metaData.name + "] UUID: [" + asset.uuid + "] ");
        AssetItem repoAsset = this.repository.loadAssetByUUID(asset.uuid);
        if (this.isAssetUpdatedInRepository(asset, repoAsset)) {
            return "ERR: Unable to save this asset, as it has been recently updated by [" + repoAsset.getLastContributor() + "]";
        }
        MetaData meta = asset.metaData;
        this.metaDataMapper.copyFromMetaData(meta, (Object)repoAsset);
        this.updateEffectiveAndExpiredDate(repoAsset, meta);
        repoAsset.updateCategoryList(meta.categories);
        ContentHandler handler = ContentManager.getHandler((String)repoAsset.getFormat());
        handler.storeAssetContent(asset, repoAsset);
        if (!asset.metaData.format.equals("scenario") || asset.metaData.format.equals("enumeration")) {
            PackageItem pkg = repoAsset.getPackage();
            pkg.updateBinaryUpToDate(false);
            ruleBaseCache.remove(pkg.getUUID());
        }
        repoAsset.checkin(meta.checkinComment);
        return repoAsset.getUUID();
    }

    private ContentHandler getContentHandler(AssetItem repoAsset) {
        return ContentManager.getHandler((String)repoAsset.getFormat());
    }

    private void updateEffectiveAndExpiredDate(AssetItem repoAsset, MetaData meta) {
        repoAsset.updateDateEffective(this.dateToCalendar(meta.dateEffective));
        repoAsset.updateDateExpired(this.dateToCalendar(meta.dateExpired));
    }

    private boolean isAssetUpdatedInRepository(RuleAsset asset, AssetItem repoAsset) {
        return asset.metaData.lastModifiedDate.before(repoAsset.getLastModified().getTime());
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadAssetHistory(String uuid) throws SerializationException {
        ArrayList<TableDataRow> result = new ArrayList<TableDataRow>();
        AssetItem item = this.repository.loadAssetByUUID(uuid);
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(item.getPackage().getUUID()), "package.readonly");
        }
        AssetHistoryIterator it = item.getHistory();
        while (it.hasNext()) {
            AssetItem historical = it.next();
            long versionNumber = historical.getVersionNumber();
            if (!this.isHistory(item, versionNumber)) continue;
            result.add(this.createHistoricalRow(result, historical));
        }
        if (result.size() == 0) {
            return null;
        }
        TableDataResult table = new TableDataResult();
        table.data = result.toArray(new TableDataRow[result.size()]);
        return table;
    }

    private TableDataRow createHistoricalRow(List<TableDataRow> result, AssetItem historical) {
        TableDataRow tableDataRow = new TableDataRow();
        tableDataRow.id = historical.getVersionSnapshotUUID();
        tableDataRow.values = new String[4];
        tableDataRow.values[0] = Long.toString(historical.getVersionNumber());
        tableDataRow.values[1] = historical.getCheckinComment();
        tableDataRow.values[2] = dateFormatter.format(historical.getLastModified().getTime());
        tableDataRow.values[3] = historical.getStateDescription();
        return tableDataRow;
    }

    private boolean isHistory(AssetItem item, long versionNumber) {
        return versionNumber != 0L && versionNumber != item.getVersionNumber();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadArchivedAssets(int skip, int numRows) throws SerializationException {
        ArrayList<TableDataRow> result = new ArrayList<TableDataRow>();
        AssetItemFilter filter = new AssetItemFilter();
        AssetItemIterator it = this.repository.findArchivedAssets();
        it.skip((long)skip);
        int count = 0;
        while (it.hasNext()) {
            AssetItem archived = it.next();
            if (filter.accept((Object)archived, "read")) {
                result.add(this.createArchivedRow(archived));
                ++count;
            }
            if (count != numRows) continue;
            break;
        }
        return this.createArchivedTable(result, it);
    }

    private TableDataResult createArchivedTable(List<TableDataRow> result, AssetItemIterator it) {
        TableDataResult table = new TableDataResult();
        table.data = result.toArray(new TableDataRow[result.size()]);
        table.currentPosition = it.getPosition();
        table.total = it.getSize();
        table.hasNext = it.hasNext();
        return table;
    }

    private TableDataRow createArchivedRow(AssetItem archived) {
        TableDataRow row = new TableDataRow();
        row.id = archived.getUUID();
        row.values = new String[5];
        row.values[0] = archived.getName();
        row.values[1] = archived.getFormat();
        row.values[2] = archived.getPackageName();
        row.values[3] = archived.getLastContributor();
        row.values[4] = Long.toString(archived.getLastModified().getTime().getTime());
        return row;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void restoreVersion(String versionUUID, String assetUUID, String comment) {
        AssetItem old = this.repository.loadAssetByUUID(versionUUID);
        AssetItem head = this.repository.loadAssetByUUID(assetUUID);
        log.info("USER:" + this.getCurrentUserName() + " RESTORE of asset: [" + head.getName() + "] UUID: [" + head.getUUID() + "] with historical version number: [" + old.getVersionNumber());
        this.repository.restoreHistoricalAsset(old, head, comment);
    }

    @WebRemote
    public String createPackage(String name, String description, String[] workspace) throws RulesRepositoryException {
        this.checkSecurityIsAdmin();
        log.info("USER: " + this.getCurrentUserName() + " CREATING package [" + name + "]");
        PackageItem item = this.repository.createPackage(name, description, workspace);
        return item.getUUID();
    }

    @WebRemote
    public String createPackage(String name, String description) throws RulesRepositoryException {
        return this.createPackage(name, description, new String[0]);
    }

    @WebRemote
    public String createSubPackage(String name, String description, String parentNode) throws SerializationException {
        this.checkSecurityIsAdmin();
        log.info("USER: " + this.getCurrentUserName() + " CREATING subPackage [" + name + "], parent [" + parentNode + "]");
        PackageItem item = this.repository.createSubPackage(name, description, parentNode);
        return item.getUUID();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData loadPackageConfig(String uuid) {
        PackageItem item = this.repository.loadPackageByUUID(uuid);
        this.checkSecurityNameTypePackageReadOnly(item);
        PackageConfigData data = this.createPackageConfigData(item);
        if (data.isSnapshot) {
            data.snapshotName = item.getSnapshotName();
        }
        return data;
    }

    private PackageConfigData createPackageConfigData(PackageItem item) {
        PackageConfigData data = new PackageConfigData();
        data.uuid = item.getUUID();
        data.header = ServiceImplementation.getDroolsHeader((PackageItem)item);
        data.externalURI = item.getExternalURI();
        data.catRules = item.getCategoryRules();
        data.description = item.getDescription();
        data.archived = item.isArchived();
        data.name = item.getName();
        data.lastModified = item.getLastModified().getTime();
        data.dateCreated = item.getCreatedDate().getTime();
        data.checkinComment = item.getCheckinComment();
        data.lasContributor = item.getLastContributor();
        data.state = item.getStateDescription();
        data.isSnapshot = item.isSnapshot();
        return data;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public ValidatedResponse savePackage(PackageConfigData data) throws SerializationException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(data.uuid), "package.developer");
        }
        log.info("USER:" + this.getCurrentUserName() + " SAVING package [" + data.name + "]");
        PackageItem item = this.repository.loadPackage(data.name);
        boolean unarchived = !data.archived && item.isArchived();
        Calendar packageLastModified = item.getLastModified();
        ServiceImplementation.updateDroolsHeader((String)data.header, (PackageItem)item);
        this.updateCategoryRules(data, item);
        item.updateExternalURI(data.externalURI);
        item.updateDescription(data.description);
        item.archiveItem(data.archived);
        item.updateBinaryUpToDate(false);
        ruleBaseCache.remove(data.uuid);
        item.checkin(data.description);
        if (data.archived) {
            this.handleArchivedForSavePackage(data, item);
        } else if (unarchived) {
            this.handleUnarchivedForSavePackage(data, item, packageLastModified);
        }
        BRMSSuggestionCompletionLoader loader = new BRMSSuggestionCompletionLoader();
        loader.getSuggestionEngine(item);
        return this.validateBRMSSuggestionCompletionLoaderResponse(loader);
    }

    private ValidatedResponse validateBRMSSuggestionCompletionLoaderResponse(BRMSSuggestionCompletionLoader loader) {
        ValidatedResponse res = new ValidatedResponse();
        if (loader.hasErrors()) {
            res.hasErrors = true;
            String err = "";
            Iterator iter = loader.getErrors().iterator();
            while (iter.hasNext()) {
                err = err + (String)iter.next();
                if (!iter.hasNext()) continue;
                err = err + "\n";
            }
            res.errorHeader = "Package validation errors";
            res.errorMessage = err;
        }
        return res;
    }

    private void handleUnarchivedForSavePackage(PackageConfigData data, PackageItem item, Calendar packageLastModified) {
        Iterator iter = item.getAssets();
        while (iter.hasNext()) {
            AssetItem assetItem = (AssetItem)iter.next();
            if (assetItem.getLastModified().compareTo(packageLastModified) < 0) continue;
            assetItem.archiveItem(false);
            assetItem.checkin(data.description);
        }
    }

    private void handleArchivedForSavePackage(PackageConfigData data, PackageItem item) {
        Iterator iter = item.getAssets();
        while (iter.hasNext()) {
            AssetItem assetItem = (AssetItem)iter.next();
            if (assetItem.isArchived()) continue;
            assetItem.archiveItem(true);
            assetItem.checkin(data.description);
        }
    }

    private void updateCategoryRules(PackageConfigData data, PackageItem item) {
        KeyValueTO keyValueTO = ServiceImplementation.convertMapToCsv((Map)data.catRules);
        item.updateCategoryRules(keyValueTO.getKeys(), keyValueTO.getValues());
    }

    private static KeyValueTO convertMapToCsv(Map map) {
        StringBuilder keysBuilder = new StringBuilder();
        StringBuilder valuesBuilder = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            if (keysBuilder.length() > 0) {
                keysBuilder.append(",");
            }
            if (valuesBuilder.length() > 0) {
                valuesBuilder.append(",");
            }
            keysBuilder.append(entry.getKey());
            valuesBuilder.append(entry.getValue());
        }
        return new KeyValueTO(keysBuilder.toString(), valuesBuilder.toString());
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public AssetPageResponse findAssetPage(AssetPageRequest request) throws SerializationException {
        AssetItemIterator it;
        log.debug("Finding asset page of packageUuid (" + request.getPackageUuid() + ")");
        long start = System.currentTimeMillis();
        PackageItem packageItem = this.repository.loadPackageByUUID(request.getPackageUuid());
        if (request.getFormatInList() != null) {
            if (request.getFormatIsRegistered() != null) {
                throw new IllegalArgumentException("Combining formatInList and formatIsRegistered is not yet supported.");
            }
            it = packageItem.listAssetsByFormat(request.getFormatInList());
        } else {
            it = request.getFormatIsRegistered() != null ? packageItem.listAssetsNotOfFormat(AssetFormatHelper.listRegisteredTypes()) : packageItem.queryAssets("");
        }
        AssetPageResponse response = new AssetPageResponse();
        long totalRowSize = it.getSize();
        if (totalRowSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The totalRowSize (" + totalRowSize + ") is too big.");
        }
        response.setTotalRowSize((int)totalRowSize);
        it.skip((long)request.getStartRowIndex());
        response.setStartRowIndex(request.getStartRowIndex());
        List rowList = this.fillAssetPageRowsForFindAssetPage(request, it);
        response.setAssetPageRowList(rowList);
        response.setLastPage(!it.hasNext());
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Found asset page of packageUuid (" + request.getPackageUuid() + ") in " + methodDuration + " ms.");
        return response;
    }

    private List<AssetPageRow> fillAssetPageRowsForFindAssetPage(AssetPageRequest request, AssetItemIterator it) {
        int pageSize = request.getPageSize();
        ArrayList<AssetPageRow> rowList = new ArrayList<AssetPageRow>(request.getPageSize());
        while (it.hasNext() && (pageSize < 0 || rowList.size() <= pageSize)) {
            AssetItem assetItem = it.next();
            AssetPageRow row = new AssetPageRow();
            row.setUuid(assetItem.getUUID());
            row.setFormat(assetItem.getFormat());
            row.setPackageName(assetItem.getPackageName());
            row.setName(assetItem.getName());
            row.setDescription(assetItem.getDescription());
            row.setDescriptionAbbreviated(StringUtils.abbreviate((String)assetItem.getDescription(), (int)80));
            row.setStateName(assetItem.getStateDescription());
            row.setCreator(assetItem.getCreator());
            row.setCreatedDate(assetItem.getCreatedDate().getTime());
            row.setLastContributor(assetItem.getLastContributor());
            row.setLastModified(assetItem.getLastModified().getTime());
            row.setCategorySummary(assetItem.getCategorySummary());
            row.setExternalSource(assetItem.getExternalSource());
            rowList.add(row);
        }
        return rowList;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult listAssetsWithPackageName(String packageName, String[] formats, int skip, int numRows, String tableConfig) throws SerializationException {
        PackageItem pkg = this.repository.loadPackage(packageName);
        return this.listAssets(pkg.getUUID(), formats, skip, numRows, tableConfig);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult listAssets(String packageUuid, String[] formats, int skip, int numRows, String tableConfig) throws SerializationException {
        log.debug("Loading asset list for [" + packageUuid + "]");
        if (numRows == 0) {
            throw new DetailedSerializationException("Unable to return zero results (bug)", "probably have the parameters around the wrong way, sigh...");
        }
        long start = System.currentTimeMillis();
        PackageItem pkg = this.repository.loadPackageByUUID(packageUuid);
        AssetItemIterator it = formats.length > 0 ? pkg.listAssetsByFormat(formats) : pkg.listAssetsNotOfFormat(AssetFormatHelper.listRegisteredTypes());
        TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
        log.debug("time for asset list load: " + (System.currentTimeMillis() - start));
        return handler.loadRuleListTable(it, skip, numRows);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult quickFindAsset(String searchText, boolean searchArchived, int skip, int numRows) throws SerializationException {
        String search = searchText.replace('*', '%');
        if (!search.endsWith("%")) {
            search = search + "%";
        }
        ArrayList<AssetItem> resultList = new ArrayList<AssetItem>();
        long start = System.currentTimeMillis();
        AssetItemIterator it = this.repository.findAssetsByName(search, searchArchived);
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        AssetItemFilter filter = new AssetItemFilter();
        while (it.hasNext()) {
            AssetItem ai = it.next();
            if (!filter.accept((Object)ai, "package.readonly")) continue;
            resultList.add(ai);
        }
        TableDisplayHandler handler = new TableDisplayHandler("searchresults");
        return handler.loadRuleListTable(resultList, skip, numRows);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult queryFullText(String text, boolean seekArchived, int skip, int numRows) throws SerializationException {
        if (numRows == 0) {
            throw new DetailedSerializationException("Unable to return zero results (bug)", "probably have the parameters around the wrong way, sigh...");
        }
        AssetItemIterator it = this.repository.queryFullText(text, seekArchived);
        ArrayList<AssetItem> resultList = new ArrayList<AssetItem>();
        PackageFilter filter = new PackageFilter();
        while (it.hasNext()) {
            AssetItem ai = it.next();
            if (!this.checkPackagePermissionHelper((RepositoryFilter)filter, ai, "package.readonly")) continue;
            resultList.add(ai);
        }
        TableDisplayHandler handler = new TableDisplayHandler("searchresults");
        return handler.loadRuleListTable(resultList, skip, numRows);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult queryMetaData(MetaDataQuery[] qr, Date createdAfter, Date createdBefore, Date modifiedAfter, Date modifiedBefore, boolean seekArchived, int skip, int numRows) throws SerializationException {
        if (numRows == 0) {
            throw new DetailedSerializationException("Unable to return zero results (bug)", "probably have the parameters around the wrong way, sigh...");
        }
        2 q = new /* Unavailable Anonymous Inner Class!! */;
        RulesRepository.DateQuery[] dates = new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", this.isoDate(createdAfter), this.isoDate(createdBefore)), new RulesRepository.DateQuery("drools:lastModified", this.isoDate(modifiedAfter), this.isoDate(modifiedBefore))};
        AssetItemIterator it = this.repository.query((Map)q, seekArchived, dates);
        ArrayList<AssetItem> resultList = new ArrayList<AssetItem>();
        PackageFilter packageFilter = new PackageFilter();
        CategoryFilter categoryFilter = new CategoryFilter();
        while (it.hasNext()) {
            AssetItem ai = it.next();
            if (!this.checkPackagePermissionHelper((RepositoryFilter)packageFilter, ai, "package.readonly") && !this.checkCategoryPermissionHelper((RepositoryFilter)categoryFilter, ai, "analyst.readonly")) continue;
            resultList.add(ai);
        }
        return new TableDisplayHandler("searchresults").loadRuleListTable(resultList, skip, numRows);
    }

    private boolean checkPackagePermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        return filter.accept((Object)this.getConfigDataHelper(item.getPackage().getUUID()), roleType);
    }

    private boolean checkCategoryPermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        List tempCateList = item.getCategories();
        for (CategoryItem categoryItem : tempCateList) {
            if (!filter.accept((Object)categoryItem.getName(), roleType)) continue;
            return true;
        }
        return false;
    }

    private PackageConfigData getConfigDataHelper(String uuidStr) {
        PackageConfigData data = new PackageConfigData();
        data.uuid = uuidStr;
        return data;
    }

    private String isoDate(Date d) {
        if (d != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            return ISO8601.format((Calendar)cal);
        }
        return null;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String createState(String name) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " CREATING state: [" + name + "]");
        try {
            name = this.cleanHTML(name);
            String uuid = this.repository.createState(name).getNode().getUUID();
            this.repository.save();
            return uuid;
        }
        catch (RepositoryException e) {
            throw new SerializationException("Unable to create the status.");
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removeState(String name) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " REMOVING state: [" + name + "]");
        try {
            this.repository.loadState(name).remove();
            this.repository.save();
        }
        catch (RulesRepositoryException e) {
            throw new DetailedSerializationException("Unable to remove status. It is probably still used (even by archived items).", e.getMessage());
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void renameState(String oldName, String newName) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " RENAMING state: [" + oldName + "] to [" + newName + "]");
        this.repository.renameState(oldName, newName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listStates() throws SerializationException {
        StateItem[] states = this.repository.listStates();
        String[] result = new String[states.length];
        for (int i = 0; i < states.length; ++i) {
            result[i] = states[i].getName();
        }
        return result;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void changeState(String uuid, String newState, boolean wholePackage) {
        if (!wholePackage) {
            AssetItem asset;
            block9: {
                asset = this.repository.loadAssetByUUID(uuid);
                if (Contexts.isSessionContextActive()) {
                    boolean passed = false;
                    try {
                        Identity.instance().checkPermission((Object)new PackageUUIDType(asset.getPackage().getUUID()), "package.developer");
                    }
                    catch (RuntimeException e) {
                        if (asset.getCategories().size() == 0) {
                            Identity.instance().checkPermission((Object)new CategoryPathType(null), "analyst");
                        }
                        RuntimeException exception = null;
                        for (CategoryItem cat : asset.getCategories()) {
                            try {
                                Identity.instance().checkPermission((Object)new CategoryPathType(cat.getName()), "analyst");
                                passed = true;
                            }
                            catch (RuntimeException re) {
                                exception = re;
                            }
                        }
                        if (passed) break block9;
                        throw exception;
                    }
                }
            }
            log.info("USER:" + this.getCurrentUserName() + " CHANGING ASSET STATUS. Asset name, uuid: " + "[" + asset.getName() + ", " + asset.getUUID() + "]" + " to [" + newState + "]");
            String oldState = asset.getStateDescription();
            asset.updateState(newState);
            this.push("statusChange", oldState);
            this.push("statusChange", newState);
            this.addToDiscussionForAsset(asset.getUUID(), oldState + " -> " + newState);
        } else {
            this.checkSecurityIsPackageDeveloper(uuid);
            PackageItem pkg = this.repository.loadPackageByUUID(uuid);
            log.info("USER:" + this.getCurrentUserName() + " CHANGING Package STATUS. Asset name, uuid: " + "[" + pkg.getName() + ", " + pkg.getUUID() + "]" + " to [" + newState + "]");
            pkg.changeStatus(newState);
        }
        this.repository.save();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void changeAssetPackage(String uuid, String newPackage, String comment) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(newPackage), "package.developer");
        }
        log.info("USER:" + this.getCurrentUserName() + " CHANGING PACKAGE OF asset: [" + uuid + "] to [" + newPackage + "]");
        this.repository.moveRuleItemPackage(newPackage, uuid, comment);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void promoteAssetToGlobalArea(String uuid) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType("globalArea"), "package.developer");
        }
        log.info("USER:" + this.getCurrentUserName() + " CHANGING PACKAGE OF asset: [" + uuid + "] to [ globalArea ]");
        this.repository.moveRuleItemPackage("globalArea", uuid, "promote asset to globalArea");
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String copyAsset(String assetUUID, String newPackage, String newName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(newPackage), "package.developer");
        }
        log.info("USER:" + this.getCurrentUserName() + " COPYING asset: [" + assetUUID + "] to [" + newName + "] in PACKAGE [" + newPackage + "]");
        return this.repository.copyAsset(assetUUID, newPackage, newName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public SnapshotInfo[] listSnapshots(String packageName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), "package.developer");
        }
        String[] snaps = this.repository.listPackageSnapshots(packageName);
        SnapshotInfo[] res = new SnapshotInfo[snaps.length];
        for (int i = 0; i < snaps.length; ++i) {
            SnapshotInfo info;
            PackageItem snap = this.repository.loadPackageSnapshot(packageName, snaps[i]);
            res[i] = info = new SnapshotInfo();
            info.comment = snap.getCheckinComment();
            info.name = snaps[i];
            info.uuid = snap.getUUID();
        }
        return res;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void createPackageSnapshot(String packageName, String snapshotName, boolean replaceExisting, String comment) {
        this.checkSecurityIsPackageNameTypeAdmin(packageName);
        log.info("USER:" + this.getCurrentUserName() + " CREATING PACKAGE SNAPSHOT for package: [" + packageName + "] snapshot name: [" + snapshotName);
        if (replaceExisting) {
            this.repository.removePackageSnapshot(packageName, snapshotName);
        }
        this.repository.createPackageSnapshot(packageName, snapshotName);
        PackageItem item = this.repository.loadPackageSnapshot(packageName, snapshotName);
        item.updateCheckinComment(comment);
        this.repository.save();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void copyOrRemoveSnapshot(String packageName, String snapshotName, boolean delete, String newSnapshotName) throws SerializationException {
        this.checkSecurityIsPackageNameTypeAdmin(packageName);
        if (delete) {
            log.info("USER:" + this.getCurrentUserName() + " REMOVING SNAPSHOT for package: [" + packageName + "] snapshot: [" + snapshotName + "]");
            this.repository.removePackageSnapshot(packageName, snapshotName);
        } else {
            if (newSnapshotName.equals("")) {
                throw new SerializationException("Need to have a new snapshot name.");
            }
            log.info("USER:" + this.getCurrentUserName() + " COPYING SNAPSHOT for package: [" + packageName + "] snapshot: [" + snapshotName + "] to [" + newSnapshotName + "]");
            this.repository.copyPackageSnapshot(packageName, snapshotName, newSnapshotName);
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removeCategory(String categoryPath) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " REMOVING CATEGORY path: [" + categoryPath + "]");
        try {
            this.repository.loadCategory(categoryPath).remove();
            this.repository.save();
        }
        catch (RulesRepositoryException e) {
            log.info("Unable to remove category [" + categoryPath + "]. It is probably still used: " + e.getMessage());
            throw new DetailedSerializationException("Unable to remove category. It is probably still used.", e.getMessage());
        }
    }

    @WebRemote
    public void clearRulesRepository() {
        this.checkSecurityIsAdmin();
        RulesRepositoryAdministrator admin = new RulesRepositoryAdministrator(this.repository.getSession());
        admin.clearRulesRepository();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public SuggestionCompletionEngine loadSuggestionCompletionEngine(String packageName) throws SerializationException {
        this.checkSecurityIsPackageReadOnly(packageName);
        SuggestionCompletionEngine result = null;
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            PackageItem pkg = this.repository.loadPackage(packageName);
            BRMSSuggestionCompletionLoader loader = null;
            List jars = BRMSPackageBuilder.getJars((PackageItem)pkg);
            if (jars != null && !jars.isEmpty()) {
                MapBackedClassLoader cl = BRMSPackageBuilder.createClassLoader((List)jars);
                Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                loader = new BRMSSuggestionCompletionLoader((ClassLoader)cl);
            } else {
                loader = new BRMSSuggestionCompletionLoader();
            }
            result = loader.getSuggestionEngine(pkg);
        }
        catch (RulesRepositoryException e) {
            log.error("An error occurred loadSuggestionCompletionEngine: " + e.getMessage());
            throw new SerializationException(e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        return result;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BuilderResult buildPackage(String packageUUID, boolean force) throws SerializationException {
        return this.buildPackage(packageUUID, force, null, null, null, false, null, null, false, null);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BuilderResult buildPackage(String packageUUID, boolean force, String buildMode, String statusOperator, String statusDescriptionValue, boolean enableStatusSelector, String categoryOperator, String category, boolean enableCategorySelector, String customSelectorName) throws SerializationException {
        this.checkSecurityIsPackageDeveloper(packageUUID);
        PackageItem item = this.repository.loadPackageByUUID(packageUUID);
        try {
            return this.buildPackage(item, force, buildMode, statusOperator, statusDescriptionValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, customSelectorName);
        }
        catch (NoClassDefFoundError e) {
            throw new DetailedSerializationException("Unable to find a class that was needed when building the package  [" + e.getMessage() + "]", "Perhaps you are missing them from the model jars, or from the BRMS itself (lib directory).");
        }
        catch (UnsupportedClassVersionError e) {
            throw new DetailedSerializationException("Can not build the package. One or more of the classes that are needed were compiled with an unsupported Java version.", "For example the pojo classes were compiled with Java 1.6 and Guvnor is running on Java 1.5. [" + e.getMessage() + "]");
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] getCustomSelectors() throws SerializationException {
        return SelectorManager.getInstance().getCustomSelectors();
    }

    private BuilderResult buildPackage(PackageItem item, boolean force) throws DetailedSerializationException {
        return this.buildPackage(item, force, null, null, null, false, null, null, false, null);
    }

    private BuilderResult buildPackage(PackageItem item, boolean force, String buildMode, String statusOperator, String statusDescriptionValue, boolean enableStatusSelector, String categoryOperator, String category, boolean enableCategorySelector, String selectorConfigName) throws DetailedSerializationException {
        if (!force && item.isBinaryUpToDate()) {
            return null;
        }
        ContentPackageAssembler asm = new ContentPackageAssembler(item, true, buildMode, statusOperator, statusDescriptionValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, selectorConfigName);
        if (asm.hasErrors()) {
            BuilderResult result = new BuilderResult();
            result.setLines(this.generateBuilderResults(asm));
            return result;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)bout);
            out.writeObject(asm.getBinaryPackage());
            item.updateCompiledPackage((InputStream)new ByteArrayInputStream(bout.toByteArray()));
            out.flush();
            out.close();
            this.updateBinaryPackage(item, asm);
            this.repository.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("An error occurred building the package [" + item.getName() + "]: " + e.getMessage());
            throw new DetailedSerializationException("An error occurred building the package.", e.getMessage());
        }
        return null;
    }

    private void updateBinaryPackage(PackageItem item, ContentPackageAssembler asm) throws SerializationException {
        item.updateBinaryUpToDate(true);
        Collection loaders = asm.getBuilder().getRootClassLoader().getClassLoaders();
        RuleBaseConfiguration conf = new RuleBaseConfiguration(loaders.toArray(new ClassLoader[loaders.size()]));
        RuleBase rb = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        rb.addPackage(asm.getBinaryPackage());
    }

    private BuilderResultLine[] generateBuilderResults(ContentPackageAssembler asm) {
        BuilderResultLine[] result = new BuilderResultLine[asm.getErrors().size()];
        for (int i = 0; i < result.length; ++i) {
            ContentAssemblyError err = (ContentAssemblyError)asm.getErrors().get(i);
            BuilderResultLine res = new BuilderResultLine();
            res.assetName = err.getName();
            res.assetFormat = err.getFormat();
            res.message = err.getErrorReport();
            res.uuid = err.getUUID();
            result[i] = res;
        }
        return result;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String buildPackageSource(String packageUUID) throws SerializationException {
        this.checkSecurityIsPackageDeveloper(packageUUID);
        PackageItem item = this.repository.loadPackageByUUID(packageUUID);
        ContentPackageAssembler asm = new ContentPackageAssembler(item, false);
        return asm.getDRL();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String buildAssetSource(RuleAsset asset) throws SerializationException {
        this.checkSecurityIsPackageDeveloper(asset);
        ContentHandler handler = ContentManager.getHandler((String)asset.metaData.format);
        log.info("****** ContentHandler is: " + handler.getClass().getName());
        StringBuffer buf = new StringBuffer();
        if (handler.isRuleAsset()) {
            log.info("****** isRuleAsset!");
            BRMSPackageBuilder builder = new BRMSPackageBuilder();
            PackageItem packageItem = this.repository.loadPackage(asset.metaData.packageName);
            builder.setDSLFiles(BRMSPackageBuilder.getDSLMappingFiles((PackageItem)packageItem, (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */));
            if (asset.metaData.isBinary()) {
                AssetItem item = this.repository.loadAssetByUUID(asset.uuid);
                handler.storeAssetContent(asset, item);
                ((IRuleAsset)handler).assembleDRL(builder, item, buf);
            } else {
                ((IRuleAsset)handler).assembleDRL(builder, asset, buf);
            }
        } else if (handler.getClass().getName().equals("org.drools.guvnor.server.contenthandler.BPMN2ProcessHandler")) {
            BPMN2ProcessHandler bpmn2handler = (BPMN2ProcessHandler)handler;
            bpmn2handler.assembleProcessSource(asset.content, buf);
        }
        return buf.toString();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BuilderResult buildAsset(RuleAsset asset) throws SerializationException {
        this.checkSecurityIsPackageDeveloper(asset);
        BuilderResult result = new BuilderResult();
        try {
            ContentHandler handler = ContentManager.getHandler((String)asset.metaData.format);
            if (asset.metaData.isBinary()) {
                AssetItem item = this.repository.loadAssetByUUID(asset.uuid);
                handler.storeAssetContent(asset, item);
                if (handler instanceof IValidating) {
                    return ((IValidating)handler).validateAsset(item);
                }
                ContentPackageAssembler asm = new ContentPackageAssembler(item);
                if (!asm.hasErrors()) {
                    return null;
                }
                result.setLines(this.generateBuilderResults(asm));
            } else {
                if (handler instanceof IValidating) {
                    return ((IValidating)handler).validateAsset(asset);
                }
                PackageItem packageItem = this.repository.loadPackageByUUID(asset.metaData.packageUUID);
                ContentPackageAssembler asm = new ContentPackageAssembler(asset, packageItem);
                if (!asm.hasErrors()) {
                    return null;
                }
                result.setLines(this.generateBuilderResults(asm));
            }
        }
        catch (Exception e) {
            log.error("Unable to build asset.", (Throwable)e);
            result = new BuilderResult();
            BuilderResultLine res = new BuilderResultLine();
            res.assetName = asset.metaData.name;
            res.assetFormat = asset.metaData.format;
            res.message = "Unable to validate this asset. (Check log for detailed messages).";
            res.uuid = asset.uuid;
            result.getLines()[0] = res;
            return result;
        }
        return result;
    }

    @WebRemote
    public void copyPackage(String sourcePackageName, String destPackageName) throws SerializationException {
        this.checkSecurityIsAdmin();
        try {
            log.info("USER:" + this.getCurrentUserName() + " COPYING package [" + sourcePackageName + "] to  package [" + destPackageName + "]");
            this.repository.copyPackage(sourcePackageName, destPackageName);
        }
        catch (RulesRepositoryException e) {
            log.error("Unable to copy package.", (Throwable)e);
            throw e;
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String renameAsset(String uuid, String newName) {
        AssetItem item = this.repository.loadAssetByUUID(uuid);
        this.checkSecurityIsPackageDeveloper(item);
        return this.repository.renameAsset(uuid, newName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void archiveAsset(String uuid) {
        this.archiveOrUnarchiveAsset(uuid, true);
    }

    public void unArchiveAsset(String uuid) {
        this.archiveOrUnarchiveAsset(uuid, false);
    }

    private void archiveOrUnarchiveAsset(String uuid, boolean archive) {
        try {
            AssetItem item = this.repository.loadAssetByUUID(uuid);
            this.checkSecurityIsPackageDeveloper(item);
            if (item.getPackage().isArchived()) {
                throw new RulesRepositoryException("The package [" + item.getPackageName() + "] that asset [" + item.getName() + "] belongs to is archived. You need to unarchive it first.");
            }
            log.info("USER:" + this.getCurrentUserName() + " ARCHIVING asset: [" + item.getName() + "] UUID: [" + item.getUUID() + "] ");
            try {
                ContentHandler handler = this.getContentHandler(item);
                if (handler instanceof ICanHasAttachment) {
                    ((ICanHasAttachment)handler).onAttachmentRemoved(item);
                }
            }
            catch (IOException e) {
                log.error("Unable to remove asset attachment", (Throwable)e);
            }
            item.archiveItem(archive);
            PackageItem pkg = item.getPackage();
            pkg.updateBinaryUpToDate(false);
            ruleBaseCache.remove(pkg.getUUID());
            if (archive) {
                item.checkin("archived");
            } else {
                item.checkin("unarchived");
            }
            this.push("packageChange", pkg.getName());
        }
        catch (RulesRepositoryException e) {
            log.error("Unable to get item format.", (Throwable)e);
            throw e;
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void archiveAssets(String[] uuids, boolean value) {
        for (String uuid : uuids) {
            this.archiveOrUnarchiveAsset(uuid, value);
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removeAsset(String uuid) {
        try {
            AssetItem item = this.repository.loadAssetByUUID(uuid);
            this.checkSecurityIsPackageDeveloper(item);
            item.remove();
            this.repository.save();
        }
        catch (RulesRepositoryException e) {
            log.error("Unable to remove asset.", (Throwable)e);
            throw e;
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removeAssets(String[] uuids) {
        for (String uuid : uuids) {
            this.removeAsset(uuid);
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removePackage(String uuid) {
        this.checkSecurityIsPackageAdmin(uuid);
        try {
            PackageItem item = this.repository.loadPackageByUUID(uuid);
            log.info("USER:" + this.getCurrentUserName() + " REMOVEING package [" + item.getName() + "]");
            item.remove();
            this.repository.save();
        }
        catch (RulesRepositoryException e) {
            log.error("Unable to remove package.", (Throwable)e);
            throw e;
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String renamePackage(String uuid, String newName) {
        this.checkSecurityIsPackageAdmin(uuid);
        log.info("USER:" + this.getCurrentUserName() + " RENAMING package [UUID: " + uuid + "] to package [" + newName + "]");
        return this.repository.renamePackage(uuid, newName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public byte[] exportPackages(String packageName) {
        this.checkSecurityIsPackageNameTypeAdmin(packageName);
        log.info("USER:" + this.getCurrentUserName() + " export package [name: " + packageName + "] ");
        byte[] result = null;
        try {
            result = this.repository.dumpPackageFromRepositoryXml(packageName);
        }
        catch (PathNotFoundException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
        return result;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void importPackages(byte[] byteArray, boolean importAsNew) {
        this.repository.importPackageToRepository(byteArray, importAsNew);
    }

    @WebRemote
    public void rebuildSnapshots() throws SerializationException {
        this.checkSecurityIsAdmin();
        PackageIterator pkit = this.repository.listPackages();
        while (pkit.hasNext()) {
            String[] snaps;
            PackageItem pkg = (PackageItem)pkit.next();
            for (String snapName : snaps = this.repository.listPackageSnapshots(pkg.getName())) {
                PackageItem snap = this.repository.loadPackageSnapshot(pkg.getName(), snapName);
                BuilderResult res = this.buildPackage(snap.getUUID(), true);
                if (res == null) continue;
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < res.getLines().length; ++i) {
                    buf.append(res.getLines()[i].toString());
                    buf.append('\n');
                }
                throw new DetailedSerializationException("Unable to rebuild snapshot [" + snapName, buf.toString() + "]");
            }
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listRulesInPackage(String packageName) throws SerializationException {
        this.checkSecurityIsPackageReadOnly(packageName);
        PackageItem item = this.repository.loadPackage(packageName);
        ContentPackageAssembler asm = new ContentPackageAssembler(item, false);
        ArrayList result = new ArrayList();
        try {
            String drl = asm.getDRL();
            if (drl == null || "".equals(drl)) {
                return new String[0];
            }
            this.parseRulesToPackageList(asm, result);
            return result.toArray(new String[result.size()]);
        }
        catch (DroolsParserException e) {
            log.error("Unable to list rules in package", (Throwable)e);
            return new String[0];
        }
    }

    private void parseRulesToPackageList(ContentPackageAssembler asm, List<String> result) throws DroolsParserException {
        int count = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(asm.getDRL(), "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String line = stringTokenizer.nextToken().trim();
            if (!line.startsWith("rule ")) continue;
            String name = ClassicDRLImporter.getRuleName((String)line);
            result.add(name);
            if (++count != 5000) continue;
            result.add("More then 5000 rules.");
            break;
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listRulesInGlobalArea() throws SerializationException {
        return this.listRulesInPackage("globalArea");
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public SingleScenarioResult runScenario(String packageName, Scenario scenario) throws SerializationException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), "package.developer");
        }
        return this.runScenario(packageName, scenario, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingleScenarioResult runScenario(String packageName, Scenario scenario, RuleCoverageListener coverage) throws SerializationException {
        SingleScenarioResult result;
        block6: {
            PackageItem item = this.repository.loadPackage(packageName);
            result = null;
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            try {
                RuleBase rb = this.loadCacheRuleBase(item);
                CompositeClassLoader cl = ((InternalRuleBase)ruleBaseCache.get(item.getUUID())).getRootClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                result = this.runScenario(scenario, item, (ClassLoader)cl, rb, coverage);
            }
            catch (Exception e) {
                if (!(e instanceof DetailedSerializationException)) break block6;
                DetailedSerializationException err = (DetailedSerializationException)((Object)e);
                result = new SingleScenarioResult();
                if (err.getErrs() != null) {
                    result.result = new ScenarioRunResult(err.getErrs(), null);
                    break block6;
                }
                throw err;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }
        return result;
    }

    private RuleBase loadCacheRuleBase(PackageItem item) throws DetailedSerializationException {
        RuleBase rb = null;
        if (item.isBinaryUpToDate() && ruleBaseCache.containsKey(item.getUUID())) {
            rb = (RuleBase)ruleBaseCache.get(item.getUUID());
        } else {
            List jars = BRMSPackageBuilder.getJars((PackageItem)item);
            MapBackedClassLoader buildCl = BRMSPackageBuilder.createClassLoader((List)jars);
            if (item.isBinaryUpToDate()) {
                rb = this.loadRuleBase(item, (ClassLoader)buildCl);
                ruleBaseCache.put(item.getUUID(), rb);
            } else {
                BuilderResult result = this.buildPackage(item, false);
                if (result == null || result.getLines().length == 0) {
                    rb = this.loadRuleBase(item, (ClassLoader)buildCl);
                    ruleBaseCache.put(item.getUUID(), rb);
                } else {
                    throw new DetailedSerializationException("Build error", result.getLines());
                }
            }
        }
        return rb;
    }

    private RuleBase loadRuleBase(PackageItem item, ClassLoader cl) throws DetailedSerializationException {
        try {
            return this.deserKnowledgebase(item, cl);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to load rule base.", (Throwable)e);
            throw new DetailedSerializationException("A required class was not found.", e.getMessage());
        }
        catch (Exception e) {
            log.error("Unable to load rule base.", (Throwable)e);
            log.info("...but trying to rebuild binaries...");
            try {
                BuilderResult res = this.buildPackage(item, true);
                if (res != null && res.getLines().length > 0) {
                    log.error("There were errors when rebuilding the knowledgebase.");
                    throw new DetailedSerializationException("There were errors when rebuilding the knowledgebase.", "");
                }
            }
            catch (Exception e1) {
                log.error("Unable to rebuild the rulebase: " + e.getMessage());
                throw new DetailedSerializationException("Unable to rebuild the rulebase.", e.getMessage());
            }
            try {
                return this.deserKnowledgebase(item, cl);
            }
            catch (Exception e2) {
                log.error("Unable to reload knowledgebase: " + e.getMessage());
                throw new DetailedSerializationException("Unable to reload knowledgebase.", e.getMessage());
            }
        }
    }

    private RuleBase deserKnowledgebase(PackageItem item, ClassLoader cl) throws IOException, ClassNotFoundException {
        RuleBase rb = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)new RuleBaseConfiguration(new ClassLoader[]{cl}));
        Package bin = (Package)DroolsStreamUtils.streamIn((byte[])item.getCompiledPackageBytes(), (ClassLoader)cl);
        rb.addPackage(bin);
        return rb;
    }

    private SingleScenarioResult runScenario(Scenario scenario, PackageItem item, ClassLoader cl, RuleBase rb, RuleCoverageListener coverage) throws DetailedSerializationException {
        Package bin = rb.getPackages()[0];
        Set imps = bin.getImports().keySet();
        HashSet allImps = new HashSet(imps);
        if (bin.getGlobals() != null) {
            Iterator iterator = bin.getGlobals().keySet().iterator();
            while (iterator.hasNext()) {
                allImps.add(bin.getGlobals().get(iterator.next()));
            }
        }
        allImps.add(bin.getName() + ".*");
        ClassTypeResolver res = new ClassTypeResolver(allImps, cl);
        SessionConfiguration sessionConfiguration = new SessionConfiguration();
        sessionConfiguration.setClockType(ClockType.PSEUDO_CLOCK);
        sessionConfiguration.setKeepReference(false);
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)rb.newStatefulSession(sessionConfiguration, null);
        if (coverage != null) {
            workingMemory.addEventListener((AgendaEventListener)coverage);
        }
        try {
            AuditLogReporter logger = new AuditLogReporter((WorkingMemory)workingMemory);
            new ScenarioRunner(scenario, (TypeResolver)res, workingMemory);
            SingleScenarioResult r = new SingleScenarioResult();
            r.auditLog = logger.buildReport();
            r.result = new ScenarioRunResult(null, scenario);
            return r;
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to load a required class.", (Throwable)e);
            throw new DetailedSerializationException("Unable to load a required class.", e.getMessage());
        }
        catch (ConsequenceException e) {
            String messageShort = "There was an error executing the consequence of rule [" + e.getRule().getName() + "]";
            String messageLong = e.getMessage();
            if (e.getCause() != null) {
                messageLong = messageLong + "\nCAUSED BY " + e.getCause().getMessage();
            }
            log.error(messageShort + ": " + messageLong, (Throwable)e);
            throw new DetailedSerializationException(messageShort, messageLong);
        }
        catch (Exception e) {
            log.error("Unable to run the scenario.", (Throwable)e);
            throw new DetailedSerializationException("Unable to run the scenario.", e.getMessage());
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BulkTestRunResult runScenariosInPackage(String packageUUID) throws SerializationException {
        this.checkSecurityIsPackageDeveloper(packageUUID);
        PackageItem item = this.repository.loadPackageByUUID(packageUUID);
        return this.runScenariosInPackage(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkTestRunResult runScenariosInPackage(PackageItem item) throws DetailedSerializationException, SerializationException {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        MapBackedClassLoader cl = null;
        try {
            BulkTestRunResult result;
            if (item.isBinaryUpToDate() && ruleBaseCache.containsKey(item.getUUID())) {
                RuleBase rb = (RuleBase)ruleBaseCache.get(item.getUUID());
                AbstractRuleBase arb = (AbstractRuleBase)rb;
                cl = arb.getConfiguration().getClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)cl);
            } else {
                List jars = BRMSPackageBuilder.getJars((PackageItem)item);
                cl = BRMSPackageBuilder.createClassLoader((List)jars);
                Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                if (item.isBinaryUpToDate()) {
                    ruleBaseCache.put(item.getUUID(), this.loadRuleBase(item, (ClassLoader)cl));
                } else {
                    BuilderResult result2 = this.buildPackage(item, false);
                    if (result2 == null || result2.getLines().length == 0) {
                        ruleBaseCache.put(item.getUUID(), this.loadRuleBase(item, (ClassLoader)cl));
                    } else {
                        BulkTestRunResult bulkTestRunResult = new BulkTestRunResult(result2, null, 0, null);
                        return bulkTestRunResult;
                    }
                }
            }
            AssetItemIterator it = item.listAssetsByFormat(new String[]{"scenario"});
            ArrayList<ScenarioResultSummary> resultSummaries = new ArrayList<ScenarioResultSummary>();
            RuleBase rb = (RuleBase)ruleBaseCache.get(item.getUUID());
            Package bin = rb.getPackages()[0];
            RuleCoverageListener coverage = new RuleCoverageListener(this.expectedRules(bin));
            while (it.hasNext()) {
                AssetItem as = it.next();
                if (as.getDisabled()) continue;
                RuleAsset asset = this.loadAsset(as);
                Scenario sc = (Scenario)asset.content;
                this.runScenario(item.getName(), sc, coverage);
                int[] totals = sc.countFailuresTotal();
                resultSummaries.add(new ScenarioResultSummary(totals[0], totals[1], asset.metaData.name, asset.metaData.description, asset.uuid));
            }
            ScenarioResultSummary[] summaries = resultSummaries.toArray(new ScenarioResultSummary[resultSummaries.size()]);
            BulkTestRunResult bulkTestRunResult = result = new BulkTestRunResult(null, resultSummaries.toArray(summaries), coverage.getPercentCovered(), coverage.getUnfiredRules());
            return bulkTestRunResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    private HashSet<String> expectedRules(Package bin) {
        HashSet<String> h = new HashSet<String>();
        for (int i = 0; i < bin.getRules().length; ++i) {
            h.add(bin.getRules()[i].getName());
        }
        return h;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listTypesInPackage(String packageUUID) throws SerializationException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(packageUUID), "package.readoly");
        }
        PackageItem pkg = this.repository.loadPackageByUUID(packageUUID);
        ArrayList res = new ArrayList();
        AssetItemIterator it = pkg.listAssetsByFormat(new String[]{"jar", "model.drl"});
        JarInputStream jis = null;
        try {
            String[] asset;
            while (it.hasNext()) {
                asset = it.next();
                if (asset.isArchived()) continue;
                if (asset.getFormat().equals("jar")) {
                    jis = this.typesForModel(res, (AssetItem)asset);
                    continue;
                }
                this.typesForOthers(res, (AssetItem)asset);
            }
            asset = res.toArray(new String[res.size()]);
            return asset;
        }
        catch (IOException e) {
            log.error("Unable to read the jar files in the package: " + e.getMessage());
            throw new DetailedSerializationException("Unable to read the jar files in the package.", e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(jis);
        }
    }

    private void typesForOthers(List<String> res, AssetItem asset) {
        DrlParser parser = new DrlParser();
        try {
            PackageDescr desc = parser.parse(asset.getContent());
            List types = desc.getTypeDeclarations();
            for (TypeDeclarationDescr typeDeclarationDescr : types) {
                res.add(typeDeclarationDescr.getTypeName());
            }
        }
        catch (DroolsParserException e) {
            log.error("An error occurred parsing rule: " + e.getMessage());
        }
    }

    private JarInputStream typesForModel(List<String> res, AssetItem asset) throws IOException {
        JarInputStream jis = new JarInputStream(asset.getBinaryContentAttachment());
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            res.add(ModelContentHandler.convertPathToName((String)entry.getName()));
        }
        return jis;
    }

    @WebRemote
    public LogEntry[] showLog() {
        this.checkSecurityIsAdmin();
        return LoggingHelper.getMessages();
    }

    @WebRemote
    public void cleanLog() {
        this.checkSecurityIsAdmin();
        LoggingHelper.cleanLog();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void renameCategory(String fullPathAndName, String newName) {
        this.repository.renameCategory(fullPathAndName, newName);
    }

    public static String getDroolsHeader(PackageItem pkg) {
        if (pkg.containsAsset("drools")) {
            return pkg.loadAsset("drools").getContent();
        }
        return "";
    }

    public static void updateDroolsHeader(String string, PackageItem pkg) {
        pkg.checkout();
        if (pkg.containsAsset("drools")) {
            AssetItem conf = pkg.loadAsset("drools");
            conf.updateContent(string);
            conf.checkin("");
        } else {
            AssetItem conf = pkg.addAsset("drools", "");
            conf.updateFormat("package");
            conf.updateContent(string);
            conf.checkin("");
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] loadDropDownExpression(String[] valuePairs, String expression) {
        HashMap<String, String> context = new HashMap<String, String>();
        for (int i = 0; i < valuePairs.length; ++i) {
            if (valuePairs[i] == null) {
                return new String[0];
            }
            String[] pair = valuePairs[i].split("=");
            context.put(pair[0], pair[1]);
        }
        Object result = MVEL.eval((String)(expression = (String)TemplateRuntime.eval((String)expression, context)));
        if (result instanceof String[]) {
            return (String[])result;
        }
        if (result instanceof List) {
            List l = (List)result;
            String[] xs = new String[l.size()];
            for (int i = 0; i < xs.length; ++i) {
                Object el = l.get(i);
                xs[i] = el.toString();
            }
            return xs;
        }
        return null;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void rebuildPackages() throws SerializationException {
        PackageIterator pkit = this.repository.listPackages();
        StringBuffer errs = new StringBuffer();
        while (pkit.hasNext()) {
            PackageItem pkg = (PackageItem)pkit.next();
            try {
                BuilderResult res = this.buildPackage(pkg.getUUID(), true);
                if (res == null) continue;
                errs.append("Unable to build package name [" + pkg.getName() + "]\n");
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < res.getLines().length; ++i) {
                    buf.append(res.getLines()[i].toString());
                    buf.append('\n');
                }
                log.warn(buf.toString());
            }
            catch (Exception e) {
                log.error("An error occurred building package [" + pkg.getName() + "]\n");
                errs.append("An error occurred building package [" + pkg.getName() + "]\n");
            }
        }
        if (errs.toString().length() > 0) {
            throw new DetailedSerializationException("Unable to rebuild all packages.", errs.toString());
        }
    }

    @Restrict(value="#{identity.loggedIn}")
    public Map<String, List<String>> listUserPermissions() {
        this.checkSecurityIsAdmin();
        PermissionManager pm = new PermissionManager(this.repository);
        return pm.listUsers();
    }

    @Restrict(value="#{identity.loggedIn}")
    public Map<String, List<String>> retrieveUserPermissions(String userName) {
        this.checkSecurityIsAdmin();
        PermissionManager pm = new PermissionManager(this.repository);
        return pm.retrieveUserPermissions(userName);
    }

    @Restrict(value="#{identity.loggedIn}")
    public void updateUserPermissions(String userName, Map<String, List<String>> perms) {
        this.checkSecurityIsAdmin();
        PermissionManager pm = new PermissionManager(this.repository);
        log.info("Updating user permissions for userName [" + userName + "] to [" + perms + "]");
        pm.updateUserPermissions(userName, perms);
        this.repository.save();
    }

    @Restrict(value="#{identity.loggedIn}")
    public String[] listAvailablePermissionTypes() {
        this.checkSecurityIsAdmin();
        return RoleTypes.listAvailableTypes();
    }

    @Restrict(value="#{identity.loggedIn}")
    public void deleteUser(String userName) {
        log.info("Removing user permissions for user name [" + userName + "]");
        PermissionManager pm = new PermissionManager(this.repository);
        pm.removeUserPermissions(userName);
        this.repository.save();
    }

    @Restrict(value="#{identity.loggedIn}")
    public void createUser(String userName) {
        log.info("Creating user permissions, user name [" + userName + "]");
        PermissionManager pm = new PermissionManager(this.repository);
        pm.createUser(userName);
        this.repository.save();
    }

    @Restrict(value="#{identity.loggedIn}")
    public String getAssetLockerUserName(String uuid) {
        AssetLockManager alm = AssetLockManager.instance();
        String userName = alm.getAssetLockerUserName(uuid);
        log.info("Asset locked by [" + userName + "]");
        return userName;
    }

    @Restrict(value="#{identity.loggedIn}")
    public void lockAsset(String uuid) {
        AssetLockManager alm = AssetLockManager.instance();
        String userName = Contexts.isApplicationContextActive() ? Identity.instance().getUsername() : "anonymous";
        log.info("Locking asset uuid=" + uuid + " for user [" + userName + "]");
        alm.lockAsset(uuid, userName);
    }

    @Restrict(value="#{identity.loggedIn}")
    public void unLockAsset(String uuid) {
        AssetLockManager alm = AssetLockManager.instance();
        log.info("Unlocking asset [" + uuid + "]");
        alm.unLockAsset(uuid);
    }

    @Restrict(value="#{identity.loggedIn}")
    public void installSampleRepository() throws SerializationException {
        this.checkIfADMIN();
        this.repository.importRepository(this.getClass().getResourceAsStream("/mortgage-sample-repository.xml"));
        this.rebuildPackages();
        this.rebuildSnapshots();
    }

    @Restrict(value="#{identity.loggedIn}")
    public List<DiscussionRecord> loadDiscussionForAsset(String assetId) {
        return new Discussion().fromString(this.getRulesRepository().loadAssetByUUID(assetId).getStringProperty("discussion"));
    }

    @Restrict(value="#{identity.loggedIn}")
    public List<DiscussionRecord> addToDiscussionForAsset(String assetId, String comment) {
        RulesRepository repo = this.getRulesRepository();
        AssetItem asset = repo.loadAssetByUUID(assetId);
        Discussion dp = new Discussion();
        List discussion = dp.fromString(asset.getStringProperty("discussion"));
        discussion.add(new DiscussionRecord(repo.getSession().getUserID(), StringEscapeUtils.escapeXml((String)comment)));
        asset.updateStringProperty(dp.toString(discussion), "discussion", false);
        repo.save();
        this.push("discussion", assetId);
        MailboxService.getInstance().recordItemUpdated(asset);
        return discussion;
    }

    @Restrict(value="#{identity.loggedIn}")
    public void clearAllDiscussionsForAsset(String assetId) {
        this.checkIfADMIN();
        RulesRepository repo = this.getRulesRepository();
        AssetItem asset = repo.loadAssetByUUID(assetId);
        asset.updateStringProperty("", "discussion");
        repo.save();
        this.push("discussion", assetId);
    }

    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadInbox(String inboxName) throws DetailedSerializationException {
        try {
            UserInbox ib = new UserInbox(this.repository);
            if (inboxName.equals("recentViewed")) {
                return UserInbox.toTable((List)ib.loadRecentOpened(), (boolean)false);
            }
            if (inboxName.equals("recentEdited")) {
                return UserInbox.toTable((List)ib.loadRecentEdited(), (boolean)false);
            }
            return UserInbox.toTable((List)ib.loadIncoming(), (boolean)true);
        }
        catch (Exception e) {
            log.error("Unable to load Inbox: " + e.getMessage());
            throw new DetailedSerializationException("Unable to load Inbox", e.getMessage());
        }
    }

    private void push(String messageType, String message) {
        backchannel.publish(new PushResponse(messageType, message));
    }

    public List<PushResponse> subscribe() {
        if (Contexts.isApplicationContextActive() && !Session.instance().isInvalid()) {
            try {
                return backchannel.await(this.getCurrentUserName());
            }
            catch (InterruptedException e) {
                return new ArrayList<PushResponse>();
            }
        }
        return new ArrayList<PushResponse>();
    }

    private String getCurrentUserName() {
        return this.repository.getSession().getUserID();
    }

    private void checkIfADMIN() {
        if (Contexts.isApplicationContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
    }

    public String cleanHTML(String s) {
        return s.replace("<", "&lt;").replace(">", "&gt;");
    }

    public SnapshotDiffs compareSnapshots(String packageName, String firstSnapshotName, String secondSnapshotName) {
        PackageItem rightPackage;
        SnapshotDiffs diffs = new SnapshotDiffs();
        ArrayList<SnapshotDiff> list = new ArrayList<SnapshotDiff>();
        PackageItem leftPackage = this.repository.loadPackageSnapshot(packageName, firstSnapshotName);
        if (this.isRightOlderThanLeft(leftPackage, rightPackage = this.repository.loadPackageSnapshot(packageName, secondSnapshotName))) {
            PackageItem temp = leftPackage;
            leftPackage = rightPackage;
            rightPackage = temp;
            diffs.leftName = secondSnapshotName;
            diffs.rightName = firstSnapshotName;
        } else {
            diffs.leftName = firstSnapshotName;
            diffs.rightName = secondSnapshotName;
        }
        Iterator leftExistingIter = leftPackage.getAssets();
        while (leftExistingIter.hasNext()) {
            AssetItem left = (AssetItem)leftExistingIter.next();
            if (!this.isPackageItemDeleted(rightPackage, left)) continue;
            SnapshotDiff diff = new SnapshotDiff();
            diff.name = left.getName();
            diff.diffType = "TYPE_DELETED";
            diff.leftUuid = left.getUUID();
            list.add(diff);
        }
        Iterator rightExistingIter = rightPackage.getAssets();
        while (rightExistingIter.hasNext()) {
            SnapshotDiff diff;
            AssetItem right = (AssetItem)rightExistingIter.next();
            AssetItem left = null;
            if (right != null && leftPackage.containsAsset(right.getName())) {
                left = leftPackage.loadAsset(right.getName());
            }
            if (right == null || left == null) {
                diff = new SnapshotDiff();
                if (left == null) {
                    diff.name = right.getName();
                    diff.diffType = "TYPE_ADDED";
                    diff.rightUuid = right.getUUID();
                }
                list.add(diff);
                continue;
            }
            if (this.isAssetArchivedOrRestored(right, left)) {
                diff = new SnapshotDiff();
                diff.name = right.getName();
                diff.leftUuid = left.getUUID();
                diff.rightUuid = right.getUUID();
                diff.diffType = left.isArchived() ? "TYPE_RESTORED" : "TYPE_ARCHIVED";
                list.add(diff);
                continue;
            }
            if (!this.isAssetItemUpdated(right, left)) continue;
            diff = new SnapshotDiff();
            diff.name = right.getName();
            diff.leftUuid = left.getUUID();
            diff.rightUuid = right.getUUID();
            diff.diffType = "TYPE_UPDATED";
            list.add(diff);
        }
        diffs.diffs = list.toArray(new SnapshotDiff[list.size()]);
        return diffs;
    }

    private boolean isAssetArchivedOrRestored(AssetItem right, AssetItem left) {
        return right.isArchived() != left.isArchived();
    }

    private boolean isAssetItemUpdated(AssetItem right, AssetItem left) {
        return right.getLastModified().compareTo(left.getLastModified()) != 0;
    }

    private boolean isPackageItemDeleted(PackageItem rightPackage, AssetItem left) {
        return !rightPackage.containsAsset(left.getName());
    }

    private boolean isRightOlderThanLeft(PackageItem leftPackage, PackageItem rightPackage) {
        return leftPackage.getLastModified().compareTo(rightPackage.getLastModified()) > 0;
    }

    public String processTemplate(String name, Map<String, Object> data) {
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateUpdateDelay(0);
            Template temp = new Template(name, (Reader)new InputStreamReader(ServiceImplementation.class.getResourceAsStream("/repoconfig/" + name + ".xml")), cfg);
            StringWriter strw = new StringWriter();
            temp.process(data, (Writer)strw);
            return StringEscapeUtils.escapeXml((String)strw.toString());
        }
        catch (Exception e) {
            return "";
        }
    }

    public Boolean isHostedMode() {
        Boolean hm = Contexts.isApplicationContextActive() ? Boolean.FALSE : Boolean.TRUE;
        return hm;
    }

    private void checkSecurityIsPackageNameTypeAdmin(String packageName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), "package.admin");
        }
    }

    private void checkSecurityIsPackageDeveloper(String packageUUID) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(packageUUID), "package.developer");
        }
    }

    private void checkSecurityIsPackageDeveloper(RuleAsset asset) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(asset.metaData.packageName), "package.developer");
        }
    }

    private void checkSecurityIsPackageReadOnly(String packageName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), "package.readonly");
        }
    }

    private void checkSecurityIsPackageDeveloper(AssetItem item) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(item.getPackage().getUUID()), "package.developer");
        }
    }

    private void checkSecurityIsPackageAdmin(String uuid) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(uuid), "package.admin");
        }
    }

    private void checkSecurityIsAdmin() {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
    }

    private void checkSecurityNameTypePackageReadOnly(PackageItem item) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(item.getName()), "package.readonly");
        }
    }
}

