/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.example;

import java.io.IOException;
import java.util.ArrayList;
import org.drools.impact.analysis.example.domain.Order;
import org.drools.impact.analysis.example.domain.Product;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.GraphCollapsionHelper;
import org.drools.impact.analysis.graph.ImpactAnalysisHelper;
import org.drools.impact.analysis.graph.ModelToGraphConverter;
import org.drools.impact.analysis.graph.TextReporter;
import org.drools.impact.analysis.graph.graphviz.GraphImageGenerator;
import org.drools.impact.analysis.integrationtests.RuleExecutionHelper;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.parser.internal.ImpactAnalysisKieModule;
import org.drools.impact.analysis.parser.internal.ImpactAnalysisProject;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;

public class ExampleUsageTest {
    @Test
    public void testExampleUsage() throws IOException {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.drools.impact.analysis.example", "order-process", "1.0.0");
        KieFileSystem kfs = this.createKieFileSystemWithClassPathResourceNames(releaseId, this.getClass(), "/org/drools/impact/analysis/example/CustomerCheck.drl.xls", "/org/drools/impact/analysis/example/PriceCheck.drl.xls", "/org/drools/impact/analysis/example/StatusCheck.drl.xls", "/org/drools/impact/analysis/example/inventory.drl");
        Order order = new Order(1L, "Guitar", 6000.0, 65, 5);
        Product guitar = new Product("Guitar", 5500.0, 8);
        KieSession kieSession = RuleExecutionHelper.getKieSession(kfs);
        ArrayList resultList = new ArrayList();
        kieSession.setGlobal("resultList", resultList);
        kieSession.insert((Object)order);
        kieSession.insert((Object)guitar);
        kieSession.fireAllRules();
        kieSession.dispose();
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(ImpactAnalysisProject.class);
        ImpactAnalysisKieModule analysisKieModule = (ImpactAnalysisKieModule)kieBuilder.getKieModule();
        AnalysisModel analysisModel = analysisKieModule.getAnalysisModel();
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.generateImage(graph, "example-whole-graph");
        ImpactAnalysisHelper impactFilter = new ImpactAnalysisHelper();
        Graph impactedSubGraph = impactFilter.filterImpactedNodes(graph, "org.drools.impact.analysis.example.PriceCheck_11");
        this.generateImage(impactedSubGraph, "example-impacted-sub-graph");
        this.generateImage(graph, "example-impacted-whole-graph");
        Graph collapsedGraph = new GraphCollapsionHelper().collapseWithRuleNamePrefix(graph);
        this.generateImage(collapsedGraph, "example-collapsed-graph");
        Graph impactedCollapsedSubGraph = impactFilter.filterImpactedNodes(collapsedGraph, "org.drools.impact.analysis.example.PriceCheck");
        this.generateImage(impactedCollapsedSubGraph, "example-impacted-collapsed-sub-graph");
        System.out.println("--- toHierarchyText ---");
        String hierarchyText = TextReporter.toHierarchyText((Graph)impactedSubGraph);
        System.out.println(hierarchyText);
        System.out.println("--- toFlatText ---");
        String flatText = TextReporter.toFlatText((Graph)impactedSubGraph);
        System.out.println(flatText);
        Graph impactingSubGraph = impactFilter.filterImpactingNodes(graph, "org.drools.impact.analysis.example.StatusCheck_11");
        this.generateImage(impactingSubGraph, "example-impacting-sub-graph");
    }

    private KieFileSystem createKieFileSystemWithClassPathResourceNames(ReleaseId releaseId, Class<?> classForClassLoader, String ... resourceNames) throws IOException {
        KieServices ks = KieServices.Factory.get();
        KieResources kieResources = ks.getResources();
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (String resourceName : resourceNames) {
            Resource resource = kieResources.newClassPathResource(resourceName, classForClassLoader);
            resource.setSourcePath("src/main/resources/" + resource.getSourcePath());
            resourceList.add(resource);
        }
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writePomXML(RuleExecutionHelper.getPom(releaseId));
        for (Resource resource : resourceList.toArray(new Resource[0])) {
            kfs.write(resource.getSourcePath(), resource);
        }
        return kfs;
    }

    protected void generateImage(Graph graph, String fileName) {
        GraphImageGenerator generator = new GraphImageGenerator(fileName);
        generator.generateSvg(graph);
    }
}

