/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jboss.integration;

import java.net.URI;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.jboss.integration.FullDistributionTest;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.Path;
import org.kie.workbench.common.services.datamodel.oracle.ProjectDataModelOracle;
import org.kie.workbench.common.services.datamodel.service.DataModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;

@Ignore
@RunWith(value=Arquillian.class)
public class AnnotationsTest
extends FullDistributionTest {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationsTest.class);
    @Inject
    IOService ioService;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private Paths paths;
    @Inject
    private Event<InvalidateDMOProjectCacheEvent> invalidateDMOProjectCache;

    @Test
    public void test() {
        try {
            TestCase.assertNotNull((Object)this.ioService);
            TestCase.assertNotNull((Object)this.dataModelService);
            TestCase.assertNotNull((Object)this.paths);
            URI projectUri = null;
            projectUri = new URI("default://master@uf-playground/GuvnorM2RepoDependencyExample1");
            Path projectPath = this.ioService.get(projectUri);
            TestCase.assertNotNull((Object)projectPath);
            this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(this.paths.convert(projectPath)));
            ProjectDataModelOracle projectDataModelOracle = this.dataModelService.getProjectDataModel(this.paths.convert(projectPath));
            String annotationTest = "org.kie.test.AnnotationsBean";
            String annotationTestSerializable = "org.kie.test.AnnotationsBeanSerializable";
            boolean isTestLoaded = false;
            boolean isTestSerializableLoaded = false;
            String[] types = projectDataModelOracle.getFactTypes();
            if (types != null) {
                for (int i = 0; i < types.length; ++i) {
                    logger.info("**************************** -> Loading type: " + types[i]);
                    if (annotationTest.equals(types[i])) {
                        isTestLoaded = true;
                    }
                    if (!annotationTestSerializable.equals(types[i])) continue;
                    isTestSerializableLoaded = true;
                }
            } else {
                logger.info("project has not types");
            }
            TestCase.assertEquals((String)("Annotations test class: " + annotationTest + " wasn't loaded"), (boolean)true, (boolean)isTestLoaded);
            TestCase.assertEquals((String)("Annotations test class: " + annotationTestSerializable + " wasn't loaded"), (boolean)true, (boolean)isTestSerializableLoaded);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed: " + e.getMessage()));
        }
    }
}

