/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jboss.integration;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.TestCase;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullDistributionTest {
    private static final Logger logger = LoggerFactory.getLogger(FullDistributionTest.class);
    public static final String DIST_FILE = "distFile";

    public static WebArchive createDeploymentForDistribution(String distFile) throws Exception {
        JarEntry entry;
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class);
        JarFile jar = new JarFile(distFile);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements() && (entry = entries.nextElement()) != null) {
            if (entry.isDirectory()) continue;
            webArchive.add(FullDistributionTest.getAsset(jar, entry), entry.getName());
        }
        webArchive.addClass(FullDistributionTest.class);
        System.out.println("Generated web archive");
        System.out.println("*******************************");
        System.out.println(webArchive.toString(true));
        System.out.println("*******************************");
        return webArchive;
    }

    public static Asset getAsset(final JarFile jar, final JarEntry entry) {
        return new Asset(){

            public InputStream openStream() {
                try {
                    return jar.getInputStream(entry);
                }
                catch (Exception e) {
                    logger.error("asset generation failed. entry: " + entry, (Throwable)e);
                    return null;
                }
            }
        };
    }

    @Deployment
    public static WebArchive createDeployment() {
        String distFile = System.getProperty(DIST_FILE);
        logger.info("Configured distribution file is: " + distFile);
        TestCase.assertNotNull((String)"Distribution file was not configured", (Object)distFile);
        WebArchive distWar = null;
        try {
            distWar = FullDistributionTest.createDeploymentForDistribution(distFile);
        }
        catch (Exception e) {
            logger.error("WebArchive creation failed, fistFile: " + distFile, (Throwable)e);
        }
        TestCase.assertNotNull((String)"WebArchive couldn't be created.", (Object)distWar);
        return distWar;
    }
}

