/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.ResultHandler;
import org.drools.runtime.pipeline.ResultHandlerFactory;
import org.drools.runtime.pipeline.impl.ExecuteResultHandler;
import org.drools.runtime.pipeline.impl.JmsMessenger;
import org.drools.runtime.pipeline.impl.JmsUnwrapMessageObject;
import org.drools.runtime.pipeline.impl.SimpleProducer;
import org.drools.runtime.pipeline.impl.StatefulKnowledgeSessionInsertStage;
import org.drools.runtime.pipeline.impl.StatefulKnowledgeSessionPipelineImpl;
import org.drools.runtime.rule.FactHandle;

public class SimpleJmsMessengerTest
extends TestCase {
    private SimpleProducer simpleProducer;
    private BrokerService broker;
    private String destinationName = "dynamicQueues/FOO.BAR";
    private String url = "vm://localhost:61616";
    private Properties props;

    protected void setUp() {
        try {
            this.broker = new BrokerService();
            this.broker.setBrokerName("consumer");
            this.broker.addConnector(this.url);
            this.broker.start();
            this.props = new Properties();
            this.props.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
            this.props.setProperty("java.naming.provider.url", this.url);
            this.simpleProducer = new SimpleProducer(this.props, this.destinationName);
            this.simpleProducer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void tearDown() throws Exception {
        this.simpleProducer.stop();
        this.broker.stop();
    }

    public void testJms() throws Exception {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        StatefulKnowledgeSessionPipelineImpl pipeline = new StatefulKnowledgeSessionPipelineImpl(ksession);
        JmsUnwrapMessageObject unwrapObjectStage = new JmsUnwrapMessageObject();
        StatefulKnowledgeSessionInsertStage insertStage = new StatefulKnowledgeSessionInsertStage();
        unwrapObjectStage.setReceiver((Receiver)insertStage);
        ExecuteResultHandler resultHandlerStage = new ExecuteResultHandler();
        insertStage.setReceiver((Receiver)resultHandlerStage);
        pipeline.setReceiver((Receiver)unwrapObjectStage);
        ResultHandleFactoryImpl factory = new ResultHandleFactoryImpl();
        JmsMessenger feeder = new JmsMessenger((Pipeline)pipeline, this.props, this.destinationName, (ResultHandlerFactory)factory);
        feeder.start();
        this.simpleProducer.sendObject((Serializable)((Object)"hello"));
        this.simpleProducer.sendObject((Serializable)((Object)"hello1"));
        this.simpleProducer.sendObject((Serializable)((Object)"hello2"));
        this.simpleProducer.sendObject((Serializable)((Object)"hello3"));
        for (int i = 0; i < 5 && factory.list.size() != 4; ++i) {
            Thread.sleep(500L);
        }
        SimpleJmsMessengerTest.assertEquals((int)4, (int)factory.list.size());
        FactHandle factHandle = (FactHandle)((Map)((ResultHandlerImpl)factory.list.get(0)).getObject()).keySet().iterator().next();
        SimpleJmsMessengerTest.assertEquals((Object)"hello", (Object)ksession.getObject(factHandle));
        factHandle = (FactHandle)((Map)((ResultHandlerImpl)factory.list.get(1)).getObject()).keySet().iterator().next();
        SimpleJmsMessengerTest.assertEquals((Object)"hello1", (Object)ksession.getObject(factHandle));
        factHandle = (FactHandle)((Map)((ResultHandlerImpl)factory.list.get(2)).getObject()).keySet().iterator().next();
        SimpleJmsMessengerTest.assertEquals((Object)"hello2", (Object)ksession.getObject(factHandle));
        factHandle = (FactHandle)((Map)((ResultHandlerImpl)factory.list.get(3)).getObject()).keySet().iterator().next();
        SimpleJmsMessengerTest.assertEquals((Object)"hello3", (Object)ksession.getObject(factHandle));
        feeder.stop();
    }

    public static class ResultHandlerImpl
    implements ResultHandler {
        Object object;

        public void handleResult(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }

    public static class ResultHandleFactoryImpl
    implements ResultHandlerFactory {
        List list = new ArrayList();

        public ResultHandler newResultHandler() {
            ResultHandlerImpl handler = new ResultHandlerImpl();
            this.list.add(handler);
            return handler;
        }
    }
}

