/*
 * Decompiled with CFR 0.152.
 */
package org.drools.metric;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Person;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public class MetricLogUtilsTest
extends CommonTestMethodBase {
    @Before
    public void setup() {
        System.setProperty("drools.metric.logger.enabled", "true");
        System.setProperty("drools.metric.logger.threshold", "-1");
    }

    @Test
    public void testJoin() {
        String str = "import " + Address.class.getCanonicalName() + "\nimport " + Person.class.getCanonicalName() + "\nrule R1\nwhen\n  $p1 : Person(age > 5)\n  $p2 : Person(age > $p1.age)\nthen\nend\nrule R2\nwhen\n  $p1 : Person(age > 5)\n  $p2 : Person(age < $p1.age)\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        List personList = IntStream.range(0, 10).mapToObj(i -> new Person("John" + i, i)).collect(Collectors.toList());
        KieSession ksession = kbase.newKieSession();
        personList.stream().forEach(arg_0 -> ((KieSession)ksession).insert(arg_0));
        int fired = ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)36L, (long)fired);
    }

    @Test
    public void testFrom() {
        String str = "import " + Address.class.getCanonicalName() + "\nimport " + Person.class.getCanonicalName() + "\nrule R1\nwhen\n  $p : Person()\n  $a1 : Address() from $p.addresses\n  $a2 : Address(suburb != \"XYZ\", zipCode == $a1.zipCode, this != $a1) from $p.addresses\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        List personList = IntStream.range(0, 10).mapToObj(i -> new Person("John" + i, i)).map(p -> {
            p.addAddress(new Address("StreetX" + p.getAge(), "ABC", "111"));
            p.addAddress(new Address("StreetY" + p.getAge(), "ABC", "111"));
            p.addAddress(new Address("StreetZ" + p.getAge(), "ABC", "999"));
            return p;
        }).collect(Collectors.toList());
        KieSession ksession = kbase.newKieSession();
        personList.stream().forEach(arg_0 -> ((KieSession)ksession).insert(arg_0));
        int fired = ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)20L, (long)fired);
    }

    @Test
    public void testNot() {
        String str = "import " + Address.class.getCanonicalName() + "\nimport " + Person.class.getCanonicalName() + "\nrule R1\nwhen\n  $p1 : Person()\n  $p2 : Person(this != $p1)\n  not Person(this != $p1, this != $p2, (age == $p1.age || age == $p2.age))\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        List personList = IntStream.range(0, 10).mapToObj(i -> new Person("John" + i, i)).collect(Collectors.toList());
        KieSession ksession = kbase.newKieSession();
        personList.stream().forEach(arg_0 -> ((KieSession)ksession).insert(arg_0));
        int fired = ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)90L, (long)fired);
    }

    @Test
    public void testExists() {
        String str = "import " + Address.class.getCanonicalName() + "\nimport " + Person.class.getCanonicalName() + "\nrule R1\nwhen\n  $p1 : Person()\n  $p2 : Person(this != $p1)\n  exists Person(this != $p1, this != $p2, age != $p1.age, age != $p2.age)\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        List personList = IntStream.range(0, 10).mapToObj(i -> new Person("John" + i, i)).collect(Collectors.toList());
        KieSession ksession = kbase.newKieSession();
        personList.stream().forEach(arg_0 -> ((KieSession)ksession).insert(arg_0));
        int fired = ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)90L, (long)fired);
    }

    @Test
    public void testAccumulate() {
        String str = "import " + Address.class.getCanonicalName() + "\nimport " + Person.class.getCanonicalName() + "\nrule R1\nwhen\n  $p1 : Person()\n  accumulate ( $p2: Person ( getName().startsWith(\"J\"), this != $p1);\n                $average : average($p2.getAge());\n                $average > $p1.age, $average > 3\n             )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        List personList = IntStream.range(0, 10).mapToObj(i -> new Person("John" + i, i)).collect(Collectors.toList());
        KieSession ksession = kbase.newKieSession();
        personList.stream().forEach(arg_0 -> ((KieSession)ksession).insert(arg_0));
        int fired = ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)5L, (long)fired);
    }

    @Test
    public void testFromAccumulate() {
        String str = "import " + Address.class.getCanonicalName() + "\nimport " + Person.class.getCanonicalName() + "\nrule R1\nwhen\n  $p1 : Person()\n  $average  : Double(this > $p1.age, this > 3) from accumulate ( $p2: Person ( getName().startsWith(\"J\"), this != $p1);\n                average($p2.getAge())\n             )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        List personList = IntStream.range(0, 10).mapToObj(i -> new Person("John" + i, i)).collect(Collectors.toList());
        KieSession ksession = kbase.newKieSession();
        personList.stream().forEach(arg_0 -> ((KieSession)ksession).insert(arg_0));
        int fired = ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)5L, (long)fired);
    }

    @Test
    public void testEval() {
        String str = "import " + Address.class.getCanonicalName() + "\nimport " + Person.class.getCanonicalName() + "\nrule R1\ndialect \"mvel\"\nwhen\n  $p1 : Person()\n  eval($p1.age > 6)then\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        List personList = IntStream.range(0, 10).mapToObj(i -> new Person("John" + i, i)).collect(Collectors.toList());
        KieSession ksession = kbase.newKieSession();
        personList.stream().forEach(arg_0 -> ((KieSession)ksession).insert(arg_0));
        int fired = ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)3L, (long)fired);
    }
}

