/*
 * Decompiled with CFR 0.152.
 */
package org.drools.metric.util;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.time.Duration;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.core.common.BaseNode;
import org.kie.api.definition.rule.Rule;

public final class MicrometerUtils {
    public static final MicrometerUtils INSTANCE = new MicrometerUtils();
    private final Map<BaseNode, Timer> averageElapsedTimeCache = new WeakHashMap<BaseNode, Timer>(0);
    private final Map<BaseNode, Timer> elapsedTimeCache = new WeakHashMap<BaseNode, Timer>(0);
    private final Map<BaseNode, Counter> evaluationCountCache = new WeakHashMap<BaseNode, Counter>(0);

    private MicrometerUtils() {
    }

    public void triggerMicrometer(BaseNode node, long evalCount, long elapsedTimeInNanos) {
        CompositeMeterRegistry meterRegistry = Metrics.globalRegistry;
        MicrometerUtils.triggerMicrometer(this.averageElapsedTimeCache, arg_0 -> MicrometerUtils.lambda$triggerMicrometer$0((MeterRegistry)meterRegistry, arg_0), timer -> timer.record(Duration.ofNanos(elapsedTimeInNanos / evalCount)), node);
        MicrometerUtils.triggerMicrometer(this.elapsedTimeCache, arg_0 -> MicrometerUtils.lambda$triggerMicrometer$2((MeterRegistry)meterRegistry, arg_0), timer -> timer.record(Duration.ofNanos(elapsedTimeInNanos)), node);
        MicrometerUtils.triggerMicrometer(this.evaluationCountCache, arg_0 -> MicrometerUtils.lambda$triggerMicrometer$4((MeterRegistry)meterRegistry, arg_0), counter -> counter.increment((double)evalCount), node);
    }

    private static <Meter_ extends Meter> void triggerMicrometer(Map<BaseNode, Meter_> cache, Function<Iterable<Tag>, Meter_> meterConstructor, Consumer<Meter_> meterRecorder, BaseNode node) {
        Meter meter = cache.computeIfAbsent(node, k -> {
            Tag nodeIdTag = Tag.of((String)"node.id", (String)Long.toString(node.getId()));
            Stream<Tag> allTags = Stream.of(nodeIdTag);
            for (Rule rule : node.getAssociatedRules()) {
                String ruleName = rule.getPackageName() + "." + rule.getName();
                Tag ruleTag = Tag.of((String)"rule", (String)ruleName);
                allTags = Stream.concat(allTags, Stream.of(ruleTag));
            }
            Iterable tagsIterable = allTags.collect(Collectors.toSet());
            return (Meter)meterConstructor.apply(tagsIterable);
        });
        meterRecorder.accept(meter);
    }

    public void clear() {
        this.averageElapsedTimeCache.clear();
        this.elapsedTimeCache.clear();
        this.evaluationCountCache.clear();
    }

    private static /* synthetic */ Counter lambda$triggerMicrometer$4(MeterRegistry meterRegistry, Iterable tags) {
        return Counter.builder((String)"org.drools.metric.evaluation.count").tags(tags).register(meterRegistry);
    }

    private static /* synthetic */ Timer lambda$triggerMicrometer$2(MeterRegistry meterRegistry, Iterable tags) {
        return Timer.builder((String)"org.drools.metric.elapsed.time").tags(tags).register(meterRegistry);
    }

    private static /* synthetic */ Timer lambda$triggerMicrometer$0(MeterRegistry meterRegistry, Iterable tags) {
        return Timer.builder((String)"org.drools.metric.elapsed.time.per.evaluation").tags(tags).register(meterRegistry);
    }
}

