/*
 * Decompiled with CFR 0.152.
 */
package org.drools.metric;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.metric.AbstractMetricTest;
import org.drools.mvel.compiler.Person;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public class ConstraintsTest
extends AbstractMetricTest {
    @Test
    public void testDoubleBetaConstraints() {
        String str = "import " + Person.class.getCanonicalName() + "\nglobal java.util.List list;\nrule R when\n  Person( $age : age, $name : name )\n  Person( name == $name, age == $age + 1 )\nthen\n  list.add($age);\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("AAA", 31);
        Person p2 = new Person("AAA", 34);
        Person p3 = new Person("AAA", 33);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((int)((Integer)list.get(0))).isEqualTo(33);
    }

    @Test
    public void testTripleBetaConstraints() {
        String str = "import " + Person.class.getCanonicalName() + "\nglobal java.util.List list;\nrule R when\n  Person( $age : age, $name : name, $happy : happy )\n  Person( name == $name, age == $age + 1, happy == $happy )\nthen\n  list.add($age);\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("AAA", 31, true);
        Person p2 = new Person("AAA", 34, true);
        Person p3 = new Person("AAA", 33, true);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((int)((Integer)list.get(0))).isEqualTo(33);
    }

    @Test
    public void testQuadroupleBetaConstraints() {
        String str = "import " + Person.class.getCanonicalName() + "\nglobal java.util.List list;\nrule R when\n  Person( $age : age, $name : name, $happy : happy, $alive : alive )\n  Person( name == $name, age == $age + 1, happy == $happy, alive == $alive )\nthen\n  list.add($age);\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("AAA", 31, true);
        p1.setAlive(true);
        Person p2 = new Person("AAA", 34, true);
        p2.setAlive(true);
        Person p3 = new Person("AAA", 33, true);
        p3.setAlive(true);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((int)((Integer)list.get(0))).isEqualTo(33);
    }

    @Test
    public void testDefaultBetaConstraints() {
        String str = "import " + Person.class.getCanonicalName() + "\nglobal java.util.List list;\nrule R when\n  Person( $age : age, $name : name, $happy : happy, $alive : alive, $status : status )\n  Person( name == $name, age == $age + 1, happy == $happy, alive == $alive, status == $status )\nthen\n  list.add($age);\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("AAA", 31, true);
        p1.setAlive(true);
        p1.setStatus("OK");
        Person p2 = new Person("AAA", 34, true);
        p2.setAlive(true);
        p2.setStatus("OK");
        Person p3 = new Person("AAA", 33, true);
        p3.setAlive(true);
        p3.setStatus("OK");
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((int)((Integer)list.get(0))).isEqualTo(33);
    }
}

