/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.drools.mvel.MVEL;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ArithmeticTest {
    @Ignore(value="DROOLS-6572 - Generates wrong code for promotion")
    @Test
    public void testMath() {
        String expression = "pi * hour";
        int result = 188;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testMath2() {
        Assert.assertEquals((Object)3, (Object)MVEL.executeExpressionWithDefaultVariables("foo.number-1"));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath3() {
        String expression = "(10 * 5) * 2 / 3";
        double result = 33.333333333333336;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath4() {
        String expression = "(100 % 3) * 2 - 1 / 1 + 8 + (5 * 2)";
        double result = 19.0;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath4a() {
        String expression = "(100 % 90) * 20 - 15 / 16 + 80 + (50 * 21)";
        double result = 1329.0625;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testMath5() {
        String expression = "300.5 / 5.3 / 2.1 / 1.5";
        double result = 17.999401018268944;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testMath5a() {
        String expression = "300.5 / 5.3 / 2.1 / 1.5";
        double result = 17.999401018268944;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath6() {
        String expression = "(300 * five + 1) + (100 / 2 * 2)";
        double result = 1601.0;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath7() {
        String expression = "(100 % 3) * 2 - 1 / 1 + 8 + (5 * 2)";
        double result = 19.0;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testMath8() {
        String expression = "5 * (100.56 * 30.1)";
        double result = 15134.28;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse **")
    @Test
    public void testPowerOf() {
        Assert.assertEquals((Object)25, (Object)MVEL.executeExpressionWithDefaultVariables("5 ** 2"));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse")
    @Test
    public void testSignOperator() {
        String expr = "int x = 15; -x";
        HashMap<String, Object> vars = new HashMap<String, Object>();
        Assert.assertEquals((Object)-15, (Object)MVEL.executeExpression(expr, vars));
    }

    @Test
    public void testMath14() {
        String expression = "10-5*2 + 5*8-4";
        int result = 36;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testMath15() {
        String expression = "100-500*200 + 500*800-400";
        int result = 299700;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testMath16() {
        String expression = "100-500*200*150 + 500*800-400";
        int result = -14600300;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testMath17() {
        String expression = "(100d * 50d) * 20d / 30d * 2d";
        double result = 6666.666666666667;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse multiple assignements")
    @Test
    public void testMath18() {
        String expression = "a = 100d; b = 50d; c = 20d; d = 30d; e = 2d; (a * b) * c / d * e";
        double result = 6666.666666666667;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, Collections.emptyMap()));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse multiple assignments")
    @Test
    public void testMath19() {
        String expression = "a = 100; b = 500; c = 200; d = 150; e = 500; f = 800; g = 400; a-b*c*d + e*f-g";
        int result = -14600300;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, Collections.emptyMap()));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse")
    @Test
    public void testMath32() {
        String expression = "x = 20; y = 10; z = 5; x-y-z";
        int result = 5;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, Collections.emptyMap()));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse")
    @Test
    public void testMath33() {
        String expression = "x = 20; y = 2; z = 2; x/y/z";
        int result = 5;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, Collections.emptyMap()));
    }

    @Test
    public void testMath20() {
        String expression = "10-5*7-3*8-6";
        int result = -55;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testMath21() {
        String expression = "100-50*70-30*80-60";
        int expected = -5860;
        Assert.assertEquals((Object)expected, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse **")
    @Test
    public void testMath22() {
        String expression = "(100-50)*70-30*(20-9)**3";
        int result = (int)(3500.0 - 30.0 * Math.pow(11.0, 3.0));
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse **")
    @Test
    public void testMath22b() {
        String expression = "a = 100; b = 50; c = 70; d = 30; e = 20; f = 9; g = 3; (a-b)*c-d*(e-f)**g";
        int result = (int)(3500.0 - 30.0 * Math.pow(11.0, 3.0));
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, Collections.emptyMap()));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse **")
    @Test
    public void testMath23() {
        String expression = "10 ** (3)*10**3";
        int result = (int)(Math.pow(10.0, 3.0) * Math.pow(10.0, 3.0));
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath24() {
        String expression = "51 * 52 * 33 / 24 / 15 + 45 * 66 * 47 * 28 + 19";
        double result = 3908782.1;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Calculation error")
    @Test
    public void testMath25() {
        String expression = "51 * (40 - 1000 * 50) + 100 + 50 * 20 / 10 + 11 + 12 - 80";
        double result = -2547817.0;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse **")
    @Test
    public void testMath26() {
        String expression = "5 + 3 * 8 * 2 ** 2";
        int result = (int)(5.0 + 24.0 * Math.pow(2.0, 2.0));
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse **")
    @Test
    public void testMath27() {
        String expression = "50 + 30 * 80 * 20 ** 3 * 51";
        double result = 50.0 + 2400.0 * Math.pow(20.0, 3.0) * 51.0;
        Assert.assertEquals((Object)((int)result), (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse **")
    @Test
    public void testMath28() {
        String expression = "50 + 30 + 80 + 11 ** 2 ** 2 * 51";
        double result = 160.0 + Math.pow(Math.pow(11.0, 2.0), 2.0) * 51.0;
        Assert.assertEquals((Object)((int)result), (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath29() {
        String expression = "10 + 20 / 4 / 4";
        double result = 11.25;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath30() {
        String expression = "40 / 20 + 10 + 60 / 21";
        double result = 14.857142857142858;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse **")
    @Test
    public void testMath31() {
        String expression = "40 / 20 + 5 - 4 + 8 / 2 * 2 * 6 ** 2 + 6 - 8";
        double result = 3.0 + 8.0 * Math.pow(6.0, 2.0) + 6.0 - 8.0;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath34() {
        String expression = "a+b-c*d*x/y-z+10";
        double result = -165.0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("a", 200);
        map.put("b", 100);
        map.put("c", 150);
        map.put("d", 2);
        map.put("x", 400);
        map.put("y", 300);
        map.put("z", 75);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, map));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath34_Interpreted() {
        String expression = "a+b-c*x/y-z";
        double result = 25.0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("a", 200);
        map.put("b", 100);
        map.put("c", 150);
        map.put("x", 400);
        map.put("y", 300);
        map.put("z", 75);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, map));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath35() {
        String expression = "b/x/b/b*y+a";
        double result = 10.0625;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("a", 10);
        map.put("b", 20);
        map.put("c", 30);
        map.put("x", 40);
        map.put("y", 50);
        map.put("z", 60);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, map));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath35_Interpreted() {
        String expression = "b/x/b/b*y+a";
        double result = 10.0625;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("a", 10);
        map.put("b", 20);
        map.put("c", 30);
        map.put("x", 40);
        map.put("y", 50);
        map.put("z", 60);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, map));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath36() {
        String expression = "b/x*z/a+x-b+x-b/z+y";
        double result = 112.66666666666666;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("a", 10);
        map.put("b", 20);
        map.put("c", 30);
        map.put("x", 40);
        map.put("y", 50);
        map.put("z", 60);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, map));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath37() {
        String expression = "x+a*a*c/x*b*z+x/y-b";
        double result = 1799983.0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("a", 10);
        map.put("b", 20);
        map.put("c", 30);
        map.put("x", 2);
        map.put("y", 2);
        map.put("z", 60);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, map));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath38() {
        String expression = "100 + 200 - 300 + 400 - 500 + 105 / 205 - 405 + 305 * 206";
        double result = 62325.51219512195;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath39() {
        String expression = "147 + 60 / 167 % 448 + 36 * 23 / 166";
        double result = 152.34723324435467;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testMath40() {
        String expression = "228 - 338 % 375 - 103 + 260 + 412 * 177 + 121";
        double result = 73092.0;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testMath41() {
        String expression = "304d - 246d / 242d % 235d / 425d - 326d + 355d * 264d % 308d";
        double result = 65.99760816723386;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testMath42() {
        String expression = "11d - 7d / 3d * 18d % 14d * 8d * 11d - 2d - 11d / 13d + 14d";
        double result = 22.153846153846153;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testMath43() {
        String expression = "4d/3d*6d%8d*5d*8d+7d+9d*1d";
        double result = 16.0;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testMath44() {
        String expression = "6d+8d/9d*1d*9d*10d%4d*4d-4d*6d*3d";
        double result = -66.0;
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testMath44b() {
        String expression = "a+b/c*d*e*f%g*h-i*j*k";
        double result = -66.0;
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("a", 6.0);
        vars.put("b", 8.0);
        vars.put("c", 9.0);
        vars.put("d", 1.0);
        vars.put("e", 9.0);
        vars.put("f", 10.0);
        vars.put("g", 4.0);
        vars.put("h", 4.0);
        vars.put("i", 4.0);
        vars.put("j", 6.0);
        vars.put("k", 3.0);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, vars));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse")
    @Test
    public void testOperatorPrecedence() {
        String expression = "_x_001 = 500.2; _x_002 = 200.8; _r_001 = 701; _r_001 == _x_001 + _x_002 || _x_001 == 500 + 0.1";
        Assert.assertEquals((Object)true, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse")
    @Test
    public void testOperatorPrecedence2() {
        String expression = "_x_001 = 500.2; _x_002 = 200.8; _r_001 = 701; _r_001 == _x_001 + _x_002 && _x_001 == 500 + 0.2";
        Assert.assertEquals((Object)true, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse")
    @Test
    public void testOperatorPrecedence3() {
        String expression = "_x_001 = 500.2; _x_002 = 200.9; _r_001 = 701; _r_001 == _x_001 + _x_002 && _x_001 == 500 + 0.2";
        Assert.assertEquals((Object)false, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse")
    @Test
    public void testOperatorPrecedence4() {
        String expression = "_x_001 = 500.2; _x_002 = 200.9; _r_001 = 701; _r_001 == _x_001 + _x_002 || _x_001 == 500 + 0.2";
        Assert.assertEquals((Object)true, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testOperatorPrecedence5() {
        String expression = "_x_001 == _x_001 / 2 - _x_001 + _x_001 + _x_001 / 2 && _x_002 / 2 == _x_002 / 2";
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("_x_001", 500.2);
        vars.put("_x_002", 200.9);
        vars.put("_r_001", 701);
        Assert.assertEquals((Object)true, (Object)MVEL.executeExpression(expression, vars));
    }

    @Test
    public void testModulus() {
        Assert.assertEquals((Object)0, (Object)MVEL.executeExpressionWithDefaultVariables("38392 % 2"));
    }

    @Test
    public void testBitwiseOr1() {
        Assert.assertEquals((Object)6, (Object)MVEL.executeExpressionWithDefaultVariables("2|4"));
    }

    @Ignore(value="DROOLS-6572 - Considers second element a boolean")
    @Test
    public void testBitwiseOr2() {
        Assert.assertEquals((Object)true, (Object)MVEL.executeExpressionWithDefaultVariables("(2 | 1) > 0"));
    }

    @Ignore(value="DROOLS-6572 - Considers second element a boolean")
    @Test
    public void testBitwiseOr3() {
        Assert.assertEquals((Object)true, (Object)MVEL.executeExpressionWithDefaultVariables("(2|1) == 3"));
    }

    @Test
    public void testBitwiseOr4() {
        Assert.assertEquals((Object)7, (Object)MVEL.executeExpressionWithDefaultVariables("2|five"));
    }

    @Test
    public void testBitwiseAnd1() {
        Assert.assertEquals((Object)2, (Object)MVEL.executeExpressionWithDefaultVariables("2 & 3"));
    }

    @Test
    public void testBitwiseAnd2() {
        Assert.assertEquals((Object)1, (Object)MVEL.executeExpressionWithDefaultVariables("five & 3"));
    }

    @Test
    public void testShiftLeft() {
        Assert.assertEquals((Object)4, (Object)MVEL.executeExpressionWithDefaultVariables("2 << 1"));
    }

    @Test
    public void testShiftLeft2() {
        Assert.assertEquals((Object)10, (Object)MVEL.executeExpressionWithDefaultVariables("five << 1"));
    }

    @Ignore(value="DROOLS-6572 - Generates wrong code - unable to parse <<<")
    @Test
    public void testUnsignedShiftLeft() {
        Assert.assertEquals((Object)2, (Object)MVEL.executeExpressionWithDefaultVariables("-2 <<< 0"));
    }

    @Test
    public void testShiftRight() {
        Assert.assertEquals((Object)128, (Object)MVEL.executeExpressionWithDefaultVariables("256 >> 1"));
    }

    @Test
    public void testShiftRight2() {
        Assert.assertEquals((Object)2, (Object)MVEL.executeExpressionWithDefaultVariables("five >> 1"));
    }

    @Test
    public void testUnsignedShiftRight() {
        Assert.assertEquals((Object)0x7FFFFFFD, (Object)MVEL.executeExpressionWithDefaultVariables("-5 >>> 1"));
    }

    @Test
    public void testUnsignedShiftRight2() {
        Assert.assertEquals((Object)0x7FFFFFFD, (Object)MVEL.executeExpressionWithDefaultVariables("(five - 10) >>> 1"));
    }

    @Test
    public void testShiftRightAssign() {
        Assert.assertEquals((Object)1, (Object)MVEL.executeExpressionWithDefaultVariables("_zZz = 5; _zZz >>= 2"));
    }

    @Test
    public void testShiftLeftAssign() {
        Assert.assertEquals((Object)40, (Object)MVEL.executeExpressionWithDefaultVariables("_yYy = 10; _yYy <<= 2"));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse")
    @Test
    public void testUnsignedShiftRightAssign() {
        String expression = "_xXx = -5; _xXx >>>= 2";
        Assert.assertEquals((Object)0x3FFFFFFE, (Object)MVEL.executeExpression(expression, Collections.emptyMap()));
    }

    @Test
    public void testXOR() {
        Assert.assertEquals((Object)3, (Object)MVEL.executeExpressionWithDefaultVariables("1 ^ 2"));
    }

    @Test
    public void testXOR2() {
        Assert.assertEquals((Object)7, (Object)MVEL.executeExpressionWithDefaultVariables("five ^ 2"));
    }

    @Test
    public void testInvert() {
        Assert.assertEquals((Object)-11, (Object)MVEL.executeExpressionWithDefaultVariables("~10"));
    }

    @Test
    public void testInvert2() {
        Assert.assertEquals((Object)-12, (Object)MVEL.executeExpressionWithDefaultVariables("~(10 + 1)"));
    }

    @Test
    public void testInvert3() {
        Assert.assertEquals((Object)-61, (Object)MVEL.executeExpressionWithDefaultVariables("~10 + (1 + ~50)"));
    }

    @Test
    public void testDeepPropertyAdd() {
        Assert.assertEquals((Object)10, (Object)MVEL.executeExpressionWithDefaultVariables("foo.countTest+ 10"));
    }

    @Ignore(value="DROOLS-6572 - Generates wrong code")
    @Test
    public void testDeepAssignmentIncrement() {
        String expression = "foo.countTest += 5; if (foo.countTest == 5) { foo.countTest = 0; return true; } else { foo.countTest = 0; return false; }";
        Assert.assertEquals((Object)true, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
        Assert.assertEquals((Object)true, (Object)MVEL.executeExpressionWithDefaultVariables("foo.countTest += 5; if (foo.countTest == 5) { foo.countTest = 0; return true; } else { foo.countTest = 0; return false; }"));
    }

    @Ignore(value="DROOLS-6572 - Generates wrong code - check for statements")
    @Test
    public void testDeepAssignmentWithBlock() {
        String expression = "with (foo) { countTest += 5 }; if (foo.countTest == 5) { foo.countTest = 0; return true; } else { foo.countTest = 0; return false; }";
        Assert.assertEquals((Object)true, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
        Assert.assertEquals((Object)true, (Object)MVEL.executeExpressionWithDefaultVariables("with (foo) { countTest += 5 }; if (foo.countTest == 5) { foo.countTest = 0; return true; } else { foo.countTest = 0; return false; }"));
    }

    @Test
    public void testOperativeAssignMod() {
        int val = 5;
        Assert.assertEquals((Object)(val %= 2), (Object)MVEL.executeExpressionWithDefaultVariables("int val = 5; val %= 2; val"));
    }

    @Test
    public void testOperativeAssignDiv() {
        int val = 10;
        Assert.assertEquals((Object)(val /= 2), (Object)MVEL.executeExpressionWithDefaultVariables("int val = 10; val /= 2; val"));
    }

    @Test
    public void testOperativeAssignShift1() {
        int val = 5;
        Assert.assertEquals((Object)(val <<= 2), (Object)MVEL.executeExpressionWithDefaultVariables("int val = 5; val <<= 2; val"));
    }

    @Test
    public void testOperativeAssignShift2() {
        int val = 5;
        Assert.assertEquals((Object)(val >>= 2), (Object)MVEL.executeExpressionWithDefaultVariables("int val = 5; val >>= 2; val"));
    }

    @Test
    public void testOperativeAssignShift3() {
        int val = -5;
        Assert.assertEquals((Object)(val >>>= 2), (Object)MVEL.executeExpressionWithDefaultVariables("int val = -5; val >>>= 2; val"));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse")
    @Test
    public void testAssignPlus() {
        Assert.assertEquals((Object)10, (Object)MVEL.executeExpressionWithDefaultVariables("xx0 = 5; xx0 += 4; xx0 + 1"));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse")
    @Test
    public void testAssignPlus2() {
        Assert.assertEquals((Object)10, (Object)MVEL.executeExpressionWithDefaultVariables("xx0 = 5; xx0 =+ 4; xx0 + 1"));
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testAssignDiv() {
        Assert.assertEquals((Object)2.0, (Object)MVEL.executeExpressionWithDefaultVariables("xx0 = 20; xx0 /= 10; xx0"));
    }

    public void testAssignMult() {
        Assert.assertEquals((Object)36, (Object)MVEL.executeExpressionWithDefaultVariables("xx0 = 6; xx0 *= 6; xx0"));
    }

    @Test
    public void testAssignSub() {
        Assert.assertEquals((Object)11, (Object)MVEL.executeExpressionWithDefaultVariables("xx0 = 15; xx0 -= 4; xx0"));
    }

    @Ignore(value="DROOLS-6572 - Calculation error")
    @Test
    public void testAssignSub2() {
        Assert.assertEquals((Object)-95, (Object)MVEL.executeExpressionWithDefaultVariables("xx0 = 5; xx0 =- 100"));
    }

    @Test
    public void testBooleanStrAppend() {
        Assert.assertEquals((Object)"footrue", (Object)MVEL.executeExpressionWithDefaultVariables("\"foo\" + true"));
    }

    @Ignore(value="DROOLS-6572 - Unable to parse")
    @Test
    public void testStringAppend() {
        String expression = "c + 'bar'";
        Assert.assertEquals((Object)"catbar", (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testNegation() {
        Assert.assertEquals((Object)1, (Object)MVEL.executeExpressionWithDefaultVariables("-(-1)"));
    }

    @Test
    public void testStrongTypingModeComparison() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("a", 0L);
        MVEL.executeExpression("a==0", variables);
    }

    @Ignore(value="DROOLS-6572 - Rounding error")
    @Test
    public void testJIRA158() {
        String expression = "(float) (4/2 + Math.sin(1))";
        Assert.assertEquals((Object)Float.valueOf((float)(2.0 + Math.sin(1.0))), (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testJIRA162() {
        String expression = "1d - 2d + (3d * var1) * var1";
        double result = 2.0;
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("var1", 1.0);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, vars));
    }

    @Test
    public void testJIRA161() {
        String expression = "1==-(-1)";
        Assert.assertEquals((Object)true, (Object)MVEL.executeExpressionWithDefaultVariables(expression));
    }

    @Test
    public void testJIRA163() {
        String expression = "1d - 2d + (3d * 4d) * var1";
        double result = 11.0;
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("var1", 1.0);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, vars));
    }

    @Ignore(value="DROOLS-6572 - Wrong value calculated")
    @Test
    public void testJIRA164() {
        String expression = "1 / (var1 + var1) * var1";
        double var1 = 1.0;
        double result = 1.0 / (var1 + var1) * var1;
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("var1", var1);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, vars));
    }

    @Ignore(value="DROOLS-6572 - Wrong value calculated")
    @Test
    public void testJIRA164b() {
        String expression = "1 + 1 / (var1 + var1) * var1";
        double var1 = 1.0;
        double result = 1.0 + 1.0 / (var1 + var1) * var1;
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("var1", var1);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, vars));
    }

    @Ignore(value="DROOLS-6572 - Wrong value calculated")
    @Test
    public void testJIRA164c() {
        double var1 = 1.0;
        String expression = "1 + 1 / (var1 + var1 + 2 + 3) * var1";
        double result = 1.0 + 1.0 / (var1 + var1 + 2.0 + 3.0) * var1;
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("var1", var1);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, vars));
    }

    @Ignore(value="DROOLS-6572 - Wrong value calculated")
    @Test
    public void testJIRA164d() {
        double var1 = 1.0;
        String expression = "1 + 1 + 1 / (var1 + var1) * var1";
        double result = 2.0 + 1.0 / (var1 + var1) * var1;
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("var1", var1);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, vars));
    }

    @Ignore(value="DROOLS-6572 - Wrong value calculated")
    @Test
    public void testJIRA164e() {
        String expression = "10 + 11 + 12 / (var1 + var1 + 51 + 71) * var1 + 13 + 14";
        HashMap<String, Object> vars = new HashMap<String, Object>();
        double var1 = 1.0;
        vars.put("var1", var1);
        Assert.assertEquals((double)((float)(21.0 + 12.0 / (var1 + var1 + 51.0 + 71.0) * var1 + 13.0 + 14.0)), (double)((Double)MVEL.executeExpression(expression, vars)).floatValue(), (double)0.01);
    }

    @Ignore(value="DROOLS-6572 - Wrong value calculated")
    @Test
    public void testJIRA164f() {
        String expression = "10 + 11 + 12 / (var1 + 1 + var1 + 51 + 71) * var1 + 13 + 14";
        double var1 = 1.0;
        float result = (float)(21.0 + 12.0 / (var1 + 1.0 + var1 + 51.0 + 71.0) * var1 + 13.0 + 14.0);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("var1", var1);
        Assert.assertEquals((double)result, (double)((Double)MVEL.executeExpression(expression, vars)).floatValue(), (double)0.01);
    }

    @Test
    public void testJIRA164g() {
        String expression = "1 - 2 + (3 * var1) * var1";
        double var1 = 1.0;
        float result = (float)(-1.0 + 3.0 * var1 * var1);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("var1", var1);
        Assert.assertEquals((double)result, (double)((Double)MVEL.executeExpression(expression, vars)).floatValue(), (double)0.01);
    }

    @Test
    public void testJIRA164h() {
        String expression = "1 - var1 * (var1 * var1 * (var1 * var1) * var1) * var1";
        HashMap<String, Object> vars = new HashMap<String, Object>();
        double var1 = 2.0;
        vars.put("var1", var1);
        Assert.assertEquals((double)((float)(1.0 - var1 * (var1 * var1 * (var1 * var1) * var1) * var1)), (double)((Double)MVEL.executeExpression(expression, vars)).floatValue(), (double)0.01);
    }

    @Test
    public void testJIRA180() {
        MVEL.executeExpressionWithDefaultVariables("-Math.sin(0)");
    }

    @Test
    public void testJIRA208() {
        String[] testCases;
        LinkedHashMap<String, Object> vars = new LinkedHashMap<String, Object>();
        vars.put("bal", 999);
        for (String expr : testCases = new String[]{"bal - 80 - 90 - 30", "bal-80-90-30", "100 + 80 == 180", "100+80==180"}) {
            Serializable val1 = MVEL.executeExpression(expr, vars);
            Assert.assertNotNull((Object)val1);
            Serializable val2 = MVEL.executeExpression(expr, vars);
            Assert.assertNotNull((Object)val2);
            Assert.assertEquals((String)("expression did not evaluate correctly: " + expr), (Object)val1, (Object)val2);
        }
    }

    @Test
    public void testJIRA1208a() {
        HashMap<String, Object> bal = new HashMap<String, Object>();
        bal.put("bal", 999);
        Assert.assertEquals((Object)799, (Object)MVEL.executeExpression("bal - 80 - 90 - 30", bal));
    }

    @Test
    public void testJIRA208b() {
        String[] testCases;
        LinkedHashMap<String, Object> vars = new LinkedHashMap<String, Object>();
        vars.put("bal", 999);
        for (String expr : testCases = new String[]{"bal + 80 - 80", "bal - 80 + 80", "bal * 80 / 80", "bal / 80 * 80"}) {
            Serializable val1 = MVEL.executeExpression(expr, vars);
            Assert.assertNotNull((Object)val1);
            Serializable val2 = MVEL.executeExpression(expr, vars);
            Assert.assertNotNull((Object)val2);
            Assert.assertEquals((String)("expression did not evaluate correctly: " + expr), (Object)val1, (Object)val2);
        }
    }

    @Test
    public void testJIRA210() {
        String[] testCases;
        LinkedHashMap<String, Object> vars = new LinkedHashMap<String, Object>();
        vars.put("bal", new BigDecimal("999.99"));
        for (String expr : testCases = new String[]{"bal - 1 + \"abc\""}) {
            Serializable val1 = MVEL.executeExpression(expr, vars);
            Assert.assertNotNull((Object)val1);
            Serializable val2 = MVEL.executeExpression(expr, vars);
            Assert.assertNotNull((Object)val2);
            Assert.assertEquals((String)("expression did not evaluate correctly: " + expr), (Object)val1, (Object)val2);
        }
    }

    @Ignore(value="DROOLS-6572 - Generates wrong code - missing symbol")
    @Test
    public void testMathDec30() {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("value", 10);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("param", params);
        vars.put("param2", 10);
        Assert.assertEquals((Object)21, (Object)MVEL.executeExpression("1 + 2 * param.value", vars));
    }

    @Test
    public void testJIRA99_Interpreted() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", 20);
        map.put("y", 10);
        map.put("z", 5);
        Assert.assertEquals((Object)5, (Object)MVEL.executeExpression("x - y - z", map));
    }

    @Test
    public void testJIRA99_Compiled() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", 20);
        map.put("y", 10);
        map.put("z", 5);
        Assert.assertEquals((Object)5, (Object)MVEL.executeExpression("x - y - z", map));
    }

    @Ignore(value="DROOLS-6572 - Too many iterations - why")
    @Test
    public void testModExpr() {
        String str = "$y % 4 == 0 && $y % 100 != 0 || $y % 400 == 0 ";
        HashMap<String, Object> vars = new HashMap<String, Object>();
        for (int i = 0; i < 500; ++i) {
            int y = i;
            boolean expected = y % 4 == 0 && y % 100 != 0 || y % 400 == 0;
            vars.put("$y", y);
            Assert.assertEquals((Object)expected, (Object)MVEL.executeExpression(str, vars));
        }
    }

    @Test
    public void testIntsWithDivision() {
        String expression = "0 == x - (y/2)";
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("x", 50);
        vars.put("y", 100);
        Boolean result = (Boolean)MVEL.executeExpression(expression, vars);
        Assert.assertTrue((boolean)result);
    }

    @Ignore(value="DROOLS-6572 - Wrong result")
    @Test
    public void testMathCeil() {
        String expression = "Math.ceil( x/3 ) == 2";
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("x", 4);
        Boolean result = (Boolean)MVEL.executeExpression(expression, vars);
        Assert.assertTrue((boolean)result);
    }

    @Ignore(value="DROOLS-6572 - Generates wrong code")
    @Test
    public void testStaticMathCeil() {
        int x = 4;
        int m = (int)Math.ceil(x / 3);
        String expression = "int m = (int) java.lang.Math.ceil( x/3 ); return m;";
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("x", 4);
        Assert.assertEquals((Object)2, (Object)MVEL.executeExpression(expression, vars));
    }

    @Ignore(value="DROOLS-6572 - Calculates wrong result")
    @Test
    public void testStaticMathCeilWithJavaClassStyleLiterals() {
        String expression = "java.lang.Math.ceil( x/3 )";
        double result = Math.ceil(1.3333333333333333);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("x", 4);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, vars));
    }

    @Test
    public void testMathCeilWithDoubleCast() {
        String expression = "Math.ceil( (double) x / 3 )";
        double result = Math.ceil(1.3333333333333333);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("x", 4);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, vars));
    }

    @Test
    public void testBigDecimalAssignmentIncrement() {
        String expression = "s1=0B;s1+=1;s1+=1;s1";
        BigDecimal result = new BigDecimal(2);
        Assert.assertEquals((Object)result, (Object)MVEL.executeExpression(expression, new HashMap<String, Object>()));
    }

    @Test
    public void testIssue249() {
        String expression = "70 + 30 *  x1";
        HashMap<String, Object> expressionVars = new HashMap<String, Object>();
        expressionVars.put("x1", 128.33);
        Assert.assertEquals((double)3919.9, (double)((Number)MVEL.executeExpression(expression, expressionVars)).doubleValue(), (double)0.01);
    }
}

