/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import org.drools.Gender;
import org.drools.Person;
import org.drools.core.addon.ClassTypeResolver;
import org.drools.core.addon.TypeResolver;
import org.drools.mvelcompiler.CompiledBlockResult;
import org.drools.mvelcompiler.MvelCompiler;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

interface CompilerTest {
    default public void test(Consumer<MvelCompilerContext> testFunction, String inputExpression, String expectedResult, Consumer<CompiledBlockResult> resultAssert) {
        HashSet<String> imports = new HashSet<String>();
        imports.add("java.util.List");
        imports.add("java.util.ArrayList");
        imports.add("java.util.HashMap");
        imports.add("java.util.Map");
        imports.add("java.math.BigDecimal");
        imports.add("org.drools.Address");
        imports.add(Person.class.getCanonicalName());
        imports.add(Gender.class.getCanonicalName());
        ClassTypeResolver typeResolver = new ClassTypeResolver(imports, this.getClass().getClassLoader());
        MvelCompilerContext mvelCompilerContext = new MvelCompilerContext((TypeResolver)typeResolver);
        testFunction.accept(mvelCompilerContext);
        CompiledBlockResult compiled = new MvelCompiler(mvelCompilerContext).compileStatement(inputExpression);
        this.verifyBodyWithBetterDiff(expectedResult, compiled.resultAsString());
        resultAssert.accept(compiled);
    }

    default public void verifyBodyWithBetterDiff(Object expected, Object actual) {
        try {
            MatcherAssert.assertThat((Object)actual.toString(), (Matcher)Matchers.equalToIgnoringWhiteSpace((String)expected.toString()));
        }
        catch (AssertionError e) {
            MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.equalTo((Object)expected));
        }
    }

    default public void test(String inputExpression, String expectedResult, Consumer<CompiledBlockResult> resultAssert) {
        this.test(id -> {}, inputExpression, expectedResult, resultAssert);
    }

    default public void test(Consumer<MvelCompilerContext> testFunction, String inputExpression, String expectedResult) {
        this.test(testFunction, inputExpression, expectedResult, t -> {});
    }

    default public void test(String inputExpression, String expectedResult) {
        this.test(d -> {}, inputExpression, expectedResult, t -> {});
    }

    default public Collection<String> allUsedBindings(CompiledBlockResult result) {
        return new ArrayList<String>(result.getUsedBindings());
    }
}

