/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.drools.Person;
import org.drools.mvelcompiler.CompiledBlockResult;
import org.drools.mvelcompiler.CompilerTest;
import org.drools.mvelcompiler.ModifyCompiler;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.junit.Test;

public class ModifyCompilerTest
implements CompilerTest {
    @Test
    public void testUncompiledMethod() {
        this.test("{modify( (List)$toEdit.get(0) ){ setEnabled( true ) }}", "{ { ((List) $toEdit.get(0)).setEnabled(true); } }", (CompiledBlockResult result) -> Assertions.assertThat(this.allUsedBindings((CompiledBlockResult)result)).isEmpty());
    }

    @Test
    public void testModify() {
        this.test(ctx -> ctx.addDeclaration("$p", Person.class), "{  modify($p) { setCanDrink(true); } }", "{ { ($p).setCanDrink(true); } update($p); }", result -> Assertions.assertThat(this.allUsedBindings((CompiledBlockResult)result)).containsExactlyInAnyOrder((Object[])new String[]{"$p"}));
    }

    @Test
    public void testModifyWithLambda() {
        this.test(ctx -> ctx.addDeclaration("$p", Person.class), "{  modify($p) {  setCanDrinkLambda(() -> true); } }", "{ { ($p).setCanDrinkLambda(() -> true); } update($p); }", result -> Assertions.assertThat(this.allUsedBindings((CompiledBlockResult)result)).containsExactlyInAnyOrder((Object[])new String[]{"$p"}));
    }

    @Test
    public void testNestedModify() {
        this.test("{    if ($fact.getResult() != null) {\n        $fact.setResult(\"OK\");\n    } else {\n        modify ($fact) {\n            setResult(\"FIRST\")\n        }\n    }}", " { if ($fact.getResult() != null) {   $fact.setResult(\"OK\"); } else { {   ($fact).setResult(\"FIRST\");    }   update($fact); } } ", (CompiledBlockResult result) -> Assertions.assertThat(this.allUsedBindings((CompiledBlockResult)result)).containsExactlyInAnyOrder((Object[])new String[]{"$fact"}));
    }

    @Override
    public void test(Consumer<MvelCompilerContext> testFunction, String inputExpression, String expectedResult, Consumer<CompiledBlockResult> resultAssert) {
        CompiledBlockResult compiled = new ModifyCompiler().compile(inputExpression);
        Assertions.assertThat((String)compiled.resultAsString()).isEqualToIgnoringWhitespace((CharSequence)expectedResult);
        resultAssert.accept(compiled);
    }
}

