/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.drools.Person;
import org.drools.mvelcompiler.CompiledBlockResult;
import org.drools.mvelcompiler.CompilerTest;
import org.drools.mvelcompiler.PreprocessCompiler;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.junit.Test;

public class PreprocessCompilerTest
implements CompilerTest {
    @Test
    public void testUncompiledMethod() {
        this.test("{modify( (List)$toEdit.get(0) ){ setEnabled( true ) }}", "{ { ((List) $toEdit.get(0)).setEnabled(true); } }", (CompiledBlockResult result) -> Assertions.assertThat(this.allUsedBindings((CompiledBlockResult)result)).isEmpty());
    }

    @Test
    public void testModify() {
        this.test(ctx -> ctx.addDeclaration("$p", Person.class), "{  modify($p) { setCanDrink(true); } }", "{ { ($p).setCanDrink(true); } update($p); }", result -> Assertions.assertThat(this.allUsedBindings((CompiledBlockResult)result)).containsExactlyInAnyOrder((Object[])new String[]{"$p"}));
    }

    @Test
    public void testModifyWithLambda() {
        this.test(ctx -> ctx.addDeclaration("$p", Person.class), "{  modify($p) {  setCanDrinkLambda(() -> true); } }", "{ { ($p).setCanDrinkLambda(() -> true); } update($p); }", result -> Assertions.assertThat(this.allUsedBindings((CompiledBlockResult)result)).containsExactlyInAnyOrder((Object[])new String[]{"$p"}));
    }

    @Test
    public void testNestedModify() {
        this.test("{    if ($fact.getResult() != null) {\n        $fact.setResult(\"OK\");\n    } else {\n        modify ($fact) {\n            setResult(\"FIRST\")\n        }\n    }}", " { if ($fact.getResult() != null) {   $fact.setResult(\"OK\"); } else { {   ($fact).setResult(\"FIRST\");    }   update($fact); } } ", (CompiledBlockResult result) -> Assertions.assertThat(this.allUsedBindings((CompiledBlockResult)result)).containsExactlyInAnyOrder((Object[])new String[]{"$fact"}));
    }

    @Test
    public void testMultiLineStringLiteral() {
        this.test(" { java.lang.String s = \"\"\"\n                      Pikachu\n                      Is\n                      Yellow\n                      \"\"\"; }", " { java.lang.String s = \"Pikachu\\nIs\\nYellow\\n\"; }");
    }

    @Test
    public void testMultiLineStringLiteralAsMethodCallExpr() {
        this.test(" { java.lang.String s = \"\"\"\n                      Charmander\n                      Is\n                      Red\n                      \"\"\".formatted(2);         }", " { java.lang.String s = \"Charmander\\nIs\\nRed\\n\".formatted(2); }");
    }

    @Test
    public void testMultiLineStringWithStringCharacterInside() {
        this.test(" { java.lang.String s = \"\"\"\n                      Bulbasaur\n                      Is\n                      \"Green\"\n                      \"\"\";\n}", " { java.lang.String s = \"Bulbasaur\\nIs\\n\\\"Green\\\"\\n\"; }");
    }

    @Override
    public void test(Consumer<MvelCompilerContext> testFunction, String inputExpression, String expectedResult, Consumer<CompiledBlockResult> resultAssert) {
        CompiledBlockResult compiled = new PreprocessCompiler().compile(inputExpression);
        Assertions.assertThat((String)compiled.resultAsString()).isEqualToIgnoringWhitespace((CharSequence)expectedResult);
        resultAssert.accept(compiled);
    }
}

