/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.parser;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.drools.mvel.parser.DrlxParser;
import org.drools.mvel.parser.MvelParser;
import org.drools.mvel.parser.ParseStart;
import org.drools.mvel.parser.ast.expr.DrlNameExpr;
import org.drools.mvel.parser.ast.expr.DrlxExpression;
import org.drools.mvel.parser.ast.expr.HalfBinaryExpr;
import org.drools.mvel.parser.ast.expr.HalfPointFreeExpr;
import org.drools.mvel.parser.ast.expr.OOPathChunk;
import org.drools.mvel.parser.ast.expr.OOPathExpr;
import org.drools.mvel.parser.ast.expr.PointFreeExpr;
import org.drools.mvel.parser.ast.expr.TemporalLiteralChunkExpr;
import org.drools.mvel.parser.ast.expr.TemporalLiteralExpr;
import org.drools.mvel.parser.printer.PrintUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DroolsMvelParserTest {
    private static final Collection<String> operators = new HashSet<String>();
    final ParseStart<DrlxExpression> parser;

    public DroolsMvelParserTest() {
        operators.addAll(Arrays.asList("after", "before", "in", "matches", "includes"));
        this.parser = DrlxParser.buildDrlxParserWithArguments(operators);
    }

    @Test
    public void testParseSimpleExpr() {
        String expr = "name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)binaryExpr.getLeft()));
        Assert.assertEquals((Object)"\"Mark\"", (Object)this.toString((Node)binaryExpr.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)binaryExpr.getOperator());
    }

    @Test
    public void testBinaryWithNewLine() {
        Expression or = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 ||\n                   addresses == 3  )").getExpr();
        Assert.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printConstraint((Node)or));
        Expression and = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 &&\naddresses == 3  )").getExpr();
        Assert.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printConstraint((Node)and));
    }

    @Test(expected=ParseProblemException.class)
    public void testBinaryWithNewLineBeginning() {
        Expression or = DrlxParser.parseExpression(this.parser, (String)"(\naddresses == 2 || addresses == 3  )").getExpr();
        Assert.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printConstraint((Node)or));
        Expression and = DrlxParser.parseExpression(this.parser, (String)"(\naddresses == 2 && addresses == 3  )").getExpr();
        Assert.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printConstraint((Node)and));
    }

    @Test(expected=ParseProblemException.class)
    public void testBinaryWithNewLineEnd() {
        Expression or = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 || addresses == 3 \n)").getExpr();
        Assert.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printConstraint((Node)or));
        Expression and = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 && addresses == 3  \n)").getExpr();
        Assert.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printConstraint((Node)and));
    }

    @Test
    @Ignore
    public void testBinaryWithNewLineBeforeOperator() {
        Expression and2 = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2\n&& addresses == 3  )").getExpr();
        Assert.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printConstraint((Node)and2));
        Expression or2 = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2\n|| addresses == 3  )").getExpr();
        Assert.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printConstraint((Node)or2));
    }

    @Test
    public void testParseSafeCastExpr() {
        String expr = "this instanceof Person && ((Person) this).name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testParseInlineCastExpr() {
        String expr = "this#Person.name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testParseNullSafeFieldAccessExpr() {
        String expr = "person!.name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExpr() {
        String expr = "this after $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeEnclosed() {
        String expr = "(this after $a)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeEnclosedWithNameExpr() {
        String expr = "(something after $a)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testLiteral() {
        String bigDecimalLiteral = "bigInteger < (50B)";
        Expression bigDecimalExpr = DrlxParser.parseExpression(this.parser, (String)bigDecimalLiteral).getExpr();
        Assert.assertEquals((Object)bigDecimalLiteral, (Object)PrintUtil.printConstraint((Node)bigDecimalExpr));
        String bigIntegerLiteral = "bigInteger == (50I)";
        Expression bigIntegerExpr = DrlxParser.parseExpression(this.parser, (String)bigIntegerLiteral).getExpr();
        Assert.assertEquals((Object)bigIntegerLiteral, (Object)PrintUtil.printConstraint((Node)bigIntegerExpr));
    }

    @Test
    public void testBigDecimalLiteral() {
        String bigDecimalLiteralWithDecimals = "12.111B";
        Expression bigDecimalExprWithDecimals = DrlxParser.parseExpression(this.parser, (String)bigDecimalLiteralWithDecimals).getExpr();
        Assert.assertEquals((Object)bigDecimalLiteralWithDecimals, (Object)PrintUtil.printConstraint((Node)bigDecimalExprWithDecimals));
    }

    @Test
    public void testDotFreeExprWithOr() {
        String expr = "this after $a || this after $b";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof BinaryExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExprWithArgs() {
        String expr = "this after[5,8] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertFalse((boolean)((PointFreeExpr)expression).isNegated());
        Assert.assertEquals((Object)"this after[5ms,8ms] $a", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExprWithArgsInfinite() {
        String expr = "this after[5s,*] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertFalse((boolean)((PointFreeExpr)expression).isNegated());
        Assert.assertEquals((Object)"this after[5s,*] $a", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExprWithThreeArgsInfinite() {
        String expr = "this after[*,*,*,2s] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertFalse((boolean)((PointFreeExpr)expression).isNegated());
        Assert.assertEquals((Object)"this after[*,*,*,2s] $a", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExprWithArgsNegated() {
        String expr = "this not after[5,8] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(PointFreeExpr.class));
        Assert.assertTrue((boolean)((PointFreeExpr)expression).isNegated());
        Assert.assertEquals((Object)"this not after[5ms,8ms] $a", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExprWithTemporalArgs() {
        String expr = "this after[5ms,8d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExprWithFourTemporalArgs() {
        String expr = "this includes[1s,1m,1h,1d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testHalfDotFreeExprWithFourTemporalArgs() {
        String expr = "includes[1s,1m,1h,1d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(HalfPointFreeExpr.class));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test(expected=ParseProblemException.class)
    public void testInvalidTemporalArgs() {
        String expr = "this after[5ms,8f] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
    }

    @Test
    public void testOOPathExpr() {
        String expr = "/wife/children[age > 10]/toys";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression expression = drlx.getExpr();
        Assert.assertTrue((boolean)(expression instanceof OOPathExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
    }

    @Test
    public void testOOPathExprWithMultipleCondition() {
        String expr = "$address : /address[street == \"Elm\",city == \"Big City\"]";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression expression = drlx.getExpr();
        Assert.assertTrue((boolean)(expression instanceof OOPathExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
    }

    @Test
    public void testOOPathExprWithDeclaration() {
        String expr = "$toy : /wife/children[age > 10]/toys";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assert.assertEquals((Object)"$toy", (Object)drlx.getBind().asString());
        Expression expression = drlx.getExpr();
        Assert.assertTrue((boolean)(expression instanceof OOPathExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
    }

    @Test
    public void testOOPathExprWithBackReference() {
        String expr = "$toy : /wife/children/toys[name.length == ../../name.length]";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assert.assertEquals((Object)"$toy", (Object)drlx.getBind().asString());
        Expression expression = drlx.getExpr();
        Assert.assertTrue((boolean)(expression instanceof OOPathExpr));
        OOPathChunk secondChunk = (OOPathChunk)((OOPathExpr)expression).getChunks().get(2);
        BinaryExpr secondChunkFirstCondition = (BinaryExpr)secondChunk.getConditions().get(0);
        DrlNameExpr rightName = (DrlNameExpr)((FieldAccessExpr)secondChunkFirstCondition.getRight()).getScope();
        Assert.assertEquals((long)2L, (long)rightName.getBackReferencesCount());
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
    }

    @Test
    public void testMapInitializationEmpty() {
        String expr = "countItems([])";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
    }

    @Test
    public void testMapInitializationLiteralAsArgument() {
        String expr = "countItems([123 : 456, 789 : 1011])";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
    }

    @Test
    public void testParseTemporalLiteral() {
        String expr = "5s";
        TemporalLiteralExpr drlx = DrlxParser.parseTemporalLiteral((String)expr);
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
        Assert.assertEquals((long)1L, (long)drlx.getChunks().size());
        TemporalLiteralChunkExpr chunk0 = (TemporalLiteralChunkExpr)drlx.getChunks().get(0);
        Assert.assertEquals((long)5L, (long)chunk0.getValue());
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)chunk0.getTimeUnit()));
    }

    @Test
    public void testParseTemporalLiteralOf2Chunks() {
        String expr = "1m5s";
        TemporalLiteralExpr drlx = DrlxParser.parseTemporalLiteral((String)expr);
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
        Assert.assertEquals((long)2L, (long)drlx.getChunks().size());
        TemporalLiteralChunkExpr chunk0 = (TemporalLiteralChunkExpr)drlx.getChunks().get(0);
        Assert.assertEquals((long)1L, (long)chunk0.getValue());
        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)chunk0.getTimeUnit()));
        TemporalLiteralChunkExpr chunk1 = (TemporalLiteralChunkExpr)drlx.getChunks().get(1);
        Assert.assertEquals((long)5L, (long)chunk1.getValue());
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)chunk1.getTimeUnit()));
    }

    @Test
    public void testInExpression() {
        String expr = "this in ()";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testUnsupportedImplicitParameter() {
        String expr = "== \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof HalfBinaryExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testAndWithImplicitNegativeParameter() {
        String expr = "value > -2 && < -1";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)comboExpr.getLeft();
        Assert.assertEquals((Object)"value", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"-2", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"-1", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)second.getOperator());
    }

    @Test
    public void testOrWithImplicitParameter() {
        String expr = "name == \"Mark\" || == \"Mario\" || == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"\"Mark\"", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assert.assertEquals((Object)"\"Mario\"", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"\"Luca\"", (Object)this.toString((Node)third.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void testAndWithImplicitParameter() {
        String expr = "name == \"Mark\" && == \"Mario\" && == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"\"Mark\"", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assert.assertEquals((Object)"\"Mario\"", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"\"Luca\"", (Object)this.toString((Node)third.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void testAndWithImplicitParameter2() {
        String expr = "name == \"Mark\" && == \"Mario\" || == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)((BinaryExpr)comboExpr.getLeft()).getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"\"Mark\"", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assert.assertEquals((Object)"\"Mario\"", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"\"Luca\"", (Object)this.toString((Node)third.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void testAndWithImplicitParameter3() {
        String expr = "age == 2 && == 3 || == 4";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)((BinaryExpr)comboExpr.getLeft()).getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assert.assertEquals((Object)"age", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"2", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assert.assertEquals((Object)"3", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"4", (Object)this.toString((Node)third.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void dotFreeWithRegexp() {
        String expr = "name matches \"[a-z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(PointFreeExpr.class));
        Assert.assertEquals((Object)"name matches \"[a-z]*\"", (Object)PrintUtil.printConstraint((Node)expression));
        PointFreeExpr e = (PointFreeExpr)expression;
        Assert.assertEquals((Object)"matches", (Object)e.getOperator().asString());
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)e.getLeft()));
        Assert.assertEquals((Object)"\"[a-z]*\"", (Object)this.toString(e.getRight().get(0)));
    }

    @Test
    public void implicitOperatorWithRegexps() {
        String expr = "name matches \"[a-z]*\" || matches \"pippo\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)"name matches \"[a-z]*\" || matches \"pippo\"", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void halfPointFreeExpr() {
        String expr = "matches \"[A-Z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(HalfPointFreeExpr.class));
        Assert.assertEquals((Object)"matches \"[A-Z]*\"", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void halfPointFreeExprNegated() {
        String expr = "not matches \"[A-Z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(HalfPointFreeExpr.class));
        Assert.assertEquals((Object)"not matches \"[A-Z]*\"", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void regressionTestHalfPointFree() {
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"getAddress().getAddressName().length() == 5").getExpr(), (Matcher)CoreMatchers.instanceOf(BinaryExpr.class));
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"isFortyYearsOld(this, true)").getExpr(), (Matcher)CoreMatchers.instanceOf(MethodCallExpr.class));
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"getName().startsWith(\"M\")").getExpr(), (Matcher)CoreMatchers.instanceOf(MethodCallExpr.class));
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"isPositive($i.intValue())").getExpr(), (Matcher)CoreMatchers.instanceOf(MethodCallExpr.class));
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"someEntity.someString in (\"1.500\")").getExpr(), (Matcher)CoreMatchers.instanceOf(PointFreeExpr.class));
    }

    @Test
    public void mvelSquareBracketsOperators() {
        this.testMvelSquareOperator("this str[startsWith] \"M\"", "str[startsWith]", "this", "\"M\"", false);
        this.testMvelSquareOperator("this not str[startsWith] \"M\"", "str[startsWith]", "this", "\"M\"", true);
        this.testMvelSquareOperator("this str[endsWith] \"K\"", "str[endsWith]", "this", "\"K\"", false);
        this.testMvelSquareOperator("this str[length] 17", "str[length]", "this", "17", false);
    }

    @Test
    public void halfPointFreeMVEL() {
        String expr = "this str[startsWith] \"M\" || str[startsWith] \"E\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)"this str[startsWith] \"M\" || str[startsWith] \"E\"", (Object)PrintUtil.printConstraint((Node)expression));
        Expression expression2 = DrlxParser.parseExpression(this.parser, (String)"str[startsWith] \"E\"").getExpr();
        Assert.assertThat((Object)expression2, (Matcher)CoreMatchers.instanceOf(HalfPointFreeExpr.class));
        Assert.assertEquals((Object)"str[startsWith] \"E\"", (Object)PrintUtil.printConstraint((Node)expression2));
    }

    @Test
    public void testModifyStatement() {
        String expr = "{ modify ( $p )  { name = \"Luca\", age = \"35\" }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    modify ($p) { name = \"Luca\", age = \"35\" };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test(expected=ParseProblemException.class)
    public void testModifyFailing() {
        String expr = "{ modify  { name = \"Luca\", age = \"35\" }; }";
        MvelParser.parseBlock((String)expr);
    }

    @Test
    public void testModifyStatementSemicolon() {
        String expr = "{ modify ( $p )  { name = \"Luca\"; }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    modify ($p) { name = \"Luca\" };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testModifySemiColon() {
        String expr = "{ modify($p) { setAge(1); }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    modify ($p) { setAge(1) };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testModifyEmptyBlock() {
        String expr = "{ modify( $s ) { } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    modify ($s) {  };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testModifyWithoutSemicolon() {
        String expr = "{modify($p) { setAge($p.getAge()+1) } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    modify ($p) { setAge($p.getAge() + 1) };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testModifyWithCast() {
        String expr = "{modify( (BooleanEvent)$toEdit.get(0) ){  }}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    modify ((BooleanEvent) $toEdit.get(0)) {  };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithStatement() {
        String expr = "{ with ( $p )  { name = \"Luca\", age = \"35\" }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    with ($p) { name = \"Luca\", age = \"35\" };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test(expected=ParseProblemException.class)
    public void testWithFailing() {
        String expr = "{ with  { name = \"Luca\", age = \"35\" }; }";
        MvelParser.parseBlock((String)expr);
    }

    @Test
    public void testWithStatementSemicolon() {
        String expr = "{ with ( $p )  { name = \"Luca\"; }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    with ($p) { name = \"Luca\" };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithSemiColon() {
        String expr = "{ with($p) { setAge(1); }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    with ($p) { setAge(1) };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithEmptyBlock() {
        String expr = "{ with( $s ) { } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    with ($s) {  };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithWithoutSemicolon() {
        String expr = "{with($p) { setAge($p.getAge()+1) } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    with ($p) { setAge($p.getAge() + 1) };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithWithCast() {
        String expr = "{with( (BooleanEvent)$toEdit.get(0) ){  }}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    with ((BooleanEvent) $toEdit.get(0)) {  };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithConstructor() {
        String expr = "{ with(s1 = new Some()) { }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    with (s1 = new Some()) {  };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithoutSemicolon() {
        String expr = "{             a\nb\n}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    a;\n    b;\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithoutSemicolonMethod() {
        String expr = "{             delete($person)\ndelete($pet)\n}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    delete($person);\n    delete($pet);\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithoutSemicolonMethodComment() {
        String expr = "{             delete($person) // comment\ndelete($pet) // comment \n}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    delete($person);\n    delete($pet);\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithoutSemicolonMethodCommentWindows() {
        String expr = "{             delete($person) // comment\r\ndelete($pet) // comment\r\n}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    delete($person);\n    delete($pet);\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void statementsWithComments() {
        String expr = "{             delete($person); // comment\ndelete($pet); // comment \n}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    delete($person);\n    delete($pet);\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void singleLineBlock() {
        String expr = "{ delete($person); } // comment ";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    delete($person);\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void singleLineBlockWithoutsemicolon() {
        String expr = "{ delete($person) } // comment";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    delete($person);\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void commentsWithEmptyStatements() {
        String expr = "{// modify ; something\n/* modify ; something */\nsetAge(47)\n}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    ;\n    ;\n    setAge(47);\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void newLineInFunctionCall() {
        String expr = "{func(x \n)\n}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    func(x);\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void newLineInFunctionCall2() {
        Expression expression = MvelParser.parseExpression((String)"func(x,\n 2)");
        Assert.assertEquals((Object)"func(x, 2)", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void newLineInFunctionCall3() {
        Expression expression = MvelParser.parseExpression((String)"func(x\n, 2)");
        Assert.assertEquals((Object)"func(x, 2)", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void commentsWithEmptyStatements2() {
        String expr = "{  globalA.add(\"A\");\n  modify( $p ) {\n    // modify ; something\n    /* modify ; something */\n    setAge(47)\n  }\n  globalB.add(\"B\");\n  // modify ; something\n  /* modify ; something */}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)"{\n    globalA.add(\"A\");\n    modify ($p) { setAge(47) };\n    globalB.add(\"B\");\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testNewExpression() {
        String expr = "money == new BigInteger(\"3\")";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testArrayCreation() {
        String expr = "new Object[] { \"getMessageId\", ($s != null ? $s : \"42103\") }";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testArrayCreation2() {
        String expr = "functions.arrayContainsInstanceWithParameters((Object[]) $f.getPersons())";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    private void testMvelSquareOperator(String wholeExpression, String operator, String left, String right, boolean isNegated) {
        String expr = wholeExpression;
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(PointFreeExpr.class));
        Assert.assertEquals((Object)wholeExpression, (Object)PrintUtil.printConstraint((Node)expression));
        PointFreeExpr e = (PointFreeExpr)expression;
        Assert.assertEquals((Object)operator, (Object)e.getOperator().asString());
        Assert.assertEquals((Object)left, (Object)this.toString((Node)e.getLeft()));
        Assert.assertEquals((Object)right, (Object)this.toString(e.getRight().get(0)));
        Assert.assertEquals((Object)isNegated, (Object)e.isNegated());
    }

    private String toString(Node n) {
        return PrintUtil.printConstraint((Node)n);
    }
}

