/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.parser;

import com.github.javaparser.Problem;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.comments.CommentsCollection;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.Utils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.drools.mvel.parser.GeneratedMvelParserTokenManager;
import org.drools.mvel.parser.JavaToken;
import org.drools.mvel.parser.ParseException;
import org.drools.mvel.parser.Provider;
import org.drools.mvel.parser.Token;

abstract class GeneratedMvelParserBase {
    List<Problem> problems = new ArrayList<Problem>();
    boolean storeTokens;

    GeneratedMvelParserBase() {
    }

    abstract GeneratedMvelParserTokenManager getTokenSource();

    abstract void ReInit(Provider var1);

    abstract com.github.javaparser.JavaToken token();

    abstract Token getNextToken();

    void reset(Provider provider) {
        this.ReInit(provider);
        this.problems = new ArrayList<Problem>();
        this.getTokenSource().reset();
    }

    public List<com.github.javaparser.JavaToken> getTokens() {
        return this.getTokenSource().getTokens();
    }

    CommentsCollection getCommentsCollection() {
        return this.getTokenSource().getCommentsCollection();
    }

    void addProblem(String message) {
        this.problems.add(new Problem(message, this.tokenRange(), null));
    }

    TokenRange tokenRange() {
        if (this.storeTokens) {
            return new TokenRange(this.token(), this.token());
        }
        return null;
    }

    TokenRange range(com.github.javaparser.JavaToken begin, com.github.javaparser.JavaToken end) {
        if (this.storeTokens) {
            return new TokenRange(begin, end);
        }
        return null;
    }

    TokenRange range(Node begin, com.github.javaparser.JavaToken end) {
        if (this.storeTokens) {
            return new TokenRange(((TokenRange)begin.getTokenRange().get()).getBegin(), end);
        }
        return null;
    }

    TokenRange range(com.github.javaparser.JavaToken begin, Node end) {
        if (this.storeTokens) {
            return new TokenRange(begin, ((TokenRange)end.getTokenRange().get()).getEnd());
        }
        return null;
    }

    TokenRange range(Node begin, Node end) {
        if (this.storeTokens) {
            return new TokenRange(((TokenRange)begin.getTokenRange().get()).getBegin(), ((TokenRange)end.getTokenRange().get()).getEnd());
        }
        return null;
    }

    com.github.javaparser.JavaToken orIfInvalid(com.github.javaparser.JavaToken firstChoice, com.github.javaparser.JavaToken secondChoice) {
        if (this.storeTokens) {
            Utils.assertNotNull((Object)firstChoice);
            Utils.assertNotNull((Object)secondChoice);
            if (firstChoice.valid() || secondChoice.invalid()) {
                return firstChoice;
            }
            return secondChoice;
        }
        return null;
    }

    com.github.javaparser.JavaToken orIfInvalid(com.github.javaparser.JavaToken firstChoice, Node secondChoice) {
        if (this.storeTokens) {
            return this.orIfInvalid(firstChoice, ((TokenRange)secondChoice.getTokenRange().get()).getBegin());
        }
        return null;
    }

    void setTokenKind(int newKind) {
        JavaToken token = (JavaToken)this.token();
        token.setKind(newKind);
    }

    void setStoreTokens(boolean storeTokens) {
        this.storeTokens = storeTokens;
        this.getTokenSource().setStoreTokens(storeTokens);
    }

    TokenRange recover(int recoveryTokenType, ParseException p) {
        Token t;
        com.github.javaparser.JavaToken begin = null;
        if (p.currentToken != null) {
            begin = this.token();
        }
        do {
            t = this.getNextToken();
        } while (t.kind != recoveryTokenType && t.kind != 0);
        com.github.javaparser.JavaToken end = this.token();
        TokenRange tokenRange = null;
        if (begin != null && end != null) {
            tokenRange = this.range(begin, end);
        }
        this.problems.add(new Problem(this.makeMessageForParseException(p), tokenRange, (Throwable)p));
        return tokenRange;
    }

    <T extends Node> NodeList<T> emptyList() {
        return new NodeList();
    }

    <T extends Node> NodeList<T> add(NodeList<T> list, T obj) {
        if (list == null) {
            list = new NodeList();
        }
        list.add(obj);
        return list;
    }

    <T> List<T> add(List<T> list, T obj) {
        if (list == null) {
            list = new LinkedList<T>();
        }
        list.add(obj);
        return list;
    }

    ArrayCreationExpr juggleArrayCreation(TokenRange range, List<TokenRange> levelRanges, Type type, NodeList<Expression> dimensions, List<NodeList<AnnotationExpr>> arrayAnnotations, ArrayInitializerExpr arrayInitializerExpr) {
        NodeList levels = new NodeList();
        for (int i = 0; i < arrayAnnotations.size(); ++i) {
            levels.add((Node)new ArrayCreationLevel(levelRanges.get(i), (Expression)dimensions.get(i), arrayAnnotations.get(i)));
        }
        return new ArrayCreationExpr(range, type, levels, arrayInitializerExpr);
    }

    Type juggleArrayType(Type partialType, List<ArrayType.ArrayBracketPair> additionalBrackets) {
        Pair partialParts = ArrayType.unwrapArrayTypes((Type)partialType);
        Type elementType = (Type)partialParts.a;
        List leftMostBrackets = (List)partialParts.b;
        return ArrayType.wrapInArrayTypes((Type)elementType, (List[])new List[]{leftMostBrackets, additionalBrackets}).clone();
    }

    private String makeMessageForParseException(ParseException exception) {
        StringBuilder sb = new StringBuilder("Parse error. Found ");
        StringBuilder expected = new StringBuilder();
        int maxExpectedTokenSequenceLength = 0;
        TreeSet<String> sortedOptions = new TreeSet<String>();
        for (int i = 0; i < exception.expectedTokenSequences.length; ++i) {
            if (maxExpectedTokenSequenceLength < exception.expectedTokenSequences[i].length) {
                maxExpectedTokenSequenceLength = exception.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < exception.expectedTokenSequences[i].length; ++j) {
                sortedOptions.add(exception.tokenImage[exception.expectedTokenSequences[i][j]]);
            }
        }
        for (String option : sortedOptions) {
            expected.append(" ").append(option);
        }
        sb.append("");
        Token token = exception.currentToken.next;
        for (int i = 0; i < maxExpectedTokenSequenceLength; ++i) {
            String tokenText = token.image;
            String escapedTokenText = ParseException.add_escapes(tokenText);
            if (i != 0) {
                sb.append(" ");
            }
            if (token.kind == 0) {
                sb.append(exception.tokenImage[0]);
                break;
            }
            String image = exception.tokenImage[token.kind];
            escapedTokenText = "\"" + escapedTokenText + "\"";
            if (image.equals(escapedTokenText)) {
                sb.append(image);
            } else {
                sb.append(" ").append(escapedTokenText).append(" ").append(image);
            }
            token = token.next;
        }
        if (exception.expectedTokenSequences.length != 0) {
            int numExpectedTokens = exception.expectedTokenSequences.length;
            sb.append(", expected").append(numExpectedTokens == 1 ? "" : " one of ").append(expected.toString());
        }
        return sb.toString();
    }
}

