/* Generated by: ParserGeneratorCC: Do not edit this line. StringProvider.java Version 1.1 */
/* ParserGeneratorCCOptions:KEEP_LINE_COLUMN=true */
/*
 * Copyright (C) 2007-2010 Júlio Vilmar Gesser.
 * Copyright (C) 2011, 2013-2016 The JavaParser Team.
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * This file is part of JavaParser.
 *
 * JavaParser can be used either under the terms of
 * a) the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * b) the terms of the Apache License
 *
 * You should have received a copy of both licenses in LICENCE.LGPL and
 * LICENCE.APACHE. Please refer to those files for details.
 *
 * JavaParser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * Modified by Red Hat, Inc.
 */
package org.drools.mvel.parser;

  
import java.io.IOException;
  
public class StringProvider implements Provider {
  private String _string;
  private int _position = 0;
  private final int _size;
  
  public StringProvider(final String string) {
    _string = string;
    _size = string.length();
  }
  
  public int read(final char[] aDest, final int nOfs, final int nLen) throws IOException {
    final int numCharsOutstandingInString = _size - _position;
    if (numCharsOutstandingInString == 0)
      return -1;
    
    int numBytesToRead = aDest.length - nOfs;
    if (nLen < numBytesToRead)
      numBytesToRead = nLen;
    if (numCharsOutstandingInString < numBytesToRead)
      numBytesToRead = numCharsOutstandingInString;
    
    _string.getChars(_position, _position + numBytesToRead, aDest, nOfs);
    _position += numBytesToRead;
    
    return numBytesToRead;
  }

  public void close() {
    _string = null;
  }
}
/* ParserGeneratorCC - OriginalChecksum=f383aaf311aa4269fae29dbfb5c1da55 (do not edit this line) */
