/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.parser.utils;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import org.drools.mvel.parser.ast.expr.HalfBinaryExpr;

public class AstUtils {
    public static boolean hasChildOfType(Node node, Class<?> nodeType) {
        if (nodeType.isInstance(node)) {
            return true;
        }
        for (Node child : node.getChildNodes()) {
            if (!AstUtils.hasChildOfType(child, nodeType)) continue;
            return true;
        }
        return false;
    }

    public static Expression parseMethodExprOrHalfBinary(TokenRange tokenRange, SimpleName name, NodeList<Expression> args) {
        return args.size() == 1 && AstUtils.isHalfBinaryArg((Expression)args.get(0)) ? AstUtils.transformHalfBinaryArg(tokenRange, name, (Expression)args.get(0)) : new MethodCallExpr(tokenRange, null, null, name, args);
    }

    private static Expression transformHalfBinaryArg(TokenRange tokenRange, SimpleName name, Expression expr) {
        if (expr instanceof HalfBinaryExpr) {
            BinaryExpr result = new BinaryExpr(tokenRange, (Expression)new NameExpr(name), ((HalfBinaryExpr)expr).getRight(), ((HalfBinaryExpr)expr).getOperator().toBinaryExprOperator());
            return result;
        }
        if (expr instanceof EnclosedExpr) {
            return AstUtils.transformHalfBinaryArg(tokenRange, name, ((EnclosedExpr)expr).getInner());
        }
        if (expr instanceof BinaryExpr) {
            BinaryExpr binary = (BinaryExpr)expr;
            Expression rewrittenLeft = AstUtils.transformHalfBinaryArg(tokenRange, name, binary.getLeft());
            Expression rewrittenRight = binary.getRight() instanceof HalfBinaryExpr && !(binary.getLeft() instanceof EnclosedExpr) ? binary.getRight() : AstUtils.transformHalfBinaryArg(tokenRange, name, binary.getRight());
            rewrittenRight.setParentNode((Node)rewrittenLeft);
            return new BinaryExpr(tokenRange, rewrittenLeft, rewrittenRight, binary.getOperator());
        }
        throw new IllegalStateException();
    }

    private static boolean isHalfBinaryArg(Expression expr) {
        if (expr instanceof HalfBinaryExpr) {
            return true;
        }
        if (expr instanceof BinaryExpr) {
            return AstUtils.isHalfBinaryArg(((BinaryExpr)expr).getLeft());
        }
        if (expr instanceof EnclosedExpr) {
            return AstUtils.isHalfBinaryArg(((EnclosedExpr)expr).getInner());
        }
        return false;
    }
}

