/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.parser;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.drools.mvel.parser.DrlxParser;
import org.drools.mvel.parser.GeneratedMvelParser;
import org.drools.mvel.parser.MvelParser;
import org.drools.mvel.parser.ParseStart;
import org.drools.mvel.parser.Provider;
import org.drools.mvel.parser.StringProvider;
import org.drools.mvel.parser.ast.expr.DrlNameExpr;
import org.drools.mvel.parser.ast.expr.DrlxExpression;
import org.drools.mvel.parser.ast.expr.HalfBinaryExpr;
import org.drools.mvel.parser.ast.expr.HalfPointFreeExpr;
import org.drools.mvel.parser.ast.expr.NullSafeFieldAccessExpr;
import org.drools.mvel.parser.ast.expr.OOPathChunk;
import org.drools.mvel.parser.ast.expr.OOPathExpr;
import org.drools.mvel.parser.ast.expr.PointFreeExpr;
import org.drools.mvel.parser.ast.expr.TemporalLiteralChunkExpr;
import org.drools.mvel.parser.ast.expr.TemporalLiteralExpr;
import org.drools.mvel.parser.printer.PrintUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DroolsMvelParserTest {
    private static final Collection<String> operators = new HashSet<String>();
    final ParseStart<DrlxExpression> parser;

    public DroolsMvelParserTest() {
        operators.addAll(Arrays.asList("after", "before", "in", "matches", "includes"));
        this.parser = DrlxParser.buildDrlxParserWithArguments(operators);
    }

    @Test
    public void testParseSimpleExpr() {
        String expr = "name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)binaryExpr.getLeft()));
        Assert.assertEquals((Object)"\"Mark\"", (Object)this.toString((Node)binaryExpr.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)binaryExpr.getOperator());
    }

    @Test
    public void testBinaryWithNewLine() {
        Expression or = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 ||\n                   addresses == 3  )").getExpr();
        Assert.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printNode((Node)or));
        Expression and = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 &&\n addresses == 3  )").getExpr();
        Assert.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printNode((Node)and));
    }

    @Test
    public void testBinaryWithWindowsNewLine() {
        Expression or = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 ||\r\n                   addresses == 3  )").getExpr();
        Assert.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printNode((Node)or));
        Expression and = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 &&\r\n addresses == 3  )").getExpr();
        Assert.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printNode((Node)and));
    }

    @Test
    public void testBinaryWithNewLineBeginning() {
        Expression or = DrlxParser.parseExpression(this.parser, (String)("(" + this.newLine() + "addresses == 2 || addresses == 3  )")).getExpr();
        Assert.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printNode((Node)or));
        Expression and = DrlxParser.parseExpression(this.parser, (String)("(" + this.newLine() + "addresses == 2 && addresses == 3  )")).getExpr();
        Assert.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printNode((Node)and));
    }

    @Test
    public void testBinaryWithNewLineEnd() {
        Expression or = DrlxParser.parseExpression(this.parser, (String)("(addresses == 2 || addresses == 3 " + this.newLine() + ")")).getExpr();
        Assert.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printNode((Node)or));
        Expression and = DrlxParser.parseExpression(this.parser, (String)("(addresses == 2 && addresses == 3 " + this.newLine() + ")")).getExpr();
        Assert.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printNode((Node)and));
    }

    @Test
    public void testBinaryWithNewLineBeforeOperator() {
        String andExpr = "(addresses == 2" + this.newLine() + "&& addresses == 3  )";
        MvelParser mvelParser1 = new MvelParser(new ParserConfiguration(), true);
        Expression and2 = (Expression)mvelParser1.parse(GeneratedMvelParser::Expression, (Provider)new StringProvider(andExpr)).getResult().get();
        Assert.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printNode((Node)and2));
        String orExpr = "(addresses == 2" + this.newLine() + "|| addresses == 3  )";
        MvelParser mvelParser2 = new MvelParser(new ParserConfiguration(), false);
        Expression or2 = (Expression)mvelParser2.parse(GeneratedMvelParser::Expression, (Provider)new StringProvider(orExpr)).getResult().get();
        Assert.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printNode((Node)or2));
    }

    @Test
    public void testParseSafeCastExpr() {
        String expr = "this instanceof Person && ((Person) this).name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testParseInlineCastExpr() {
        String expr = "this#Person.name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testParseInlineCastExpr2() {
        String expr = "address#com.pkg.InternationalAddress.state.length == 5";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testParseInlineCastExpr3() {
        String expr = "address#org.drools.mvel.compiler.LongAddress.country.substring(1)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testParseInlineCastExpr4() {
        String expr = "address#com.pkg.InternationalAddress.getState().length == 5";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testParseNullSafeFieldAccessExpr() {
        String expr = "person!.name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testDotFreeExpr() {
        String expr = "this after $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testDotFreeEnclosed() {
        String expr = "(this after $a)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testDotFreeEnclosedWithNameExpr() {
        String expr = "(something after $a)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testLiteral() {
        String bigDecimalLiteral = "bigInteger < (50B)";
        Expression bigDecimalExpr = DrlxParser.parseExpression(this.parser, (String)bigDecimalLiteral).getExpr();
        Assert.assertEquals((Object)bigDecimalLiteral, (Object)PrintUtil.printNode((Node)bigDecimalExpr));
        String bigIntegerLiteral = "bigInteger == (50I)";
        Expression bigIntegerExpr = DrlxParser.parseExpression(this.parser, (String)bigIntegerLiteral).getExpr();
        Assert.assertEquals((Object)bigIntegerLiteral, (Object)PrintUtil.printNode((Node)bigIntegerExpr));
    }

    @Test
    public void testBigDecimalLiteral() {
        String bigDecimalLiteralWithDecimals = "12.111B";
        Expression bigDecimalExprWithDecimals = DrlxParser.parseExpression(this.parser, (String)bigDecimalLiteralWithDecimals).getExpr();
        Assert.assertEquals((Object)bigDecimalLiteralWithDecimals, (Object)PrintUtil.printNode((Node)bigDecimalExprWithDecimals));
    }

    @Test
    public void testDotFreeExprWithOr() {
        String expr = "this after $a || this after $b";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof BinaryExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testDotFreeExprWithArgs() {
        String expr = "this after[5,8] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertFalse((boolean)((PointFreeExpr)expression).isNegated());
        Assert.assertEquals((Object)"this after[5ms,8ms] $a", (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testDotFreeExprWithArgsInfinite() {
        String expr = "this after[5s,*] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertFalse((boolean)((PointFreeExpr)expression).isNegated());
        Assert.assertEquals((Object)"this after[5s,*] $a", (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testDotFreeExprWithThreeArgsInfinite() {
        String expr = "this after[*,*,*,2s] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertFalse((boolean)((PointFreeExpr)expression).isNegated());
        Assert.assertEquals((Object)"this after[*,*,*,2s] $a", (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testDotFreeExprWithArgsNegated() {
        String expr = "this not after[5,8] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(PointFreeExpr.class));
        Assert.assertTrue((boolean)((PointFreeExpr)expression).isNegated());
        Assert.assertEquals((Object)"this not after[5ms,8ms] $a", (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testDotFreeExprWithTemporalArgs() {
        String expr = "this after[5ms,8d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testDotFreeExprWithFourTemporalArgs() {
        String expr = "this includes[1s,1m,1h,1d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testHalfDotFreeExprWithFourTemporalArgs() {
        String expr = "includes[1s,1m,1h,1d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(HalfPointFreeExpr.class));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test(expected=ParseProblemException.class)
    public void testInvalidTemporalArgs() {
        String expr = "this after[5ms,8f] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
    }

    @Test
    public void testOOPathExpr() {
        String expr = "/wife/children[age > 10]/toys";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression expression = drlx.getExpr();
        Assert.assertTrue((boolean)(expression instanceof OOPathExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)drlx));
    }

    @Test
    public void testOOPathExprWithDot() {
        String expr = "/wife.children/toys";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression expression = drlx.getExpr();
        Assert.assertTrue((boolean)(expression instanceof OOPathExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)drlx));
    }

    @Test
    public void testOOPathExprWithMultipleCondition() {
        String expr = "$address : /address[street == \"Elm\",city == \"Big City\"]";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression expression = drlx.getExpr();
        Assert.assertTrue((boolean)(expression instanceof OOPathExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)drlx));
    }

    @Test
    public void testOOPathExprWithDeclaration() {
        String expr = "$toy : /wife/children[age > 10]/toys";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assert.assertEquals((Object)"$toy", (Object)drlx.getBind().asString());
        Expression expression = drlx.getExpr();
        Assert.assertTrue((boolean)(expression instanceof OOPathExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)drlx));
    }

    @Test
    public void testOOPathExprWithBackReference() {
        String expr = "$toy : /wife/children/toys[name.length == ../../name.length]";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assert.assertEquals((Object)"$toy", (Object)drlx.getBind().asString());
        Expression expression = drlx.getExpr();
        Assert.assertTrue((boolean)(expression instanceof OOPathExpr));
        OOPathChunk secondChunk = (OOPathChunk)((OOPathExpr)expression).getChunks().get(2);
        BinaryExpr secondChunkFirstCondition = (BinaryExpr)((DrlxExpression)secondChunk.getConditions().get(0)).getExpr();
        DrlNameExpr rightName = (DrlNameExpr)((FieldAccessExpr)secondChunkFirstCondition.getRight()).getScope();
        Assert.assertEquals((long)2L, (long)rightName.getBackReferencesCount());
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)drlx));
    }

    @Test
    public void testMapInitializationEmpty() {
        String expr = "countItems([])";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)drlx));
    }

    @Test
    public void testMapInitializationLiteralAsArgument() {
        String expr = "countItems([123 : 456, 789 : 1011])";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)drlx));
    }

    @Test
    public void testParseTemporalLiteral() {
        String expr = "5s";
        TemporalLiteralExpr drlx = DrlxParser.parseTemporalLiteral((String)expr);
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)drlx));
        Assert.assertEquals((long)1L, (long)drlx.getChunks().size());
        TemporalLiteralChunkExpr chunk0 = (TemporalLiteralChunkExpr)drlx.getChunks().get(0);
        Assert.assertEquals((long)5L, (long)chunk0.getValue());
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)chunk0.getTimeUnit()));
    }

    @Test
    public void testParseTemporalLiteralOf2Chunks() {
        String expr = "1m5s";
        TemporalLiteralExpr drlx = DrlxParser.parseTemporalLiteral((String)expr);
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)drlx));
        Assert.assertEquals((long)2L, (long)drlx.getChunks().size());
        TemporalLiteralChunkExpr chunk0 = (TemporalLiteralChunkExpr)drlx.getChunks().get(0);
        Assert.assertEquals((long)1L, (long)chunk0.getValue());
        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)chunk0.getTimeUnit()));
        TemporalLiteralChunkExpr chunk1 = (TemporalLiteralChunkExpr)drlx.getChunks().get(1);
        Assert.assertEquals((long)5L, (long)chunk1.getValue());
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)chunk1.getTimeUnit()));
    }

    @Test
    public void testInExpression() {
        String expr = "this in ()";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testUnsupportedImplicitParameter() {
        String expr = "== \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof HalfBinaryExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testAndWithImplicitNegativeParameter() {
        String expr = "value > -2 && < -1";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)comboExpr.getLeft();
        Assert.assertEquals((Object)"value", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"-2", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"-1", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)second.getOperator());
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesis() {
        String expr = "value (> 1 && < 2)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)comboExpr.getLeft();
        Assert.assertEquals((Object)"value", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"1", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"2", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)second.getOperator());
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesisOnThis() {
        String expr = "this (> 1 && < 2)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)comboExpr.getLeft();
        Assert.assertEquals((Object)"this", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"1", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"2", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)second.getOperator());
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesisComplex() {
        String expr = "value ((> 1 && < 2) || (> 3 && < 4))";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        BinaryExpr comboExprLeft = (BinaryExpr)comboExpr.getLeft();
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExprLeft.getOperator());
        BinaryExpr first = (BinaryExpr)comboExprLeft.getLeft();
        Assert.assertEquals((Object)"value", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"1", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)comboExprLeft.getRight();
        Assert.assertEquals((Object)"2", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)second.getOperator());
        BinaryExpr comboExprRight = (BinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExprRight.getOperator());
        BinaryExpr third = (BinaryExpr)comboExprRight.getLeft();
        Assert.assertEquals((Object)"value", (Object)this.toString((Node)third.getLeft()));
        Assert.assertEquals((Object)"3", (Object)this.toString((Node)third.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)third.getOperator());
        HalfBinaryExpr forth = (HalfBinaryExpr)comboExprRight.getRight();
        Assert.assertEquals((Object)"4", (Object)this.toString((Node)forth.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)forth.getOperator());
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesisComplexOnField() {
        String expr = "value.length ((> 1 && < 2) || (> 3 && < 4))";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        BinaryExpr comboExprLeft = (BinaryExpr)comboExpr.getLeft();
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExprLeft.getOperator());
        BinaryExpr first = (BinaryExpr)comboExprLeft.getLeft();
        Assert.assertTrue((boolean)(first.getLeft() instanceof FieldAccessExpr));
        Assert.assertEquals((Object)"value.length", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"1", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)comboExprLeft.getRight();
        Assert.assertEquals((Object)"2", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)second.getOperator());
        BinaryExpr comboExprRight = (BinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExprRight.getOperator());
        BinaryExpr third = (BinaryExpr)comboExprRight.getLeft();
        Assert.assertEquals((Object)"value.length", (Object)this.toString((Node)third.getLeft()));
        Assert.assertEquals((Object)"3", (Object)this.toString((Node)third.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)third.getOperator());
        HalfBinaryExpr forth = (HalfBinaryExpr)comboExprRight.getRight();
        Assert.assertEquals((Object)"4", (Object)this.toString((Node)forth.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)forth.getOperator());
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesisComplexOnNullSafeField() {
        String expr = "value!.length ((> 1 && < 2) || (> 3 && < 4))";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        BinaryExpr comboExprLeft = (BinaryExpr)comboExpr.getLeft();
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExprLeft.getOperator());
        BinaryExpr first = (BinaryExpr)comboExprLeft.getLeft();
        Assert.assertTrue((boolean)(first.getLeft() instanceof NullSafeFieldAccessExpr));
        Assert.assertEquals((Object)"value!.length", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"1", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)comboExprLeft.getRight();
        Assert.assertEquals((Object)"2", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)second.getOperator());
        BinaryExpr comboExprRight = (BinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExprRight.getOperator());
        BinaryExpr third = (BinaryExpr)comboExprRight.getLeft();
        Assert.assertEquals((Object)"value!.length", (Object)this.toString((Node)third.getLeft()));
        Assert.assertEquals((Object)"3", (Object)this.toString((Node)third.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)third.getOperator());
        HalfBinaryExpr forth = (HalfBinaryExpr)comboExprRight.getRight();
        Assert.assertEquals((Object)"4", (Object)this.toString((Node)forth.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)forth.getOperator());
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesisMixedLeft() {
        String expr = "value ((> 1 && < 2) || > 3)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        BinaryExpr comboExprLeft = (BinaryExpr)comboExpr.getLeft();
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExprLeft.getOperator());
        BinaryExpr first = (BinaryExpr)comboExprLeft.getLeft();
        Assert.assertEquals((Object)"value", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"1", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)comboExprLeft.getRight();
        Assert.assertEquals((Object)"2", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)second.getOperator());
        BinaryExpr third = (BinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"value", (Object)this.toString((Node)third.getLeft()));
        Assert.assertEquals((Object)"3", (Object)this.toString((Node)third.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)third.getOperator());
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesisMixedRight() {
        String expr = "value (< 1 || (> 2 && < 3))";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)comboExpr.getLeft();
        Assert.assertEquals((Object)"value", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"1", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.LESS, (Object)first.getOperator());
        BinaryExpr comboExprRight = (BinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExprRight.getOperator());
        BinaryExpr third = (BinaryExpr)comboExprRight.getLeft();
        Assert.assertEquals((Object)"value", (Object)this.toString((Node)third.getLeft()));
        Assert.assertEquals((Object)"2", (Object)this.toString((Node)third.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)third.getOperator());
        HalfBinaryExpr forth = (HalfBinaryExpr)comboExprRight.getRight();
        Assert.assertEquals((Object)"3", (Object)this.toString((Node)forth.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)forth.getOperator());
    }

    @Test
    public void testOrWithImplicitParameter() {
        String expr = "name == \"Mark\" || == \"Mario\" || == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"\"Mark\"", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assert.assertEquals((Object)"\"Mario\"", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"\"Luca\"", (Object)this.toString((Node)third.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void testAndWithImplicitParameter() {
        String expr = "name == \"Mark\" && == \"Mario\" && == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"\"Mark\"", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assert.assertEquals((Object)"\"Mario\"", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"\"Luca\"", (Object)this.toString((Node)third.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void testAndWithImplicitParameter2() {
        String expr = "name == \"Mark\" && == \"Mario\" || == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)((BinaryExpr)comboExpr.getLeft()).getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"\"Mark\"", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assert.assertEquals((Object)"\"Mario\"", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"\"Luca\"", (Object)this.toString((Node)third.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void testAndWithImplicitParameter3() {
        String expr = "age == 2 && == 3 || == 4";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)((BinaryExpr)comboExpr.getLeft()).getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assert.assertEquals((Object)"age", (Object)this.toString((Node)first.getLeft()));
        Assert.assertEquals((Object)"2", (Object)this.toString((Node)first.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assert.assertEquals((Object)"3", (Object)this.toString((Node)second.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"4", (Object)this.toString((Node)third.getRight()));
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void dotFreeWithRegexp() {
        String expr = "name matches \"[a-z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(PointFreeExpr.class));
        Assert.assertEquals((Object)"name matches \"[a-z]*\"", (Object)PrintUtil.printNode((Node)expression));
        PointFreeExpr e = (PointFreeExpr)expression;
        Assert.assertEquals((Object)"matches", (Object)e.getOperator().asString());
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)e.getLeft()));
        Assert.assertEquals((Object)"\"[a-z]*\"", (Object)this.toString(e.getRight().get(0)));
    }

    @Test
    public void implicitOperatorWithRegexps() {
        String expr = "name matches \"[a-z]*\" || matches \"pippo\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)"name matches \"[a-z]*\" || matches \"pippo\"", (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void halfPointFreeExpr() {
        String expr = "matches \"[A-Z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(HalfPointFreeExpr.class));
        Assert.assertEquals((Object)"matches \"[A-Z]*\"", (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void halfPointFreeExprNegated() {
        String expr = "not matches \"[A-Z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(HalfPointFreeExpr.class));
        Assert.assertEquals((Object)"not matches \"[A-Z]*\"", (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void regressionTestHalfPointFree() {
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"getAddress().getAddressName().length() == 5").getExpr(), (Matcher)CoreMatchers.instanceOf(BinaryExpr.class));
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"isFortyYearsOld(this, true)").getExpr(), (Matcher)CoreMatchers.instanceOf(MethodCallExpr.class));
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"getName().startsWith(\"M\")").getExpr(), (Matcher)CoreMatchers.instanceOf(MethodCallExpr.class));
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"isPositive($i.intValue())").getExpr(), (Matcher)CoreMatchers.instanceOf(MethodCallExpr.class));
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"someEntity.someString in (\"1.500\")").getExpr(), (Matcher)CoreMatchers.instanceOf(PointFreeExpr.class));
    }

    @Test
    public void mvelSquareBracketsOperators() {
        this.testMvelSquareOperator("this str[startsWith] \"M\"", "str[startsWith]", "this", "\"M\"", false);
        this.testMvelSquareOperator("this not str[startsWith] \"M\"", "str[startsWith]", "this", "\"M\"", true);
        this.testMvelSquareOperator("this str[endsWith] \"K\"", "str[endsWith]", "this", "\"K\"", false);
        this.testMvelSquareOperator("this str[length] 17", "str[length]", "this", "17", false);
    }

    @Test
    public void halfPointFreeMVEL() {
        String expr = "this str[startsWith] \"M\" || str[startsWith] \"E\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)"this str[startsWith] \"M\" || str[startsWith] \"E\"", (Object)PrintUtil.printNode((Node)expression));
        Expression expression2 = DrlxParser.parseExpression(this.parser, (String)"str[startsWith] \"E\"").getExpr();
        Assert.assertThat((Object)expression2, (Matcher)CoreMatchers.instanceOf(HalfPointFreeExpr.class));
        Assert.assertEquals((Object)"str[startsWith] \"E\"", (Object)PrintUtil.printNode((Node)expression2));
    }

    @Test
    public void testLambda() {
        String expr = "x -> y";
        DrlxExpression expression = DrlxParser.parseExpression(this.parser, (String)expr);
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testLambdaParameter() {
        String expr = "($p).setCanDrinkLambda(() -> true)";
        DrlxExpression expression = DrlxParser.parseExpression(this.parser, (String)expr);
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testModifyStatement() {
        String expr = "{ modify ( $p )  { name = \"Luca\", age = \"35\" }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    modify ($p) { name = \"Luca\", age = \"35\" };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test(expected=ParseProblemException.class)
    public void testModifyFailing() {
        String expr = "{ modify  { name = \"Luca\", age = \"35\" }; }";
        MvelParser.parseBlock((String)expr);
    }

    @Test
    public void testModifyStatementSemicolon() {
        String expr = "{ modify ( $p )  { name = \"Luca\"; }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    modify ($p) { name = \"Luca\" };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testModifySemiColon() {
        String expr = "{ modify($p) { setAge(1); }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    modify ($p) { setAge(1) };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testModifyMultiple() {
        String expr = "{ modify($p) { setAge(1)," + this.newLine() + " setAge(2), setAge(3)," + this.newLine() + "setAge(4); }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    modify ($p) { setAge(1), setAge(2), setAge(3), setAge(4) };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testModifyEmptyBlock() {
        String expr = "{ modify( $s ) { } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    modify ($s) {  };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testModifyWithoutSemicolon() {
        String expr = "{modify($p) { setAge($p.getAge()+1) } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    modify ($p) { setAge($p.getAge() + 1) };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testModifyWithCast() {
        String expr = "{modify( (BooleanEvent)$toEdit.get(0) ){  }}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    modify ((BooleanEvent) $toEdit.get(0)) {  };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testWithStatement() {
        String expr = "{ with ( $p )  { name = \"Luca\", age = \"35\" }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    with ($p) { name = \"Luca\", age = \"35\" };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test(expected=ParseProblemException.class)
    public void testWithFailing() {
        String expr = "{ with  { name = \"Luca\", age = \"35\" }; }";
        MvelParser.parseBlock((String)expr);
    }

    @Test
    public void testWithStatementSemicolon() {
        String expr = "{ with ( $p )  { name = \"Luca\"; }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    with ($p) { name = \"Luca\" };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testWithSemiColon() {
        String expr = "{ with($p) { setAge(1); }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    with ($p) { setAge(1) };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testWithEmptyBlock() {
        String expr = "{ with( $s ) { } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    with ($s) {  };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testWithWithoutSemicolon() {
        String expr = "{with($p) { setAge($p.getAge()+1) } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    with ($p) { setAge($p.getAge() + 1) };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testWithWithCast() {
        String expr = "{with( (BooleanEvent)$toEdit.get(0) ){  }}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    with ((BooleanEvent) $toEdit.get(0)) {  };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testWithConstructor() {
        String expr = "{ with(s1 = new Some()) { }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    with (s1 = new Some()) {  };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testWithoutSemicolon() {
        String expr = "{             a()" + this.newLine() + "b()" + this.newLine() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    a();" + this.newLine() + "    b();" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testWithoutSemicolonMethod() {
        String expr = "{             delete($person)" + this.newLine() + "delete($pet)" + this.newLine() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    delete($person);" + this.newLine() + "    delete($pet);" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testWithoutSemicolonMethodComment() {
        String expr = "{             delete($person) // comment" + this.newLine() + "delete($pet) // comment " + this.newLine() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    delete($person);" + this.newLine() + "    delete($pet);" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testWithoutSemicolonMethodCommentOppositeOSLineEndings() {
        String oppositeLineEnding = SystemUtils.IS_OS_WINDOWS ? "\n" : "\r\n";
        String expr = "{             delete($person) // comment" + oppositeLineEnding + "delete($pet) // comment" + oppositeLineEnding + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    delete($person);" + this.newLine() + "    delete($pet);" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void statementsWithComments() {
        String expr = "{             delete($person); // comment" + this.newLine() + "delete($pet); // comment " + this.newLine() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    delete($person);" + this.newLine() + "    delete($pet);" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void singleLineBlock() {
        String expr = "{ delete($person); } // comment ";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    delete($person);" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void singleLineBlockWithoutsemicolon() {
        String expr = "{ delete($person) } // comment";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    delete($person);" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void commentsWithEmptyStatements() {
        String expr = "{// modify ; something" + this.newLine() + "/* modify ; something */" + this.newLine() + "setAge(47)" + this.newLine() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    setAge(47);" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void newLineInFunctionCall() {
        String expr = "{func(x " + this.newLine() + ")" + this.newLine() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    func(x);" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void newLineInFunctionCall2() {
        Expression expression = MvelParser.parseExpression((String)("func(x," + this.newLine() + " 2)"));
        Assert.assertEquals((Object)"func(x, 2)", (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void newLineInFunctionCall3() {
        Expression expression = MvelParser.parseExpression((String)("func(x" + this.newLine() + ", 2)"));
        Assert.assertEquals((Object)"func(x, 2)", (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void commentsWithEmptyStatements2() {
        String expr = "{  globalA.add(\"A\");" + this.newLine() + "  modify( $p ) {" + this.newLine() + "    // modify ; something" + this.newLine() + "    /* modify ; something */" + this.newLine() + "    setAge(47)" + this.newLine() + "  }" + this.newLine() + "  globalB.add(\"B\");" + this.newLine() + "  // modify ; something" + this.newLine() + "  /* modify ; something */}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    globalA.add(\"A\");" + this.newLine() + "    modify ($p) { setAge(47) };" + this.newLine() + "    globalB.add(\"B\");" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testModifyLambda() {
        String expr = "{  modify($p) {  setCanDrinkLambda(() -> true); } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assert.assertEquals((Object)("{" + this.newLine() + "    modify ($p) { setCanDrinkLambda(() -> true) };" + this.newLine() + "}"), (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testNewExpression() {
        String expr = "money == new BigInteger(\"3\")";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testArrayCreation() {
        String expr = "new Object[] { \"getMessageId\", ($s != null ? $s : \"42103\") }";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testArrayCreation2() {
        String expr = "functions.arrayContainsInstanceWithParameters((Object[]) $f.getPersons())";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.printNode((Node)expression));
    }

    @Test
    public void testSpecialNewlineHandling() {
        String expr = "{ a() \nprint(1) }";
        Assert.assertEquals((String)"There should be 2 statements", (long)2L, (long)MvelParser.parseBlock((String)expr).getStatements().size());
        MvelParser mvelParser = new MvelParser(new ParserConfiguration(), false);
        ParseResult r = mvelParser.parse(GeneratedMvelParser::BlockParseStart, (Provider)new StringProvider(expr));
        Assert.assertFalse((String)"Parsing should break at newline", (boolean)r.isSuccessful());
    }

    @Test
    public void testLineBreakAtTheEndOfStatementWithoutSemicolon() {
        String expr = "{  Person p2 = new Person(\"John\");\n  p2.age = 30\ninsert(p2);\n }";
        MvelParser mvelParser = new MvelParser(new ParserConfiguration(), true);
        ParseResult r = mvelParser.parse(GeneratedMvelParser::BlockParseStart, (Provider)new StringProvider(expr));
        BlockStmt blockStmt = (BlockStmt)r.getResult().get();
        Assert.assertEquals((String)"Should parse 3 statements", (long)3L, (long)blockStmt.getStatements().size());
    }

    private void testMvelSquareOperator(String wholeExpression, String operator, String left, String right, boolean isNegated) {
        String expr = wholeExpression;
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(PointFreeExpr.class));
        Assert.assertEquals((Object)wholeExpression, (Object)PrintUtil.printNode((Node)expression));
        PointFreeExpr e = (PointFreeExpr)expression;
        Assert.assertEquals((Object)operator, (Object)e.getOperator().asString());
        Assert.assertEquals((Object)left, (Object)this.toString((Node)e.getLeft()));
        Assert.assertEquals((Object)right, (Object)this.toString(e.getRight().get(0)));
        Assert.assertEquals((Object)isNegated, (Object)e.isNegated());
    }

    private String toString(Node n) {
        return PrintUtil.printNode((Node)n);
    }

    private String newLine() {
        return System.lineSeparator();
    }

    @Test
    public void testBindVariable() {
        String expr = "$n : name == \"Mark\"";
        DrlxExpression drlxExpression = DrlxParser.parseExpression(this.parser, (String)expr);
        SimpleName bind = drlxExpression.getBind();
        Assert.assertEquals((Object)"$n", (Object)bind.asString());
        Expression expression = drlxExpression.getExpr();
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)binaryExpr.getLeft()));
        Assert.assertEquals((Object)"\"Mark\"", (Object)this.toString((Node)binaryExpr.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)binaryExpr.getOperator());
    }

    @Test
    public void testEnclosedBindVariable() {
        String expr = "($n : name == \"Mario\")";
        DrlxExpression drlxExpression = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression enclosedExpr = drlxExpression.getExpr();
        Assert.assertTrue((boolean)(enclosedExpr instanceof EnclosedExpr));
        Expression inner = ((EnclosedExpr)enclosedExpr).getInner();
        Assert.assertTrue((boolean)(inner instanceof DrlxExpression));
        DrlxExpression innerDrlxExpression = (DrlxExpression)inner;
        SimpleName bind = innerDrlxExpression.getBind();
        Assert.assertEquals((Object)"$n", (Object)bind.asString());
        Expression expression = innerDrlxExpression.getExpr();
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)binaryExpr.getLeft()));
        Assert.assertEquals((Object)"\"Mario\"", (Object)this.toString((Node)binaryExpr.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)binaryExpr.getOperator());
    }

    @Test
    public void testComplexEnclosedBindVariable() {
        String expr = "($n : name == \"Mario\") && (age > 20)";
        DrlxExpression drlxExpression = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression bExpr = drlxExpression.getExpr();
        Assert.assertTrue((boolean)(bExpr instanceof BinaryExpr));
        Expression left = ((BinaryExpr)bExpr).getLeft();
        Assert.assertTrue((boolean)(left instanceof EnclosedExpr));
        Expression inner = ((EnclosedExpr)left).getInner();
        Assert.assertTrue((boolean)(inner instanceof DrlxExpression));
        DrlxExpression innerDrlxExpression = (DrlxExpression)inner;
        SimpleName bind = innerDrlxExpression.getBind();
        Assert.assertEquals((Object)"$n", (Object)bind.asString());
        Expression expression = innerDrlxExpression.getExpr();
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)binaryExpr.getLeft()));
        Assert.assertEquals((Object)"\"Mario\"", (Object)this.toString((Node)binaryExpr.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)binaryExpr.getOperator());
        Expression right = ((BinaryExpr)bExpr).getRight();
        Assert.assertTrue((boolean)(right instanceof EnclosedExpr));
        Expression expression2 = ((EnclosedExpr)right).getInner();
        BinaryExpr binaryExpr2 = (BinaryExpr)expression2;
        Assert.assertEquals((Object)"age", (Object)this.toString((Node)binaryExpr2.getLeft()));
        Assert.assertEquals((Object)"20", (Object)this.toString((Node)binaryExpr2.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)binaryExpr2.getOperator());
    }

    @Test
    public void testBindingOnRight() {
        String expr = "$n : name == \"Mario\" && $a : age > 20";
        DrlxExpression drlxExpression = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression bExpr = drlxExpression.getExpr();
        Assert.assertTrue((boolean)(bExpr instanceof BinaryExpr));
        Expression left = ((BinaryExpr)bExpr).getLeft();
        Assert.assertTrue((boolean)(left instanceof DrlxExpression));
        DrlxExpression leftExpr = (DrlxExpression)left;
        SimpleName leftBind = leftExpr.getBind();
        Assert.assertEquals((Object)"$n", (Object)leftBind.asString());
        Expression expression = leftExpr.getExpr();
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)binaryExpr.getLeft()));
        Assert.assertEquals((Object)"\"Mario\"", (Object)this.toString((Node)binaryExpr.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)binaryExpr.getOperator());
        Expression right = ((BinaryExpr)bExpr).getRight();
        Assert.assertTrue((boolean)(right instanceof DrlxExpression));
        DrlxExpression rightExpr = (DrlxExpression)right;
        SimpleName rightBind = rightExpr.getBind();
        Assert.assertEquals((Object)"$a", (Object)rightBind.asString());
        BinaryExpr binaryExpr2 = (BinaryExpr)rightExpr.getExpr();
        Assert.assertEquals((Object)"age", (Object)this.toString((Node)binaryExpr2.getLeft()));
        Assert.assertEquals((Object)"20", (Object)this.toString((Node)binaryExpr2.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)binaryExpr2.getOperator());
    }

    @Test
    public void test3BindingOn3Conditions() {
        String expr = "$n : name == \"Mario\" && $a : age > 20 && $l : likes != null";
        DrlxExpression drlxExpression = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression bExpr = drlxExpression.getExpr();
        Assert.assertTrue((boolean)(bExpr instanceof BinaryExpr));
        Expression left = ((BinaryExpr)bExpr).getLeft();
        Assert.assertTrue((boolean)(left instanceof BinaryExpr));
        BinaryExpr leftExpr = (BinaryExpr)left;
        DrlxExpression first = (DrlxExpression)leftExpr.getLeft();
        DrlxExpression second = (DrlxExpression)leftExpr.getRight();
        DrlxExpression third = (DrlxExpression)((BinaryExpr)bExpr).getRight();
        SimpleName bind = first.getBind();
        Assert.assertEquals((Object)"$n", (Object)bind.asString());
        BinaryExpr binaryExpr = (BinaryExpr)first.getExpr();
        Assert.assertEquals((Object)"name", (Object)this.toString((Node)binaryExpr.getLeft()));
        Assert.assertEquals((Object)"\"Mario\"", (Object)this.toString((Node)binaryExpr.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)binaryExpr.getOperator());
        bind = second.getBind();
        Assert.assertEquals((Object)"$a", (Object)bind.asString());
        binaryExpr = (BinaryExpr)second.getExpr();
        Assert.assertEquals((Object)"age", (Object)this.toString((Node)binaryExpr.getLeft()));
        Assert.assertEquals((Object)"20", (Object)this.toString((Node)binaryExpr.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)binaryExpr.getOperator());
        bind = third.getBind();
        Assert.assertEquals((Object)"$l", (Object)bind.asString());
        binaryExpr = (BinaryExpr)third.getExpr();
        Assert.assertEquals((Object)"likes", (Object)this.toString((Node)binaryExpr.getLeft()));
        Assert.assertEquals((Object)"null", (Object)this.toString((Node)binaryExpr.getRight()));
        Assert.assertEquals((Object)BinaryExpr.Operator.NOT_EQUALS, (Object)binaryExpr.getOperator());
    }
}

