/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect.asm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.builder.dialect.asm.InvokerDataProvider;
import org.drools.core.rule.builder.dialect.asm.InvokerStub;
import org.drools.mvel.asm.ClassGenerator;
import org.drools.mvel.asm.InvokerContext;
import org.drools.mvel.asm.InvokerGenerator;
import org.junit.Assert;
import org.junit.Test;

public class InvokerGeneratorTest {
    @Test
    public void testGenerate() {
        HashMap<String, Object> invokerContext = new HashMap<String, Object>();
        invokerContext.put("package", "pkg");
        invokerContext.put("invokerClassName", "TestInvoker");
        invokerContext.put("ruleClassName", "TestRule");
        invokerContext.put("methodName", "testMethod");
        invokerContext.put("consequenceName", "TestConsequence");
        invokerContext.put("hashCode", 111);
        invokerContext.put("declarations", new Declaration[0]);
        invokerContext.put("globals", new String[]{"globalList"});
        invokerContext.put("globalTypes", new String[]{"java/util/List"});
        HashSet<String> imports = new HashSet<String>();
        imports.add("p1");
        imports.add("p2");
        ClassGenerator generator = InvokerGenerator.createStubGenerator((InvokerDataProvider)new InvokerContext(invokerContext), (ClassLoader)this.getClass().getClassLoader(), null, imports);
        generator.setInterfaces(new Class[]{InvokerStub.class});
        InvokerStub stub = (InvokerStub)generator.newInstance();
        Assert.assertEquals((Object)"pkg", (Object)stub.getPackageName());
        Assert.assertEquals((Object)"TestRule", (Object)stub.getRuleClassName());
        Assert.assertEquals((Object)"testMethod", (Object)stub.getMethodName());
        Assert.assertEquals((Object)"TestInvokerGenerated", (Object)stub.getGeneratedInvokerClassName());
        Assert.assertEquals((long)111L, (long)stub.hashCode());
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"globalList"}, stub.getGlobals()));
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"java/util/List"}, stub.getGlobalTypes()));
        List<String> importList = Arrays.asList(stub.getPackageImports());
        Assert.assertTrue((boolean)importList.contains("p1"));
        Assert.assertTrue((boolean)importList.contains("p2"));
    }
}

