/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.base.EvaluatorWrapper;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.constraint.ConditionEvaluator;
import org.drools.core.rule.constraint.EvaluatorHelper;
import org.drools.core.spi.Tuple;
import org.drools.mvel.ConditionAnalyzer;
import org.drools.mvel.expr.MVELCompilationUnit;
import org.drools.mvel.expr.MvelEvaluator;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.And;
import org.mvel2.ast.BooleanNode;
import org.mvel2.ast.Contains;
import org.mvel2.ast.LineLabel;
import org.mvel2.ast.LiteralNode;
import org.mvel2.ast.Negation;
import org.mvel2.ast.Or;
import org.mvel2.ast.Substatement;
import org.mvel2.compiler.Accessor;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableAccessor;
import org.mvel2.compiler.ExecutableLiteral;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.impl.refl.nodes.MethodAccessor;
import org.mvel2.util.ASTLinkedList;

public class MVELConditionEvaluator
implements ConditionEvaluator {
    private final Declaration[] declarations;
    private final EvaluatorWrapper[] operators;
    private final String conditionClass;
    private final ParserConfiguration parserConfiguration;
    private final ExecutableStatement executableStatement;
    private final MVELCompilationUnit compilationUnit;
    private final MvelEvaluator<Boolean> evaluator;
    private boolean evaluated = false;

    public MVELConditionEvaluator(ParserConfiguration configuration, String expression, Declaration[] declarations, EvaluatorWrapper[] operators, String conditionClass) {
        this(null, configuration, (ExecutableStatement)MVEL.compileExpression((String)expression, (ParserContext)new ParserContext(configuration)), declarations, operators, conditionClass);
    }

    public MVELConditionEvaluator(MVELCompilationUnit compilationUnit, ParserConfiguration parserConfiguration, ExecutableStatement executableStatement, Declaration[] declarations, EvaluatorWrapper[] operators, String conditionClass) {
        this.declarations = declarations;
        this.operators = operators;
        this.conditionClass = conditionClass;
        this.compilationUnit = compilationUnit;
        this.parserConfiguration = parserConfiguration;
        this.executableStatement = executableStatement;
        this.evaluator = MvelEvaluator.createMvelEvaluator((Serializable)executableStatement);
    }

    public boolean evaluate(InternalFactHandle handle, InternalWorkingMemory workingMemory, Tuple tuple) {
        return this.evaluate(this.evaluator, handle, workingMemory, tuple);
    }

    private boolean evaluate(MvelEvaluator<Boolean> evaluator, InternalFactHandle handle, InternalWorkingMemory workingMemory, Tuple tuple) {
        if (this.compilationUnit == null) {
            HashMap<String, Object> vars = EvaluatorHelper.valuesAsMap((Object)handle.getObject(), (InternalWorkingMemory)workingMemory, (Tuple)tuple, (Declaration[])this.declarations);
            if (this.operators.length > 0) {
                if (vars == null) {
                    vars = new HashMap<String, Object>();
                }
                InternalFactHandle[] handles = tuple != null ? tuple.toFactHandles() : new InternalFactHandle[]{};
                for (EvaluatorWrapper operator : this.operators) {
                    vars.put(operator.getBindingName(), operator);
                    operator.loadHandles(handles, handle);
                }
            }
            return this.evaluate(evaluator, handle.getObject(), vars);
        }
        VariableResolverFactory factory = this.compilationUnit.createFactory();
        this.compilationUnit.updateFactory(handle, tuple, null, workingMemory, workingMemory.getGlobalResolver(), factory);
        return evaluator.evaluate(handle.getObject(), factory);
    }

    private boolean evaluate(MvelEvaluator<Boolean> evaluator, Object object, Map<String, Object> vars) {
        return vars == null ? evaluator.evaluate(object).booleanValue() : evaluator.evaluate(object, vars).booleanValue();
    }

    ConditionAnalyzer.Condition getAnalyzedCondition(InternalFactHandle handle, InternalWorkingMemory workingMemory, Tuple leftTuple) {
        this.ensureCompleteEvaluation(handle, workingMemory, leftTuple);
        return new ConditionAnalyzer(this.executableStatement, this.declarations, this.operators, this.conditionClass).analyzeCondition();
    }

    private void ensureCompleteEvaluation(InternalFactHandle handle, InternalWorkingMemory workingMemory, Tuple tuple) {
        if (!this.evaluated) {
            ASTNode rootNode = MVELConditionEvaluator.getRootNode((Serializable)this.executableStatement);
            if (rootNode != null) {
                this.ensureCompleteEvaluation(rootNode, handle, workingMemory, tuple);
            }
            this.evaluated = true;
        }
    }

    private void ensureCompleteEvaluation(ASTNode node, InternalFactHandle handle, InternalWorkingMemory workingMemory, Tuple tuple) {
        if (!((node = MVELConditionEvaluator.unwrap(node)) instanceof And) && !(node instanceof Or)) {
            this.evaluateIfNecessary(handle, workingMemory, tuple, node);
            return;
        }
        this.ensureBranchEvaluation(handle, workingMemory, tuple, ((BooleanNode)node).getLeft());
        this.ensureBranchEvaluation(handle, workingMemory, tuple, ((BooleanNode)node).getRight());
    }

    private void ensureBranchEvaluation(InternalFactHandle handle, InternalWorkingMemory workingMemory, Tuple tuple, ASTNode node) {
        this.evaluateIfNecessary(handle, workingMemory, tuple, node);
        this.ensureCompleteEvaluation(node, handle, workingMemory, tuple);
    }

    private void evaluateIfNecessary(InternalFactHandle handle, InternalWorkingMemory workingMemory, Tuple tuple, ASTNode node) {
        if (!MVELConditionEvaluator.isEvaluated(node)) {
            ASTNode next = node.nextASTNode;
            node.nextASTNode = null;
            this.evaluate(MvelEvaluator.createMvelEvaluator(this.evaluator, (Serializable)this.asCompiledExpression(node)), handle, workingMemory, tuple);
            node.nextASTNode = next;
        }
    }

    private CompiledExpression asCompiledExpression(ASTNode node) {
        return new CompiledExpression(new ASTLinkedList(node), null, Object.class, this.parserConfiguration, false);
    }

    public static boolean isFullyEvaluated(Serializable executableStatement) {
        return MVELConditionEvaluator.isEvaluated(MVELConditionEvaluator.getRootNode(executableStatement));
    }

    private static boolean isEvaluated(ASTNode node) {
        AccessorNode nextNode;
        if ((node = MVELConditionEvaluator.unwrapSubstatement(node)) == null) {
            return true;
        }
        if (node instanceof Contains) {
            return ((Contains)node).getFirstStatement().getAccessor() != null;
        }
        if (node instanceof BooleanNode) {
            return MVELConditionEvaluator.isEvaluated(((BooleanNode)node).getLeft()) && MVELConditionEvaluator.isEvaluated(((BooleanNode)node).getRight());
        }
        Accessor accessor = node.getAccessor();
        if (accessor == null) {
            return node instanceof LiteralNode;
        }
        if (accessor instanceof AccessorNode && (nextNode = ((AccessorNode)accessor).getNextNode()) instanceof MethodAccessor && ((MethodAccessor)nextNode).getParms() != null) {
            for (ExecutableStatement param : ((MethodAccessor)nextNode).getParms()) {
                if (MVELConditionEvaluator.isFullyEvaluated((Serializable)param)) continue;
                return false;
            }
        }
        return true;
    }

    private static ASTNode getRootNode(Serializable executableStatement) {
        if (executableStatement instanceof ExecutableLiteral) {
            return null;
        }
        return executableStatement instanceof CompiledExpression ? ((CompiledExpression)executableStatement).getFirstNode() : ((ExecutableAccessor)executableStatement).getNode();
    }

    private static ASTNode unwrap(ASTNode node) {
        while (node instanceof Negation || node instanceof LineLabel || node instanceof Substatement) {
            node = MVELConditionEvaluator.unwrapNegation(node);
            node = MVELConditionEvaluator.unwrapSubstatement(node);
        }
        return node;
    }

    private static ASTNode unwrapNegation(ASTNode node) {
        if (node instanceof Negation) {
            ExecutableStatement statement = ((Negation)node).getStatement();
            return statement instanceof ExecutableAccessor ? ((ExecutableAccessor)statement).getNode() : null;
        }
        return node;
    }

    private static ASTNode unwrapSubstatement(ASTNode node) {
        if (node instanceof LineLabel) {
            return node.nextASTNode;
        }
        return node instanceof Substatement ? ((ExecutableAccessor)((Substatement)node).getStatement()).getNode() : node;
    }
}

