/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect.mvel;

import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.FromNodeLeftTuple;
import org.drools.core.reteoo.InitialFactImpl;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockLeftTupleSink;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Accumulate;
import org.drools.core.spi.Tuple;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.builder.MVELAccumulateBuilder;
import org.drools.mvel.builder.MVELDialect;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.expr.MVELCompileable;
import org.junit.Test;

public class MVELAccumulateBuilderTest {
    @Test
    public void testSimpleExpression() {
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl();
        pkgBuilder.addPackage(new PackageDescr("pkg1"));
        InternalKnowledgePackage pkg = pkgBuilder.getPackage("pkg1");
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        KnowledgeBuilderConfigurationImpl conf = pkgBuilder.getBuilderConfiguration();
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        RuleBuildContext context = new RuleBuildContext((DroolsAssemblerContext)pkgBuilder, ruleDescr, dialectRegistry, pkg, (Dialect)mvelDialect);
        AccumulateDescr accDescr = new AccumulateDescr();
        PatternDescr inputPattern = new PatternDescr("org.drools.mvel.compiler.Cheese", "$cheese");
        accDescr.setInputPattern(inputPattern);
        accDescr.setInitCode("total = 0;");
        accDescr.setActionCode("total += $cheese.price;");
        accDescr.setReverseCode("total -= $cheese.price;");
        accDescr.setResultCode("new Integer(total)");
        MVELAccumulateBuilder builder = new MVELAccumulateBuilder();
        Accumulate acc = (Accumulate)builder.build(context, (BaseDescr)accDescr);
        ((MVELCompileable)acc.getAccumulators()[0]).compile((MVELDialectRuntimeData)pkgBuilder.getPackageRegistry(pkg.getName()).getDialectRuntimeRegistry().getDialectData("mvel"));
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        BuildContext buildContext = new BuildContext(kBase);
        MockLeftTupleSink sink = new MockLeftTupleSink(buildContext);
        MockTupleSource source = new MockTupleSource(1, buildContext);
        source.setObjectCount(1);
        sink.setLeftTupleSource((LeftTupleSource)source);
        Cheese cheddar1 = new Cheese("cheddar", 10);
        Cheese cheddar2 = new Cheese("cheddar", 8);
        InternalFactHandle f0 = (InternalFactHandle)ksession.insert((Object)new InitialFactImpl());
        InternalFactHandle f1 = (InternalFactHandle)ksession.insert((Object)cheddar1);
        InternalFactHandle f2 = (InternalFactHandle)ksession.insert((Object)cheddar2);
        LeftTupleImpl tuple = new LeftTupleImpl(f0, (Sink)sink, true);
        Object wmContext = acc.createWorkingMemoryContext();
        AccumulateNode.AccumulateContext accContext = new AccumulateNode.AccumulateContext();
        Object funcContext = acc.createFunctionContext();
        funcContext = acc.init(wmContext, (Object)accContext, funcContext, (Tuple)tuple, (WorkingMemory)ksession);
        accContext.setFunctionContext(funcContext);
        Object value1 = acc.accumulate(wmContext, (Object)accContext, (Tuple)tuple, f1, (WorkingMemory)ksession);
        acc.accumulate(wmContext, (Object)accContext, (Tuple)tuple, f2, (WorkingMemory)ksession);
        Assertions.assertThat((Object)acc.getResult(wmContext, (Object)accContext, (Tuple)tuple, (WorkingMemory)ksession)).isEqualTo((Object)new Integer(18));
        FromNodeLeftTuple match = new FromNodeLeftTuple();
        match.setContextObject(value1);
        acc.tryReverse(wmContext, (Object)accContext, (Tuple)tuple, f1, null, (LeftTuple)match, (WorkingMemory)ksession);
        Assertions.assertThat((Object)acc.getResult(wmContext, (Object)accContext, (Tuple)tuple, (WorkingMemory)ksession)).isEqualTo((Object)new Integer(8));
    }
}

