/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.util.HashMap;
import org.drools.mvel.MVELSafeHelper;
import org.drools.mvel.SafeMVELEvaluator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mvel2.PropertyAccessException;

@Ignore(value="This test causes problems to surefire, so it will be disabled for now. It works when executed by itself.")
public class MVELSafeHelperTest {
    private static TestSecurityManager tsm;

    @BeforeClass
    public static void init() {
        String enginePolicy = MVELSafeHelperTest.class.getResource("engine.policy").getFile();
        String kiePolicy = MVELSafeHelperTest.class.getResource("kie.policy").getFile();
        System.setProperty("java.security.policy", enginePolicy);
        System.setProperty("kie.security.policy", kiePolicy);
        tsm = new TestSecurityManager();
        System.setSecurityManager(tsm);
    }

    @AfterClass
    public static void close() {
        System.setSecurityManager(null);
        System.setProperty("java.security.policy", "");
        System.setProperty("kie.security.policy", "");
    }

    @Test
    public void testUntrustedJavaConsequence() throws Exception {
        try {
            MVELSafeHelper.getEvaluator().eval("System.exit(0);");
            Assert.fail((String)"Should have raised an exception...");
        }
        catch (ShouldHavePrevented e) {
            Assert.fail((String)"The security policy for the rule should have prevented this from executing...");
        }
        catch (PropertyAccessException propertyAccessException) {
            // empty catch block
        }
    }

    @Test
    public void testReflectionAttack() throws Exception {
        String setup = "java.lang.reflect.Field field = org.drools.core.util.MVELSafeHelper.getDeclaredField(\"evaluator\");\nSystem.out.println(field);\nfield.setAccessible(true);\nfield.set(null, \"new org.drools.core.util.MVELSafeHelper.RawMVELEvaluator()\");";
        try {
            Assert.assertEquals((Object)SafeMVELEvaluator.class.getName(), (Object)MVELSafeHelper.getEvaluator().getClass().getName());
            MVELSafeHelper.getEvaluator().eval(setup, new HashMap());
            Assert.fail((String)"Should have raised an AccessControlException");
        }
        catch (PropertyAccessException propertyAccessException) {
            // empty catch block
        }
    }

    public void testReflectionOnFinal() throws Exception {
    }

    public static class StaticFinalHolder {
        private static final boolean FLAG = true;
    }

    public static class ShouldHavePrevented
    extends SecurityException {
        public ShouldHavePrevented(String message) {
            super(message);
        }
    }

    public static class TestSecurityManager
    extends SecurityManager {
        @Override
        public void checkExit(int status) {
            super.checkExit(status);
            throw new ShouldHavePrevented("The security policy should have prevented the call to System.exit()");
        }
    }

    public static class MaliciousExitHelper {
        public static int exit() {
            System.exit(0);
            return 0;
        }
    }
}

