/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect.java;

import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.RecognitionException;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.core.base.ClassObjectType;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.ImportDeclaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.AcceptsReadAccessor;
import org.drools.core.spi.CompiledInvoker;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.BindingDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.mvel.asm.AsmUtil;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.java.JavaAnalysisResult;
import org.drools.mvel.java.JavaExprAnalyzer;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.PropertySpecificOption;

public class JavaConsequenceBuilderPRAlwaysTest {
    private RuleBuildContext context;
    private RuleDescr ruleDescr;

    private void setupTest(String consequence, Map<String, Object> namedConsequences) {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("org.drools");
        pkg.addImport(new ImportDeclaration("org.drools.mvel.compiler.Cheese"));
        KnowledgeBuilderConfigurationImpl conf = new KnowledgeBuilderConfigurationImpl();
        conf.setOption((KnowledgeBuilderOption)PropertySpecificOption.ALWAYS);
        KnowledgeBuilderImpl kBuilder = new KnowledgeBuilderImpl(pkg, conf);
        this.ruleDescr = new RuleDescr("test consequence builder");
        this.ruleDescr.setConsequence((Object)consequence);
        for (Map.Entry<String, Object> entry : namedConsequences.entrySet()) {
            this.ruleDescr.addNamedConsequences(entry.getKey(), entry.getValue());
        }
        RuleImpl rule = RuleBuildContext.descrToRule((RuleDescr)this.ruleDescr);
        PackageRegistry pkgRegistry = kBuilder.getPackageRegistry(pkg.getName());
        DialectCompiletimeRegistry reg = kBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        this.context = new RuleBuildContext((DroolsAssemblerContext)kBuilder, this.ruleDescr, reg, pkg, reg.getDialect(pkgRegistry.getDialect()));
        rule.addPattern((RuleConditionElement)new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class), "$cheese"));
        Pattern p = new Pattern(1, (ObjectType)new ClassObjectType(Person.class), "$persone");
        Declaration declr = p.addDeclaration("age");
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor((RuleBuildContext)this.context, (BaseDescr)new BindingDescr("age", "age"), (Pattern)p, (String)"age", (AcceptsReadAccessor)declr, (boolean)true);
        rule.addPattern((RuleConditionElement)p);
        this.context.getDeclarationResolver().pushOnBuildStack((RuleConditionElement)rule.getLhs());
        this.context.getDialect().getConsequenceBuilder().build(this.context, "default");
        for (String name : namedConsequences.keySet()) {
            this.context.getDialect().getConsequenceBuilder().build(this.context, name);
        }
        this.context.getDialect().addRule(this.context);
        pkgRegistry.getPackage().addRule(this.context.getRule());
        kBuilder.compileAll();
        kBuilder.reloadAll();
    }

    @Test
    public void testFixExitPointsReferences() {
        String consequence = " System.out.println(\"this is a test\");\n  exitPoints[\"foo\"].insert( new Cheese() );\n  System.out.println(\"we are done with exitPoints\");\n ";
        this.setupTest(consequence, new HashMap<String, Object>());
        try {
            JavaExprAnalyzer analyzer = new JavaExprAnalyzer();
            JavaAnalysisResult analysis = analyzer.analyzeBlock((String)this.ruleDescr.getConsequence(), new BoundIdentifiers(new HashMap(), null));
            String fixed = AsmUtil.fixBlockDescr((RuleBuildContext)this.context, (JavaAnalysisResult)analysis, new HashMap());
            String expected = " System.out.println(\"this is a test\");\n  drools.getExitPoint(\"foo\").insert( new Cheese() );\n  System.out.println(\"we are done with exitPoints\");\n ";
            Assert.assertNotNull((String)this.context.getErrors().toString(), (Object)fixed);
            this.assertEqualsIgnoreSpaces(expected, fixed);
        }
        catch (RecognitionException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testFixEntryPointsReferences() {
        String consequence = " System.out.println(\"this is a test\");\n  entryPoints[\"foo\"].insert( new Cheese() );\n  System.out.println(\"we are done with entryPoints\");\n ";
        this.setupTest("", new HashMap<String, Object>());
        try {
            this.ruleDescr.setConsequence((Object)consequence);
            JavaExprAnalyzer analyzer = new JavaExprAnalyzer();
            JavaAnalysisResult analysis = analyzer.analyzeBlock((String)this.ruleDescr.getConsequence(), new BoundIdentifiers(new HashMap(), null));
            String fixed = AsmUtil.fixBlockDescr((RuleBuildContext)this.context, (JavaAnalysisResult)analysis, new HashMap());
            String expected = " System.out.println(\"this is a test\");\n  drools.getEntryPoint(\"foo\").insert( new Cheese() );\n  System.out.println(\"we are done with entryPoints\");\n ";
            Assert.assertNotNull((String)this.context.getErrors().toString(), (Object)fixed);
            this.assertEqualsIgnoreSpaces(expected, fixed);
        }
        catch (RecognitionException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testDefaultConsequenceCompilation() {
        String consequence = " System.out.println(\"this is a test\");\n ";
        this.setupTest(consequence, new HashMap<String, Object>());
        Assert.assertNotNull((Object)this.context.getRule().getConsequence());
        Assert.assertFalse((boolean)this.context.getRule().hasNamedConsequences());
        Assert.assertTrue((boolean)(this.context.getRule().getConsequence() instanceof CompiledInvoker));
        Assert.assertTrue((boolean)(this.context.getRule().getConsequence() instanceof Consequence));
    }

    @Test
    public void testDefaultConsequenceWithSingleNamedConsequenceCompilation() {
        String defaultCon = " System.out.println(\"this is a test\");\n ";
        HashMap<String, Object> namedConsequences = new HashMap<String, Object>();
        String name1 = " System.out.println(\"this is a test name1\");\n ";
        namedConsequences.put("name1", name1);
        this.setupTest(defaultCon, namedConsequences);
        Assert.assertTrue((boolean)(this.context.getRule().getConsequence() instanceof CompiledInvoker));
        Assert.assertTrue((boolean)(this.context.getRule().getConsequence() instanceof Consequence));
        Assert.assertTrue((boolean)(this.context.getRule().getNamedConsequence("name1") instanceof CompiledInvoker));
        Assert.assertTrue((boolean)(this.context.getRule().getNamedConsequence("name1") instanceof Consequence));
        Assert.assertNotSame((Object)this.context.getRule().getConsequence(), (Object)this.context.getRule().getNamedConsequence("name1"));
    }

    @Test
    public void testDefaultConsequenceWithMultipleNamedConsequenceCompilation() {
        String defaultCon = " System.out.println(\"this is a test\");\n ";
        HashMap<String, Object> namedConsequences = new HashMap<String, Object>();
        String name1 = " System.out.println(\"this is a test name1\");\n ";
        namedConsequences.put("name1", name1);
        String name2 = " System.out.println(\"this is a test name2\");\n ";
        namedConsequences.put("name2", name2);
        this.setupTest(defaultCon, namedConsequences);
        Assert.assertTrue((boolean)(this.context.getRule().getConsequence() instanceof CompiledInvoker));
        Assert.assertTrue((boolean)(this.context.getRule().getConsequence() instanceof Consequence));
        Assert.assertTrue((boolean)(this.context.getRule().getNamedConsequence("name1") instanceof CompiledInvoker));
        Assert.assertTrue((boolean)(this.context.getRule().getNamedConsequence("name1") instanceof Consequence));
        Assert.assertTrue((boolean)(this.context.getRule().getNamedConsequence("name2") instanceof CompiledInvoker));
        Assert.assertTrue((boolean)(this.context.getRule().getNamedConsequence("name2") instanceof Consequence));
        Assert.assertNotSame((Object)this.context.getRule().getConsequence(), (Object)this.context.getRule().getNamedConsequence("name1"));
        Assert.assertNotSame((Object)this.context.getRule().getConsequence(), (Object)this.context.getRule().getNamedConsequence("name2"));
        Assert.assertNotSame((Object)this.context.getRule().getNamedConsequence("name1"), (Object)this.context.getRule().getNamedConsequence("name2"));
    }

    private void assertEqualsIgnoreSpaces(String expected, String fixed) {
        Assert.assertEquals((Object)expected.replaceAll("\\s+", ""), (Object)fixed.replaceAll("\\s+", ""));
    }
}

