/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect.mvel;

import java.util.Collections;
import java.util.HashMap;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.core.WorkingMemory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.AgendaItemImpl;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockLeftTupleSink;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.Activation;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PatternExtractor;
import org.drools.core.spi.Salience;
import org.drools.core.spi.Tuple;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.builder.MVELDialect;
import org.drools.mvel.builder.MVELSalienceBuilder;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.rule.builder.dialect.mvel.InstrumentedDeclarationScopeResolver;
import org.drools.mvel.expr.MVELSalienceExpression;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.definition.rule.Rule;

public class MVELSalienceBuilderTest {
    private RuleBuildContext context;
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;

    @Before
    public void setUp() throws Exception {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("pkg1");
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        ruleDescr.addAttribute(new AttributeDescr("salience", "(p.age + 20)/2"));
        ruleDescr.setConsequence((Object)"");
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl(pkg);
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        this.context = new RuleBuildContext((DroolsAssemblerContext)pkgBuilder, ruleDescr, dialectRegistry, pkg, (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassObjectType personObjeectType = new ClassObjectType(Person.class);
        Pattern pattern = new Pattern(0, (ObjectType)personObjeectType);
        PatternExtractor extractor = new PatternExtractor((ObjectType)personObjeectType);
        Declaration declaration = new Declaration("p", (InternalReadAccessor)extractor, pattern);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("p", declaration);
        declarationResolver.setDeclarations(map);
        this.context.setDeclarationResolver((DeclarationScopeResolver)declarationResolver);
        this.kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext((RuleBase)this.kBase, Collections.emptyList());
        MVELSalienceBuilder salienceBuilder = new MVELSalienceBuilder();
        salienceBuilder.build(this.context);
        ((MVELSalienceExpression)this.context.getRule().getSalience()).compile((MVELDialectRuntimeData)this.context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel"));
    }

    @Test
    public void testSimpleExpression() {
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        Person p = new Person("mark", "", 31);
        InternalFactHandle f0 = (InternalFactHandle)ksession.insert((Object)p);
        MockLeftTupleSink sink = new MockLeftTupleSink(this.buildContext);
        MockTupleSource source = new MockTupleSource(1, this.buildContext);
        source.setObjectCount(1);
        sink.setLeftTupleSource((LeftTupleSource)source);
        LeftTupleImpl tuple = new LeftTupleImpl(f0, (Sink)sink, true);
        RuleTerminalNode rtn = new RuleTerminalNode();
        rtn.setSalienceDeclarations(this.context.getDeclarationResolver().getDeclarations(this.context.getRule()).values().toArray(new Declaration[1]));
        AgendaItemImpl item = new AgendaItemImpl(0L, (Tuple)tuple, 0, null, (TerminalNode)rtn, null);
        Assert.assertEquals((long)25L, (long)this.context.getRule().getSalience().getValue((Activation)item, (Rule)this.context.getRule(), (ReteEvaluator)ksession));
    }

    @Test
    public void testMultithreadSalienceExpression() {
        int i;
        int tcount = 10;
        SalienceEvaluator[] evals = new SalienceEvaluator[10];
        Thread[] threads = new Thread[10];
        for (i = 0; i < evals.length; ++i) {
            evals[i] = new SalienceEvaluator(this.kBase, this.context, (Rule)this.context.getRule(), this.context.getRule().getSalience(), new Person("bob" + i, 30 + i * 3));
            threads[i] = new Thread(evals[i]);
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int errors = 0;
        for (int i2 = 0; i2 < evals.length; ++i2) {
            if (!evals[i2].isError()) continue;
            ++errors;
        }
        Assert.assertEquals((String)"There shouldn't be any threads in error: ", (long)0L, (long)errors);
    }

    public static class SalienceEvaluator
    implements Runnable {
        public static final int iterations = 1000;
        private Salience salience;
        private Rule rule;
        private LeftTupleImpl tuple;
        private WorkingMemory wm;
        private final int result;
        private transient boolean halt;
        private RuleBuildContext context;
        private AgendaItem item;
        private boolean error;

        public SalienceEvaluator(InternalKnowledgeBase kBase, RuleBuildContext context, Rule rule, Salience salience, Person person) {
            this.wm = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
            this.context = context;
            InternalFactHandle f0 = (InternalFactHandle)this.wm.insert((Object)person);
            BuildContext buildContext = new BuildContext((RuleBase)kBase, Collections.emptyList());
            MockLeftTupleSink sink = new MockLeftTupleSink(buildContext);
            MockTupleSource source = new MockTupleSource(1, buildContext);
            source.setObjectCount(1);
            sink.setLeftTupleSource((LeftTupleSource)source);
            this.tuple = new LeftTupleImpl(f0, (Sink)sink, true);
            this.salience = salience;
            this.halt = false;
            this.error = false;
            this.result = (person.getAge() + 20) / 2;
            RuleTerminalNode rtn = new RuleTerminalNode();
            rtn.setSalienceDeclarations(context.getDeclarationResolver().getDeclarations(context.getRule()).values().toArray(new Declaration[1]));
            this.item = new AgendaItemImpl(0L, (Tuple)this.tuple, 0, null, (TerminalNode)rtn, null);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                for (int i = 0; i < 1000 && !this.halt; ++i) {
                    Assert.assertEquals((long)this.result, (long)this.salience.getValue((Activation)this.item, this.rule, (ReteEvaluator)this.wm));
                    Thread.currentThread();
                    Thread.yield();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.error = true;
            }
        }

        public void halt() {
            this.halt = true;
        }

        public boolean isError() {
            return this.error;
        }

        public void setError(boolean error) {
            this.error = error;
        }
    }
}

