/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.rule.builder.EvaluatorWrapper;
import org.drools.core.base.CoreComponentsBuilder;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Tuple;

public class EvaluatorHelper {
    private EvaluatorHelper() {
    }

    public static Map<String, Object> valuesAsMap(Object object, ReteEvaluator reteEvaluator, Tuple tuple, Declaration[] declarations) {
        if (declarations.length == 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Declaration declaration : declarations) {
            if (tuple == null) {
                map.put(declaration.getBindingName(), declaration.getExtractor().getValue(reteEvaluator, object));
                continue;
            }
            Object fact = tuple.getObject(declaration);
            map.put(declaration.getBindingName(), declaration.getExtractor().getValue(reteEvaluator, fact != null ? fact : object));
        }
        return map;
    }

    public static void initOperators(InternalFactHandle handle, Tuple tuple, EvaluatorWrapper[] operators) {
        InternalFactHandle[] handles = tuple != null ? tuple.toFactHandles() : new InternalFactHandle[]{};
        for (EvaluatorWrapper operator : operators) {
            operator.loadHandles(handles, handle);
        }
    }

    public static int arrayLenght(Object array) {
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        return 0;
    }

    public static boolean soundslike(String value1, String value2) {
        if (value1 == null || value2 == null) {
            return false;
        }
        String soundex1 = CoreComponentsBuilder.get().getMVELExecutor().soundex(value1);
        return soundex1 != null && soundex1.equals(CoreComponentsBuilder.get().getMVELExecutor().soundex(value2));
    }

    public static boolean contains(Object list, Object item) {
        if (list == null) {
            return false;
        }
        if (list instanceof Collection) {
            return ((Collection)list).contains(item);
        }
        if (list instanceof Object[]) {
            return EvaluatorHelper.arrayContains((Object[])list, item);
        }
        if (item == null) {
            return false;
        }
        if (list instanceof int[]) {
            return EvaluatorHelper.contains((int[])list, (int)((Integer)item));
        }
        if (list instanceof long[]) {
            return EvaluatorHelper.contains((long[])list, (long)((Long)item));
        }
        if (list instanceof double[]) {
            return EvaluatorHelper.contains((double[])list, (double)((Double)item));
        }
        if (list instanceof float[]) {
            return EvaluatorHelper.contains((float[])list, ((Float)item).floatValue());
        }
        if (list instanceof boolean[]) {
            return EvaluatorHelper.contains((boolean[])list, (boolean)((Boolean)item));
        }
        if (list instanceof byte[]) {
            return EvaluatorHelper.contains((byte[])list, (byte)((Byte)item));
        }
        if (list instanceof char[]) {
            return EvaluatorHelper.contains((char[])list, ((Character)item).charValue());
        }
        if (list instanceof short[]) {
            return EvaluatorHelper.contains((short[])list, (short)((Short)item));
        }
        return false;
    }

    private static boolean arrayContains(Object[] list, Object item) {
        for (Object i : list) {
            if (!i.equals(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object list, boolean primitiveItem) {
        if (list instanceof Collection) {
            return ((Collection)list).contains(primitiveItem);
        }
        return !list.getClass().getComponentType().isPrimitive() ? EvaluatorHelper.arrayContains((Object[])list, primitiveItem) : EvaluatorHelper.contains((boolean[])list, primitiveItem);
    }

    private static boolean contains(boolean[] list, boolean primitiveItem) {
        for (boolean i : list) {
            if (i != primitiveItem) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object list, int primitiveItem) {
        if (list instanceof Collection) {
            return ((Collection)list).contains(primitiveItem);
        }
        return !list.getClass().getComponentType().isPrimitive() ? EvaluatorHelper.arrayContains((Object[])list, primitiveItem) : EvaluatorHelper.contains((int[])list, primitiveItem);
    }

    private static boolean contains(int[] list, int primitiveItem) {
        for (int i : list) {
            if (i != primitiveItem) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object list, long primitiveItem) {
        if (list instanceof Collection) {
            return ((Collection)list).contains(primitiveItem);
        }
        return !list.getClass().getComponentType().isPrimitive() ? EvaluatorHelper.arrayContains((Object[])list, primitiveItem) : EvaluatorHelper.contains((long[])list, primitiveItem);
    }

    private static boolean contains(long[] list, long primitiveItem) {
        for (long i : list) {
            if (i != primitiveItem) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object list, double primitiveItem) {
        if (list instanceof Collection) {
            return ((Collection)list).contains(primitiveItem);
        }
        return !list.getClass().getComponentType().isPrimitive() ? EvaluatorHelper.arrayContains((Object[])list, primitiveItem) : EvaluatorHelper.contains((double[])list, primitiveItem);
    }

    private static boolean contains(double[] list, double primitiveItem) {
        for (double i : list) {
            if (i != primitiveItem) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object list, float primitiveItem) {
        if (list instanceof Collection) {
            return ((Collection)list).contains(Float.valueOf(primitiveItem));
        }
        return !list.getClass().getComponentType().isPrimitive() ? EvaluatorHelper.arrayContains((Object[])list, Float.valueOf(primitiveItem)) : EvaluatorHelper.contains((float[])list, primitiveItem);
    }

    private static boolean contains(float[] list, float primitiveItem) {
        for (float i : list) {
            if (i != primitiveItem) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object list, byte primitiveItem) {
        if (list instanceof Collection) {
            return ((Collection)list).contains(primitiveItem);
        }
        return !list.getClass().getComponentType().isPrimitive() ? EvaluatorHelper.arrayContains((Object[])list, primitiveItem) : EvaluatorHelper.contains((byte[])list, primitiveItem);
    }

    private static boolean contains(byte[] list, byte primitiveItem) {
        for (byte i : list) {
            if (i != primitiveItem) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object list, char primitiveItem) {
        if (list instanceof Collection) {
            return ((Collection)list).contains(Character.valueOf(primitiveItem));
        }
        return !list.getClass().getComponentType().isPrimitive() ? EvaluatorHelper.arrayContains((Object[])list, Character.valueOf(primitiveItem)) : EvaluatorHelper.contains((char[])list, primitiveItem);
    }

    private static boolean contains(char[] list, char primitiveItem) {
        for (char i : list) {
            if (i != primitiveItem) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object list, short primitiveItem) {
        if (list instanceof Collection) {
            return ((Collection)list).contains(primitiveItem);
        }
        return !list.getClass().getComponentType().isPrimitive() ? EvaluatorHelper.arrayContains((Object[])list, primitiveItem) : EvaluatorHelper.contains((short[])list, primitiveItem);
    }

    private static boolean contains(short[] list, short primitiveItem) {
        for (short i : list) {
            if (i != primitiveItem) continue;
            return true;
        }
        return false;
    }

    public static boolean coercingComparison(Object obj1, Object obj2, String op) {
        if (EvaluatorHelper.canCoerceToNumber(obj1, obj2)) {
            try {
                double d1 = EvaluatorHelper.toDouble(obj1);
                double d2 = EvaluatorHelper.toDouble(obj2);
                if (Double.isNaN(d1) || Double.isNaN(d2)) {
                    return false;
                }
                switch (op) {
                    case "<": {
                        return d1 < d2;
                    }
                    case "<=": {
                        return d1 <= d2;
                    }
                    case ">": {
                        return d1 > d2;
                    }
                    case ">=": {
                        return d1 >= d2;
                    }
                }
            }
            catch (NumberFormatException d1) {
                // empty catch block
            }
        }
        String s1 = obj1.toString();
        String s2 = obj2.toString();
        switch (op) {
            case "<": {
                return s1.compareTo(s2) < 0;
            }
            case "<=": {
                return s1.compareTo(s2) <= 0;
            }
            case ">": {
                return s1.compareTo(s2) > 0;
            }
            case ">=": {
                return s1.compareTo(s2) >= 0;
            }
        }
        throw new UnsupportedOperationException("Unable to compare " + obj1 + " and " + obj2);
    }

    private static boolean canCoerceToNumber(Object left, Object right) {
        return !(left instanceof String) || right instanceof Number;
    }

    private static double toDouble(Object obj) {
        return obj instanceof Number ? ((Number)obj).doubleValue() : Double.parseDouble(obj.toString());
    }
}

