/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import java.util.Map;
import org.drools.compiler.compiler.MissingDependencyError;
import org.drools.compiler.rule.builder.ConsequenceBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.core.common.MissingDependencyException;
import org.drools.core.rule.RuleConditionElement;
import org.drools.drl.parser.DroolsError;
import org.drools.mvel.asm.AsmUtil;
import org.drools.mvel.asm.KnowledgeHelperFixer;
import org.drools.mvel.java.JavaAnalysisResult;
import org.drools.mvel.java.JavaRuleBuilderHelper;

public abstract class AbstractASMConsequenceBuilder
implements ConsequenceBuilder {
    public void build(RuleBuildContext context, String consequenceName) {
        context.getDeclarationResolver().pushOnBuildStack((RuleConditionElement)context.getRule().getLhs());
        Map<String, Object> vars = this.consequenceContext(context, consequenceName);
        if (vars == null) {
            return;
        }
        JavaRuleBuilderHelper.generateMethodTemplate("consequenceMethod", context, vars);
        byte[] bytecode = this.createConsequenceBytecode(context, vars);
        JavaRuleBuilderHelper.registerInvokerBytecode(context, vars, bytecode, context.getRule());
        context.getDeclarationResolver().popBuildStack();
    }

    private Map<String, Object> consequenceContext(RuleBuildContext context, String consequenceName) {
        String className = consequenceName + "Consequence";
        Map decls = context.getDeclarationResolver().getDeclarations(context.getRule(), consequenceName);
        JavaAnalysisResult analysis = JavaRuleBuilderHelper.createJavaAnalysisResult(context, consequenceName, decls);
        if (analysis == null) {
            return null;
        }
        try {
            String fixedConsequence = KnowledgeHelperFixer.fix(AsmUtil.fixBlockDescr(context, analysis, decls));
            return JavaRuleBuilderHelper.createConsequenceContext(context, consequenceName, className, fixedConsequence, decls, analysis.getBoundIdentifiers());
        }
        catch (MissingDependencyException e) {
            context.addError((DroolsError)new MissingDependencyError(context.getRuleDescr().getResource(), e));
            return null;
        }
    }

    protected abstract byte[] createConsequenceBytecode(RuleBuildContext var1, Map<String, Object> var2);
}

