/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.core.util.asm.BeanInherit;
import org.drools.core.util.asm.InterfaceChild;
import org.drools.core.util.asm.InterfaceChildImpl;
import org.drools.core.util.asm.TestAbstract;
import org.drools.core.util.asm.TestInterface;
import org.drools.mvel.asm.ClassFieldInspectorImpl;
import org.junit.Test;

public class ClassFieldInspectorTest {
    @Test
    public void testIt() throws Exception {
        ClassFieldInspectorImpl ext = new ClassFieldInspectorImpl(Person.class);
        Assertions.assertThat((int)ext.getFieldNames().size()).isEqualTo(8);
        Assertions.assertThat((String)((Method)ext.getGetterMethods().get("age")).getName()).isEqualTo("getAge");
        Assertions.assertThat((String)((Method)ext.getGetterMethods().get("happy")).getName()).isEqualTo("isHappy");
        Assertions.assertThat((String)((Method)ext.getGetterMethods().get("name")).getName()).isEqualTo("getName");
        Map names = ext.getFieldNames();
        Assertions.assertThat((Map)names).isNotNull();
        Assertions.assertThat((int)names.size()).isEqualTo(8);
        Assertions.assertThat((Integer)((Integer)names.get("nAme"))).isNull();
    }

    @Test
    public void testInterface() throws Exception {
        ClassFieldInspectorImpl ext = new ClassFieldInspectorImpl(TestInterface.class);
        Assertions.assertThat((int)ext.getFieldNames().size()).isEqualTo(3);
        Assertions.assertThat((String)((Method)ext.getGetterMethods().get("something")).getName()).isEqualTo("getSomething");
        Assertions.assertThat((String)((Method)ext.getGetterMethods().get("another")).getName()).isEqualTo("getAnother");
        Map names = ext.getFieldNames();
        Assertions.assertThat((Map)names).isNotNull();
        Assertions.assertThat((int)names.size()).isEqualTo(3);
    }

    @Test
    public void testAbstract() throws Exception {
        ClassFieldInspectorImpl ext = new ClassFieldInspectorImpl(TestAbstract.class);
        Assertions.assertThat((int)ext.getFieldNames().size()).isEqualTo(6);
        Assertions.assertThat((String)((Method)ext.getGetterMethods().get("something")).getName()).isEqualTo("getSomething");
        Assertions.assertThat((String)((Method)ext.getGetterMethods().get("another")).getName()).isEqualTo("getAnother");
        Map names = ext.getFieldNames();
        Assertions.assertThat((Map)names).isNotNull();
        Assertions.assertThat((int)names.size()).isEqualTo(6);
    }

    @Test
    public void testInheritedFields() throws Exception {
        ClassFieldInspectorImpl ext = new ClassFieldInspectorImpl(BeanInherit.class);
        Assertions.assertThat((int)ext.getFieldNames().size()).isEqualTo(6);
        Assertions.assertThat((Object)((Field)ext.getFieldTypesField().get("text"))).isNotNull();
        Assertions.assertThat((Object)((Field)ext.getFieldTypesField().get("number"))).isNotNull();
        ext = new ClassFieldInspectorImpl(InterfaceChildImpl.class);
        Assertions.assertThat((int)ext.getFieldNames().size()).isEqualTo(9);
        Assertions.assertThat((Integer)((Integer)ext.getFieldNames().get("HTML"))).isNotNull();
        Assertions.assertThat((Object)((Field)ext.getFieldTypesField().get("HTML"))).isNotNull();
        Assertions.assertThat((Integer)((Integer)ext.getFieldNames().get("baz"))).isNotNull();
        Assertions.assertThat((Object)((Field)ext.getFieldTypesField().get("baz"))).isNotNull();
        Assertions.assertThat((Integer)((Integer)ext.getFieldNames().get("URI"))).isNotNull();
        Assertions.assertThat((Object)((Field)ext.getFieldTypesField().get("URI"))).isNotNull();
    }

    @Test
    public void testIntefaceInheritance() throws Exception {
        ClassFieldInspectorImpl ext = new ClassFieldInspectorImpl(InterfaceChild.class);
        Map fields = ext.getFieldNames();
        Assertions.assertThat((boolean)fields.containsKey("foo")).isTrue();
        Assertions.assertThat((boolean)fields.containsKey("bar")).isTrue();
        Assertions.assertThat((boolean)fields.containsKey("baz")).isTrue();
        Assertions.assertThat((boolean)fields.containsKey("URI")).isTrue();
    }

    @Test
    public void testFieldIndexCalculation() {
        try {
            ClassFieldInspectorImpl ext = new ClassFieldInspectorImpl(SubPerson.class);
            Map map = ext.getFieldNames();
            String[] fields = new String[map.size()];
            for (Map.Entry entry : map.entrySet()) {
                String fieldName = (String)entry.getKey();
                int fieldIndex = (Integer)entry.getValue();
                if (fields[fieldIndex] == null) {
                    fields[fieldIndex] = fieldName;
                    continue;
                }
                Assertions.fail((String)("Duplicate index found for 2 fields: index[" + fieldIndex + "] = [" + fields[fieldIndex] + "] and [" + fieldName + "]"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.fail((String)"Unexpected exception thrown");
        }
    }

    @Test
    public void testGetReturnTypes() throws Exception {
        ClassFieldInspectorImpl ext = new ClassFieldInspectorImpl(Person.class);
        Map types = ext.getFieldTypes();
        Assertions.assertThat((Map)types).isNotNull();
        Assertions.assertThat(types.get("happy")).isEqualTo(Boolean.TYPE);
        Assertions.assertThat(types.get("age")).isEqualTo(Integer.TYPE);
        Assertions.assertThat(types.get("name")).isEqualTo(String.class);
    }

    @Test
    public void testGetMethodForField() throws Exception {
        ClassFieldInspectorImpl ext = new ClassFieldInspectorImpl(Person.class);
        Map methods = ext.getGetterMethods();
        Assertions.assertThat((Map)methods).isNotNull();
        Assertions.assertThat((String)((Method)methods.get("happy")).getName()).isEqualTo("isHappy");
        Assertions.assertThat((String)((Method)methods.get("name")).getName()).isEqualTo("getName");
        Assertions.assertThat(methods.get("nAme")).isNull();
        Assertions.assertThat((String)((Method)methods.get("age")).getName()).isEqualTo("getAge");
    }

    @Test
    public void testNonGetter() throws Exception {
        ClassFieldInspectorImpl ext = new ClassFieldInspectorImpl(NonGetter.class);
        Map methods = ext.getGetterMethods();
        Assertions.assertThat((String)((Method)methods.get("foo")).getName()).isEqualTo("getFoo");
        Assertions.assertThat((int)methods.size()).isEqualTo(5);
        Assertions.assertThat((boolean)ext.getFieldNames().containsKey("foo")).isTrue();
        Assertions.assertThat((boolean)ext.getFieldNames().containsKey("baz")).isTrue();
        Assertions.assertThat((Class)((Class)ext.getFieldTypes().get("foo"))).isEqualTo(String.class);
    }

    @Test
    public void testWierdCapsForField() throws Exception {
        ClassFieldInspectorImpl ext = new ClassFieldInspectorImpl(Person.class);
        Map methods = ext.getGetterMethods();
        Assertions.assertThat((String)((Method)methods.get("URI")).getName()).isEqualTo("getURI");
        Assertions.assertThat((int)methods.size()).isEqualTo(7);
    }

    @Test
    public void testOverridingMethodWithCovariantReturnType() throws Exception {
        ClassFieldInspectorImpl ext = new ClassFieldInspectorImpl(SuperCar.class);
        Class engine = (Class)ext.getFieldTypes().get("engine");
        Assertions.assertThat((Class)engine).isEqualTo(SuperEngine.class);
    }

    static class SuperEngine
    extends NormalEngine {
        SuperEngine() {
        }
    }

    static class NormalEngine {
        NormalEngine() {
        }
    }

    static class SuperCar
    extends Car {
        SuperCar() {
        }

        @Override
        public SuperEngine getEngine() {
            return new SuperEngine();
        }
    }

    static class Car
    extends Vehicle<NormalEngine> {
        Car() {
        }

        @Override
        public NormalEngine getEngine() {
            return new NormalEngine();
        }
    }

    static class Vehicle<T> {
        private T engine;

        Vehicle() {
        }

        public T getEngine() {
            return this.engine;
        }
    }

    static class SubPerson {
        private int childField;

        SubPerson() {
        }

        public int getChildField() {
            return this.childField;
        }

        public void setChildField(int childField) {
            this.childField = childField;
        }
    }

    static class Person {
        public static String aStaticString = "A static String";
        private boolean happy;
        private String name;
        private int age;
        private String URI;

        Person() {
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public boolean isHappy() {
            return this.happy;
        }

        public void setHappy(boolean happy) {
            this.happy = happy;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void getNotAGetter() {
        }

        private boolean isBogus() {
            return false;
        }

        public String getAlsoBad(String s) {
            return "ignored";
        }

        public String getURI() {
            return this.URI;
        }

        public void setURI(String URI) {
            this.URI = URI;
        }
    }

    static class NonGetter {
        NonGetter() {
        }

        public int foo() {
            return 42;
        }

        public String getFoo() {
            return "foo";
        }

        public String baz() {
            return "";
        }

        public void bas() {
        }
    }
}

