/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import java.io.Serializable;
import java.util.Map;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.drools.mvel.asm.LambdaIntrospector;
import org.drools.mvel.compiler.Person;
import org.junit.Test;

public class LambdaIntrospectorTest {
    @Test
    public void testLambdaFingerprint() {
        LambdaIntrospector lambdaIntrospector = new LambdaIntrospector();
        Predicate1<Person> predicate1 = p -> p.getAge() > 35;
        String fingerprint = lambdaIntrospector.apply(predicate1);
        Assertions.assertThat((boolean)fingerprint.contains("ALOAD 0")).isTrue();
        Assertions.assertThat((boolean)fingerprint.contains("INVOKEVIRTUAL org/drools/mvel/compiler/Person.getAge()I")).isTrue();
    }

    @Test
    public void testMaterializedLambdaFingerprint() {
        LambdaIntrospector lambdaIntrospector = new LambdaIntrospector();
        String fingerprint = lambdaIntrospector.apply((Object)LambdaPredicate21D56248F6A2E8DA3990031D77D229DD.INSTANCE);
        Assertions.assertThat((String)fingerprint).isEqualTo("4DEB93975D9859892B1A5FD4B38E2155");
    }

    @Test
    public void testMethodFingerprintsMapCacheSize() throws Exception {
        Map methodFingerprintsMapPerClassLoader = LambdaIntrospector.getMethodFingerprintsMapPerClassLoader();
        methodFingerprintsMapPerClassLoader.clear();
        LambdaIntrospector lambdaIntrospector = new LambdaIntrospector();
        Predicate1<Person> predicate1 = p -> p.getAge() > 35;
        lambdaIntrospector.apply(predicate1);
        LambdaIntrospector.ClassesFingerPrintsCache methodFingerprintsMap = (LambdaIntrospector.ClassesFingerPrintsCache)methodFingerprintsMapPerClassLoader.get(predicate1.getClass().getClassLoader());
        Assertions.assertThat((int)methodFingerprintsMap.size()).isEqualTo(1);
    }

    public static interface Predicate1<A>
    extends Serializable {
        public boolean test(A var1) throws Exception;

        default public Predicate1<A> negate() {
            return a -> !this.test(a);
        }

        public static class Impl<A>
        implements Predicate1<A>,
        Supplier<Object> {
            private final Predicate1<A> predicate;

            public Impl(Predicate1<A> predicate) {
                this.predicate = predicate;
            }

            @Override
            public boolean test(A a) throws Exception {
                return this.predicate.test(a);
            }

            @Override
            public Object get() {
                return this.predicate;
            }
        }
    }

    public static enum LambdaPredicate21D56248F6A2E8DA3990031D77D229DD implements Predicate1<Person>
    {
        INSTANCE;

        public static final String EXPRESSION_HASH = "4DEB93975D9859892B1A5FD4B38E2155";

        @Override
        public boolean test(Person p) {
            return p.getAge() > 35;
        }
    }
}

