/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect.mvel;

import java.util.Collections;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.reteoo.JoinNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockLeftTupleSink;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.accessor.DeclarationScopeResolver;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.EvalDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.accessors.ClassFieldAccessorStore;
import org.drools.mvel.accessors.ClassFieldReader;
import org.drools.mvel.builder.MVELDialect;
import org.drools.mvel.builder.MVELEvalBuilder;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.rule.builder.dialect.mvel.InstrumentedDeclarationScopeResolver;
import org.drools.mvel.expr.MVELEvalExpression;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.rule.FactHandle;

public class MVELEvalBuilderTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testSimpleExpression() {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("pkg1");
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl(pkg);
        KnowledgeBuilderConfigurationImpl conf = pkgBuilder.getBuilderConfiguration();
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        RuleBuildContext context = new RuleBuildContext((TypeDeclarationContext)pkgBuilder, ruleDescr, dialectRegistry, pkg, (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "price");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Integer.TYPE));
        Declaration declaration = new Declaration("a", (ReadAccessor)extractor, pattern);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("a", declaration);
        declarationResolver.setDeclarations(map);
        context.setDeclarationResolver((DeclarationScopeResolver)declarationResolver);
        EvalDescr evalDescr = new EvalDescr();
        evalDescr.setContent((Object)"a == 10");
        MVELEvalBuilder builder = new MVELEvalBuilder();
        EvalCondition eval = (EvalCondition)builder.build(context, (BaseDescr)evalDescr);
        ((MVELEvalExpression)eval.getEvalExpression()).compile((MVELDialectRuntimeData)pkgBuilder.getPackageRegistry(pkg.getName()).getDialectRuntimeRegistry().getDialectData("mvel"));
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        BuildContext buildContext = new BuildContext((RuleBase)kBase, Collections.emptyList());
        MockLeftTupleSink sink = new MockLeftTupleSink(buildContext);
        MockTupleSource source = new MockTupleSource(1, buildContext);
        source.setObjectCount(1);
        sink.setLeftTupleSource((LeftTupleSource)source);
        Cheese cheddar = new Cheese("cheddar", 10);
        InternalFactHandle f0 = (InternalFactHandle)ksession.insert((Object)cheddar);
        JoinNodeLeftTuple tuple = new JoinNodeLeftTuple(f0, (Sink)sink, true);
        f0.removeLeftTuple((LeftTuple)tuple);
        Object evalContext = eval.createContext();
        Assertions.assertThat((boolean)eval.isAllowed((Tuple)tuple, (ReteEvaluator)ksession, evalContext)).isTrue();
        cheddar.setPrice(9);
        ksession.update((FactHandle)f0, (Object)cheddar);
        Assertions.assertThat((boolean)eval.isAllowed((Tuple)tuple, (ReteEvaluator)ksession, evalContext)).isFalse();
    }
}

