/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.builder;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.rule.builder.FromBuilder;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.From;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.rule.accessor.DataProvider;
import org.drools.core.rule.accessor.DeclarationScopeResolver;
import org.drools.core.rule.accessor.Wireable;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.FromDescr;
import org.drools.drl.parser.DroolsError;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.asm.AsmUtil;
import org.drools.mvel.builder.MVELDialect;
import org.drools.mvel.dataproviders.MVELDataProvider;
import org.drools.mvel.expr.MVELCompilationUnit;

public class MVELFromBuilder
implements FromBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        String text = ((FromDescr)descr).getExpression();
        Optional entryPointId = context.getEntryPointId(text);
        if (entryPointId.isPresent()) {
            return (RuleConditionElement)entryPointId.get();
        }
        MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
        boolean typeSafe = context.isTypesafe();
        if (!dialect.isStrictMode()) {
            context.setTypesafe(false);
        }
        try {
            Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
            AnalysisResult analysis = dialect.analyzeExpression((PackageBuildContext)context, descr, text, new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses((Map)decls), (PackageBuildContext)context));
            if (analysis == null) {
                RuleConditionElement ruleConditionElement = null;
                return ruleConditionElement;
            }
            Class returnType = analysis.getReturnType();
            if (prefixPattern != null && !prefixPattern.isCompatibleWithFromReturnType(returnType)) {
                context.addError((DroolsError)new DescrBuildError(descr, (BaseDescr)context.getRuleDescr(), null, "Pattern of type: '" + prefixPattern.getObjectType() + "' on rule '" + context.getRuleDescr().getName() + "' is not compatible with type " + returnType.getCanonicalName() + " returned by source"));
                RuleConditionElement ruleConditionElement = null;
                return ruleConditionElement;
            }
            BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
            Declaration[] declarations = new Declaration[usedIdentifiers.getDeclrClasses().size()];
            int j = 0;
            for (String str : usedIdentifiers.getDeclrClasses().keySet()) {
                declarations[j++] = (Declaration)decls.get(str);
            }
            Arrays.sort(declarations, RuleTerminalNode.SortDeclarations.instance);
            MVELCompilationUnit unit = MVELDialect.getMVELCompilationUnit(text, analysis, declarations, null, null, (PackageBuildContext)context, "drools", KnowledgeHelper.class, false, MVELCompilationUnit.Scope.CONSEQUENCE);
            MVELDataProvider dataProvider = new MVELDataProvider(unit, context.getDialect().getId());
            From from = new From((DataProvider)dataProvider);
            from.setResultPattern(prefixPattern);
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            data.addCompileable((Wireable)from, dataProvider);
            dataProvider.compile(data, context.getRule());
            From from2 = from;
            return from2;
        }
        catch (Exception e) {
            AsmUtil.copyErrorLocation(e, descr);
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), descr, null, "Unable to build expression for 'from' : " + e.getMessage() + " '" + text + "'"));
            RuleConditionElement ruleConditionElement = null;
            return ruleConditionElement;
        }
        finally {
            context.setTypesafe(typeSafe);
        }
    }
}

