/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.common.InternalAgenda;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.integrationtests.SerializationHelper;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.Option;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.definition.KnowledgeDescr;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonTestMethodBase {
    private static Logger logger = LoggerFactory.getLogger(CommonTestMethodBase.class);

    protected KieSession createKieSession(KieBase kbase) {
        return kbase.newKieSession();
    }

    protected KieSession createKieSession(KieBase kbase, KieSessionOption option) {
        KieSessionConfiguration ksconf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((Option)option);
        return kbase.newKieSession(ksconf, null);
    }

    protected KieSession createKieSession(KieBase kbase, KieSessionConfiguration sessionConfiguration, Environment env) {
        return kbase.newKieSession(sessionConfiguration, env);
    }

    protected KieSession createKnowledgeSession(KieBase kbase) {
        return kbase.newKieSession();
    }

    protected KieSession createKnowledgeSession(KieBase kbase, KieSessionOption option) {
        KieSessionConfiguration ksconf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((Option)option);
        return kbase.newKieSession(ksconf, null);
    }

    protected KieSession createKnowledgeSession(KieBase kbase, KieSessionConfiguration ksconf) {
        return kbase.newKieSession(ksconf, null);
    }

    protected KieSession createKnowledgeSession(KieBase kbase, KieSessionConfiguration ksconf, Environment env) {
        return kbase.newKieSession(ksconf, env);
    }

    protected StatelessKieSession createStatelessKnowledgeSession(KieBase kbase) {
        return kbase.newStatelessKieSession();
    }

    protected KieBase loadKnowledgeBaseFromString(String ... drlContentStrings) {
        return this.loadKnowledgeBaseFromString((KnowledgeBuilderConfiguration)null, (KieBaseConfiguration)null, drlContentStrings);
    }

    protected KieBase loadKnowledgeBaseFromString(KnowledgeBuilderConfiguration config, String ... drlContentStrings) {
        return this.loadKnowledgeBaseFromString(config, (KieBaseConfiguration)null, drlContentStrings);
    }

    protected KieBase loadKnowledgeBaseFromString(KieBaseConfiguration kBaseConfig, String ... drlContentStrings) {
        return this.loadKnowledgeBaseFromString(null, kBaseConfig, drlContentStrings);
    }

    protected KieBase loadKnowledgeBaseFromString(KnowledgeBuilderConfiguration config, KieBaseConfiguration kBaseConfig, String ... drlContentStrings) {
        KnowledgeBuilder kbuilder = config == null ? KnowledgeBuilderFactory.newKnowledgeBuilder() : KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)config);
        for (String drlContentString : drlContentStrings) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drlContentString.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        if (kBaseConfig == null) {
            kBaseConfig = RuleBaseFactory.newKnowledgeBaseConfiguration();
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((RuleBase)(kBaseConfig == null ? RuleBaseFactory.newRuleBase() : RuleBaseFactory.newRuleBase((KieBaseConfiguration)kBaseConfig)));
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    protected KieBase loadKnowledgeBase(KnowledgeBuilderConfiguration kbuilderConf, KieBaseConfiguration kbaseConf, String ... classPathResources) {
        Collection<KiePackage> knowledgePackages = this.loadKnowledgePackages(kbuilderConf, classPathResources);
        if (kbaseConf == null) {
            kbaseConf = RuleBaseFactory.newKnowledgeBaseConfiguration();
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((RuleBase)RuleBaseFactory.newRuleBase((KieBaseConfiguration)kbaseConf));
        kbase.addPackages(knowledgePackages);
        try {
            kbase = (InternalKnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return kbase;
    }

    protected KieBase loadKnowledgeBase(PackageDescr descr) {
        return this.loadKnowledgeBase(null, null, descr);
    }

    protected KieBase loadKnowledgeBase(KnowledgeBuilderConfiguration kbuilderConf, KieBaseConfiguration kbaseConf, PackageDescr descr) {
        Collection<KiePackage> knowledgePackages = this.loadKnowledgePackages(kbuilderConf, descr);
        if (kbaseConf == null) {
            kbaseConf = RuleBaseFactory.newKnowledgeBaseConfiguration();
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((RuleBase)RuleBaseFactory.newRuleBase((KieBaseConfiguration)kbaseConf));
        kbase.addPackages(knowledgePackages);
        try {
            kbase = (InternalKnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return kbase;
    }

    public Collection<KiePackage> loadKnowledgePackages(String ... classPathResources) {
        return this.loadKnowledgePackages((KnowledgeBuilderConfiguration)null, classPathResources);
    }

    public Collection<KiePackage> loadKnowledgePackages(PackageDescr descr) {
        return this.loadKnowledgePackages(null, descr);
    }

    public Collection<KiePackage> loadKnowledgePackages(KnowledgeBuilderConfiguration kbuilderConf, PackageDescr descr) {
        if (kbuilderConf == null) {
            kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbuilderConf);
        kbuilder.add(ResourceFactory.newDescrResource((KnowledgeDescr)descr), ResourceType.DESCR);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        Collection knowledgePackages = kbuilder.getKnowledgePackages();
        return knowledgePackages;
    }

    public Collection<KiePackage> loadKnowledgePackages(KnowledgeBuilderConfiguration kbuilderConf, String ... classPathResources) {
        return this.loadKnowledgePackages(kbuilderConf, true, classPathResources);
    }

    public Collection<KiePackage> loadKnowledgePackages(KnowledgeBuilderConfiguration kbuilderConf, boolean serialize, String ... classPathResources) {
        Collection knowledgePackages;
        if (kbuilderConf == null) {
            kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbuilderConf);
        for (String classPathResource : classPathResources) {
            kbuilder.add(ResourceFactory.newClassPathResource((String)classPathResource, this.getClass()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        if (serialize) {
            try {
                knowledgePackages = (Collection)SerializationHelper.serializeObject((Object)kbuilder.getKnowledgePackages(), (ClassLoader)((KnowledgeBuilderConfigurationImpl)kbuilderConf).getClassLoader());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            knowledgePackages = kbuilder.getKnowledgePackages();
        }
        return knowledgePackages;
    }

    public Collection<KiePackage> loadKnowledgePackagesFromString(String ... content) {
        return this.loadKnowledgePackagesFromString((KnowledgeBuilderConfiguration)null, content);
    }

    public Collection<KiePackage> loadKnowledgePackagesFromString(KnowledgeBuilderConfiguration kbuilderConf, String ... content) {
        if (kbuilderConf == null) {
            kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbuilderConf);
        for (String r : content) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])r.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        Collection knowledgePackages = kbuilder.getKnowledgePackages();
        return knowledgePackages;
    }

    protected KieBase loadKnowledgeBase(KnowledgeBuilderConfiguration kbuilderConf, String ... classPathResources) {
        return this.loadKnowledgeBase(kbuilderConf, (KieBaseConfiguration)null, classPathResources);
    }

    protected KieBase loadKnowledgeBase(KieBaseConfiguration kbaseConf, String ... classPathResources) {
        return this.loadKnowledgeBase(null, kbaseConf, classPathResources);
    }

    protected KieBase getKnowledgeBase() {
        KieBaseConfiguration kBaseConfig = RuleBaseFactory.newKnowledgeBaseConfiguration();
        return this.getKnowledgeBase(kBaseConfig);
    }

    protected KieBase getKnowledgeBase(KieBaseConfiguration kBaseConfig) {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((RuleBase)RuleBaseFactory.newRuleBase((KieBaseConfiguration)kBaseConfig));
        try {
            kbase = (KieBase)SerializationHelper.serializeObject((Object)kbase, (ClassLoader)kbase.getRootClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return kbase;
    }

    protected KieBase loadKnowledgeBase(String ... classPathResources) {
        return this.loadKnowledgeBase((KnowledgeBuilderConfiguration)null, (KieBaseConfiguration)null, classPathResources);
    }

    protected InternalAgenda getInternalAgenda(StatefulKnowledgeSession session) {
        return (InternalAgenda)session.getAgenda();
    }

    protected void waitBusy(long waitDuration) {
        long waitEndTime = System.currentTimeMillis() + waitDuration;
        while (System.currentTimeMillis() < waitEndTime) {
        }
    }

    protected void testInvalidDrl(String drl) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            logger.warn(kbuilder.getErrors().toString());
        }
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isTrue();
    }

    public static byte[] createJar(KieServices ks, ReleaseId releaseId, String ... drls) {
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId);
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            kfs.write("src/main/resources/r" + i + ".drl", drls[i]);
        }
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).as(kb.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).toString(), new Object[0])).isFalse();
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        return jar;
    }

    public static KieModule createAndDeployJar(KieServices ks, ReleaseId releaseId, String ... drls) {
        byte[] jar = CommonTestMethodBase.createJar(ks, releaseId, drls);
        KieModule km = CommonTestMethodBase.deployJarIntoRepository(ks, jar);
        return km;
    }

    public static KieModule createAndDeployJar(KieServices ks, String kmoduleContent, ReleaseId releaseId, Resource ... resources) {
        return CommonTestMethodBase.createAndDeployJar(ks, kmoduleContent, (String o) -> true, releaseId, resources);
    }

    public static KieModule createAndDeployJar(KieServices ks, String kmoduleContent, Predicate<String> classFilter, ReleaseId releaseId, Resource ... resources) {
        byte[] jar = CommonTestMethodBase.createJar(ks, kmoduleContent, classFilter, releaseId, resources);
        KieModule km = CommonTestMethodBase.deployJarIntoRepository(ks, jar);
        return km;
    }

    public static byte[] createJar(KieServices ks, String kmoduleContent, Predicate<String> classFilter, ReleaseId releaseId, Resource ... resources) {
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).writeKModuleXML(kmoduleContent);
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] == null) continue;
            kfs.write(resources[i]);
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        ((InternalKieBuilder)kieBuilder).buildAll(classFilter);
        Results results = kieBuilder.getResults();
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new IllegalStateException(results.getMessages(new Message.Level[]{Message.Level.ERROR}).toString());
        }
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        return jar;
    }

    private static KieModule deployJarIntoRepository(KieServices ks, byte[] jar) {
        Resource jarRes = ks.getResources().newByteArrayResource(jar);
        KieModule km = ks.getRepository().addKieModule(jarRes, new Resource[0]);
        return km;
    }

    public static byte[] createKJar(KieServices ks, ReleaseId releaseId, Resource pom, Resource ... resources) {
        KieFileSystem kfs = ks.newKieFileSystem();
        if (pom != null) {
            kfs.write(pom);
        } else {
            kfs.generateAndWritePomXML(releaseId);
        }
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] == null) continue;
            kfs.write(resources[i]);
        }
        ks.newKieBuilder(kfs).buildAll();
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        return jar;
    }

    public static byte[] createKJar(KieServices ks, ReleaseId releaseId, String pom, String ... drls) {
        return CommonTestMethodBase.createKJar(ks, null, releaseId, pom, drls);
    }

    public static byte[] createKJar(KieServices ks, KieModuleModel kproj, ReleaseId releaseId, String pom, String ... drls) {
        KieFileSystem kfs = ks.newKieFileSystem();
        if (kproj != null) {
            kfs.writeKModuleXML(kproj.toXML());
        }
        if (pom != null) {
            kfs.write("pom.xml", pom);
        } else {
            kfs.generateAndWritePomXML(releaseId);
        }
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            kfs.write("src/main/resources/r" + i + ".drl", drls[i]);
        }
        return CommonTestMethodBase.buildKJar(ks, kfs, releaseId);
    }

    public static byte[] buildKJar(KieServices ks, KieFileSystem kfs, ReleaseId releaseId) {
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            for (Message result : kb.getResults().getMessages()) {
                System.out.println(result.getText());
            }
            return null;
        }
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        return jar;
    }

    public static KieModule deployJar(KieServices ks, byte[] jar) {
        Resource jarRes = ks.getResources().newByteArrayResource(jar);
        KieModule km = ks.getRepository().addKieModule(jarRes, new Resource[0]);
        return km;
    }

    public static KieSession marshallAndUnmarshall(KieServices ks, KieBase kbase, KieSession ksession) {
        return CommonTestMethodBase.marshallAndUnmarshall(ks, kbase, ksession, null);
    }

    public static KieSession marshallAndUnmarshall(KieServices ks, KieBase kbase, KieSession ksession, KieSessionConfiguration sessionConfig) {
        try {
            Marshaller marshaller = ks.getMarshallers().newMarshaller(kbase);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshall((OutputStream)baos, ksession);
            marshaller = MarshallerFactory.newMarshaller((KieBase)kbase);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
            ksession = marshaller.unmarshall((InputStream)bais, sessionConfig, null);
            bais.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("unexpected exception :" + e.getMessage()));
        }
        return ksession;
    }

    public KieSession genSession(String source) {
        return this.genSession(new String[]{source}, 0);
    }

    public KieSession genSession(String source, int numerrors) {
        return this.genSession(new String[]{source}, numerrors);
    }

    public KieSession genSession(String[] sources, int numerrors) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String source : sources) {
            kbuilder.add(ResourceFactory.newClassPathResource((String)source, this.getClass()), ResourceType.DRL);
        }
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (kbuilder.getErrors().size() > 0) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                System.err.println(error);
            }
        }
        Assertions.assertThat((int)errors.size()).isEqualTo(numerrors);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return this.createKnowledgeSession((KieBase)kbase);
    }
}

