/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import org.assertj.core.api.Assertions;
import org.drools.mvel.asm.KnowledgeHelperFixer;
import org.junit.Test;

public class KnowledgeHelperFixerTest {
    private static final KnowledgeHelperFixer fixer = new KnowledgeHelperFixer();

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        Assertions.assertThat((String)expected).isEqualToIgnoringWhitespace((CharSequence)actual);
    }

    @Test
    public void testAdd__Handle__Simple() {
        String result = KnowledgeHelperFixer.fix((String)"update(myObject );");
        this.assertEqualsIgnoreWhitespace("drools.update(myObject );", result);
        result = KnowledgeHelperFixer.fix((String)"update ( myObject );");
        this.assertEqualsIgnoreWhitespace("drools.update( myObject );", result);
    }

    @Test
    public void testAdd__Handle__withNewLines() {
        String result = KnowledgeHelperFixer.fix((String)"\n\t\n\tupdate( myObject );");
        this.assertEqualsIgnoreWhitespace("\n\t\n\tdrools.update( myObject );", result);
    }

    @Test
    public void testAdd__Handle__rComplex() {
        String result = KnowledgeHelperFixer.fix((String)"something update( myObject); other");
        this.assertEqualsIgnoreWhitespace("something drools.update( myObject); other", result);
        result = KnowledgeHelperFixer.fix((String)"something update ( myObject );");
        this.assertEqualsIgnoreWhitespace("something drools.update( myObject );", result);
        result = KnowledgeHelperFixer.fix((String)" update( myObject ); x");
        this.assertEqualsIgnoreWhitespace(" drools.update( myObject ); x", result);
        result = KnowledgeHelperFixer.fix((String)"xxupdate(myObject ) x");
        this.assertEqualsIgnoreWhitespace("xxupdate(myObject ) x", result);
    }

    @Test
    public void testMultipleMatches() {
        String result = KnowledgeHelperFixer.fix((String)"update(myObject); update(myObject );");
        this.assertEqualsIgnoreWhitespace("drools.update(myObject); drools.update(myObject );", result);
        result = KnowledgeHelperFixer.fix((String)"xxx update(myObject ); update( myObject ); update( yourObject ); yyy");
        this.assertEqualsIgnoreWhitespace("xxx drools.update(myObject ); drools.update( myObject ); drools.update( yourObject ); yyy", result);
    }

    @Test
    public void testAssert1() {
        String raw = "insert( foo );";
        String result = "drools.insert( foo );";
        this.assertEqualsIgnoreWhitespace("drools.insert( foo );", KnowledgeHelperFixer.fix((String)"insert( foo );"));
    }

    @Test
    public void testAssert2() {
        String raw = "some code; insert( new String(\"foo\") );\n More();";
        String result = "some code; drools.insert( new String(\"foo\") );\n More();";
        this.assertEqualsIgnoreWhitespace("some code; drools.insert( new String(\"foo\") );\n More();", KnowledgeHelperFixer.fix((String)"some code; insert( new String(\"foo\") );\n More();"));
    }

    @Test
    public void testAssertLogical() {
        String raw = "some code; insertLogical(new String(\"foo\"));\n More();";
        String result = "some code; drools.insertLogical(new String(\"foo\"));\n More();";
        this.assertEqualsIgnoreWhitespace("some code; drools.insertLogical(new String(\"foo\"));\n More();", KnowledgeHelperFixer.fix((String)"some code; insertLogical(new String(\"foo\"));\n More();"));
    }

    @Test
    public void testModifyRetractModifyInsert() {
        String raw = "some code; insert( bar ); modifyRetract( foo );\n More(); retract( bar ); modifyInsert( foo );";
        String result = "some code; drools.insert( bar ); drools.modifyRetract( foo );\n More(); drools.retract( bar ); drools.modifyInsert( foo );";
        this.assertEqualsIgnoreWhitespace("some code; drools.insert( bar ); drools.modifyRetract( foo );\n More(); drools.retract( bar ); drools.modifyInsert( foo );", KnowledgeHelperFixer.fix((String)"some code; insert( bar ); modifyRetract( foo );\n More(); retract( bar ); modifyInsert( foo );"));
    }

    @Test
    public void testAllActionsMushedTogether() {
        String result = KnowledgeHelperFixer.fix((String)"insert(myObject ); update(ourObject);\t retract(herObject);");
        this.assertEqualsIgnoreWhitespace("drools.insert(myObject ); drools.update(ourObject);\t drools.retract(herObject);", result);
        result = KnowledgeHelperFixer.fix((String)"insert( myObject ); update(ourObject);\t retract(herObject  );\ninsert(  myObject ); update(ourObject);\t retract(  herObject  );");
        this.assertEqualsIgnoreWhitespace("drools.insert( myObject ); drools.update(ourObject);\t drools.retract(herObject  );\ndrools.insert(  myObject ); drools.update(ourObject);\t drools.retract(  herObject  );", result);
    }

    @Test
    public void testLeaveLargeAlone() {
        String original = "yeah yeah yeah minsert( xxx ) this is a long() thing Person (name=='drools') modify a thing";
        String result = KnowledgeHelperFixer.fix((String)"yeah yeah yeah minsert( xxx ) this is a long() thing Person (name=='drools') modify a thing");
        this.assertEqualsIgnoreWhitespace("yeah yeah yeah minsert( xxx ) this is a long() thing Person (name=='drools') modify a thing", result);
    }

    @Test
    public void testWithNull() {
        String original = null;
        String result = KnowledgeHelperFixer.fix(original);
        this.assertEqualsIgnoreWhitespace(original, result);
    }

    @Test
    public void testLeaveAssertAlone() {
        String original = "drools.insert(foo)";
        this.assertEqualsIgnoreWhitespace("drools.insert(foo)", KnowledgeHelperFixer.fix((String)"drools.insert(foo)"));
    }

    @Test
    public void testLeaveAssertLogicalAlone() {
        String original = "drools.insertLogical(foo)";
        this.assertEqualsIgnoreWhitespace("drools.insertLogical(foo)", KnowledgeHelperFixer.fix((String)"drools.insertLogical(foo)"));
    }

    @Test
    public void testWackyAssert() {
        String raw = "System.out.println($person1.getName() + \" and \" + $person2.getName() +\" are sisters\");\ninsert($person1.getName(\"foo\") + \" and \" + $person2.getName() +\" are sisters\"); yeah();";
        String expected = "System.out.println($person1.getName() + \" and \" + $person2.getName() +\" are sisters\");\ndrools.insert($person1.getName(\"foo\") + \" and \" + $person2.getName() +\" are sisters\"); yeah();";
        this.assertEqualsIgnoreWhitespace("System.out.println($person1.getName() + \" and \" + $person2.getName() +\" are sisters\");\ndrools.insert($person1.getName(\"foo\") + \" and \" + $person2.getName() +\" are sisters\"); yeah();", KnowledgeHelperFixer.fix((String)"System.out.println($person1.getName() + \" and \" + $person2.getName() +\" are sisters\");\ninsert($person1.getName(\"foo\") + \" and \" + $person2.getName() +\" are sisters\"); yeah();"));
    }

    @Test
    public void testMoreAssertCraziness() {
        String raw = "foobar(); (insert(new String(\"blah\").get()); bangBangYudoHono();)";
        this.assertEqualsIgnoreWhitespace("foobar(); (drools.insert(new String(\"blah\").get()); bangBangYudoHono();)", KnowledgeHelperFixer.fix((String)"foobar(); (insert(new String(\"blah\").get()); bangBangYudoHono();)"));
    }

    @Test
    public void testRetract() {
        String raw = "System.out.println(\"some text\");retract(object);";
        this.assertEqualsIgnoreWhitespace("System.out.println(\"some text\");drools.retract(object);", KnowledgeHelperFixer.fix((String)"System.out.println(\"some text\");retract(object);"));
    }
}

