/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect.asm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.base.rule.Declaration;
import org.drools.mvel.asm.ClassGenerator;
import org.drools.mvel.asm.InvokerContext;
import org.drools.mvel.asm.InvokerDataProvider;
import org.drools.mvel.asm.InvokerGenerator;
import org.drools.mvel.asm.InvokerStub;
import org.junit.Test;

public class InvokerGeneratorTest {
    @Test
    public void testGenerate() {
        HashMap<String, Object> invokerContext = new HashMap<String, Object>();
        invokerContext.put("package", "pkg");
        invokerContext.put("invokerClassName", "TestInvoker");
        invokerContext.put("ruleClassName", "TestRule");
        invokerContext.put("methodName", "testMethod");
        invokerContext.put("consequenceName", "TestConsequence");
        invokerContext.put("hashCode", 111);
        invokerContext.put("declarations", new Declaration[0]);
        invokerContext.put("globals", new String[]{"globalList"});
        invokerContext.put("globalTypes", new String[]{"java/util/List"});
        HashSet<String> imports = new HashSet<String>();
        imports.add("p1");
        imports.add("p2");
        ClassGenerator generator = InvokerGenerator.createStubGenerator((InvokerDataProvider)new InvokerContext(invokerContext), (ClassLoader)this.getClass().getClassLoader(), null, imports);
        generator.setInterfaces(new Class[]{InvokerStub.class});
        InvokerStub stub = (InvokerStub)generator.newInstance();
        Assertions.assertThat((String)stub.getPackageName()).isEqualTo("pkg");
        Assertions.assertThat((String)stub.getRuleClassName()).isEqualTo("TestRule");
        Assertions.assertThat((String)stub.getMethodName()).isEqualTo("testMethod");
        Assertions.assertThat((String)stub.getGeneratedInvokerClassName()).isEqualTo("TestInvokerGenerated");
        Assertions.assertThat((int)stub.hashCode()).isEqualTo(111);
        Assertions.assertThat((boolean)Arrays.equals(new String[]{"globalList"}, stub.getGlobals())).isTrue();
        Assertions.assertThat((boolean)Arrays.equals(new String[]{"java/util/List"}, stub.getGlobalTypes())).isTrue();
        List<String> importList = Arrays.asList(stub.getPackageImports());
        Assertions.assertThat((boolean)importList.contains("p1")).isTrue();
        Assertions.assertThat((boolean)importList.contains("p2")).isTrue();
    }
}

