/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Header;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.ContextObjectInputStream;
import org.jgroups.util.Marshaller;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Message
implements Externalizable,
Streamable {
    protected Address dest_addr = null;
    protected Address src_addr = null;
    private byte[] buf = null;
    protected transient int offset = 0;
    protected transient int length = 0;
    protected HashMap headers = null;
    protected static final Log log = LogFactory.getLog((Class)Message.class);
    static final long serialVersionUID = -1137364035832847034L;
    static final byte DEST_SET = 1;
    static final byte SRC_SET = 2;
    static final byte BUF_SET = 4;
    static final byte HDRS_SET = 8;
    static final byte IPADDR_DEST = 16;
    static final byte IPADDR_SRC = 32;
    static final byte SRC_HOST_NULL = 64;
    static final HashSet nonStreamableHeaders = new HashSet();

    public Message(Address dest, Address src, byte[] buf) {
        this.dest_addr = dest;
        this.src_addr = src;
        this.setBuffer(buf);
    }

    public Message(Address dest, Address src, byte[] buf, int offset, int length) {
        this.dest_addr = dest;
        this.src_addr = src;
        this.setBuffer(buf, offset, length);
    }

    public Message(Address dest, Address src, Serializable obj) {
        this.dest_addr = dest;
        this.src_addr = src;
        this.setObject(obj);
    }

    public Message() {
    }

    public Address getDest() {
        return this.dest_addr;
    }

    public void setDest(Address new_dest) {
        this.dest_addr = new_dest;
    }

    public Address getSrc() {
        return this.src_addr;
    }

    public void setSrc(Address new_src) {
        this.src_addr = new_src;
    }

    public byte[] getRawBuffer() {
        return this.buf;
    }

    public byte[] getBuffer() {
        if (this.buf == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.buf.length) {
            return this.buf;
        }
        byte[] retval = new byte[this.length];
        System.arraycopy(this.buf, this.offset, retval, 0, this.length);
        return retval;
    }

    public void setBuffer(byte[] b) {
        this.buf = b;
        if (this.buf != null) {
            this.offset = 0;
            this.length = this.buf.length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
    }

    public void setBuffer(byte[] b, int offset, int length) {
        this.buf = b;
        if (this.buf != null) {
            if (offset < 0 || offset > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            if (offset + length > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset + length);
            }
            this.offset = offset;
            this.length = length;
        } else {
            length = 0;
            offset = 0;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public void setObject(Serializable obj) {
        if (obj == null) {
            return;
        }
        try {
            ByteArrayOutputStream out_stream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(obj);
            this.setBuffer(out_stream.toByteArray());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public Object getObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            ByteArrayInputStream in_stream = new ByteArrayInputStream(this.buf, this.offset, this.length);
            ContextObjectInputStream in = new ContextObjectInputStream(in_stream);
            return in.readObject();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public void reset() {
        this.src_addr = null;
        this.dest_addr = null;
        this.setBuffer(null);
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public void putHeader(String key, Header hdr) {
        this.headers().put(key, hdr);
    }

    public Header removeHeader(String key) {
        return this.headers != null ? (Header)this.headers.remove(key) : null;
    }

    public void removeHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public Header getHeader(String key) {
        return this.headers != null ? (Header)this.headers.get(key) : null;
    }

    public Message copy() {
        return this.copy(true);
    }

    public Message copy(boolean copy_buffer) {
        Message retval = new Message();
        retval.dest_addr = this.dest_addr;
        retval.src_addr = this.src_addr;
        if (copy_buffer && this.buf != null) {
            retval.setBuffer(this.buf, this.offset, this.length);
        }
        if (this.headers != null) {
            retval.headers = (HashMap)this.headers.clone();
        }
        return retval;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public Message makeReply() {
        return new Message(this.src_addr, null, null);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(64);
        ret.append("[dst: ");
        if (this.dest_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.dest_addr);
        }
        ret.append(", src: ");
        if (this.src_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.src_addr);
        }
        if (this.headers != null && this.headers.size() > 0) {
            ret.append(" (" + this.headers.size() + " headers)");
        }
        ret.append(", size = ");
        if (this.buf != null && this.length > 0) {
            ret.append(this.length);
        } else {
            ret.append('0');
        }
        ret.append(" bytes");
        ret.append(']');
        return ret.toString();
    }

    public String toStringAsObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            Object obj = this.getObject();
            return obj != null ? obj.toString() : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public long size() {
        long retval = 1 + this.length + (this.buf != null ? 4 : 0);
        if (this.dest_addr != null) {
            retval += (long)this.dest_addr.size();
        }
        if (this.src_addr != null) {
            retval += (long)this.src_addr.size();
        }
        if (this.headers != null) {
            retval += 4L;
            Iterator it = this.headers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                retval += (long)(key.length() + 2);
                Header hdr = (Header)entry.getValue();
                retval += 5L;
                retval += hdr.size();
            }
        }
        return retval;
    }

    public String printObjectHeaders() {
        StringBuffer sb = new StringBuffer();
        if (this.headers != null) {
            Iterator it = this.headers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
            }
        }
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.dest_addr != null) {
            out.writeBoolean(true);
            Marshaller.write(this.dest_addr, out);
        } else {
            out.writeBoolean(false);
        }
        if (this.src_addr != null) {
            out.writeBoolean(true);
            Marshaller.write(this.src_addr, out);
        } else {
            out.writeBoolean(false);
        }
        if (this.buf == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
        if (this.headers == null) {
            out.writeInt(0);
        } else {
            int len = this.headers.size();
            out.writeInt(len);
            Iterator it = this.headers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                out.writeUTF((String)entry.getKey());
                Externalizable hdr = (Externalizable)entry.getValue();
                Marshaller.write(hdr, out);
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len;
        int i;
        boolean srcAddressExist;
        boolean destAddressExist = in.readBoolean();
        if (destAddressExist) {
            this.dest_addr = (Address)Marshaller.read(in);
        }
        if (srcAddressExist = in.readBoolean()) {
            this.src_addr = (Address)Marshaller.read(in);
        }
        if ((i = in.readInt()) != 0) {
            this.buf = new byte[i];
            in.readFully(this.buf);
            this.offset = 0;
            this.length = this.buf.length;
        }
        if ((len = in.readInt()) > 0) {
            this.headers = new HashMap(11);
        }
        while (len-- > 0) {
            String key = in.readUTF();
            Externalizable value = Marshaller.read(in);
            this.headers.put(key, value);
        }
    }

    public void writeTo(DataOutputStream out) throws IOException {
        int leading = 0;
        if (this.dest_addr != null) {
            leading = (byte)(leading + 1);
            if (this.dest_addr instanceof IpAddress) {
                leading = (byte)(leading + 16);
            }
        }
        if (this.src_addr != null) {
            leading = (byte)(leading + 2);
            if (this.src_addr instanceof IpAddress) {
                leading = (byte)(leading + 32);
                if (((IpAddress)this.src_addr).getIpAddress() == null) {
                    leading = (byte)(leading + 64);
                }
            }
        }
        if (this.buf != null) {
            leading = (byte)(leading + 4);
        }
        if (this.headers != null && this.headers.size() > 0) {
            leading = (byte)(leading + 8);
        }
        out.write(leading);
        if (this.dest_addr != null) {
            if (this.dest_addr instanceof IpAddress) {
                this.dest_addr.writeTo(out);
            } else {
                Util.writeAddress(this.dest_addr, out);
            }
        }
        if (this.src_addr != null) {
            if (this.src_addr instanceof IpAddress) {
                this.src_addr.writeTo(out);
            } else {
                Util.writeAddress(this.src_addr, out);
            }
        }
        if (this.buf != null) {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
        if (this.headers != null && this.headers.size() > 0) {
            out.writeInt(this.headers.size());
            Iterator it = this.headers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                out.writeUTF((String)entry.getKey());
                this.writeHeader((Header)entry.getValue(), out);
            }
        }
    }

    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        int len;
        byte leading = in.readByte();
        if ((leading & 1) == 1) {
            if ((leading & 0x10) == 16) {
                this.dest_addr = new IpAddress();
                this.dest_addr.readFrom(in);
            } else {
                this.dest_addr = Util.readAddress(in);
            }
        }
        if ((leading & 2) == 2) {
            if ((leading & 0x20) == 32) {
                this.src_addr = new IpAddress();
                this.src_addr.readFrom(in);
            } else {
                this.src_addr = Util.readAddress(in);
            }
        }
        if ((leading & 4) == 4) {
            len = in.readInt();
            this.buf = new byte[len];
            in.read(this.buf, 0, len);
            this.length = len;
        }
        if ((leading & 8) == 8) {
            len = in.readInt();
            this.headers(len);
            for (int i = 0; i < len; ++i) {
                String hdr_name = in.readUTF();
                Header hdr = this.readHeader(in);
                this.headers.put(hdr_name, hdr);
            }
        }
    }

    HashMap headers() {
        return this.headers != null ? this.headers : (this.headers = new HashMap(11));
    }

    HashMap headers(int len) {
        return this.headers != null ? this.headers : (this.headers = new HashMap(len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeader(Header value, DataOutputStream out) throws IOException {
        ObjectOutputStream oos = null;
        try {
            int magic_number = ClassConfigurator.getInstance(false).getMagicNumber(value.getClass());
            if (magic_number == -1) {
                out.writeBoolean(false);
                String classname = value.getClass().getName();
                out.writeUTF(classname);
            } else {
                out.writeBoolean(true);
                out.writeInt(magic_number);
            }
            if (value instanceof Streamable) {
                ((Streamable)((Object)value)).writeTo(out);
            } else {
                oos = new ObjectOutputStream(out);
                value.writeExternal(oos);
                if (!nonStreamableHeaders.contains(value.getClass())) {
                    nonStreamableHeaders.add(value.getClass());
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("encountered non-Streamable header: " + value.getClass()));
                    }
                }
            }
        }
        catch (ChannelException e) {
            log.error((Object)"failed writing the header", (Throwable)e);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    private Header readHeader(DataInputStream in) throws IOException {
        Header hdr = null;
        boolean use_magic_number = in.readBoolean();
        ObjectInputStream ois = null;
        try {
            Class clazz;
            if (use_magic_number) {
                int magic_number = in.readInt();
                clazz = ClassConfigurator.getInstance(false).get(magic_number);
            } else {
                String classname = in.readUTF();
                clazz = ClassConfigurator.getInstance(false).get(classname);
            }
            hdr = (Header)clazz.newInstance();
            if (hdr instanceof Streamable) {
                ((Streamable)((Object)hdr)).readFrom(in);
            } else {
                ois = new ObjectInputStream(in);
                hdr.readExternal(ois);
            }
        }
        catch (Exception ex) {
            throw new IOException("failed read header: " + ex.toString());
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
        return hdr;
    }
}

