/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.List;
import org.jgroups.util.TimeScheduler;

public class NakReceiverWindow {
    private final ReadWriteLock lock = new WriterPreferenceReadWriteLock();
    private long head = 0L;
    private long tail = 0L;
    private long lowest_seen = 0L;
    private long highest_seen = 0L;
    private final TreeMap received_msgs = new TreeMap();
    private final TreeMap delivered_msgs = new TreeMap();
    private boolean discard_delivered_msgs = false;
    private int max_xmit_buf_size = 0;
    private Retransmitter retransmitter = null;
    protected static final Log log = LogFactory.getLog((Class)NakReceiverWindow.class);

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long start_seqno, TimeScheduler sched) {
        this.tail = this.head = start_seqno;
        if (cmd != null) {
            this.retransmitter = sched == null ? new Retransmitter(sender, cmd) : new Retransmitter(sender, cmd, sched);
        }
    }

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long start_seqno) {
        this(sender, cmd, start_seqno, null);
    }

    public NakReceiverWindow(Address sender, long start_seqno) {
        this(sender, null, start_seqno);
    }

    public void setRetransmitTimeouts(long[] timeouts) {
        if (this.retransmitter != null) {
            this.retransmitter.setRetransmitTimeouts(timeouts);
        }
    }

    public void setDiscardDeliveredMessages(boolean flag) {
        this.discard_delivered_msgs = flag;
    }

    public int getMaxXmitBufSize() {
        return this.max_xmit_buf_size;
    }

    public void setMaxXmitBufSize(int max_xmit_buf_size) {
        this.max_xmit_buf_size = max_xmit_buf_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long seqno, Message msg) {
        try {
            this.lock.writeLock().acquire();
            try {
                long old_tail = this.tail;
                if (seqno < this.head) {
                    if (log.isTraceEnabled()) {
                        StringBuffer sb = new StringBuffer("seqno ");
                        sb.append(seqno).append(" is smaller than ").append(this.head).append("); discarding message");
                        log.trace((Object)sb.toString());
                    }
                    return;
                }
                if (seqno == this.tail) {
                    this.received_msgs.put(new Long(seqno), msg);
                    ++this.tail;
                    this.highest_seen = seqno;
                } else if (seqno > this.tail) {
                    for (long i = this.tail; i < seqno; ++i) {
                        this.received_msgs.put(new Long(i), null);
                        ++this.tail;
                    }
                    this.received_msgs.put(new Long(seqno), msg);
                    this.tail = seqno + 1L;
                    if (this.retransmitter != null) {
                        this.retransmitter.add(old_tail, seqno - 1L);
                    }
                } else if (seqno < this.tail) {
                    Object val;
                    if (log.isTraceEnabled()) {
                        StringBuffer sb = new StringBuffer("added missing msg ");
                        sb.append(msg.getSrc()).append('#').append(seqno);
                        log.trace((Object)sb.toString());
                    }
                    if ((val = this.received_msgs.get(new Long(seqno))) == null) {
                        this.received_msgs.put(new Long(seqno), msg);
                        if (this.highest_seen + 1L == seqno || seqno == this.head) {
                            this.updateHighestSeen();
                        }
                        if (this.retransmitter != null) {
                            this.retransmitter.remove(seqno);
                        }
                    }
                }
                this.updateLowestSeen();
            }
            finally {
                this.lock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"failed acquiring write lock", (Throwable)e);
        }
    }

    void updateHighestSeen() {
        Map.Entry entry;
        SortedMap map = this.received_msgs.tailMap(new Long(this.highest_seen));
        Iterator it = map.entrySet().iterator();
        while (it.hasNext() && (entry = it.next()).getValue() != null) {
            this.highest_seen = entry.getKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message remove() {
        Serializable retval = null;
        boolean bounded_buffer_enabled = this.max_xmit_buf_size > 0;
        try {
            this.lock.writeLock().acquire();
            try {
                StringBuffer sb;
                while (this.received_msgs.size() > 0) {
                    Long key;
                    if (log.isTraceEnabled()) {
                        sb = new StringBuffer("received msgs=");
                        sb.append(this.received_msgs.size()).append(", max_xmit_buf_size=").append(this.max_xmit_buf_size);
                        log.trace((Object)sb.toString());
                    }
                    if ((retval = (Message)this.received_msgs.get(key = (Long)this.received_msgs.firstKey())) != null) {
                        this.received_msgs.remove(key);
                        if (!this.discard_delivered_msgs) {
                            this.delivered_msgs.put(key, retval);
                        }
                        ++this.head;
                        sb = retval;
                        return sb;
                    }
                    if (!bounded_buffer_enabled || this.received_msgs.size() <= this.max_xmit_buf_size) break;
                    this.received_msgs.remove(key);
                    ++this.head;
                    this.retransmitter.remove(key);
                }
                sb = retval;
                return sb;
            }
            finally {
                this.lock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"failed acquiring write lock", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stable(long seqno) {
        try {
            this.lock.writeLock().acquire();
            try {
                SortedMap m = this.delivered_msgs.headMap(new Long(seqno + 1L));
                if (m.size() > 0) {
                    this.lowest_seen = Math.max(this.lowest_seen, m.lastKey());
                }
                m.clear();
            }
            finally {
                this.lock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"failed acquiring write lock", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            this.lock.writeLock().acquire();
            try {
                if (this.retransmitter != null) {
                    this.retransmitter.reset();
                }
                this._reset();
            }
            finally {
                this.lock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"failed acquiring write lock", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.lock.writeLock().acquire();
            try {
                if (this.retransmitter != null) {
                    this.retransmitter.stop();
                }
                this._reset();
            }
            finally {
                this.lock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"failed acquiring write lock", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestDelivered() {
        long l;
        this.lock.readLock().acquire();
        try {
            l = Math.max(this.head - 1L, -1L);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                log.error((Object)"failed acquiring read lock", (Throwable)e);
                return -1L;
            }
        }
        this.lock.readLock().release();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLowestSeen() {
        long l;
        this.lock.readLock().acquire();
        try {
            l = this.lowest_seen;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                log.error((Object)"failed acquiring read lock", (Throwable)e);
                return -1L;
            }
        }
        this.lock.readLock().release();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestSeen() {
        long l;
        this.lock.readLock().acquire();
        try {
            l = this.highest_seen;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                log.error((Object)"failed acquiring read lock", (Throwable)e);
                return -1L;
            }
        }
        this.lock.readLock().release();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMissingMessages(long low, long high) {
        List list;
        List retval = new List();
        if (low > high) {
            if (log.isErrorEnabled()) {
                log.error((Object)("invalid range: low (" + low + ") is higher than high (" + high + ')'));
            }
            return null;
        }
        this.lock.readLock().acquire();
        try {
            SortedMap m = this.received_msgs.subMap(new Long(low), new Long(high + 1L));
            Iterator<Long> it = m.keySet().iterator();
            while (it.hasNext()) {
                retval.add(it.next());
            }
            list = retval;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                log.error((Object)"failed acquiring read lock", (Throwable)e);
                return null;
            }
        }
        this.lock.readLock().release();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestReceived() {
        long l;
        this.lock.readLock().acquire();
        try {
            l = Math.max(this.tail - 1L, -1L);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                log.error((Object)"failed acquiring read lock", (Throwable)e);
                return -1L;
            }
        }
        this.lock.readLock().release();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesHigherThan(long seqno) {
        List list;
        List retval = new List();
        this.lock.readLock().acquire();
        try {
            SortedMap m = this.received_msgs.tailMap(new Long(seqno + 1L));
            Iterator it = m.values().iterator();
            while (it.hasNext()) {
                retval.add(it.next());
            }
            m = this.delivered_msgs.tailMap(new Long(seqno + 1L));
            it = m.values().iterator();
            while (it.hasNext()) {
                retval.add(((Message)it.next()).copy());
            }
            list = retval;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                log.error((Object)"failed acquiring read lock", (Throwable)e);
                return null;
            }
        }
        this.lock.readLock().release();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesInRange(long lower, long upper) {
        List list;
        List retval = new List();
        this.lock.readLock().acquire();
        try {
            SortedMap m = this.received_msgs.subMap(new Long(lower + 1L), new Long(upper + 1L));
            Iterator it = m.values().iterator();
            while (it.hasNext()) {
                retval.add(it.next());
            }
            m = this.delivered_msgs.subMap(new Long(lower + 1L), new Long(upper + 1L));
            it = m.values().iterator();
            while (it.hasNext()) {
                retval.add(((Message)it.next()).copy());
            }
            list = retval;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                log.error((Object)"failed acquiring read lock", (Throwable)e);
                return null;
            }
        }
        this.lock.readLock().release();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesInList(List missing_msgs) {
        List list;
        List ret = new List();
        if (missing_msgs == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"argument list is null");
            }
            return ret;
        }
        this.lock.readLock().acquire();
        try {
            Enumeration en = missing_msgs.elements();
            while (en.hasMoreElements()) {
                Long seqno = (Long)en.nextElement();
                Message msg = (Message)this.delivered_msgs.get(seqno);
                if (msg != null) {
                    ret.add(msg.copy());
                }
                if ((msg = (Message)this.received_msgs.get(seqno)) == null) continue;
                ret.add(msg.copy());
            }
            list = ret;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (InterruptedException e) {
                log.error((Object)"failed acquiring read lock", (Throwable)e);
                return null;
            }
        }
        this.lock.readLock().release();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        boolean acquired = false;
        try {
            this.lock.readLock().acquire();
            acquired = true;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            int n = this.received_msgs.size();
            return n;
        }
        finally {
            if (acquired) {
                this.lock.readLock().release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        try {
            this.lock.readLock().acquire();
            try {
                sb.append("received_msgs: " + this.printReceivedMessages());
                sb.append(", delivered_msgs: " + this.printDeliveredMessages());
            }
            finally {
                this.lock.readLock().release();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"failed acquiring read lock", (Throwable)e);
            return "";
        }
        return sb.toString();
    }

    String printDeliveredMessages() {
        StringBuffer sb = new StringBuffer();
        Long min = null;
        Long max = null;
        if (this.delivered_msgs.size() > 0) {
            try {
                min = (Long)this.delivered_msgs.firstKey();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            try {
                max = (Long)this.delivered_msgs.lastKey();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
        }
        sb.append('[').append(min).append(" - ").append(max).append(']');
        return sb.toString();
    }

    String printReceivedMessages() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        if (this.received_msgs.size() > 0) {
            Long first = null;
            Long last = null;
            try {
                first = (Long)this.received_msgs.firstKey();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            try {
                last = (Long)this.received_msgs.lastKey();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            sb.append(first).append(" - ").append(last);
            int non_received = 0;
            Iterator it = this.received_msgs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (entry.getValue() != null) continue;
                ++non_received;
            }
            sb.append(" (size=").append(this.received_msgs.size()).append(", missing=").append(non_received).append(')');
        }
        sb.append(']');
        return sb.toString();
    }

    private void updateLowestSeen() {
        Long lowest_seqno = null;
        if (this.delivered_msgs.size() > 0) {
            try {
                lowest_seqno = (Long)this.delivered_msgs.firstKey();
                if (lowest_seqno != null) {
                    this.lowest_seen = lowest_seqno;
                }
            }
            catch (NoSuchElementException ex) {}
        } else if (this.received_msgs.size() > 0) {
            try {
                lowest_seqno = (Long)this.received_msgs.firstKey();
                if (this.received_msgs.get(lowest_seqno) != null) {
                    this.lowest_seen = lowest_seqno;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    private void _reset() {
        this.received_msgs.clear();
        this.delivered_msgs.clear();
        this.head = 0L;
        this.tail = 0L;
        this.lowest_seen = 0L;
        this.highest_seen = 0L;
    }
}

