/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.Opcode;
import org.codehaus.janino.util.ClassFile;

public class CodeContext {
    private static final boolean DEBUG = false;
    private static final int INITIAL_SIZE = 128;
    private ClassFile classFile;
    private short maxStack;
    private short maxLocals;
    private byte[] code;
    private Offset beginning;
    private Inserter end;
    private Inserter currentInserter;
    private List exceptionTableEntries;
    private static final byte UNEXAMINED = -1;
    private static final byte INVALID_OFFSET = -2;
    private static final Map BRANCH_OPCODE_INVERSION = CodeContext.createBranchOpcodeInversion();
    private short localVariableArrayLength = 0;
    private final Stack savedLocalVariableArrayLengths = new Stack();
    private final List relocatables = new ArrayList();

    public CodeContext(ClassFile classFile) {
        this.classFile = classFile;
        this.maxStack = 0;
        this.maxLocals = 0;
        this.code = new byte[128];
        this.beginning = new Offset();
        this.currentInserter = this.end = new Inserter();
        this.exceptionTableEntries = new ArrayList();
        this.beginning.offset = 0;
        this.end.offset = 0;
        this.beginning.next = this.end;
        this.end.prev = this.beginning;
    }

    public void addExceptionTableEntry(Offset offset, Offset offset2, Offset offset3, String string) {
        this.exceptionTableEntries.add(new ExceptionTableEntry(offset, offset2, offset3, string == null ? (short)0 : this.classFile.addConstantClassInfo(string)));
    }

    public short allocateLocalVariable(short s) {
        short s2 = this.localVariableArrayLength;
        this.localVariableArrayLength = (short)(this.localVariableArrayLength + s);
        if (this.localVariableArrayLength > this.maxLocals) {
            this.maxLocals = this.localVariableArrayLength;
        }
        return s2;
    }

    private static Map createBranchOpcodeInversion() {
        HashMap<Byte, Byte> hashMap = new HashMap<Byte, Byte>();
        hashMap.put(new Byte(-91), new Byte(-90));
        hashMap.put(new Byte(-90), new Byte(-91));
        hashMap.put(new Byte(-97), new Byte(-96));
        hashMap.put(new Byte(-96), new Byte(-97));
        hashMap.put(new Byte(-94), new Byte(-95));
        hashMap.put(new Byte(-95), new Byte(-94));
        hashMap.put(new Byte(-93), new Byte(-92));
        hashMap.put(new Byte(-92), new Byte(-93));
        hashMap.put(new Byte(-103), new Byte(-102));
        hashMap.put(new Byte(-102), new Byte(-103));
        hashMap.put(new Byte(-100), new Byte(-101));
        hashMap.put(new Byte(-101), new Byte(-100));
        hashMap.put(new Byte(-99), new Byte(-98));
        hashMap.put(new Byte(-98), new Byte(-99));
        hashMap.put(new Byte(-58), new Byte(-57));
        hashMap.put(new Byte(-57), new Byte(-58));
        return Collections.unmodifiableMap(hashMap);
    }

    public Inserter currentInserter() {
        return this.currentInserter;
    }

    private int determineArgumentsSize(short s) {
        ClassFile.ConstantPoolInfo constantPoolInfo = this.classFile.getConstantPoolInfo(s);
        ClassFile.ConstantNameAndTypeInfo constantNameAndTypeInfo = (ClassFile.ConstantNameAndTypeInfo)this.classFile.getConstantPoolInfo(constantPoolInfo instanceof ClassFile.ConstantInterfaceMethodrefInfo ? ((ClassFile.ConstantInterfaceMethodrefInfo)constantPoolInfo).getNameAndTypeIndex() : ((ClassFile.ConstantMethodrefInfo)constantPoolInfo).getNameAndTypeIndex());
        ClassFile.ConstantUtf8Info constantUtf8Info = (ClassFile.ConstantUtf8Info)this.classFile.getConstantPoolInfo(constantNameAndTypeInfo.getDescriptorIndex());
        String string = constantUtf8Info.getString();
        if (string.charAt(0) != '(') {
            throw new RuntimeException("Method descriptor does not start with \"(\"");
        }
        int n = 1;
        int n2 = 0;
        block7: while (true) {
            switch (string.charAt(n++)) {
                case ')': {
                    return n2 - Descriptor.size(string.substring(n));
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++n2;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    n2 += 2;
                    continue block7;
                }
                case '[': {
                    int n3;
                    ++n2;
                    while (string.charAt(n) == '[') {
                        ++n;
                    }
                    if ("BCFISZDJ".indexOf(string.charAt(n)) != -1) {
                        ++n;
                        continue block7;
                    }
                    if (string.charAt(n) != 'L') {
                        throw new RuntimeException("Invalid char after \"[\"");
                    }
                    do {
                        n3 = ++n;
                        ++n;
                    } while (string.charAt(n3) != ';');
                    continue block7;
                }
                case 'L': {
                    ++n2;
                    while (string.charAt(n++) != ';') {
                    }
                    continue block7;
                }
            }
            break;
        }
        throw new RuntimeException("Invalid method descriptor");
    }

    private int determineFieldSize(short s) {
        ClassFile.ConstantFieldrefInfo constantFieldrefInfo = (ClassFile.ConstantFieldrefInfo)this.classFile.getConstantPoolInfo(s);
        ClassFile.ConstantNameAndTypeInfo constantNameAndTypeInfo = (ClassFile.ConstantNameAndTypeInfo)this.classFile.getConstantPoolInfo(constantFieldrefInfo.getNameAndTypeIndex());
        ClassFile.ConstantUtf8Info constantUtf8Info = (ClassFile.ConstantUtf8Info)this.classFile.getConstantPoolInfo(constantNameAndTypeInfo.getDescriptorIndex());
        return Descriptor.size(constantUtf8Info.getString());
    }

    private int extract16BitValue(int n, int n2, byte[] byArray) {
        int n3 = n + ((byArray[n2] << 8) + (0xFF & byArray[n2 + 1]));
        return n3;
    }

    private int extract32BitValue(int n, int n2, byte[] byArray) {
        int n3 = n + ((byArray[n2] << 24) + ((0xFF & byArray[n2 + 1]) << 16) + ((0xFF & byArray[n2 + 2]) << 8) + (0xFF & byArray[n2 + 3]));
        return n3;
    }

    private void fixUp() {
        Offset offset = this.beginning;
        while (offset != this.end) {
            if (offset instanceof FixUp) {
                ((FixUp)((Object)offset)).fixUp();
            }
            offset = offset.next;
        }
    }

    public void fixUpAndRelocate() {
        do {
            this.fixUp();
        } while (!this.relocate());
    }

    public void flowAnalysis(String string) {
        int n;
        byte[] byArray = new byte[this.end.offset];
        Arrays.fill(byArray, (byte)-1);
        this.flowAnalysis(string, this.code, this.end.offset, 0, 0, byArray);
        int n2 = 0;
        while (n2 != this.exceptionTableEntries.size()) {
            n = 0;
            while (n < this.exceptionTableEntries.size()) {
                ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.exceptionTableEntries.get(n);
                if (byArray[((ExceptionTableEntry)exceptionTableEntry).startPC.offset] != -1) {
                    this.flowAnalysis(string, this.code, this.end.offset, ((ExceptionTableEntry)exceptionTableEntry).handlerPC.offset, byArray[((ExceptionTableEntry)exceptionTableEntry).startPC.offset] + 1, byArray);
                    ++n2;
                }
                ++n;
            }
        }
        this.maxStack = 0;
        n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            if (by == -1) {
                throw new RuntimeException(String.valueOf(string) + ": Unexamined code at offset " + n);
            }
            if (by > this.maxStack) {
                this.maxStack = by;
            }
            ++n;
        }
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void flowAnalysis(String var1_1, byte[] var2_2, int var3_3, int var4_4, int var5_5, byte[] var6_6) {
        while (true) {
            if (var4_4 < 0 || var4_4 >= var3_3) {
                throw new RuntimeException(String.valueOf(var1_1) + ": Offset out of range");
            }
            var7_7 = var6_6[var4_4];
            if (var7_7 == var5_5) {
                return;
            }
            if (var7_7 == -2) {
                throw new RuntimeException(String.valueOf(var1_1) + ": Invalid offset");
            }
            if (var7_7 != -1) {
                throw new RuntimeException(String.valueOf(var1_1) + ": Operand stack inconsistent at offset " + var4_4 + ": Previous size " + var7_7 + ", now " + var5_5);
            }
            var6_6[var4_4] = (byte)var5_5;
            var8_8 = var2_2[var4_4];
            var9_9 = var4_4 + 1;
            if (var8_8 == -60) {
                var8_8 = var2_2[var9_9++];
                var10_10 = Opcode.WIDE_OPCODE_PROPERTIES[255 & var8_8];
            } else {
                var10_10 = Opcode.OPCODE_PROPERTIES[255 & var8_8];
            }
            if (var10_10 == -1) {
                throw new RuntimeException(String.valueOf(var1_1) + ": Invalid opcode " + (255 & var8_8) + " at offset " + var4_4);
            }
            switch (var10_10 & 31) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    var5_5 += (var10_10 & 31) - 4;
                    break;
                }
                case 7: {
                    var5_5 = 0;
                    break;
                }
                case 9: {
                    --var5_5;
                }
                case 10: {
                    var5_5 += this.determineFieldSize((short)this.extract16BitValue(0, var9_9, var2_2));
                    break;
                }
                case 11: {
                    --var5_5;
                }
                case 12: {
                    var5_5 -= this.determineFieldSize((short)this.extract16BitValue(0, var9_9, var2_2));
                    break;
                }
                case 13: 
                case 14: 
                case 16: {
                    --var5_5;
                }
                case 15: {
                    var5_5 -= this.determineArgumentsSize((short)this.extract16BitValue(0, var9_9, var2_2));
                    break;
                }
                case 18: {
                    var5_5 -= var2_2[var9_9 + 2] - 1;
                    break;
                }
                default: {
                    throw new RuntimeException(String.valueOf(var1_1) + ": Invalid stack delta");
                }
            }
            if (var5_5 < 0) {
                var11_12 = String.valueOf(this.classFile.getThisClassName()) + '.' + var1_1 + ": Operand stack underrun at offset " + var4_4;
                throw new RuntimeException(var11_12);
            }
            if (var5_5 > 127) {
                var11_13 = String.valueOf(this.classFile.getThisClassName()) + '.' + var1_1 + ": Operand stack overflow at offset " + var4_4;
                throw new RuntimeException(var11_13);
            }
            cfr_temp_0 = -2147483648;
            block31: do {
                switch (cfr_temp_0 == -2147483648 ? var10_10 & 480 : cfr_temp_0) {
                    case 32: 
                    case 64: 
                    case 128: 
                    case 192: {
                        ++var9_9;
                        break;
                    }
                    case 96: 
                    case 160: 
                    case 224: {
                        var9_9 += 2;
                        break;
                    }
                    case 256: {
                        this.flowAnalysis(var1_1, var2_2, var3_3, this.extract16BitValue(var4_4, var9_9, var2_2), var5_5, var6_6);
                        var9_9 += 2;
                        break;
                    }
                    case 384: {
                        var11_11 = this.extract16BitValue(var4_4, var9_9, var2_2);
                        var9_9 += 2;
                        if (var6_6[var11_11] != -1) break block31;
                        this.flowAnalysis(var1_1, var2_2, var3_3, var11_11, var5_5 + 1, var6_6);
                        break;
                    }
                    case 288: {
                        this.flowAnalysis(var1_1, var2_2, var3_3, this.extract32BitValue(var4_4, var9_9, var2_2), var5_5, var6_6);
                        var9_9 += 4;
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.valueOf(var1_1) + ": Invalid OP1");
                    }
                    case 0: {
                        break;
                    }
                    while (true) {
                        cfr_temp_0 = 320;
                        ++var9_9;
                        break;
                    }
                    case 320: {
                        if ((var9_9 & 3) != 0) ** continue;
                        this.flowAnalysis(var1_1, var2_2, var3_3, this.extract32BitValue(var4_4, var9_9, var2_2), var5_5, var6_6);
                        var12_14 = this.extract32BitValue(0, var9_9 += 4, var2_2);
                        var9_9 += 4;
                        var13_15 = 0;
                        while (var13_15 < var12_14) {
                            this.flowAnalysis(var1_1, var2_2, var3_3, this.extract32BitValue(var4_4, var9_9 += 4, var2_2), var5_5, var6_6);
                            var9_9 += 4;
                            ++var13_15;
                        }
                        break block31;
                    }
                    while (true) {
                        cfr_temp_0 = 352;
                        ++var9_9;
                        break;
                    }
                    case 352: {
                        if ((var9_9 & 3) != 0) ** continue;
                        this.flowAnalysis(var1_1, var2_2, var3_3, this.extract32BitValue(var4_4, var9_9, var2_2), var5_5, var6_6);
                        var13_15 = this.extract32BitValue(var4_4, var9_9 += 4, var2_2);
                        var14_16 = this.extract32BitValue(var4_4, var9_9 += 4, var2_2);
                        var9_9 += 4;
                        var15_17 = var13_15;
                        while (var15_17 <= var14_16) {
                            this.flowAnalysis(var1_1, var2_2, var3_3, this.extract32BitValue(var4_4, var9_9, var2_2), var5_5, var6_6);
                            var9_9 += 4;
                            ++var15_17;
                        }
                        break block31;
                    }
                }
                break;
            } while (true);
            switch (var10_10 & 1536) {
                case 512: {
                    ++var9_9;
                    break;
                }
                case 1024: {
                    var9_9 += 2;
                    break;
                }
                default: {
                    throw new RuntimeException(String.valueOf(var1_1) + ": Invalid OP2");
                }
                case 0: 
            }
            switch (var10_10 & 2048) {
                case 2048: {
                    ++var9_9;
                    break;
                }
                default: {
                    throw new RuntimeException(String.valueOf(var1_1) + ": Invalid OP3");
                }
                case 0: 
            }
            Arrays.fill(var6_6, var4_4 + 1, var9_9, (byte)-2);
            if ((var10_10 & -32768) != 0) {
                return;
            }
            var4_4 = var9_9;
        }
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    private static byte invertBranchOpcode(byte by) {
        return (Byte)BRANCH_OPCODE_INVERSION.get(new Byte(by));
    }

    public void makeSpace(short s, int n) {
        Object object;
        block9: {
            if (n == 0) {
                return;
            }
            if (s != -1) {
                Offset offset = this.currentInserter.prev;
                while (offset != this.beginning) {
                    if (offset instanceof LineNumberOffset) {
                        if (((LineNumberOffset)offset).lineNumber != s) break;
                        break block9;
                    }
                    offset = offset.prev;
                }
                object = new LineNumberOffset(this.currentInserter.offset, s);
                object.prev = this.currentInserter.prev;
                object.next = this.currentInserter;
                this.currentInserter.prev.next = object;
                this.currentInserter.prev = object;
            }
        }
        int n2 = this.currentInserter.offset;
        if (this.end.offset + n <= this.code.length) {
            if (n2 != this.end.offset) {
                System.arraycopy(this.code, n2, this.code, n2 + n, this.end.offset - n2);
            }
        } else {
            object = this.code;
            int n3 = Math.max(Math.min(((byte[])object).length * 2, 65535), ((byte[])object).length + n);
            if (n3 > 65535) {
                throw new RuntimeException("Code attribute in class \"" + this.classFile.getThisClassName() + "\" grows beyond 64 KB");
            }
            this.code = new byte[n3];
            System.arraycopy(object, 0, this.code, 0, n2);
            System.arraycopy(object, n2, this.code, n2 + n, this.end.offset - n2);
        }
        Arrays.fill(this.code, n2, n2 + n, (byte)0);
        object = this.currentInserter;
        while (object != null) {
            object.offset += n;
            object = object.next;
        }
    }

    public Inserter newInserter() {
        Inserter inserter = new Inserter();
        inserter.set();
        return inserter;
    }

    public Offset newOffset() {
        Offset offset = new Offset();
        offset.set();
        return offset;
    }

    public void popInserter() {
        Inserter inserter = this.currentInserter.nextInserter;
        if (inserter == null) {
            throw new RuntimeException("Code inserter stack underflow");
        }
        this.currentInserter.nextInserter = null;
        this.currentInserter = inserter;
    }

    public void pushInserter(Inserter inserter) {
        if (inserter.nextInserter != null) {
            throw new RuntimeException("An Inserter can only be pushed once at a time");
        }
        inserter.nextInserter = this.currentInserter;
        this.currentInserter = inserter;
    }

    private boolean relocate() {
        boolean bl = true;
        int n = 0;
        while (n < this.relocatables.size()) {
            boolean bl2 = ((Relocatable)this.relocatables.get(n)).relocate();
            bl = bl && bl2;
            ++n;
        }
        return bl;
    }

    public void restoreLocalVariables() {
        this.localVariableArrayLength = (Short)this.savedLocalVariableArrayLengths.pop();
    }

    public void saveLocalVariables() {
        this.savedLocalVariableArrayLengths.push(new Short(this.localVariableArrayLength));
    }

    protected void storeCodeAttributeBody(DataOutputStream dataOutputStream, short s) throws IOException {
        Object object;
        Object object2;
        Object object3;
        dataOutputStream.writeShort(this.maxStack);
        dataOutputStream.writeShort(this.maxLocals);
        dataOutputStream.writeInt(this.end.offset);
        dataOutputStream.write(this.code, 0, this.end.offset);
        dataOutputStream.writeShort(this.exceptionTableEntries.size());
        int n = 0;
        while (n < this.exceptionTableEntries.size()) {
            object3 = (ExceptionTableEntry)this.exceptionTableEntries.get(n);
            dataOutputStream.writeShort(((ExceptionTableEntry)object3).startPC.offset);
            dataOutputStream.writeShort(((ExceptionTableEntry)object3).endPC.offset);
            dataOutputStream.writeShort(((ExceptionTableEntry)object3).handlerPC.offset);
            dataOutputStream.writeShort(((ExceptionTableEntry)object3).catchType);
            ++n;
        }
        object3 = new ArrayList();
        if (s != 0) {
            object2 = new ArrayList();
            object = this.beginning;
            while (object != null) {
                if (object instanceof LineNumberOffset) {
                    object2.add(new ClassFile.LineNumberTableAttribute.Entry(((Offset)object).offset, ((LineNumberOffset)object).lineNumber));
                }
                object = ((Offset)object).next;
            }
            ClassFile.LineNumberTableAttribute.Entry[] entryArray = object2.toArray(new ClassFile.LineNumberTableAttribute.Entry[object2.size()]);
            object3.add(new ClassFile.LineNumberTableAttribute(s, entryArray));
        }
        dataOutputStream.writeShort(object3.size());
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (ClassFile.AttributeInfo)object2.next();
            ((ClassFile.AttributeInfo)object).store(dataOutputStream);
        }
    }

    public void write(short s, byte by) {
        int n = this.currentInserter.offset;
        this.makeSpace(s, 1);
        this.code[n] = by;
    }

    public void write(short s, byte by, byte by2) {
        int n = this.currentInserter.offset;
        this.makeSpace(s, 2);
        this.code[n++] = by;
        this.code[n] = by2;
    }

    public void write(short s, byte by, byte by2, byte by3) {
        int n = this.currentInserter.offset;
        this.makeSpace(s, 3);
        this.code[n++] = by;
        this.code[n++] = by2;
        this.code[n] = by3;
    }

    public void write(short s, byte by, byte by2, byte by3, byte by4) {
        int n = this.currentInserter.offset;
        this.makeSpace(s, 4);
        this.code[n++] = by;
        this.code[n++] = by2;
        this.code[n++] = by3;
        this.code[n] = by4;
    }

    public void write(short s, byte[] byArray) {
        if (byArray.length == 0) {
            return;
        }
        int n = this.currentInserter.offset;
        this.makeSpace(s, byArray.length);
        System.arraycopy(byArray, 0, this.code, n, byArray.length);
    }

    public void writeBranch(short s, int n, Offset offset) {
        this.relocatables.add(new Branch(n, offset));
        this.write(s, (byte)n, (byte)-1, (byte)-1);
    }

    public void writeOffset(short s, Offset offset, Offset offset2) {
        this.relocatables.add(new OffsetBranch(this.newOffset(), offset, offset2));
        this.write(s, (byte)-1, (byte)-1, (byte)-1, (byte)-1);
    }

    public void writeShort(short s, int n) {
        this.write(s, (byte)(n >> 8), (byte)n);
    }

    private class Branch
    extends Relocatable {
        private boolean expanded;
        private final int opcode;
        private final Inserter source;
        private final Offset destination;

        public Branch(int n, Offset offset) {
            this.opcode = n;
            this.source = CodeContext.this.newInserter();
            this.destination = offset;
            this.expanded = n == -55 || n == -56;
        }

        public boolean relocate() {
            byte[] byArray;
            if (this.destination.offset == -1) {
                throw new RuntimeException("Cannot relocate branch to unset destination offset");
            }
            int n = this.destination.offset - this.source.offset;
            if (!(this.expanded || n <= Short.MAX_VALUE && n >= Short.MIN_VALUE)) {
                int n2 = this.source.offset;
                CodeContext.this.pushInserter(this.source);
                CodeContext.this.makeSpace((short)-1, this.opcode == -89 ? 2 : (this.opcode == -88 ? 2 : 5));
                CodeContext.this.popInserter();
                this.source.offset = n2;
                this.expanded = true;
                return false;
            }
            if (!this.expanded) {
                byArray = new byte[]{(byte)this.opcode, (byte)(n >> 8), (byte)n};
            } else if (this.opcode == -89 || this.opcode == -88) {
                byArray = new byte[]{(byte)(this.opcode + 33), (byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
            } else {
                byte[] byArray2 = new byte[8];
                byArray2[0] = CodeContext.invertBranchOpcode((byte)this.opcode);
                byArray2[2] = 8;
                byArray2[3] = -56;
                byArray2[4] = (byte)((n -= 3) >> 24);
                byArray2[5] = (byte)(n >> 16);
                byArray2[6] = (byte)(n >> 8);
                byArray2[7] = (byte)n;
                byArray = byArray2;
            }
            System.arraycopy(byArray, 0, CodeContext.this.code, this.source.offset, byArray.length);
            return true;
        }
    }

    private class OffsetBranch
    extends Relocatable {
        private final Offset where;
        private final Offset source;
        private final Offset destination;

        public OffsetBranch(Offset offset, Offset offset2, Offset offset3) {
            this.where = offset;
            this.source = offset2;
            this.destination = offset3;
        }

        public boolean relocate() {
            if (this.source.offset == -1 || this.destination.offset == -1) {
                throw new RuntimeException("Cannot relocate offset branch to unset destination offset");
            }
            int n = this.destination.offset - this.source.offset;
            byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
            System.arraycopy(byArray, 0, CodeContext.this.code, this.where.offset, 4);
            return true;
        }
    }

    public class Offset {
        int offset = -1;
        Offset prev = null;
        Offset next = null;
        static final int UNSET = -1;

        public final CodeContext getCodeContext() {
            return CodeContext.this;
        }

        public void set() {
            if (this.offset != -1) {
                throw new RuntimeException("Cannot \"set()\" Offset more than once");
            }
            this.offset = ((CodeContext)CodeContext.this).currentInserter.offset;
            this.prev = ((CodeContext)CodeContext.this).currentInserter.prev;
            this.next = CodeContext.this.currentInserter;
            this.prev.next = this;
            this.next.prev = this;
        }

        public String toString() {
            return String.valueOf(CodeContext.this.classFile.getThisClassName()) + ": " + this.offset;
        }
    }

    private static class ExceptionTableEntry {
        private final Offset startPC;
        private final Offset endPC;
        private final Offset handlerPC;
        private final short catchType;

        public ExceptionTableEntry(Offset offset, Offset offset2, Offset offset3, short s) {
            this.startPC = offset;
            this.endPC = offset2;
            this.handlerPC = offset3;
            this.catchType = s;
        }
    }

    public class Inserter
    extends Offset {
        private Inserter nextInserter = null;
    }

    public class LineNumberOffset
    extends Offset {
        private final int lineNumber;

        public LineNumberOffset(int n, int n2) {
            this.lineNumber = n2;
            this.offset = n;
        }
    }

    private abstract class Relocatable {
        Relocatable() {
        }

        public abstract boolean relocate();
    }

    public static interface FixUp {
        public void fixUp();
    }
}

