/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.jmx.JmxRegistrationManager;

@NonVolatile
public class PlatformMBeanServerRegistration {
    private static final Log log = LogFactory.getLog(PlatformMBeanServerRegistration.class);
    private CacheSPI cache;
    private JmxRegistrationManager jmxRegistrationManager;

    @Inject
    public void initialize(CacheSPI cache) {
        this.cache = cache;
    }

    @Start(priority=14)
    public void registerToPlatformMBeanServer() {
        if (this.cache == null) {
            throw new IllegalStateException("The cache should had been injected before a call to this method");
        }
        Configuration config = this.cache.getConfiguration();
        if (config.getExposeManagementStatistics()) {
            this.jmxRegistrationManager = new JmxRegistrationManager(this.cache);
            this.jmxRegistrationManager.registerAllMBeans();
            log.info((Object)"JBossCache MBeans were successfully registered to the platform mbean server.");
        }
    }

    @Stop
    public void unregisterMBeans() {
        if (this.cache == null) {
            return;
        }
        Configuration config = this.cache.getConfiguration();
        if (config.getExposeManagementStatistics()) {
            this.jmxRegistrationManager.unregisterAllMBeans();
            log.trace((Object)"JBossCache MBeans were successfully unregistered from the platform mbean server.");
        }
        this.cache = null;
    }
}

