/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ExtendedReceiver;
import org.jgroups.JChannel;
import org.jgroups.JChannelFactory;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.mux.MuxChannel;
import org.jgroups.stack.GossipRouter;
import org.jgroups.util.Util;

public class ChannelTestBase
extends TestCase {
    protected static final Random RANDOM = new Random();
    private static final int LETTER_A = 64;
    protected static final String DEFAULT_MUX_FACTORY_COUNT = "4";
    protected static String CHANNEL_CONFIG = "udp.xml";
    protected static String MUX_CHANNEL_CONFIG = "stacks.xml";
    protected static String MUX_CHANNEL_CONFIG_STACK_NAME = "udp";
    protected int active_threads = 0;
    protected JChannelFactory[] muxFactory = null;
    protected String thread_dump = null;
    protected int currentChannelGeneratedName = 64;
    private static final int ROUTER_PORT = 12001;
    private static final String BIND_ADDR = "127.0.0.1";
    GossipRouter router = null;
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public ChannelTestBase() {
    }

    public ChannelTestBase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        MUX_CHANNEL_CONFIG = System.getProperty("mux.conf", MUX_CHANNEL_CONFIG);
        MUX_CHANNEL_CONFIG_STACK_NAME = System.getProperty("mux.conf.stack", MUX_CHANNEL_CONFIG_STACK_NAME);
        CHANNEL_CONFIG = System.getProperty("channel.conf", CHANNEL_CONFIG);
        this.currentChannelGeneratedName = 64;
        if (ChannelTestBase.isTunnelUsed()) {
            this.router = new GossipRouter(12001, BIND_ADDR);
            this.router.start();
        }
        if (ChannelTestBase.isMuxChannelUsed()) {
            this.muxFactory = new JChannelFactory[this.getMuxFactoryCount()];
            for (int i = 0; i < this.muxFactory.length; ++i) {
                this.muxFactory[i] = new JChannelFactory();
                this.muxFactory[i].setMultiplexerConfig(MUX_CHANNEL_CONFIG);
            }
        }
        if (ChannelTestBase.shouldCompareThreadCount()) {
            this.active_threads = Thread.activeCount();
            this.thread_dump = "active threads before (" + this.active_threads + "):\n" + Util.activeThreads();
        }
    }

    protected static boolean isTunnelUsed() {
        return CHANNEL_CONFIG.contains("tunnel");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (ChannelTestBase.isMuxChannelUsed()) {
            for (int i = 0; i < this.muxFactory.length; ++i) {
                this.muxFactory[i].destroy();
            }
        }
        if (this.router != null) {
            this.router.stop();
            Util.sleep(100L);
        }
        if (ChannelTestBase.shouldCompareThreadCount()) {
            Util.sleep(20L);
            int current_active_threads = Thread.activeCount();
            String msg = "";
            if (this.active_threads != current_active_threads) {
                System.out.println(this.thread_dump);
                System.out.println("active threads after (" + current_active_threads + "):\n" + Util.activeThreads());
                msg = "active threads:\n" + Util.dumpThreads();
            }
            ChannelTestBase.assertEquals((String)msg, (int)this.active_threads, (int)current_active_threads);
        }
    }

    protected String[] createMuxApplicationNames(int muxApplicationstPerChannelCount) {
        return this.createMuxApplicationNames(muxApplicationstPerChannelCount, this.getMuxFactoryCount());
    }

    protected String[] createMuxApplicationNames(int muxApplicationstPerChannelCount, int muxFactoryCount) {
        if (muxFactoryCount > this.getMuxFactoryCount()) {
            throw new IllegalArgumentException("Parameter muxFactoryCount hs to be less than or equal to getMuxFactoryCount()");
        }
        int startLetter = 64;
        String[] names = null;
        int totalMuxAppCount = muxFactoryCount * muxApplicationstPerChannelCount;
        names = new String[totalMuxAppCount];
        boolean pickNextLetter = false;
        for (int i = 0; i < totalMuxAppCount; ++i) {
            boolean bl = pickNextLetter = i % muxFactoryCount == 0;
            if (pickNextLetter) {
                ++startLetter;
            }
            names[i] = Character.toString((char)startLetter);
        }
        return names;
    }

    protected String getNextChannelName() {
        return Character.toString((char)(++this.currentChannelGeneratedName));
    }

    protected String[] createApplicationNames(int applicationCount) {
        String[] names = new String[applicationCount];
        for (int i = 0; i < applicationCount; ++i) {
            names[i] = this.getNextChannelName();
        }
        return names;
    }

    protected JChannel createChannel(Object id) throws Exception {
        JChannel c = null;
        if (ChannelTestBase.isMuxChannelUsed()) {
            for (int i = 0; i < this.muxFactory.length; ++i) {
                if (this.muxFactory[i].hasMuxChannel(MUX_CHANNEL_CONFIG_STACK_NAME, id.toString())) continue;
                c = new DefaultMuxChannelTestFactory(this.muxFactory[i]).createChannel(id);
                return c;
            }
            throw new Exception("Cannot create mux channel with id " + id + " since all currently used channels have already registered service with that id");
        }
        c = new DefaultChannelTestFactory().createChannel(id);
        return c;
    }

    protected JChannel createChannel() throws Exception {
        return this.createChannel("A");
    }

    protected static boolean isMuxChannelUsed() {
        return Boolean.valueOf(System.getProperty("mux.on", "false"));
    }

    protected static boolean shouldCompareThreadCount() {
        return Boolean.valueOf(System.getProperty("threadcount", "false"));
    }

    protected int getMuxFactoryCount() {
        return Integer.parseInt(System.getProperty("mux.factorycount", DEFAULT_MUX_FACTORY_COUNT));
    }

    protected boolean useBlocking() {
        return Boolean.valueOf(System.getProperty("useBlocking", "false"));
    }

    public static boolean areViewsComplete(MemberRetrievable[] channels, int memberCount) {
        for (int i = 0; i < memberCount; ++i) {
            if (ChannelTestBase.isViewComplete(channels[i], memberCount)) continue;
            return false;
        }
        return true;
    }

    public static void blockUntilViewsReceived(MemberRetrievable[] channels, long timeout) {
        ChannelTestBase.blockUntilViewsReceived(channels, channels.length, timeout);
    }

    public static void blockUntilViewsReceived(Collection channels, long timeout) {
        ChannelTestBase.blockUntilViewsReceived(channels, channels.size(), timeout);
    }

    public static void blockUntilViewsReceived(MemberRetrievable[] channels, int count, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            Util.sleep(100L);
            if (!ChannelTestBase.areViewsComplete(channels, count)) continue;
            return;
        }
        throw new RuntimeException("timed out before caches had complete views");
    }

    public static void blockUntilViewsReceived(Collection channels, int count, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            Util.sleep(100L);
            if (!ChannelTestBase.areViewsComplete(channels.toArray(new MemberRetrievable[channels.size()]), count)) continue;
            return;
        }
        throw new RuntimeException("timed out before caches had complete views");
    }

    public static boolean isViewComplete(MemberRetrievable channel, int memberCount) {
        List members = channel.getMembers();
        if (members == null || memberCount > members.size()) {
            return false;
        }
        if (memberCount < members.size()) {
            StringBuilder sb = new StringBuilder("Channel at address ");
            sb.append(channel.getLocalAddress());
            sb.append(" had ");
            sb.append(members.size());
            sb.append(" members; expecting ");
            sb.append(memberCount);
            sb.append(". Members were (");
            for (int j = 0; j < members.size(); ++j) {
                if (j > 0) {
                    sb.append(", ");
                }
                sb.append(members.get(j));
            }
            sb.append(')');
            throw new IllegalStateException(sb.toString());
        }
        return true;
    }

    public static void takeAllPermits(Semaphore semaphore, int count) {
        for (int i = 0; i < count; ++i) {
            try {
                semaphore.acquire();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void acquireSemaphore(Semaphore semaphore, long timeout, int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            boolean acquired = false;
            try {
                acquired = semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (acquired) continue;
            throw new Exception("Failed to acquire semaphore");
        }
    }

    public static void sleepRandom(int maxTime) {
        Util.sleep(RANDOM.nextInt(maxTime));
    }

    protected static interface MemberRetrievable {
        public List getMembers();

        public Address getLocalAddress();
    }

    protected abstract class PushChannelApplicationWithSemaphore
    extends PushChannelApplication {
        protected Semaphore semaphore;

        public PushChannelApplicationWithSemaphore(String name, ChannelTestFactory factory, Semaphore semaphore, boolean useDispatcher) throws Exception {
            super(name, factory, useDispatcher);
            this.semaphore = semaphore;
        }

        protected PushChannelApplicationWithSemaphore(String name, Semaphore semaphore) throws Exception {
            super(name);
            this.semaphore = semaphore;
        }

        protected PushChannelApplicationWithSemaphore(String name, JChannelFactory f, Semaphore semaphore) throws Exception {
            this(name, channelTestBase.new DefaultMuxChannelTestFactory(f), semaphore, false);
        }

        protected PushChannelApplicationWithSemaphore(String name, Semaphore semaphore, boolean useDispatcher) throws Exception {
            this(name, channelTestBase.new DefaultChannelTestFactory(), semaphore, useDispatcher);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean acquired = false;
            try {
                acquired = this.semaphore.tryAcquire(60000L, TimeUnit.MILLISECONDS);
                if (!acquired) {
                    throw new Exception(this.name + " cannot acquire semaphore");
                }
                this.useChannel();
            }
            catch (Exception e) {
                ChannelTestBase.this.log.error((Object)(this.name + ": " + e.getLocalizedMessage()), (Throwable)e);
                this.exception = e;
            }
            finally {
                if (acquired) {
                    this.semaphore.release();
                }
            }
        }
    }

    protected abstract class PushChannelApplication
    extends ChannelApplication
    implements ExtendedReceiver {
        RpcDispatcher dispatcher;

        public PushChannelApplication(String name) throws Exception {
            this(name, channelTestBase.new DefaultChannelTestFactory(), false);
        }

        public PushChannelApplication(String name, JChannelFactory f) throws Exception {
            this(name, channelTestBase.new DefaultMuxChannelTestFactory(f), false);
        }

        public PushChannelApplication(String name, boolean useDispatcher) throws Exception {
            this(name, channelTestBase.new DefaultChannelTestFactory(), useDispatcher);
        }

        public PushChannelApplication(String name, ChannelTestFactory factory, boolean useDispatcher) throws Exception {
            super(name, factory);
            if (useDispatcher) {
                this.dispatcher = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
            } else {
                this.channel.setReceiver(this);
            }
        }

        public RpcDispatcher getDispatcher() {
            return this.dispatcher;
        }

        public boolean hasDispatcher() {
            return this.dispatcher != null;
        }

        public void block() {
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "] in blocking"));
        }

        public byte[] getState() {
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "] "));
            return null;
        }

        public void getState(OutputStream ostream) {
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "]"));
        }

        public byte[] getState(String state_id) {
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + " state id =" + state_id));
            return null;
        }

        public void getState(String state_id, OutputStream ostream) {
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "] state id =" + state_id));
        }

        public void receive(Message msg) {
        }

        public void setState(byte[] state) {
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "] "));
        }

        public void setState(InputStream istream) {
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "]"));
        }

        public void setState(String state_id, byte[] state) {
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "] state id =" + state_id + ", state size is " + state.length));
        }

        public void setState(String state_id, InputStream istream) {
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "] state id " + state_id));
        }

        public void suspect(Address suspected_mbr) {
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "] suspecting " + suspected_mbr));
        }

        public void unblock() {
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "] unblocking"));
        }

        public void viewAccepted(View new_view) {
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "] accepted view " + new_view));
        }
    }

    protected abstract class ChannelApplication
    implements Runnable,
    MemberRetrievable {
        protected Channel channel;
        protected Thread thread;
        protected Throwable exception;
        protected String name;

        public ChannelApplication(String name) throws Exception {
            ChannelTestBase.this.createChannel(name);
        }

        public ChannelApplication(String name, JChannelFactory f) throws Exception {
            if (f == null) {
                this.createChannel(name, new DefaultChannelTestFactory());
            } else {
                this.createChannel(name, new DefaultMuxChannelTestFactory(f));
            }
        }

        public ChannelApplication(String name, ChannelTestFactory factory) throws Exception {
            this.createChannel(name, factory);
        }

        private void createChannel(String name, ChannelTestFactory factory) throws Exception {
            this.name = name;
            this.channel = factory.createChannel(name);
        }

        protected abstract void useChannel() throws Exception;

        public void run() {
            try {
                this.useChannel();
            }
            catch (Exception e) {
                ChannelTestBase.this.log.error((Object)(this.name + ": " + e.getLocalizedMessage()), (Throwable)e);
                this.exception = e;
            }
        }

        public List getMembers() {
            Vector<Address> result = null;
            View v = this.channel.getView();
            if (v != null) {
                result = v.getMembers();
            }
            return result;
        }

        public boolean isUsingMuxChannel() {
            return this.channel instanceof MuxChannel;
        }

        public Address getLocalAddress() {
            return this.channel.getLocalAddress();
        }

        public void start() {
            boolean connected;
            this.thread = new Thread((Runnable)this, this.getName());
            this.thread.start();
            Address a = this.getLocalAddress();
            boolean bl = connected = a != null;
            if (connected) {
                ChannelTestBase.this.log.info((Object)("Thread for channel " + a + "[" + this.getName() + "] started"));
            } else {
                ChannelTestBase.this.log.info((Object)("Thread for channel [" + this.getName() + "] started"));
            }
        }

        public void setChannel(Channel ch) {
            this.channel = ch;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public String getName() {
            return this.name;
        }

        public void cleanup() {
            Address a;
            boolean connected;
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
            boolean bl = connected = (a = this.getLocalAddress()) != null;
            if (connected) {
                ChannelTestBase.this.log.info((Object)("Closing channel " + a + "[" + this.getName() + "]"));
            } else {
                ChannelTestBase.this.log.info((Object)("Closing channel [" + this.getName() + "]"));
            }
            this.channel.close();
            ChannelTestBase.this.log.info((Object)("Closed channel " + a + "[" + this.getName() + "]"));
        }
    }

    protected static interface ChannelTestFactory {
        public Channel createChannel(Object var1) throws Exception;
    }

    public class NextAvailableMuxChannelTestFactory
    implements ChannelTestFactory {
        public Channel createChannel(Object id) throws Exception {
            return ChannelTestBase.this.createChannel(id);
        }
    }

    public class DefaultMuxChannelTestFactory
    implements ChannelTestFactory {
        JChannelFactory f = null;

        public DefaultMuxChannelTestFactory(JChannelFactory f) {
            this.f = f;
        }

        public JChannel createChannel(Object id) throws Exception {
            JChannel c = (JChannel)this.f.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, id.toString());
            if (ChannelTestBase.this.useBlocking()) {
                c.setOpt(0, Boolean.TRUE);
            }
            Address address = c.getLocalAddress();
            String append = "[" + id + "]" + " using " + MUX_CHANNEL_CONFIG + ",stack " + MUX_CHANNEL_CONFIG_STACK_NAME;
            if (address == null) {
                ChannelTestBase.this.log.info((Object)("Created unconnected mux channel " + append));
            } else {
                ChannelTestBase.this.log.info((Object)("Created mux channel " + address + append));
            }
            return c;
        }
    }

    protected class DefaultChannelTestFactory
    implements ChannelTestFactory {
        protected DefaultChannelTestFactory() {
        }

        public JChannel createChannel(Object id) throws Exception {
            return this.createChannel(CHANNEL_CONFIG, ChannelTestBase.this.useBlocking());
        }

        protected JChannel createChannel(String configFile, boolean useBlocking) throws Exception {
            HashMap<Integer, Boolean> channelOptions = new HashMap<Integer, Boolean>();
            channelOptions.put(new Integer(0), useBlocking);
            return this.createChannel(configFile, channelOptions);
        }

        protected JChannel createChannel(String configFile, Map channelOptions) throws Exception {
            JChannel ch = null;
            ChannelTestBase.this.log.info((Object)("Using configuration file " + configFile));
            ch = new JChannel(configFile);
            for (Integer key : channelOptions.keySet()) {
                Object value = channelOptions.get(key);
                ch.setOpt(key, value);
            }
            return ch;
        }
    }
}

