/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Constructor;
import org.springframework.expression.AccessException;
import org.springframework.expression.ConstructorExecutor;
import org.springframework.expression.ConstructorResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.expression.spel.support.ReflectiveConstructorExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveConstructorResolver
implements ConstructorResolver {
    @Override
    public ConstructorExecutor resolve(EvaluationContext context, String typename, Class<?>[] argumentTypes) throws AccessException {
        try {
            TypeConverter typeConverter = context.getTypeConverter();
            Class<?> type = context.getTypeLocator().findType(typename);
            Constructor<?>[] ctors = type.getConstructors();
            Constructor<?> closeMatch = null;
            int[] argsToConvert = null;
            Constructor<?> matchRequiringConversion = null;
            Constructor<?>[] constructorArray = ctors;
            int n = ctors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> ctor = constructorArray[n2];
                ReflectionHelper.ArgumentsMatchInfo matchInfo = null;
                if (ctor.isVarArgs() && argumentTypes.length >= ctor.getParameterTypes().length - 1) {
                    matchInfo = ReflectionHelper.compareArgumentsVarargs(ctor.getParameterTypes(), argumentTypes, typeConverter);
                } else if (ctor.getParameterTypes().length == argumentTypes.length) {
                    matchInfo = ReflectionHelper.compareArguments(ctor.getParameterTypes(), argumentTypes, typeConverter);
                }
                if (matchInfo != null) {
                    if (matchInfo.kind == ReflectionHelper.ArgsMatchKind.EXACT) {
                        return new ReflectiveConstructorExecutor(ctor, null);
                    }
                    if (matchInfo.kind == ReflectionHelper.ArgsMatchKind.CLOSE) {
                        closeMatch = ctor;
                    } else if (matchInfo.kind == ReflectionHelper.ArgsMatchKind.REQUIRES_CONVERSION) {
                        argsToConvert = matchInfo.argsRequiringConversion;
                        matchRequiringConversion = ctor;
                    }
                }
                ++n2;
            }
            if (closeMatch != null) {
                return new ReflectiveConstructorExecutor(closeMatch, null);
            }
            if (matchRequiringConversion != null) {
                return new ReflectiveConstructorExecutor(matchRequiringConversion, argsToConvert);
            }
            return null;
        }
        catch (EvaluationException ex) {
            throw new AccessException("Failed to resolve constructor", ex);
        }
    }
}

